/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.builder.Version;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.util.FileUtil;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.common.io.jar.JarFiles;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

@Deprecated(forRemoval=true)
public class WebJarUtil {
    private static final Logger LOG = Logger.getLogger(WebJarUtil.class);
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String CUSTOM_MEDIA_FOLDER = "META-INF/branding/";
    private static final List<String> IGNORE_LIST = Arrays.asList("logo.png", "favicon.ico", "style.css");
    private static final String CSS = ".css";
    private static final String SNAPSHOT_VERSION = "-SNAPSHOT";

    private WebJarUtil() {
    }

    public static void hotReloadBrandingChanges(CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode, ResolvedDependency resourcesArtifact, Set<String> hotReloadChanges) throws IOException {
        WebJarUtil.hotReloadBrandingChanges(curateOutcomeBuildItem, launchMode, resourcesArtifact, hotReloadChanges, true);
    }

    public static void hotReloadBrandingChanges(CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode, ResolvedDependency resourcesArtifact, Set<String> hotReloadChanges, boolean useDefaultQuarkusBranding) throws IOException {
        if (launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT) && hotReloadChanges != null && !hotReloadChanges.isEmpty()) {
            for (String changedResource : hotReloadChanges) {
                if (!changedResource.startsWith(CUSTOM_MEDIA_FOLDER)) continue;
                ClassLoader classLoader = WebJarUtil.class.getClassLoader();
                ResolvedDependency userApplication = curateOutcomeBuildItem.getApplicationModel().getAppArtifact();
                String fileName = changedResource.replace(CUSTOM_MEDIA_FOLDER, "");
                String modulename = WebJarUtil.getModuleOverrideName(resourcesArtifact, fileName);
                if (!IGNORE_LIST.contains(fileName) || !WebJarUtil.isOverride(userApplication.getResolvedPaths(), classLoader, fileName, modulename)) continue;
                Path deploymentPath = WebJarUtil.createResourcesDirectory(userApplication, resourcesArtifact);
                Path filePath = deploymentPath.resolve(fileName);
                InputStream initialOverride = WebJarUtil.getOverride(userApplication.getResolvedPaths(), classLoader, fileName, modulename, useDefaultQuarkusBranding);
                try (InputStream override = WebJarUtil.insertVariables(userApplication, initialOverride, fileName);){
                    if (override == null) continue;
                    WebJarUtil.createFile(override, filePath);
                }
                finally {
                    if (initialOverride == null) continue;
                    initialOverride.close();
                }
            }
        }
    }

    public static Path copyResourcesForDevOrTest(LiveReloadBuildItem liveReloadBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode, ResolvedDependency resourcesArtifact, String rootFolderInJar) throws IOException {
        return WebJarUtil.copyResourcesForDevOrTest(liveReloadBuildItem, curateOutcomeBuildItem, launchMode, resourcesArtifact, rootFolderInJar, true, false);
    }

    @Deprecated
    public static Path copyResourcesForDevOrTest(LiveReloadBuildItem liveReloadBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode, ResolvedDependency resourcesArtifact, String rootFolderInJar, boolean useDefaultQuarkusBranding) throws IOException {
        return WebJarUtil.copyResourcesForDevOrTest(liveReloadBuildItem, curateOutcomeBuildItem, launchMode, resourcesArtifact, rootFolderInJar, useDefaultQuarkusBranding, false);
    }

    public static Path copyResourcesForDevOrTest(LiveReloadBuildItem liveReloadBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem, LaunchModeBuildItem launchMode, final ResolvedDependency resourcesArtifact, String rootFolderInJar, final boolean useDefaultQuarkusBranding, final boolean onlyCopyNonArtifactFiles) throws IOException {
        rootFolderInJar = WebJarUtil.normalizeRootFolderInJar(rootFolderInJar);
        final ResolvedDependency userApplication = curateOutcomeBuildItem.getApplicationModel().getAppArtifact();
        final Path deploymentPath = WebJarUtil.createResourcesDirectory(userApplication, resourcesArtifact);
        if (!launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT) || resourcesArtifact.getVersion().contains(SNAPSHOT_VERSION) || launchMode.getLaunchMode().equals((Object)LaunchMode.DEVELOPMENT) && !liveReloadBuildItem.isLiveReload()) {
            IoUtils.createOrEmptyDir((Path)deploymentPath);
        }
        if (WebJarUtil.isEmpty(deploymentPath)) {
            final ClassLoader classLoader = WebJarUtil.class.getClassLoader();
            for (Path p : resourcesArtifact.getResolvedPaths()) {
                File artifactFile = p.toFile();
                if (artifactFile.isFile()) {
                    JarFile jarFile = JarFiles.create((File)artifactFile);
                    try {
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            if (!entry.getName().startsWith(rootFolderInJar)) continue;
                            String fileName = entry.getName().replace(rootFolderInJar, "");
                            Path filePath = deploymentPath.resolve(fileName);
                            if (entry.isDirectory()) {
                                Files.createDirectories(filePath, new FileAttribute[0]);
                                continue;
                            }
                            boolean overrideFileCreated = false;
                            String modulename = WebJarUtil.getModuleOverrideName(resourcesArtifact, fileName);
                            if (IGNORE_LIST.contains(fileName) && WebJarUtil.isOverride(userApplication.getResolvedPaths(), classLoader, fileName, modulename)) {
                                try (InsertVariableResult overrideInsertResult = WebJarUtil.insertVariablesWithResult(userApplication, WebJarUtil.getOverride(userApplication.getResolvedPaths(), classLoader, fileName, modulename, useDefaultQuarkusBranding), fileName);){
                                    if (overrideInsertResult.inputStream != null) {
                                        WebJarUtil.createFile(overrideInsertResult.inputStream, filePath);
                                        overrideFileCreated = true;
                                    }
                                }
                            }
                            if (overrideFileCreated) continue;
                            InputStream entryInputStream = jarFile.getInputStream(entry);
                            try {
                                InsertVariableResult entryInsertResult = WebJarUtil.insertVariablesWithResult(userApplication, entryInputStream, fileName);
                                try {
                                    if (onlyCopyNonArtifactFiles && !entryInsertResult.changed) continue;
                                    WebJarUtil.createFile(entryInsertResult.inputStream, filePath);
                                }
                                finally {
                                    if (entryInsertResult == null) continue;
                                    entryInsertResult.close();
                                }
                            }
                            finally {
                                if (entryInputStream == null) continue;
                                entryInputStream.close();
                            }
                        }
                        continue;
                    }
                    finally {
                        if (jarFile == null) continue;
                        jarFile.close();
                        continue;
                    }
                }
                final Path rootFolderToCopy = p.resolve(rootFolderInJar);
                if (!Files.isDirectory(rootFolderToCopy, new LinkOption[0])) continue;
                Files.walkFileTree(rootFolderToCopy, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Files.createDirectories(deploymentPath.resolve(rootFolderToCopy.relativize(dir)), new FileAttribute[0]);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        InsertVariableResult insertVariableResult;
                        String fileName = rootFolderToCopy.relativize(file).toString();
                        Path targetFilePath = deploymentPath.resolve(rootFolderToCopy.relativize(file));
                        String modulename = WebJarUtil.getModuleOverrideName(resourcesArtifact, fileName);
                        boolean overrideFileCreated = false;
                        if (IGNORE_LIST.contains(fileName) && WebJarUtil.isOverride(userApplication.getResolvedPaths(), classLoader, fileName, modulename)) {
                            insertVariableResult = WebJarUtil.insertVariablesWithResult(userApplication, WebJarUtil.getOverride(userApplication.getResolvedPaths(), classLoader, fileName, modulename, useDefaultQuarkusBranding), fileName);
                            try {
                                if (insertVariableResult.inputStream != null) {
                                    overrideFileCreated = true;
                                    WebJarUtil.createFile(insertVariableResult.inputStream, targetFilePath);
                                }
                            }
                            finally {
                                if (insertVariableResult != null) {
                                    insertVariableResult.close();
                                }
                            }
                        }
                        if (!overrideFileCreated) {
                            insertVariableResult = WebJarUtil.insertVariablesWithResult(userApplication, Files.newInputStream(file, new OpenOption[0]), fileName);
                            try {
                                if (!onlyCopyNonArtifactFiles || insertVariableResult.changed) {
                                    WebJarUtil.createFile(insertVariableResult.inputStream, targetFilePath);
                                }
                            }
                            finally {
                                if (insertVariableResult != null) {
                                    insertVariableResult.close();
                                }
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        return deploymentPath;
    }

    public static Map<String, byte[]> copyResourcesForProduction(CurateOutcomeBuildItem curateOutcomeBuildItem, ResolvedDependency artifact, String rootFolderInJar) throws IOException {
        return WebJarUtil.copyResourcesForProduction(curateOutcomeBuildItem, artifact, rootFolderInJar, true);
    }

    public static Map<String, byte[]> copyResourcesForProduction(CurateOutcomeBuildItem curateOutcomeBuildItem, ResolvedDependency artifact, String rootFolderInJar, boolean useDefaultQuarkusBranding) throws IOException {
        rootFolderInJar = WebJarUtil.normalizeRootFolderInJar(rootFolderInJar);
        ResolvedDependency userApplication = curateOutcomeBuildItem.getApplicationModel().getAppArtifact();
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        ClassLoader classLoader = WebJarUtil.class.getClassLoader();
        for (Path p : artifact.getResolvedPaths()) {
            File artifactFile = p.toFile();
            JarFile jarFile = JarFiles.create((File)artifactFile);
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!entry.getName().startsWith(rootFolderInJar) || entry.isDirectory()) continue;
                    String filename = entry.getName().replace(rootFolderInJar, "");
                    InputStream inputStream = WebJarUtil.insertVariables(userApplication, jarFile.getInputStream(entry), filename);
                    try {
                        byte[] content = null;
                        String modulename = WebJarUtil.getModuleOverrideName(artifact, filename);
                        if (IGNORE_LIST.contains(filename) && WebJarUtil.isOverride(userApplication.getResolvedPaths(), classLoader, filename, modulename)) {
                            try (InputStream initialOverride = WebJarUtil.getOverride(userApplication.getResolvedPaths(), classLoader, filename, modulename, useDefaultQuarkusBranding);
                                 InputStream resourceAsStream = WebJarUtil.insertVariables(userApplication, initialOverride, filename);){
                                if (resourceAsStream != null) {
                                    content = IoUtil.readBytes(resourceAsStream);
                                }
                            }
                        }
                        if (content == null) {
                            content = FileUtil.readFileContents(inputStream);
                        }
                        map.put(filename, content);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
            }
            finally {
                if (jarFile == null) continue;
                jarFile.close();
            }
        }
        return map;
    }

    public static void updateFile(Path original, byte[] newContent) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(newContent);){
            WebJarUtil.createFile(bais, original);
        }
    }

    public static void updateUrl(Path original, String path, String lineStartsWith, String format) throws IOException {
        String content = Files.readString(original);
        String result = WebJarUtil.updateUrl(content, path, lineStartsWith, format);
        if (result != null && !result.equals(content)) {
            Files.write(original, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public static String updateUrl(String original, String path, String lineStartsWith, String format) {
        try (Scanner scanner = new Scanner(original);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (!line.trim().startsWith(lineStartsWith)) continue;
                String newLine = String.format(format, path);
                String string = original.replace(line.trim(), newLine);
                return string;
            }
        }
        return original;
    }

    public static ResolvedDependency getAppArtifact(CurateOutcomeBuildItem curateOutcomeBuildItem, String groupId, String artifactId) {
        for (ResolvedDependency dep : curateOutcomeBuildItem.getApplicationModel().getDependencies()) {
            if (!dep.getArtifactId().equals(artifactId) || !dep.getGroupId().equals(groupId)) continue;
            return dep;
        }
        throw new RuntimeException("Could not find artifact " + groupId + ":" + artifactId + " among the application dependencies");
    }

    private static void copyFile(ResolvedDependency appArtifact, Path file, String fileName, Path targetFilePath) throws IOException {
        InputStream providedContent = WebJarUtil.pathToStream(file).orElse(null);
        if (providedContent != null) {
            Files.copy(WebJarUtil.insertVariables(appArtifact, providedContent, fileName), targetFilePath, new CopyOption[0]);
        }
    }

    private static String getModuleOverrideName(ResolvedDependency artifact, String filename) {
        String type = filename.substring(filename.lastIndexOf("."));
        return artifact.getArtifactId() + type;
    }

    private static InputStream getOverride(PathCollection paths, ClassLoader classLoader, String filename, String modulename, boolean useDefaultQuarkusBranding) {
        InputStream overrideStream = WebJarUtil.getCustomOverride(paths, filename, modulename);
        if (overrideStream == null && useDefaultQuarkusBranding) {
            overrideStream = WebJarUtil.getQuarkusOverride(classLoader, filename, modulename);
        }
        return overrideStream;
    }

    private static InputStream insertVariables(ResolvedDependency appArtifact, InputStream is, String filename) throws IOException {
        return WebJarUtil.insertVariablesWithResult((ResolvedDependency)appArtifact, (InputStream)is, (String)filename).inputStream;
    }

    private static InsertVariableResult insertVariablesWithResult(ResolvedDependency appArtifact, InputStream is, String filename) throws IOException {
        if (filename.endsWith(CSS)) {
            Config c = ConfigProvider.getConfig();
            String applicationName = c.getOptionalValue("quarkus.application.name", String.class).orElse(appArtifact.getArtifactId());
            String applicationVersion = c.getOptionalValue("quarkus.application.version", String.class).orElse(appArtifact.getVersion());
            String oldContents = new String(IoUtil.readBytes(is));
            String contents = WebJarUtil.replaceHeaderVars(oldContents, applicationName, applicationVersion);
            contents = contents.replace("{applicationHeader}", WebJarUtil.getUIHeader(c, applicationName, applicationVersion));
            is = new ByteArrayInputStream(contents.getBytes());
            return new InsertVariableResult(is, contents.length() != oldContents.length() || !contents.equals(oldContents));
        }
        return new InsertVariableResult(is, false);
    }

    private static String getUIHeader(Config c, String applicationName, String applicationVersion) {
        String applicationHeader = c.getOptionalValue("quarkus.application.ui-header", String.class).orElse("");
        return WebJarUtil.replaceHeaderVars(applicationHeader, applicationName, applicationVersion);
    }

    private static String replaceHeaderVars(String contents, String applicationName, String applicationVersion) {
        contents = contents.replace("{applicationName}", applicationName);
        contents = contents.replace("{applicationVersion}", applicationVersion);
        contents = contents.replace("{quarkusVersion}", Version.getVersion());
        return contents;
    }

    private static InputStream getCustomOverride(PathCollection paths, String filename, String modulename) {
        Path customOverridePath = WebJarUtil.getCustomOverridePath(paths, filename, modulename);
        if (customOverridePath != null) {
            return WebJarUtil.pathToStream(customOverridePath).orElse(null);
        }
        return null;
    }

    private static Path getCustomOverridePath(PathCollection paths, String filename, String modulename) {
        for (Path root : paths) {
            Path customModuleOverride = root.resolve(CUSTOM_MEDIA_FOLDER + modulename);
            if (Files.exists(customModuleOverride, new LinkOption[0])) {
                return customModuleOverride;
            }
            Path customOverride = root.resolve(CUSTOM_MEDIA_FOLDER + filename);
            if (!Files.exists(customOverride, new LinkOption[0])) continue;
            return customOverride;
        }
        return null;
    }

    private static InputStream getQuarkusOverride(ClassLoader classLoader, String filename, String modulename) {
        InputStream stream = classLoader.getResourceAsStream(CUSTOM_MEDIA_FOLDER + modulename);
        if (stream != null) {
            return stream;
        }
        return classLoader.getResourceAsStream(CUSTOM_MEDIA_FOLDER + filename);
    }

    private static boolean isOverride(PathCollection paths, ClassLoader classLoader, String filename, String modulename) {
        return WebJarUtil.isQuarkusOverride(classLoader, filename, modulename) || WebJarUtil.isCustomOverride(paths, filename, modulename);
    }

    private static boolean isQuarkusOverride(ClassLoader classLoader, String filename, String modulename) {
        return WebJarUtil.fileExistInClasspath(classLoader, CUSTOM_MEDIA_FOLDER + modulename) || WebJarUtil.fileExistInClasspath(classLoader, CUSTOM_MEDIA_FOLDER + filename);
    }

    private static boolean isCustomOverride(PathCollection paths, String filename, String modulename) {
        Iterator iterator = paths.iterator();
        if (iterator.hasNext()) {
            Path root = (Path)iterator.next();
            Path customModuleOverride = root.resolve(CUSTOM_MEDIA_FOLDER + modulename);
            if (Files.exists(customModuleOverride, new LinkOption[0])) {
                return true;
            }
            Path customOverride = root.resolve(CUSTOM_MEDIA_FOLDER + filename);
            return Files.exists(customOverride, new LinkOption[0]);
        }
        return false;
    }

    private static boolean fileExistInClasspath(ClassLoader classLoader, String filename) {
        URL u = classLoader.getResource(filename);
        return u != null;
    }

    private static Optional<InputStream> pathToStream(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return Optional.of(Files.newInputStream(path, new OpenOption[0]));
            }
            catch (IOException ex) {
                LOG.warn((Object)("Could not read override file [" + String.valueOf(path) + "] - " + ex.getMessage()));
            }
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createFile(InputStream source, Path targetFile) throws IOException {
        FileLock lock = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(targetFile.toString());
            FileChannel channel = fos.getChannel();
            lock = channel.tryLock();
            if (lock != null) {
                IoUtils.copy((OutputStream)fos, (InputStream)source);
            }
        }
        finally {
            if (lock != null) {
                lock.release();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static Path createResourcesDirectory(ResolvedDependency userApplication, ResolvedDependency resourcesArtifact) {
        try {
            Path path = Paths.get(TMP_DIR, "quarkus", userApplication.getGroupId(), userApplication.getArtifactId(), resourcesArtifact.getGroupId(), resourcesArtifact.getArtifactId(), resourcesArtifact.getVersion());
            Files.createDirectories(path, new FileAttribute[0]);
            return path;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean isEmpty(Path directory) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(directory);){
            boolean bl = !dirStream.iterator().hasNext();
            return bl;
        }
    }

    private static String normalizeRootFolderInJar(String rootFolderInJar) {
        if (rootFolderInJar.endsWith("/")) {
            return rootFolderInJar;
        }
        return rootFolderInJar + "/";
    }

    private static class InsertVariableResult
    implements Closeable {
        final InputStream inputStream;
        final boolean changed;

        public InsertVariableResult(InputStream inputStream, boolean changed) {
            this.inputStream = inputStream;
            this.changed = changed;
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }
}

