/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jboss.jandex.IndexView;

public final class ApplicationArchiveImpl
extends MultiBuildItem
implements ApplicationArchive {
    private final IndexView indexView;
    private final OpenPathTree openTree;
    private final ArtifactKey artifactKey;

    public ApplicationArchiveImpl(IndexView indexView, OpenPathTree openTree, ArtifactKey artifactKey) {
        this.indexView = indexView;
        this.openTree = openTree;
        this.artifactKey = artifactKey;
    }

    @Override
    public IndexView getIndex() {
        return this.indexView;
    }

    @Override
    @Deprecated
    public Path getArchiveLocation() {
        return (Path)this.openTree.getOriginalTree().getRoots().iterator().next();
    }

    @Override
    @Deprecated
    public PathsCollection getRootDirs() {
        return PathsCollection.from((Iterable)this.openTree.getRoots());
    }

    @Override
    public PathCollection getRootDirectories() {
        return PathList.from((Iterable)this.openTree.getRoots());
    }

    @Override
    @Deprecated
    public PathsCollection getPaths() {
        return PathsCollection.from((Iterable)this.openTree.getOriginalTree().getRoots());
    }

    @Override
    public PathCollection getResolvedPaths() {
        return PathList.from((Iterable)this.openTree.getOriginalTree().getRoots());
    }

    @Override
    @Deprecated
    public AppArtifactKey getArtifactKey() {
        return this.artifactKey == null ? null : new AppArtifactKey(this.artifactKey.getGroupId(), this.artifactKey.getArtifactId(), this.artifactKey.getClassifier(), this.artifactKey.getType());
    }

    @Override
    public ArtifactKey getKey() {
        return this.artifactKey;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T apply(Function<OpenPathTree, T> func) {
        block11: {
            if (this.openTree.isOpen()) {
                try {
                    return (T)func.apply(this.openTree);
                }
                catch (Exception e) {
                    if (!this.openTree.isOpen()) break block11;
                    throw e;
                }
            }
        }
        try (OpenPathTree openTree = this.openTree.getOriginalTree().open();){
            OpenPathTree t = func.apply(openTree);
            return (T)t;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to open path tree with root " + String.valueOf(this.openTree.getOriginalTree().getRoots()), e);
        }
    }

    @Override
    public void accept(Consumer<OpenPathTree> func) {
        block11: {
            if (this.openTree.isOpen()) {
                try {
                    func.accept(this.openTree);
                    return;
                }
                catch (Exception e) {
                    if (!this.openTree.isOpen()) break block11;
                    throw e;
                }
            }
        }
        try (OpenPathTree openTree = this.openTree.getOriginalTree().open();){
            func.accept(openTree);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to open path tree with root " + String.valueOf(this.openTree.getOriginalTree().getRoots()), e);
        }
    }
}

