/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsProduction;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.ConfigMappingBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.SuppressNonRuntimeConfigChangedWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.ConfigMappingUtils;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingConfig;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingInterceptor;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingWriter;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.hibernate.validator.spi.AdditionalConstrainedClassBuildItem;
import io.quarkus.paths.PathCollection;
import io.quarkus.runtime.BuildAnalyticsConfig;
import io.quarkus.runtime.BuilderConfig;
import io.quarkus.runtime.CommandLineRuntimeConfig;
import io.quarkus.runtime.DebugRuntimeConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.StaticInitSafe;
import io.quarkus.runtime.configuration.AbstractConfigBuilder;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.quarkus.runtime.configuration.ConfigDiagnostic;
import io.quarkus.runtime.configuration.ConfigRecorder;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.DisableableConfigSource;
import io.quarkus.runtime.configuration.QuarkusConfigValue;
import io.quarkus.runtime.configuration.RuntimeConfigBuilder;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSourceBuilder;
import io.quarkus.runtime.configuration.StaticInitConfigBuilder;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappingMetadata;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import jakarta.annotation.Priority;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public class ConfigGenerationBuildStep {
    private static final MethodDescriptor CONFIG_BUILDER = MethodDescriptor.ofMethod(ConfigBuilder.class, (String)"configBuilder", SmallRyeConfigBuilder.class, (Class[])new Class[]{SmallRyeConfigBuilder.class});
    private static final MethodDescriptor WITH_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withSources", SmallRyeConfigBuilder.class, (Class[])new Class[]{ConfigSource[].class});
    private static final MethodDescriptor BUILDER_CUSTOMIZER = MethodDescriptor.ofMethod(SmallRyeConfigBuilderCustomizer.class, (String)"configBuilder", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class});
    private static final MethodDescriptor WITH_DEFAULTS = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withDefaultValues", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, Map.class});
    private static final MethodDescriptor WITH_RUNTIME_VALUES = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withRuntimeValues", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, Map.class});
    private static final MethodDescriptor WITH_CONVERTER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withConverter", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, String.class, Integer.TYPE, Converter.class});
    private static final MethodDescriptor WITH_INTERCEPTOR = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withInterceptor", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceInterceptor.class});
    private static final MethodDescriptor WITH_INTERCEPTOR_FACTORY = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withInterceptorFactory", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceInterceptorFactory.class});
    private static final MethodDescriptor WITH_SOURCE = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSource", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSource.class});
    private static final MethodDescriptor WITH_SOURCE_PROVIDER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSource", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceProvider.class});
    private static final MethodDescriptor WITH_SOURCE_FACTORY = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSource", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceFactory.class});
    private static final MethodDescriptor WITH_SECRET_HANDLER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSecretKeyHandler", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, SecretKeysHandler.class});
    private static final MethodDescriptor WITH_SECRET_HANDLER_FACTORY = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSecretKeyHandler", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, SecretKeysHandlerFactory.class});
    private static final MethodDescriptor WITH_MAPPING = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withMapping", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigMappings.ConfigClass.class});
    private static final MethodDescriptor WITH_MAPPING_INSTANCE = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withMappingInstance", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigMappings.ConfigClass.class});
    private static final MethodDescriptor WITH_MAPPING_IGNORE = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withMappingIgnore", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, String.class});
    private static final MethodDescriptor WITH_CUSTOMIZER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withCustomizer", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, SmallRyeConfigBuilderCustomizer.class});
    private static final MethodDescriptor WITH_BUILDER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withBuilder", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigBuilder.class});
    private static final MethodDescriptor CONFIG_CLASS = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"configClass", ConfigMappings.ConfigClass.class, (Class[])new Class[]{String.class, String.class});
    private static final MethodDescriptor ENSURE_LOADED = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"ensureLoaded", Void.TYPE, (Class[])new Class[]{String.class});
    private static final MethodDescriptor MAP_NEW = MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[]{Integer.TYPE});
    private static final MethodDescriptor MAP_PUT = MethodDescriptor.ofMethod(HashMap.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    private static final DotName CONVERTER_NAME = DotName.createSimple((String)Converter.class.getName());
    private static final DotName PRIORITY_NAME = DotName.createSimple((String)Priority.class.getName());

    @BuildStep
    void nativeSupport(BuildProducer<RuntimeInitializedClassBuildItem> runtimeInitializedClassProducer) {
        runtimeInitializedClassProducer.produce(new RuntimeInitializedClassBuildItem("io.quarkus.runtime.configuration.RuntimeConfigBuilder$UuidConfigSource$Holder"));
    }

    @BuildStep
    void buildTimeRunTimeConfig(ConfigurationBuildItem configItem, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        String builderClassName = "io.quarkus.runtime.generated.BuildTimeRunTimeFixedConfigSourceBuilder";
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(builderClassName).interfaces(new Class[]{ConfigBuilder.class}).setFinal(true).build();){
            FieldDescriptor source = FieldDescriptor.of((String)classCreator.getClassName(), (String)"source", ConfigSource.class);
            classCreator.getFieldCreator(source).setModifiers(24);
            MethodCreator clinit = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
            clinit.setModifiers(8);
            ResultHandle map = clinit.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            MethodDescriptor put = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
            for (Map.Entry<String, ConfigValue> entry : configItem.getReadResult().getBuildTimeRunTimeValues().entrySet()) {
                clinit.invokeInterfaceMethod(put, map, new ResultHandle[]{clinit.load(entry.getKey()), clinit.load(entry.getValue().getValue())});
            }
            ResultHandle defaultValuesSource = clinit.newInstance(MethodDescriptor.ofConstructor(DefaultValuesConfigSource.class, (Class[])new Class[]{Map.class, String.class, Integer.TYPE}), new ResultHandle[]{map, clinit.load("BuildTime RunTime Fixed"), clinit.load(Integer.MAX_VALUE)});
            ResultHandle disableableConfigSource = clinit.newInstance(MethodDescriptor.ofConstructor(DisableableConfigSource.class, (Class[])new Class[]{ConfigSource.class}), new ResultHandle[]{defaultValuesSource});
            clinit.writeStaticField(source, disableableConfigSource);
            clinit.returnVoid();
            MethodCreator method = classCreator.getMethodCreator(CONFIG_BUILDER);
            ResultHandle configBuilder = method.getMethodParam(0);
            ResultHandle configSources = method.newArray(ConfigSource.class, 1);
            method.writeArrayValue(configSources, 0, method.readStaticField(source));
            method.invokeVirtualMethod(WITH_SOURCES, configBuilder, new ResultHandle[]{configSources});
            method.returnValue(configBuilder);
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(builderClassName).reason(this.getClass().getName()).build());
        staticInitConfigBuilder.produce(new StaticInitConfigBuilderBuildItem(builderClassName));
        runTimeConfigBuilder.produce(new RunTimeConfigBuilderBuildItem(builderClassName));
    }

    @BuildStep(onlyIfNot={IsProduction.class})
    void runtimeOverrideConfig(BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        staticInitConfigBuilder.produce(new StaticInitConfigBuilderBuildItem(RuntimeOverrideConfigSourceBuilder.class.getName()));
        runTimeConfigBuilder.produce(new RunTimeConfigBuilderBuildItem(RuntimeOverrideConfigSourceBuilder.class.getName()));
    }

    @BuildStep
    void generateMappings(ConfigurationBuildItem configItem, CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ConfigClassBuildItem> configClasses, BuildProducer<AdditionalConstrainedClassBuildItem> additionalConstrainedClasses) {
        HashMap<String, GeneratedClassBuildItem> generatedConfigClasses = new HashMap<String, GeneratedClassBuildItem>();
        ConfigMappingUtils.processConfigMapping(configItem, combinedIndex, generatedConfigClasses, reflectiveClasses, reflectiveMethods, configClasses, additionalConstrainedClasses);
        List<ConfigMappings.ConfigClass> buildTimeRunTimeMappings = configItem.getReadResult().getBuildTimeRunTimeMappings();
        for (ConfigMappings.ConfigClass buildTimeRunTimeMapping : buildTimeRunTimeMappings) {
            ConfigMappingUtils.processExtensionConfigMapping(buildTimeRunTimeMapping, combinedIndex, generatedConfigClasses, reflectiveClasses, reflectiveMethods, configClasses, additionalConstrainedClasses);
        }
        List<ConfigMappings.ConfigClass> runTimeMappings = configItem.getReadResult().getRunTimeMappings();
        for (ConfigMappings.ConfigClass runTimeMapping : runTimeMappings) {
            ConfigMappingUtils.processExtensionConfigMapping(runTimeMapping, combinedIndex, generatedConfigClasses, reflectiveClasses, reflectiveMethods, configClasses, additionalConstrainedClasses);
        }
        for (GeneratedClassBuildItem generatedConfigClass : generatedConfigClasses.values()) {
            generatedClasses.produce(generatedConfigClass);
        }
    }

    @BuildStep
    void generateBuilders(ConfigurationBuildItem configItem, CombinedIndexBuildItem combinedIndex, List<ConfigMappingBuildItem> configMappings, List<RunTimeConfigurationDefaultBuildItem> runTimeDefaults, List<StaticInitConfigBuilderBuildItem> staticInitConfigBuilders, List<RunTimeConfigBuilderBuildItem> runTimeConfigBuilders, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) throws Exception {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        for (RunTimeConfigurationDefaultBuildItem e : runTimeDefaults) {
            defaultValues.put(e.getKey(), e.getValue());
        }
        Set<String> converters = ConfigGenerationBuildStep.discoverService(Converter.class, reflectiveClass);
        Set<String> interceptors = ConfigGenerationBuildStep.discoverService(ConfigSourceInterceptor.class, reflectiveClass);
        Set<String> interceptorFactories = ConfigGenerationBuildStep.discoverService(ConfigSourceInterceptorFactory.class, reflectiveClass);
        Set<String> configSources = ConfigGenerationBuildStep.discoverService(ConfigSource.class, reflectiveClass);
        Set<String> configSourceProviders = ConfigGenerationBuildStep.discoverService(ConfigSourceProvider.class, reflectiveClass);
        Set<String> configSourceFactories = ConfigGenerationBuildStep.discoverService(ConfigSourceFactory.class, reflectiveClass);
        Set<String> secretKeyHandlers = ConfigGenerationBuildStep.discoverService(SecretKeysHandler.class, reflectiveClass);
        Set<String> secretKeyHandlerFactories = ConfigGenerationBuildStep.discoverService(SecretKeysHandlerFactory.class, reflectiveClass);
        Set<String> configCustomizers = ConfigGenerationBuildStep.discoverService(SmallRyeConfigBuilderCustomizer.class, reflectiveClass);
        LinkedHashSet<ConfigMappings.ConfigClass> ignoreMappings = new LinkedHashSet<ConfigMappings.ConfigClass>();
        ignoreMappings.add(ConfigMappings.ConfigClass.configClass(BuildAnalyticsConfig.class, (String)"quarkus.analytics"));
        ignoreMappings.add(ConfigMappings.ConfigClass.configClass(BuilderConfig.class, (String)"quarkus.builder"));
        ignoreMappings.add(ConfigMappings.ConfigClass.configClass(CommandLineRuntimeConfig.class, (String)"quarkus"));
        ignoreMappings.add(ConfigMappings.ConfigClass.configClass(DebugRuntimeConfig.class, (String)"quarkus.debug"));
        LinkedHashSet<ConfigMappings.ConfigClass> allMappings = new LinkedHashSet<ConfigMappings.ConfigClass>();
        allMappings.addAll(ConfigGenerationBuildStep.staticSafeConfigMappings(configMappings));
        allMappings.addAll(ConfigGenerationBuildStep.runtimeConfigMappings(configMappings));
        allMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        allMappings.addAll(configItem.getReadResult().getRunTimeMappings());
        allMappings.removeAll(ignoreMappings);
        Map<Object, FieldDescriptor> sharedFields = ConfigGenerationBuildStep.generateSharedConfig(generatedClass, converters, allMappings);
        LinkedHashSet<ConfigMappings.ConfigClass> staticMappings = new LinkedHashSet<ConfigMappings.ConfigClass>();
        staticMappings.addAll(ConfigGenerationBuildStep.staticSafeConfigMappings(configMappings));
        staticMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        staticMappings.removeAll(ignoreMappings);
        LinkedHashSet<String> staticCustomizers = new LinkedHashSet<String>(ConfigGenerationBuildStep.staticSafeServices(configCustomizers));
        staticCustomizers.add(StaticInitConfigBuilder.class.getName());
        ConfigGenerationBuildStep.generateConfigBuilder(generatedClass, reflectiveClass, "io.quarkus.runtime.generated.StaticInitConfig", combinedIndex, sharedFields, defaultValues, Map.of(), converters, interceptors, ConfigGenerationBuildStep.staticSafeServices(interceptorFactories), ConfigGenerationBuildStep.staticSafeServices(configSources), ConfigGenerationBuildStep.staticSafeServices(configSourceProviders), ConfigGenerationBuildStep.staticSafeServices(configSourceFactories), secretKeyHandlers, ConfigGenerationBuildStep.staticSafeServices(secretKeyHandlerFactories), Set.of(), staticMappings, configItem.getReadResult().getMappingsIgnorePaths(), staticCustomizers, staticInitConfigBuilders.stream().map(StaticInitConfigBuilderBuildItem::getBuilderClassName).collect(Collectors.toSet()));
        reflectiveClass.produce(ReflectiveClassBuildItem.builder("io.quarkus.runtime.generated.StaticInitConfig").build());
        HashMap<String, String> runtimeValues = new HashMap<String, String>();
        for (Map.Entry<String, ConfigValue> entry : configItem.getReadResult().getRunTimeValues().entrySet()) {
            runtimeValues.put(entry.getKey(), entry.getValue().getRawValue());
        }
        LinkedHashSet<ConfigMappings.ConfigClass> runTimeMappings = new LinkedHashSet<ConfigMappings.ConfigClass>();
        runTimeMappings.addAll(ConfigGenerationBuildStep.runtimeConfigMappings(configMappings));
        runTimeMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        runTimeMappings.addAll(configItem.getReadResult().getRunTimeMappings());
        runTimeMappings.removeAll(ignoreMappings);
        LinkedHashSet<String> runtimeCustomizers = new LinkedHashSet<String>(configCustomizers);
        runtimeCustomizers.add(RuntimeConfigBuilder.class.getName());
        ConfigGenerationBuildStep.generateConfigBuilder(generatedClass, reflectiveClass, "io.quarkus.runtime.generated.RunTimeConfig", combinedIndex, sharedFields, defaultValues, runtimeValues, converters, interceptors, interceptorFactories, configSources, configSourceProviders, configSourceFactories, secretKeyHandlers, secretKeyHandlerFactories, staticMappings, runTimeMappings, configItem.getReadResult().getMappingsIgnorePaths(), runtimeCustomizers, runTimeConfigBuilders.stream().map(RunTimeConfigBuilderBuildItem::getBuilderClassName).collect(Collectors.toSet()));
        reflectiveClass.produce(ReflectiveClassBuildItem.builder("io.quarkus.runtime.generated.RunTimeConfig").build());
    }

    @BuildStep
    void generateConfigClass(ConfigurationBuildItem configItem, LaunchModeBuildItem launchModeBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClass, LiveReloadBuildItem liveReloadBuildItem) {
        if (!launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            ConfigDiagnostic.unknownProperties(configItem.getReadResult().getUnknownBuildProperties());
        }
        if (liveReloadBuildItem.isLiveReload()) {
            return;
        }
        RunTimeConfigurationGenerator.GenerateOperation.builder().setBuildTimeReadResult(configItem.getReadResult()).setClassOutput(new GeneratedClassGizmoAdaptor(generatedClass, false)).setLiveReloadPossible(launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT || launchModeBuildItem.isAuxiliaryApplication()).build().run();
    }

    @BuildStep
    public void suppressNonRuntimeConfigChanged(BuildProducer<SuppressNonRuntimeConfigChangedWarningBuildItem> suppressNonRuntimeConfigChanged) {
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.profile"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.default-locale"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.locales"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.test.arg-line"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void releaseConfigOnShutdown(ShutdownContextBuildItem shutdownContext, ConfigRecorder recorder) {
        recorder.releaseConfig((ShutdownContext)shutdownContext);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void checkForBuildTimeConfigChange(RecorderContext recorderContext, ConfigRecorder recorder, ConfigurationBuildItem configItem, List<SuppressNonRuntimeConfigChangedWarningBuildItem> suppressNonRuntimeConfigChangedWarningItems) {
        recorderContext.registerSubstitution(ConfigValue.class, QuarkusConfigValue.class, QuarkusConfigValue.Substitution.class);
        HashSet<String> excludedConfigKeys = new HashSet<String>(suppressNonRuntimeConfigChangedWarningItems.size());
        for (SuppressNonRuntimeConfigChangedWarningBuildItem item : suppressNonRuntimeConfigChangedWarningItems) {
            excludedConfigKeys.add(item.getConfigKey());
        }
        TreeMap<String, ConfigValue> values = new TreeMap<String, ConfigValue>();
        BuildTimeConfigurationReader.ReadResult readResult = configItem.getReadResult();
        for (Map.Entry<String, ConfigValue> entry : readResult.getAllBuildTimeValues().entrySet()) {
            if (excludedConfigKeys.contains(entry.getKey()) || readResult.getRunTimeValues().containsKey(entry.getKey())) continue;
            values.putIfAbsent(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, ConfigValue> entry : readResult.getBuildTimeRunTimeValues().entrySet()) {
            if (excludedConfigKeys.contains(entry.getKey()) || readResult.getRunTimeValues().containsKey(entry.getKey())) continue;
            values.put(entry.getKey(), entry.getValue());
        }
        recorder.handleConfigChange(values);
    }

    @BuildStep(onlyIfNot={IsProduction.class})
    public void setupConfigOverride(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true);
        try (ClassCreator clazz = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(RuntimeOverrideConfigSource.GENERATED_CLASS_NAME).build();){
            clazz.getFieldCreator("CONFIG", Map.class).setModifiers(73);
        }
    }

    @BuildStep
    public void watchConfigFiles(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        ArrayList<String> configWatchedFiles = new ArrayList<String>();
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        String userDir = System.getProperty("user.dir");
        configWatchedFiles.add("application.properties");
        configWatchedFiles.add("META-INF/microprofile-config.properties");
        configWatchedFiles.add(Paths.get(userDir, ".env").toAbsolutePath().toString());
        configWatchedFiles.add(Paths.get(userDir, "config", "application.properties").toAbsolutePath().toString());
        for (String profile : config.getProfiles()) {
            configWatchedFiles.add(String.format("application-%s.properties", profile));
            configWatchedFiles.add(String.format("META-INF/microprofile-config-%s.properties", profile));
            configWatchedFiles.add(Paths.get(userDir, String.format(".env-%s", profile)).toAbsolutePath().toString());
            configWatchedFiles.add(Paths.get(userDir, "config", String.format("application-%s.properties", profile)).toAbsolutePath().toString());
        }
        Optional optionalLocations = config.getOptionalValues("smallrye.config.locations", URI.class);
        optionalLocations.ifPresent(locations -> {
            for (URI location : locations) {
                Path path;
                Path path2 = path = location.getScheme() != null && location.getScheme().equals("file") ? Paths.get(location) : Paths.get(location.getPath(), new String[0]);
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    configWatchedFiles.add(path.toAbsolutePath().toString());
                    for (String profile : config.getProfiles()) {
                        configWatchedFiles.add(this.appendProfileToFilename(path.toAbsolutePath(), profile));
                    }
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                try {
                    DirectoryStream<Path> files = Files.newDirectoryStream(path, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
                    try {
                        for (Path file : files) {
                            configWatchedFiles.add(file.toAbsolutePath().toString());
                        }
                    }
                    finally {
                        if (files == null) continue;
                        files.close();
                    }
                }
                catch (IOException iOException) {
                }
            }
        });
        for (String configWatchedFile : configWatchedFiles) {
            watchedFiles.produce(new HotDeploymentWatchedFileBuildItem(configWatchedFile));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void reportDeprecatedMappingProperties(ConfigRecorder configRecorder, ConfigurationBuildItem configBuildItem) {
        ArrayList<ConfigMappings.ConfigClass> visibleBuildTimeMappings = new ArrayList<ConfigMappings.ConfigClass>();
        visibleBuildTimeMappings.addAll(configBuildItem.getReadResult().getBuildTimeMappings());
        visibleBuildTimeMappings.addAll(configBuildItem.getReadResult().getBuildTimeRunTimeMappings());
        Map<String, String> deprecatedProperties = ConfigGenerationBuildStep.deprecatedProperties(visibleBuildTimeMappings);
        ConfigDiagnostic.deprecatedProperties(deprecatedProperties);
        Map<String, String> runtimeDeprecatedProperties = ConfigGenerationBuildStep.deprecatedProperties(configBuildItem.getReadResult().getRunTimeMappings());
        configRecorder.deprecatedProperties(runtimeDeprecatedProperties);
    }

    private static Map<String, String> deprecatedProperties(List<ConfigMappings.ConfigClass> configClasses) {
        HashMap<String, String> deprecatedProperties = new HashMap<String, String>();
        for (ConfigMappings.ConfigClass buildTimeMapping : configClasses) {
            Map properties = ConfigMappings.getProperties((ConfigMappings.ConfigClass)buildTimeMapping);
            for (Map.Entry entry : properties.entrySet()) {
                Deprecated deprecated = ((ConfigMappingInterface.Property)entry.getValue()).getMethod().getAnnotation(Deprecated.class);
                if (deprecated == null) continue;
                deprecatedProperties.put((String)entry.getKey(), null);
            }
        }
        return deprecatedProperties;
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void unknownConfigFiles(ApplicationArchivesBuildItem applicationArchives, LaunchModeBuildItem launchModeBuildItem, ConfigRecorder configRecorder) throws Exception {
        HashSet buildTimeFiles = new HashSet();
        PathCollection rootDirectories = applicationArchives.getRootArchive().getRootDirectories();
        for (Path directory : rootDirectories) {
            buildTimeFiles.addAll(ConfigDiagnostic.configFiles((Path)directory));
        }
        buildTimeFiles.addAll(ConfigDiagnostic.configFilesFromLocations());
        ConfigDiagnostic.unknownConfigFiles(buildTimeFiles);
        if (!launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            configRecorder.unknownConfigFiles();
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void warnDifferentProfileUsedBetweenBuildAndRunTime(ConfigRecorder configRecorder) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        configRecorder.handleNativeProfileChange(config.getProfiles());
    }

    @BuildStep(onlyIf={IsProduction.class})
    void persistReadConfigOptions(BuildProducer<ArtifactResultBuildItem> dummy, QuarkusBuildCloseablesBuildItem closeables, final BuildSystemTargetBuildItem buildSystemTargetBuildItem, final ConfigurationBuildItem configBuildItem, final ConfigTrackingConfig configTrackingConfig) {
        final ConfigTrackingInterceptor.ReadOptionsProvider readOptionsProvider = configBuildItem.getReadResult().getReadOptionsProvider();
        if (readOptionsProvider != null) {
            closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ConfigTrackingWriter.write(readOptionsProvider.getReadOptions(), configTrackingConfig, configBuildItem.getReadResult(), ConfigUtils.getProfiles(), buildSystemTargetBuildItem.getOutputDirectory());
                }
            });
        }
    }

    private String appendProfileToFilename(Path path, String activeProfile) {
        String pathWithoutExtension = ConfigGenerationBuildStep.getPathWithoutExtension(path);
        return String.format("%s-%s.%s", pathWithoutExtension, activeProfile, ConfigGenerationBuildStep.getFileExtension(path));
    }

    private static String getFileExtension(Path path) {
        Objects.requireNonNull(path, "path should not be null");
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    private static String getPathWithoutExtension(Path path) {
        Objects.requireNonNull(path, "path should not be null");
        String fileName = path.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    private static Map<Object, FieldDescriptor> generateSharedConfig(BuildProducer<GeneratedClassBuildItem> generatedClass, Set<String> converters, Set<ConfigMappings.ConfigClass> mappings) {
        HashMap<Object, FieldDescriptor> fields = new HashMap<Object, FieldDescriptor>();
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className("io.quarkus.runtime.generated.SharedConfig").superClass(AbstractConfigBuilder.class).setFinal(true).build();){
            MethodCreator clinit = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
            clinit.setModifiers(8);
            int converterIndex = 0;
            for (String converter : converters) {
                String fieldName = "conv$" + converterIndex++;
                FieldDescriptor converterField = ((FieldCreator)classCreator.getFieldCreator(fieldName, Converter.class).setModifiers(8)).getFieldDescriptor();
                clinit.writeStaticField(converterField, clinit.newInstance(MethodDescriptor.ofConstructor((String)converter, (String[])new String[0]), new ResultHandle[0]));
                fields.put(converter, converterField);
            }
            int mappingIndex = 0;
            for (ConfigMappings.ConfigClass mapping : mappings) {
                FieldDescriptor mappingField = ((FieldCreator)classCreator.getFieldCreator("mapping$" + mappingIndex++, ConfigMappings.ConfigClass.class).setModifiers(8)).getFieldDescriptor();
                clinit.writeStaticField(mappingField, clinit.invokeStaticMethod(CONFIG_CLASS, new ResultHandle[]{clinit.load(mapping.getType().getName()), clinit.load(mapping.getPrefix())}));
                List configMappingsMetadata = ConfigMappingLoader.getConfigMappingsMetadata((Class)mapping.getType());
                for (ConfigMappingMetadata configMappingMetadata : configMappingsMetadata) {
                    clinit.invokeStaticMethod(ENSURE_LOADED, new ResultHandle[]{clinit.load(configMappingMetadata.getInterfaceType().getName())});
                }
                fields.put(mapping, mappingField);
            }
            clinit.returnVoid();
        }
        return fields;
    }

    private static void generateConfigBuilder(BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, String className, CombinedIndexBuildItem combinedIndex, Map<Object, FieldDescriptor> sharedFields, Map<String, String> defaultValues, Map<String, String> runtimeValues, Set<String> converters, Set<String> interceptors, Set<String> interceptorFactories, Set<String> configSources, Set<String> configSourceProviders, Set<String> configSourceFactories, Set<String> secretKeyHandlers, Set<String> secretKeyHandlerFactories, Set<ConfigMappings.ConfigClass> mappingsInstances, Set<ConfigMappings.ConfigClass> mappings, Set<String> mappingsIgnorePaths, Set<String> configCustomizers, Set<String> configBuilders) {
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(className + "Customizer").superClass(AbstractConfigBuilder.class).interfaces(new Class[]{SmallRyeConfigBuilderCustomizer.class}).setFinal(true).build();){
            MethodCreator clinit = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
            clinit.setModifiers(8);
            MethodCreator method = classCreator.getMethodCreator(BUILDER_CUSTOMIZER);
            ResultHandle configBuilder = method.getMethodParam(0);
            FieldDescriptor defaultsField = ((FieldCreator)classCreator.getFieldCreator("defaults", Map.class).setModifiers(8)).getFieldDescriptor();
            clinit.writeStaticField(defaultsField, clinit.newInstance(MAP_NEW, new ResultHandle[]{clinit.load((int)((float)defaultValues.size() / 0.75f + 1.0f))}));
            for (Map.Entry<String, String> entry : defaultValues.entrySet()) {
                clinit.invokeVirtualMethod(MAP_PUT, clinit.readStaticField(defaultsField), new ResultHandle[]{clinit.load(entry.getKey()), clinit.load(entry.getValue())});
            }
            method.invokeStaticMethod(WITH_DEFAULTS, new ResultHandle[]{configBuilder, method.readStaticField(defaultsField)});
            FieldDescriptor runtimeValuesField = ((FieldCreator)classCreator.getFieldCreator("runtimeValues", Map.class).setModifiers(8)).getFieldDescriptor();
            clinit.writeStaticField(runtimeValuesField, clinit.newInstance(MAP_NEW, new ResultHandle[]{clinit.load((int)((float)runtimeValues.size() / 0.75f + 1.0f))}));
            for (Map.Entry<String, String> entry : runtimeValues.entrySet()) {
                clinit.invokeVirtualMethod(MAP_PUT, clinit.readStaticField(runtimeValuesField), new ResultHandle[]{clinit.load(entry.getKey()), clinit.load(entry.getValue())});
            }
            method.invokeStaticMethod(WITH_RUNTIME_VALUES, new ResultHandle[]{configBuilder, method.readStaticField(runtimeValuesField)});
            for (String converter : converters) {
                ClassInfo converterClass = combinedIndex.getComputingIndex().getClassByName(converter);
                Type type = ConfigGenerationBuildStep.getConverterType(converterClass, combinedIndex);
                AnnotationInstance priorityAnnotation = converterClass.annotation(PRIORITY_NAME);
                int priority = priorityAnnotation != null ? priorityAnnotation.value().asInt() : 100;
                method.invokeStaticMethod(WITH_CONVERTER, new ResultHandle[]{configBuilder, method.load(type.name().toString()), method.load(priority), method.readStaticField(sharedFields.get(converter))});
            }
            for (String interceptor : interceptors) {
                method.invokeStaticMethod(WITH_INTERCEPTOR, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)interceptor, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String interceptorFactory : interceptorFactories) {
                method.invokeStaticMethod(WITH_INTERCEPTOR_FACTORY, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)interceptorFactory, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String configSource : configSources) {
                method.invokeStaticMethod(WITH_SOURCE, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configSource, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String configSourceProvider : configSourceProviders) {
                method.invokeStaticMethod(WITH_SOURCE_PROVIDER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configSourceProvider, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String configSourceFactory : configSourceFactories) {
                method.invokeStaticMethod(WITH_SOURCE_FACTORY, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configSourceFactory, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String secretKeyHandler : secretKeyHandlers) {
                method.invokeStaticMethod(WITH_SECRET_HANDLER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)secretKeyHandler, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String secretKeyHandlerFactory : secretKeyHandlerFactories) {
                method.invokeStaticMethod(WITH_SECRET_HANDLER_FACTORY, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)secretKeyHandlerFactory, (String[])new String[0]), new ResultHandle[0])});
            }
            for (ConfigMappings.ConfigClass mappingInstance : mappingsInstances) {
                method.invokeStaticMethod(WITH_MAPPING_INSTANCE, new ResultHandle[]{configBuilder, method.readStaticField(sharedFields.get(mappingInstance))});
            }
            mappings.removeAll(mappingsInstances);
            for (ConfigMappings.ConfigClass mapping : mappings) {
                method.invokeStaticMethod(WITH_MAPPING, new ResultHandle[]{configBuilder, method.readStaticField(sharedFields.get(mapping))});
            }
            for (String path : mappingsIgnorePaths) {
                method.invokeStaticMethod(WITH_MAPPING_IGNORE, new ResultHandle[]{configBuilder, method.load(path)});
            }
            clinit.returnVoid();
            method.returnVoid();
        }
        configCustomizers.add(className + "Customizer");
        classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(className).superClass(AbstractConfigBuilder.class).interfaces(new Class[]{SmallRyeConfigBuilderCustomizer.class}).setFinal(true).build();
        try {
            MethodCreator method = classCreator.getMethodCreator(BUILDER_CUSTOMIZER);
            ResultHandle configBuilder = method.getMethodParam(0);
            for (String configCustomizer : configCustomizers) {
                method.invokeStaticMethod(WITH_CUSTOMIZER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configCustomizer, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String builder : configBuilders) {
                method.invokeStaticMethod(WITH_BUILDER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)builder, (String[])new String[0]), new ResultHandle[0])});
            }
            method.returnVoid();
        }
        finally {
            if (classCreator != null) {
                classCreator.close();
            }
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(className).build());
    }

    private static Set<String> discoverService(Class<?> serviceClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<String> services = new LinkedHashSet<String>();
        for (String service : ServiceUtil.classNamesNamedIn(classLoader, "META-INF/services/" + serviceClass.getName())) {
            if (!QuarkusClassLoader.isClassPresentAtRuntime((String)service)) continue;
            services.add(service);
            reflectiveClass.produce(ReflectiveClassBuildItem.builder(service).build());
        }
        return services;
    }

    private static Set<String> staticSafeServices(Set<String> services) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        LinkedHashSet<String> staticSafe = new LinkedHashSet<String>();
        for (String service : services) {
            if (service.startsWith("io.smallrye.config.")) {
                staticSafe.add(service);
                continue;
            }
            try {
                Class<?> serviceClass = classloader.loadClass(service);
                if (!serviceClass.isAnnotationPresent(StaticInitSafe.class)) continue;
                staticSafe.add(service);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return staticSafe;
    }

    private static Set<ConfigMappings.ConfigClass> staticSafeConfigMappings(List<ConfigMappingBuildItem> configMappings) {
        return configMappings.stream().filter(ConfigMappingBuildItem::isStaticInitSafe).map(ConfigMappingBuildItem::toConfigClass).collect(Collectors.toSet());
    }

    private static Set<ConfigMappings.ConfigClass> runtimeConfigMappings(List<ConfigMappingBuildItem> configMappings) {
        return configMappings.stream().map(ConfigMappingBuildItem::toConfigClass).collect(Collectors.toSet());
    }

    private static Type getConverterType(ClassInfo converter, CombinedIndexBuildItem combinedIndex) {
        if (converter.name().toString().equals(Object.class.getName())) {
            throw new IllegalArgumentException("Can not add converter " + String.valueOf(converter.name()) + " that is not parameterized with a type");
        }
        for (Type type : converter.interfaceTypes()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || !(parameterizedType = type.asParameterizedType()).name().equals((Object)CONVERTER_NAME)) continue;
            List arguments = parameterizedType.arguments();
            if (arguments.size() != 1) {
                throw new IllegalArgumentException("Converter " + String.valueOf(converter.name()) + " must be parameterized with a single type");
            }
            return (Type)arguments.get(0);
        }
        return ConfigGenerationBuildStep.getConverterType(combinedIndex.getComputingIndex().getClassByName(converter.superName()), combinedIndex);
    }
}

