/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.deployment.console.StartupLogCompressor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public abstract class IsContainerRuntimeWorking
implements BooleanSupplier {
    private static final Logger LOGGER = Logger.getLogger(IsContainerRuntimeWorking.class);
    private static final int DOCKER_HOST_CHECK_TIMEOUT = 1000;
    private final List<Strategy> strategies;

    protected IsContainerRuntimeWorking(List<Strategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public boolean getAsBoolean() {
        for (Strategy strategy : this.strategies) {
            LOGGER.debugf("Checking container runtime Environment using strategy %s", (Object)strategy.getClass().getName());
            Result result = (Result)((Object)strategy.get());
            if (result != Result.AVAILABLE) continue;
            return true;
        }
        return false;
    }

    protected static interface Strategy
    extends Supplier<Result> {
    }

    protected static enum Result {
        AVAILABLE,
        UNAVAILABLE,
        UNKNOWN;

    }

    protected static class DockerHostStrategy
    implements Strategy {
        private static final String UNIX_SCHEME = "unix";

        protected DockerHostStrategy() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Result get() {
            String dockerHost = System.getenv("DOCKER_HOST");
            if (dockerHost == null) {
                return Result.UNKNOWN;
            }
            try {
                URI dockerHostUri = new URI(dockerHost);
                if (UNIX_SCHEME.equals(dockerHostUri.getScheme())) {
                    Path dockerSocketPath = Path.of(dockerHostUri.getPath(), new String[0]);
                    if (Files.isWritable(dockerSocketPath)) {
                        return Result.AVAILABLE;
                    }
                    LOGGER.warnf("Unix socket defined in DOCKER_HOST %s is not writable, make sure Docker is running on the specified host", (Object)dockerHost);
                    return Result.UNKNOWN;
                }
                try (Socket s = new Socket();){
                    s.connect(new InetSocketAddress(dockerHostUri.getHost(), dockerHostUri.getPort()), 1000);
                    Result result = Result.AVAILABLE;
                    return result;
                }
                catch (IOException e) {
                    LOGGER.warnf("Unable to connect to DOCKER_HOST URI %s, make sure Docker is running on the specified host", (Object)dockerHost);
                    return Result.UNKNOWN;
                }
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                LOGGER.warnf("Unable to parse DOCKER_HOST URI %s, it will be ignored for working Docker detection", (Object)dockerHost);
            }
            return Result.UNKNOWN;
        }
    }

    protected static class TestContainersStrategy
    implements Strategy {
        private final boolean silent;

        protected TestContainersStrategy(boolean silent) {
            this.silent = silent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result get() {
            try (StartupLogCompressor compressor = new StartupLogCompressor("Checking Docker Environment", Optional.empty(), null, s -> s.getName().startsWith("ducttape"));){
                Class<?> dockerClientFactoryClass = Thread.currentThread().getContextClassLoader().loadClass("org.testcontainers.DockerClientFactory");
                Object dockerClientFactoryInstance = dockerClientFactoryClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
                Class<?> configurationClass = Thread.currentThread().getContextClassLoader().loadClass("org.testcontainers.utility.TestcontainersConfiguration");
                Object configurationInstance = configurationClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                String oldReusePropertyValue = (String)configurationClass.getMethod("getEnvVarOrUserProperty", String.class, String.class).invoke(configurationInstance, "testcontainers.reuse.enable", "false");
                Method updateUserConfigMethod = configurationClass.getMethod("updateUserConfig", String.class, String.class);
                updateUserConfigMethod.invoke(configurationInstance, "testcontainers.reuse.enable", "true");
                Class<?> dockerClientProviderStrategyClass = Thread.currentThread().getContextClassLoader().loadClass("org.testcontainers.dockerclient.DockerClientProviderStrategy");
                Field failFastAlwaysField = dockerClientProviderStrategyClass.getDeclaredField("FAIL_FAST_ALWAYS");
                failFastAlwaysField.setAccessible(true);
                AtomicBoolean failFastAlways = (AtomicBoolean)failFastAlwaysField.get(null);
                failFastAlways.set(false);
                boolean isAvailable = (Boolean)dockerClientFactoryClass.getMethod("isDockerAvailable", new Class[0]).invoke(dockerClientFactoryInstance, new Object[0]);
                if (!isAvailable) {
                    compressor.closeAndDumpCaptured();
                }
                updateUserConfigMethod.invoke(configurationInstance, "testcontainers.reuse.enable", oldReusePropertyValue);
                Result result = isAvailable ? Result.AVAILABLE : Result.UNAVAILABLE;
                return result;
            }
        }
    }
}

