/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CompilerFlags {
    private final Set<String> defaultFlags;
    private final List<String> userFlags;
    private final String releaseJavaVersion;
    private final String sourceJavaVersion;
    private final String targetJavaVersion;
    private final List<String> annotationProcessors;

    public CompilerFlags(Set<String> defaultFlags, Collection<String> userFlags, String releaseJavaVersion, String sourceJavaVersion, String targetJavaVersion, List<String> annotationProcessors) {
        this.defaultFlags = defaultFlags == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(defaultFlags);
        this.userFlags = userFlags == null ? new ArrayList<String>() : new ArrayList<String>(userFlags);
        this.releaseJavaVersion = releaseJavaVersion;
        this.sourceJavaVersion = sourceJavaVersion;
        this.targetJavaVersion = targetJavaVersion;
        this.annotationProcessors = annotationProcessors;
    }

    public List<String> toList() {
        ArrayList<String> flagList = new ArrayList<String>();
        LinkedHashSet<String> effectiveDefaultFlags = new LinkedHashSet<String>(this.defaultFlags);
        effectiveDefaultFlags.removeAll(this.userFlags);
        flagList.addAll(effectiveDefaultFlags);
        if (this.releaseJavaVersion != null) {
            flagList.add("--release");
            flagList.add(this.releaseJavaVersion);
        } else {
            if (this.sourceJavaVersion != null) {
                flagList.add("-source");
                flagList.add(this.sourceJavaVersion);
            }
            if (this.targetJavaVersion != null) {
                flagList.add("-target");
                flagList.add(this.targetJavaVersion);
            }
        }
        if (this.annotationProcessors != null && !this.annotationProcessors.isEmpty()) {
            flagList.add("-processor");
            flagList.add(String.join((CharSequence)",", this.annotationProcessors));
        }
        flagList.addAll(this.userFlags);
        return flagList;
    }

    public int hashCode() {
        return this.toList().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CompilerFlags && this.toList().equals(((CompilerFlags)obj).toList());
    }

    public String toString() {
        return "CompilerFlags@{" + String.join((CharSequence)", ", this.toList()) + "}";
    }
}

