/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.testing.CurrentTestApplication;
import io.quarkus.deployment.dev.testing.LogCapturingOutputFilter;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestClassUsages;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestState;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.dev.testing.TestTracingProcessor;
import io.quarkus.deployment.dev.testing.TestType;
import io.quarkus.deployment.util.IoUtil;
import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.testing.TracingHandler;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.platform.commons.annotation.Testable;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.EngineFilter;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class JunitTestRunner {
    private static final Logger log = Logger.getLogger(JunitTestRunner.class);
    public static final DotName QUARKUS_TEST = DotName.createSimple((String)"io.quarkus.test.junit.QuarkusTest");
    public static final DotName QUARKUS_MAIN_TEST = DotName.createSimple((String)"io.quarkus.test.junit.main.QuarkusMainTest");
    public static final DotName QUARKUS_INTEGRATION_TEST = DotName.createSimple((String)"io.quarkus.test.junit.QuarkusIntegrationTest");
    public static final DotName TEST_PROFILE = DotName.createSimple((String)"io.quarkus.test.junit.TestProfile");
    public static final DotName TEST = DotName.createSimple((String)Test.class.getName());
    public static final DotName REPEATED_TEST = DotName.createSimple((String)RepeatedTest.class.getName());
    public static final DotName PARAMETERIZED_TEST = DotName.createSimple((String)ParameterizedTest.class.getName());
    public static final DotName TEST_FACTORY = DotName.createSimple((String)TestFactory.class.getName());
    public static final DotName TEST_TEMPLATE = DotName.createSimple((String)TestTemplate.class.getName());
    public static final DotName TESTABLE = DotName.createSimple((String)Testable.class.getName());
    public static final DotName NESTED = DotName.createSimple((String)Nested.class.getName());
    private static final String ARCHUNIT_FIELDSOURCE_FQCN = "com.tngtech.archunit.junit.FieldSource";
    private final long runId;
    private final DevModeContext.ModuleInfo moduleInfo;
    private final CuratedApplication testApplication;
    private final ClassScanResult classScanResult;
    private final TestClassUsages testClassUsages;
    private final TestState testState;
    private final List<TestRunListener> listeners;
    List<PostDiscoveryFilter> additionalFilters;
    private final Set<String> includeTags;
    private final Set<String> excludeTags;
    private final Pattern include;
    private final Pattern exclude;
    private final List<String> includeEngines;
    private final List<String> excludeEngines;
    private final boolean failingTestsOnly;
    private final TestType testType;
    private volatile boolean testsRunning = false;
    private volatile boolean aborted;

    public JunitTestRunner(Builder builder) {
        this.runId = builder.runId;
        this.moduleInfo = builder.moduleInfo;
        this.testApplication = builder.testApplication;
        this.classScanResult = builder.classScanResult;
        this.testClassUsages = builder.testClassUsages;
        this.listeners = builder.listeners;
        this.additionalFilters = builder.additionalFilters;
        this.testState = builder.testState;
        this.includeTags = new HashSet<String>(builder.includeTags);
        this.excludeTags = new HashSet<String>(builder.excludeTags);
        this.include = builder.include;
        this.exclude = builder.exclude;
        this.includeEngines = builder.includeEngines;
        this.excludeEngines = builder.excludeEngines;
        this.failingTestsOnly = builder.failingTestsOnly;
        this.testType = builder.testType;
    }

    public Runnable prepare() {
        try {
            final long start = System.currentTimeMillis();
            final ClassLoader old = Thread.currentThread().getContextClassLoader();
            final QuarkusClassLoader tcl = this.testApplication.createDeploymentClassLoader();
            final LogCapturingOutputFilter logHandler = new LogCapturingOutputFilter(this.testApplication, true, true, TestSupport.instance().get()::isDisplayTestOutput);
            Thread.currentThread().setContextClassLoader((ClassLoader)tcl);
            final Consumer currentTestAppConsumer = (Consumer)tcl.loadClass(CurrentTestApplication.class.getName()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            currentTestAppConsumer.accept(this.testApplication);
            final HashSet allDiscoveredIds = new HashSet();
            final HashSet dynamicIds = new HashSet();
            final DiscoveryResult quarkusTestClasses = this.discoverTestClasses();
            final Launcher launcher = LauncherFactory.create((LauncherConfig)LauncherConfig.builder().build());
            LauncherDiscoveryRequestBuilder launchBuilder = LauncherDiscoveryRequestBuilder.request().selectors(quarkusTestClasses.testClasses.stream().map(DiscoverySelectors::selectClass).collect(Collectors.toList()));
            launchBuilder.filters(new Filter[]{new PostDiscoveryFilter(){

                public FilterResult apply(TestDescriptor testDescriptor) {
                    allDiscoveredIds.add(testDescriptor.getUniqueId());
                    return FilterResult.included(null);
                }
            }});
            if (this.classScanResult != null) {
                launchBuilder.filters(new Filter[]{this.testClassUsages.getTestsToRun(this.classScanResult.getChangedClassNames(), this.testState)});
            }
            if (!this.includeTags.isEmpty()) {
                launchBuilder.filters(new Filter[]{new TagFilter(false, this.includeTags)});
            } else if (!this.excludeTags.isEmpty()) {
                launchBuilder.filters(new Filter[]{new TagFilter(true, this.excludeTags)});
            }
            if (this.include != null) {
                launchBuilder.filters(new Filter[]{new RegexFilter(false, this.include)});
            } else if (this.exclude != null) {
                launchBuilder.filters(new Filter[]{new RegexFilter(true, this.exclude)});
            }
            if (!this.includeEngines.isEmpty()) {
                launchBuilder.filters(new Filter[]{EngineFilter.includeEngines(this.includeEngines)});
            } else if (!this.excludeEngines.isEmpty()) {
                launchBuilder.filters(new Filter[]{EngineFilter.excludeEngines(this.excludeEngines)});
            }
            if (!this.additionalFilters.isEmpty()) {
                launchBuilder.filters((Filter[])this.additionalFilters.toArray(new PostDiscoveryFilter[0]));
            }
            if (this.failingTestsOnly) {
                launchBuilder.filters(new Filter[]{new CurrentlyFailingFilter()});
            }
            LauncherDiscoveryRequest request = launchBuilder.build();
            final TestPlan testPlan = launcher.discover(request);
            long toRun = testPlan.countTestIdentifiers(TestIdentifier::isTest);
            for (TestRunListener listener : this.listeners) {
                listener.runStarted(toRun);
            }
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ClassLoader origCl = Thread.currentThread().getContextClassLoader();
                    try {
                        JunitTestRunner junitTestRunner = JunitTestRunner.this;
                        synchronized (junitTestRunner) {
                            JunitTestRunner.this.testsRunning = true;
                        }
                        log.debug((Object)("Starting test run with " + testPlan.countTestIdentifiers(s -> true) + " tests"));
                        QuarkusConsole.addOutputFilter((BiPredicate)logHandler);
                        final LinkedBlockingDeque touchedClasses = new LinkedBlockingDeque();
                        final HashMap startTimes = new HashMap();
                        final AtomicReference startupClasses = new AtomicReference();
                        TracingHandler.setTracingHandler((TracingHandler.TraceListener)new TracingHandler.TraceListener(){

                            public void touched(String className) {
                                Set set = (Set)touchedClasses.peek();
                                if (set != null) {
                                    set.add(className);
                                }
                            }

                            public void quarkusStarting() {
                                startupClasses.set((Set)touchedClasses.peek());
                            }
                        });
                        final HashMap<String, Map<UniqueId, TestResult>> resultsByClass = new HashMap<String, Map<UniqueId, TestResult>>();
                        final AtomicReference currentNonDynamicTest = new AtomicReference();
                        Thread.currentThread().setContextClassLoader((ClassLoader)tcl);
                        launcher.execute(testPlan, new TestExecutionListener[]{new TestExecutionListener(){

                            public void executionStarted(TestIdentifier testIdentifier) {
                                if (JunitTestRunner.this.aborted) {
                                    return;
                                }
                                boolean dynamic = dynamicIds.contains(UniqueId.parse((String)testIdentifier.getUniqueId()));
                                if (!dynamic) {
                                    currentNonDynamicTest.set(testIdentifier);
                                }
                                startTimes.put(testIdentifier, System.currentTimeMillis());
                                String testClassName = "";
                                Class<?> testClass = JunitTestRunner.this.getTestClassFromSource(testIdentifier.getSource());
                                if (testClass != null) {
                                    testClassName = testClass.getName();
                                    Thread.currentThread().setContextClassLoader(testClass.getClassLoader());
                                }
                                for (TestRunListener listener : JunitTestRunner.this.listeners) {
                                    listener.testStarted(testIdentifier, testClassName);
                                }
                                touchedClasses.push(Collections.synchronizedSet(new HashSet()));
                            }

                            public void executionSkipped(TestIdentifier testIdentifier, String reason) {
                                if (JunitTestRunner.this.aborted) {
                                    return;
                                }
                                touchedClasses.pop();
                                Class<?> testClass = JunitTestRunner.this.getTestClassFromSource(testIdentifier.getSource());
                                String displayName = JunitTestRunner.this.getDisplayNameFromIdentifier(testIdentifier, testClass);
                                UniqueId id = UniqueId.parse((String)testIdentifier.getUniqueId());
                                if (testClass != null) {
                                    Map results = resultsByClass.computeIfAbsent(testClass.getName(), s -> new HashMap());
                                    TestResult result = new TestResult(displayName, testClass.getName(), id, TestExecutionResult.aborted(null), logHandler.captureOutput(), testIdentifier.isTest(), JunitTestRunner.this.runId, 0L, true);
                                    results.put(id, result);
                                    if (result.isTest()) {
                                        for (TestRunListener listener : JunitTestRunner.this.listeners) {
                                            listener.testComplete(result);
                                        }
                                    }
                                }
                                touchedClasses.push(Collections.synchronizedSet(new HashSet()));
                            }

                            public void dynamicTestRegistered(TestIdentifier testIdentifier) {
                                dynamicIds.add(UniqueId.parse((String)testIdentifier.getUniqueId()));
                                for (TestRunListener listener : JunitTestRunner.this.listeners) {
                                    listener.dynamicTestRegistered(testIdentifier);
                                }
                            }

                            public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
                                block16: {
                                    TestResult result;
                                    Map results;
                                    String testClassName;
                                    Class<?> testClass;
                                    block14: {
                                        block15: {
                                            if (JunitTestRunner.this.aborted) {
                                                return;
                                            }
                                            boolean dynamic = dynamicIds.contains(UniqueId.parse((String)testIdentifier.getUniqueId()));
                                            Set touched = (Set)touchedClasses.pop();
                                            testClass = JunitTestRunner.this.getTestClassFromSource(testIdentifier.getSource());
                                            String displayName = JunitTestRunner.this.getDisplayNameFromIdentifier(testIdentifier, testClass);
                                            UniqueId id = UniqueId.parse((String)testIdentifier.getUniqueId());
                                            if (testClass == null) {
                                                return;
                                            }
                                            testClassName = testClass.getName();
                                            if (testExecutionResult.getStatus() != TestExecutionResult.Status.ABORTED) {
                                                for (Set i : touchedClasses) {
                                                    touched.addAll(i);
                                                }
                                                if (startupClasses.get() != null) {
                                                    touched.addAll((Collection)startupClasses.get());
                                                }
                                                if (testIdentifier.getSource().map(ClassSource.class::isInstance).orElse(false).booleanValue()) {
                                                    JunitTestRunner.this.testClassUsages.updateTestData(testClassName, touched);
                                                } else {
                                                    JunitTestRunner.this.testClassUsages.updateTestData(testClassName, id, touched);
                                                }
                                            }
                                            results = resultsByClass.computeIfAbsent(testClassName, s -> new HashMap());
                                            result = new TestResult(displayName, testClassName, id, testExecutionResult, logHandler.captureOutput(), testIdentifier.isTest(), JunitTestRunner.this.runId, System.currentTimeMillis() - (Long)startTimes.get(testIdentifier), true);
                                            if (!results.containsKey(id)) {
                                                results.put(id, result);
                                            }
                                            if (!result.isTest()) break block14;
                                            for (TestRunListener testRunListener : JunitTestRunner.this.listeners) {
                                                testRunListener.testComplete(result);
                                            }
                                            if (!dynamic || testExecutionResult.getStatus() != TestExecutionResult.Status.FAILED) break block15;
                                            RuntimeException failure = new RuntimeException("A child test failed");
                                            failure.setStackTrace(new StackTraceElement[0]);
                                            results.put(id, new TestResult(((TestIdentifier)currentNonDynamicTest.get()).getDisplayName(), result.getTestClass(), ((TestIdentifier)currentNonDynamicTest.get()).getUniqueIdObject(), TestExecutionResult.failed((Throwable)failure), List.of(), false, JunitTestRunner.this.runId, 0L, false));
                                            results.put(UniqueId.parse((String)((TestIdentifier)currentNonDynamicTest.get()).getUniqueId()), result);
                                            break block16;
                                        }
                                        if (testExecutionResult.getStatus() != TestExecutionResult.Status.FAILED) break block16;
                                        Throwable throwable = (Throwable)testExecutionResult.getThrowable().get();
                                        JunitTestRunner.this.trimStackTrace(testClass, throwable);
                                        for (Throwable i : throwable.getSuppressed()) {
                                            JunitTestRunner.this.trimStackTrace(testClass, i);
                                        }
                                        break block16;
                                    }
                                    if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
                                        Set children = testPlan.getChildren(testIdentifier);
                                        for (TestIdentifier child : children) {
                                            UniqueId childId = UniqueId.parse((String)child.getUniqueId());
                                            result = new TestResult(child.getDisplayName(), testClassName, childId, testExecutionResult, logHandler.captureOutput(), child.isTest(), JunitTestRunner.this.runId, System.currentTimeMillis() - (Long)startTimes.get(testIdentifier), true);
                                            results.put(childId, result);
                                            if (!child.isTest()) continue;
                                            for (TestRunListener listener : JunitTestRunner.this.listeners) {
                                                listener.testStarted(child, testClassName);
                                                listener.testComplete(result);
                                            }
                                        }
                                        Throwable throwable = (Throwable)testExecutionResult.getThrowable().get();
                                        JunitTestRunner.this.trimStackTrace(testClass, throwable);
                                        for (Throwable i : throwable.getSuppressed()) {
                                            JunitTestRunner.this.trimStackTrace(testClass, i);
                                        }
                                    }
                                }
                            }

                            public void reportingEntryPublished(TestIdentifier testIdentifier, ReportEntry entry) {
                            }
                        }});
                        if (JunitTestRunner.this.aborted) {
                            return;
                        }
                        JunitTestRunner.this.testState.updateResults(resultsByClass);
                        JunitTestRunner.this.testState.pruneDeletedTests(allDiscoveredIds, dynamicIds);
                        if (JunitTestRunner.this.classScanResult != null) {
                            JunitTestRunner.this.testState.classesRemoved(JunitTestRunner.this.classScanResult.getDeletedClassNames());
                        }
                        QuarkusConsole.removeOutputFilter((BiPredicate)logHandler);
                        for (TestRunListener listener : JunitTestRunner.this.listeners) {
                            listener.runComplete(new TestRunResults(JunitTestRunner.this.runId, JunitTestRunner.this.classScanResult, JunitTestRunner.this.classScanResult == null, start, System.currentTimeMillis(), JunitTestRunner.this.toResultsMap(JunitTestRunner.this.testState.getCurrentResults())));
                        }
                    }
                    finally {
                        try {
                            currentTestAppConsumer.accept(null);
                            TracingHandler.setTracingHandler(null);
                            QuarkusConsole.removeOutputFilter((BiPredicate)logHandler);
                            Thread.currentThread().setContextClassLoader(old);
                            tcl.close();
                            try {
                                quarkusTestClasses.close();
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        finally {
                            Thread.currentThread().setContextClassLoader(origCl);
                            JunitTestRunner junitTestRunner = JunitTestRunner.this;
                            synchronized (junitTestRunner) {
                                JunitTestRunner.this.testsRunning = false;
                                if (JunitTestRunner.this.aborted) {
                                    JunitTestRunner.this.notifyAll();
                                }
                            }
                        }
                    }
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> getTestClassFromSource(Optional<TestSource> optionalTestSource) {
        if (optionalTestSource.isPresent()) {
            TestSource testSource = optionalTestSource.get();
            if (testSource instanceof ClassSource) {
                return ((ClassSource)testSource).getJavaClass();
            }
            if (testSource instanceof MethodSource) {
                return ((MethodSource)testSource).getJavaClass();
            }
            if (testSource.getClass().getName().equals(ARCHUNIT_FIELDSOURCE_FQCN)) {
                try {
                    return (Class)testSource.getClass().getMethod("getJavaClass", new Class[0]).invoke((Object)testSource, new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    log.warnf((Throwable)e, "Failed to read javaClass reflectively from %s. ArchUnit >= 0.23.0 is required.", (Object)testSource);
                }
            }
        }
        return null;
    }

    private String getDisplayNameFromIdentifier(TestIdentifier testIdentifier, Class<?> testClass) {
        if (testIdentifier.getSource().isPresent() && testClass != null) {
            TestSource testSource = (TestSource)testIdentifier.getSource().get();
            if (testSource instanceof ClassSource) {
                return testIdentifier.getDisplayName();
            }
            if (testSource instanceof MethodSource || testSource.getClass().getName().equals(ARCHUNIT_FIELDSOURCE_FQCN)) {
                return testClass.getSimpleName() + "#" + testIdentifier.getDisplayName();
            }
        }
        return testIdentifier.getDisplayName();
    }

    private void trimStackTrace(Class<?> testClass, Throwable throwable) {
        if (testClass != null) {
            for (Throwable cause = throwable; cause != null; cause = cause.getCause()) {
                StackTraceElement[] newst;
                StackTraceElement elem;
                int i;
                StackTraceElement[] st = cause.getStackTrace();
                for (i = st.length - 1; i >= 0; --i) {
                    elem = st[i];
                    if (!elem.getClassName().equals(testClass.getName())) continue;
                    newst = new StackTraceElement[i + 1];
                    System.arraycopy(st, 0, newst, 0, i + 1);
                    st = newst;
                    break;
                }
                for (i = st.length - 1; i >= 0; --i) {
                    elem = st[i];
                    if (!elem.getClassName().startsWith("io.restassured")) continue;
                    newst = new StackTraceElement[st.length - i];
                    System.arraycopy(st, i, newst, 0, st.length - i);
                    st = newst;
                    break;
                }
                cause.setStackTrace(st);
            }
        }
    }

    public synchronized void abort() {
        for (TestRunListener listener : this.listeners) {
            try {
                listener.runAborted();
            }
            catch (Throwable t) {
                log.error((Object)"Failed to invoke test listener", t);
            }
        }
        this.aborted = true;
        while (this.testsRunning) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Map<String, TestClassResult> toResultsMap(Map<String, Map<UniqueId, TestResult>> resultsByClass) {
        HashMap<String, TestClassResult> resultMap = new HashMap<String, TestClassResult>();
        HashSet<String> classes = new HashSet<String>(resultsByClass.keySet());
        for (String clazz : classes) {
            ArrayList<TestResult> passing = new ArrayList<TestResult>();
            ArrayList<TestResult> failing = new ArrayList<TestResult>();
            ArrayList<TestResult> skipped = new ArrayList<TestResult>();
            long time = 0L;
            for (TestResult i : Optional.ofNullable(resultsByClass.get(clazz)).orElse(Collections.emptyMap()).values()) {
                if (i.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED) {
                    failing.add(i);
                } else if (i.getTestExecutionResult().getStatus() == TestExecutionResult.Status.ABORTED) {
                    skipped.add(i);
                } else {
                    passing.add(i);
                }
                if (!i.getUniqueId().getLastSegment().getType().equals("class")) continue;
                time = i.time;
            }
            resultMap.put(clazz, new TestClassResult(clazz, passing, failing, skipped, time));
        }
        return resultMap;
    }

    private DiscoveryResult discoverTestClasses() {
        Indexer indexer = new Indexer();
        this.moduleInfo.getTest().ifPresent(test -> {
            try (Stream<Path> files = Files.walk(Paths.get(test.getClassesPath(), new String[0]), new FileVisitOption[0]);){
                files.filter(s -> s.getFileName().toString().endsWith(".class")).forEach(s -> {
                    try (InputStream in = Files.newInputStream(s, new OpenOption[0]);){
                        indexer.index(in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        final Index index = indexer.complete();
        HashSet<Object> integrationTestClasses = new HashSet<Object>();
        for (Object i : index.getAnnotations(QUARKUS_INTEGRATION_TEST)) {
            DotName name = i.target().asClass().name();
            integrationTestClasses.add(name.toString());
            for (ClassInfo clazz : index.getAllKnownSubclasses(name)) {
                integrationTestClasses.add(clazz.name().toString());
            }
        }
        HashSet<Object> quarkusTestClasses = new HashSet<Object>();
        for (DotName a : Arrays.asList(QUARKUS_TEST, QUARKUS_MAIN_TEST)) {
            for (AnnotationInstance i : index.getAnnotations(a)) {
                DotName dotName = i.target().asClass().name();
                quarkusTestClasses.add(dotName.toString());
                for (ClassInfo clazz : index.getAllKnownSubclasses(dotName)) {
                    if (integrationTestClasses.contains(clazz.name().toString())) continue;
                    quarkusTestClasses.add(clazz.name().toString());
                }
            }
        }
        Set<DotName> allTestAnnotations = JunitTestRunner.collectTestAnnotations(index);
        HashSet<DotName> allTestClasses = new HashSet<DotName>();
        HashMap<DotName, DotName> enclosingClasses = new HashMap<DotName, DotName>();
        for (DotName dotName : allTestAnnotations) {
            for (AnnotationInstance instance : index.getAnnotations(dotName)) {
                DotName enclosing;
                if (instance.target().kind() == AnnotationTarget.Kind.METHOD) {
                    ClassInfo classInfo = instance.target().asMethod().declaringClass();
                    allTestClasses.add(classInfo.name());
                    if (classInfo.declaredAnnotation(NESTED) == null || (enclosing = classInfo.enclosingClass()) == null) continue;
                    enclosingClasses.put(classInfo.name(), enclosing);
                    continue;
                }
                if (instance.target().kind() != AnnotationTarget.Kind.FIELD) continue;
                ClassInfo classInfo = instance.target().asField().declaringClass();
                allTestClasses.add(classInfo.name());
                if (classInfo.declaredAnnotation(NESTED) == null || (enclosing = classInfo.enclosingClass()) == null) continue;
                enclosingClasses.put(classInfo.name(), enclosing);
            }
        }
        HashSet<Object> unitTestClasses = new HashSet<Object>();
        for (DotName testClass : allTestClasses) {
            ClassInfo clazz;
            String name = testClass.toString();
            if (integrationTestClasses.contains(name) || quarkusTestClasses.contains(name)) continue;
            DotName dotName = (DotName)enclosingClasses.get(testClass);
            if (dotName != null) {
                if (integrationTestClasses.contains(dotName.toString())) {
                    integrationTestClasses.add(name);
                    continue;
                }
                if (quarkusTestClasses.contains(dotName.toString())) {
                    quarkusTestClasses.add(name);
                    continue;
                }
            }
            if (Modifier.isAbstract((clazz = index.getClassByName(testClass)).flags())) continue;
            unitTestClasses.add(name);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList utClasses = new ArrayList();
        for (String string : quarkusTestClasses) {
            try {
                arrayList.add(Thread.currentThread().getContextClassLoader().loadClass(string));
            }
            catch (ClassNotFoundException e) {
                log.warnf("Failed to load test class %s (possibly as it was added after the test run started), it will not be executed this run.", (Object)string);
            }
        }
        arrayList.sort(Comparator.comparing(new Function<Class<?>, String>(){

            @Override
            public String apply(Class<?> aClass) {
                ClassInfo def = index.getClassByName(DotName.createSimple((String)aClass.getName()));
                AnnotationInstance testProfile = def.declaredAnnotation(TEST_PROFILE);
                if (testProfile == null) {
                    return "$$" + aClass.getName();
                }
                return testProfile.value().asClass().name().toString() + "$$" + aClass.getName();
            }
        }));
        QuarkusClassLoader cl = null;
        if (!unitTestClasses.isEmpty()) {
            QuarkusClassLoader quarkusClassLoader = (QuarkusClassLoader)Thread.currentThread().getContextClassLoader();
            HashSet classesToTransform = new HashSet(quarkusClassLoader.getLocalClassNames());
            HashMap<CallSite, byte[]> transformedClasses = new HashMap<CallSite, byte[]>();
            for (String string : classesToTransform) {
                try {
                    byte[] classData = IoUtil.readBytes(quarkusClassLoader.getResourceAsStream(string.replace('.', '/') + ".class"));
                    ClassReader cr = new ClassReader(classData);
                    QuarkusClassWriter writer = new QuarkusClassWriter(cr, 3);
                    cr.accept((ClassVisitor)new TestTracingProcessor.TracingClassVisitor((ClassVisitor)writer, string), 0);
                    transformedClasses.put((CallSite)((Object)(string.replace('.', '/') + ".class")), writer.toByteArray());
                }
                catch (Exception e) {
                    log.error((Object)("Failed to instrument " + string + " for usage tracking"), (Throwable)e);
                }
            }
            cl = this.testApplication.createDeploymentClassLoader();
            cl.reset(Collections.emptyMap(), transformedClasses);
            for (String string : unitTestClasses) {
                try {
                    utClasses.add(cl.loadClass(string));
                }
                catch (ClassNotFoundException exception) {
                    log.warnf("Failed to load test class %s (possibly as it was added after the test run started), it will not be executed this run.", (Object)string);
                }
            }
        }
        if (this.testType == TestType.ALL) {
            ArrayList arrayList2 = new ArrayList(utClasses.size() + arrayList.size());
            arrayList2.addAll(utClasses);
            arrayList2.addAll(arrayList);
            return new DiscoveryResult(cl, arrayList2);
        }
        if (this.testType == TestType.UNIT) {
            return new DiscoveryResult(cl, utClasses);
        }
        return new DiscoveryResult(cl, arrayList);
    }

    private static Set<DotName> collectTestAnnotations(Index index) {
        HashSet<DotName> ret = new HashSet<DotName>();
        ret.add(TEST);
        ret.add(REPEATED_TEST);
        ret.add(PARAMETERIZED_TEST);
        ret.add(TEST_FACTORY);
        ret.add(TEST_TEMPLATE);
        ret.add(TESTABLE);
        HashSet<DotName> metaAnnotations = new HashSet<DotName>(ret);
        metaAnnotations.add(TESTABLE);
        for (DotName an : metaAnnotations) {
            for (AnnotationInstance instance : index.getAnnotations(an)) {
                if (instance.target().kind() != AnnotationTarget.Kind.CLASS) continue;
                ret.add(instance.target().asClass().name());
            }
        }
        HashSet<DotName> processed = new HashSet<DotName>();
        processed.addAll(ret);
        for (ClassInfo clazz : index.getKnownClasses()) {
            for (DotName annotation : clazz.annotationsMap().keySet()) {
                if (processed.contains(annotation)) continue;
                processed.add(annotation);
                try {
                    Class<?> loadedAnnotation = Thread.currentThread().getContextClassLoader().loadClass(annotation.toString());
                    if (!loadedAnnotation.isAnnotationPresent(Testable.class)) continue;
                    ret.add(annotation);
                }
                catch (ClassNotFoundException e) {
                    log.warn((Object)("Unable to load annotation type " + annotation + " cannot determine if it is @Testable"));
                }
            }
        }
        return ret;
    }

    public TestState getResults() {
        return this.testState;
    }

    public boolean isRunning() {
        return this.testsRunning;
    }

    static class DiscoveryResult
    implements AutoCloseable {
        final QuarkusClassLoader classLoader;
        final List<Class<?>> testClasses;

        DiscoveryResult(QuarkusClassLoader classLoader, List<Class<?>> testClasses) {
            this.classLoader = classLoader;
            this.testClasses = testClasses;
        }

        @Override
        public void close() throws Exception {
            if (this.classLoader != null) {
                this.classLoader.close();
            }
        }
    }

    private class CurrentlyFailingFilter
    implements PostDiscoveryFilter {
        private CurrentlyFailingFilter() {
        }

        public FilterResult apply(TestDescriptor testDescriptor) {
            if (testDescriptor.getSource().isPresent() && testDescriptor.getSource().get() instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)testDescriptor.getSource().get();
                String name = methodSource.getJavaClass().getName();
                Map<UniqueId, TestResult> results = JunitTestRunner.this.testState.getCurrentResults().get(name);
                if (results == null) {
                    return FilterResult.included((String)"new test");
                }
                TestResult testResult = results.get(testDescriptor.getUniqueId());
                if (testResult == null) {
                    return FilterResult.included((String)"new test");
                }
                return FilterResult.includedIf((testResult.getTestExecutionResult().getStatus() == TestExecutionResult.Status.FAILED ? 1 : 0) != 0);
            }
            return FilterResult.included((String)"not a method");
        }
    }

    private static class RegexFilter
    implements PostDiscoveryFilter {
        final boolean exclude;
        final Pattern pattern;

        private RegexFilter(boolean exclude, Pattern pattern) {
            this.exclude = exclude;
            this.pattern = pattern;
        }

        public FilterResult apply(TestDescriptor testDescriptor) {
            if (testDescriptor.getSource().isPresent() && testDescriptor.getSource().get() instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)testDescriptor.getSource().get();
                String name = methodSource.getJavaClass().getName();
                if (this.pattern.matcher(name).matches()) {
                    return FilterResult.includedIf((!this.exclude ? 1 : 0) != 0);
                }
                return FilterResult.includedIf((boolean)this.exclude);
            }
            return FilterResult.included((String)"not a method");
        }
    }

    private static class TagFilter
    implements PostDiscoveryFilter {
        final boolean exclude;
        final Set<String> tags;

        private TagFilter(boolean exclude, Set<String> tags) {
            this.exclude = exclude;
            this.tags = tags;
        }

        public FilterResult apply(TestDescriptor testDescriptor) {
            if (testDescriptor.getSource().isPresent() && testDescriptor.getSource().get() instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)testDescriptor.getSource().get();
                Method m = methodSource.getJavaMethod();
                FilterResult res = this.filterTags(m);
                if (res != null) {
                    return res;
                }
                res = this.filterTags(methodSource.getJavaClass());
                if (res != null) {
                    return res;
                }
                return FilterResult.includedIf((boolean)this.exclude);
            }
            return FilterResult.included((String)"not a method");
        }

        public FilterResult filterTags(AnnotatedElement clz) {
            ArrayList<Tag> all = new ArrayList<Tag>();
            this.gatherTags(clz, all);
            if (all.isEmpty()) {
                return null;
            }
            for (Tag i : all) {
                if (!this.tags.contains(i.value())) continue;
                return FilterResult.includedIf((!this.exclude ? 1 : 0) != 0);
            }
            return FilterResult.includedIf((boolean)this.exclude);
        }

        private void gatherTags(AnnotatedElement clz, List<Tag> all) {
            Tag tag = clz.getAnnotation(Tag.class);
            Tags tagsAnn = clz.getAnnotation(Tags.class);
            if (tag != null) {
                all.add(tag);
            } else if (tagsAnn != null) {
                all.addAll(List.of(tagsAnn.value()));
            }
            if (clz instanceof Class && ((Class)clz).isAnnotation()) {
                return;
            }
            for (Annotation a : clz.getAnnotations()) {
                this.gatherTags(a.annotationType(), all);
            }
        }
    }

    static class Builder {
        private DevModeContext.ModuleInfo moduleInfo;
        private TestType testType = TestType.ALL;
        private TestState testState;
        private long runId = -1L;
        private CuratedApplication testApplication;
        private ClassScanResult classScanResult;
        private TestClassUsages testClassUsages;
        private final List<TestRunListener> listeners = new ArrayList<TestRunListener>();
        private final List<PostDiscoveryFilter> additionalFilters = new ArrayList<PostDiscoveryFilter>();
        private List<String> includeTags = Collections.emptyList();
        private List<String> excludeTags = Collections.emptyList();
        private Pattern include;
        private Pattern exclude;
        private List<String> includeEngines = Collections.emptyList();
        private List<String> excludeEngines = Collections.emptyList();
        private boolean failingTestsOnly;

        Builder() {
        }

        public Builder setRunId(long runId) {
            this.runId = runId;
            return this;
        }

        public Builder setModuleInfo(DevModeContext.ModuleInfo moduleInfo) {
            this.moduleInfo = moduleInfo;
            return this;
        }

        public Builder setTestType(TestType testType) {
            this.testType = testType;
            return this;
        }

        public Builder setTestApplication(CuratedApplication testApplication) {
            this.testApplication = testApplication;
            return this;
        }

        public Builder setClassScanResult(ClassScanResult classScanResult) {
            this.classScanResult = classScanResult;
            return this;
        }

        public Builder setIncludeTags(List<String> includeTags) {
            this.includeTags = includeTags;
            return this;
        }

        public Builder setExcludeTags(List<String> excludeTags) {
            this.excludeTags = excludeTags;
            return this;
        }

        public Builder setTestClassUsages(TestClassUsages testClassUsages) {
            this.testClassUsages = testClassUsages;
            return this;
        }

        public Builder addListener(TestRunListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public Builder addAdditionalFilter(PostDiscoveryFilter filter) {
            this.additionalFilters.add(filter);
            return this;
        }

        public Builder setTestState(TestState testState) {
            this.testState = testState;
            return this;
        }

        public Builder setInclude(Pattern include) {
            this.include = include;
            return this;
        }

        public Builder setExclude(Pattern exclude) {
            this.exclude = exclude;
            return this;
        }

        public Builder setIncludeEngines(List<String> includeEngines) {
            this.includeEngines = includeEngines;
            return this;
        }

        public Builder setExcludeEngines(List<String> excludeEngines) {
            this.excludeEngines = excludeEngines;
            return this;
        }

        public JunitTestRunner build() {
            Objects.requireNonNull(this.testClassUsages, "testClassUsages");
            Objects.requireNonNull(this.testApplication, "testApplication");
            Objects.requireNonNull(this.testState, "testState");
            return new JunitTestRunner(this);
        }

        public Builder setFailingTestsOnly(boolean failingTestsOnly) {
            this.failingTestsOnly = failingTestsOnly;
            return this;
        }
    }
}

