/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.builditem;

import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class ArchiveRootBuildItem
extends SimpleBuildItem {
    private final Path archiveLocation;
    private final Path archiveRoot;
    private final Collection<Path> excludedFromIndexing;
    private final PathsCollection rootDirs;
    private final PathsCollection paths;

    public static Builder builder() {
        return new Builder();
    }

    public ArchiveRootBuildItem(Path appClassesDir) {
        this(appClassesDir, appClassesDir);
    }

    @Deprecated
    public ArchiveRootBuildItem(Path archiveLocation, Path archiveRoot) {
        this(archiveLocation, archiveRoot, Collections.emptySet());
    }

    private ArchiveRootBuildItem(Path archiveLocation, Path archiveRoot, Collection<Path> excludedFromIndexing) {
        if (!Files.isDirectory(archiveRoot, new LinkOption[0])) {
            throw new IllegalArgumentException(archiveRoot + " does not point to the application output directory");
        }
        this.archiveLocation = archiveLocation;
        this.rootDirs = PathsCollection.of((Path[])new Path[]{archiveRoot});
        this.paths = PathsCollection.of((Path[])new Path[]{archiveLocation});
        this.archiveRoot = archiveRoot;
        this.excludedFromIndexing = excludedFromIndexing;
    }

    private ArchiveRootBuildItem(Builder builder, QuarkusBuildCloseablesBuildItem buildCloseables) throws IOException {
        this.archiveLocation = builder.archiveLocation;
        this.excludedFromIndexing = builder.excludedFromIndexing;
        PathsCollection.Builder rootDirs = PathsCollection.builder();
        PathsCollection.Builder paths = PathsCollection.builder();
        for (Path root : builder.archiveRoots) {
            paths.add(root);
            if (Files.isDirectory(root, new LinkOption[0])) {
                rootDirs.add(root);
                continue;
            }
            FileSystem fs = buildCloseables.add(FileSystems.newFileSystem(root, null));
            fs.getRootDirectories().forEach(arg_0 -> ((PathsCollection.Builder)rootDirs).add(arg_0));
        }
        this.rootDirs = rootDirs.build();
        this.paths = paths.build();
        this.archiveRoot = (Path)this.rootDirs.iterator().next();
    }

    @Deprecated
    public Path getArchiveLocation() {
        return this.archiveLocation;
    }

    @Deprecated
    public Path getArchiveRoot() {
        return this.archiveRoot;
    }

    public PathsCollection getRootDirs() {
        return this.rootDirs;
    }

    public PathsCollection getPaths() {
        return this.paths;
    }

    public boolean isExcludedFromIndexing(Path p) {
        return this.excludedFromIndexing.contains(p);
    }

    public static class Builder {
        private Path archiveLocation;
        private List<Path> archiveRoots = new ArrayList<Path>();
        private Collection<Path> excludedFromIndexing;

        private Builder() {
        }

        public Builder addArchiveRoot(Path root) {
            this.archiveRoots.add(root);
            return this;
        }

        public Builder addArchiveRoots(PathsCollection paths) {
            paths.forEach(this.archiveRoots::add);
            return this;
        }

        public Builder setExcludedFromIndexing(Collection<Path> excludedFromIndexing) {
            this.excludedFromIndexing = excludedFromIndexing;
            return this;
        }

        public Builder setArchiveLocation(Path archiveLocation) {
            this.archiveLocation = archiveLocation;
            return this;
        }

        public ArchiveRootBuildItem build(QuarkusBuildCloseablesBuildItem buildCloseables) throws IOException {
            return new ArchiveRootBuildItem(this, buildCloseables);
        }
    }
}

