/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedNativeImageClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ForceNonWeakReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.JniRuntimeAccessBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageProxyDefinitionBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourcePatternsBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveFieldBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeReinitializedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.deployment.builditem.nativeimage.UnsafeAccessedFieldBuildItem;
import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.CatchBlockCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.runtime.ResourceHelper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class NativeImageAutoFeatureStep {
    private static final String GRAAL_AUTOFEATURE = "io/quarkus/runner/AutoFeature";
    private static final MethodDescriptor IMAGE_SINGLETONS_LOOKUP = MethodDescriptor.ofMethod(ImageSingletons.class, (String)"lookup", Object.class, (Class[])new Class[]{Class.class});
    private static final MethodDescriptor INITIALIZE_CLASSES_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{Class[].class});
    private static final MethodDescriptor INITIALIZE_PACKAGES_AT_RUN_TIME = MethodDescriptor.ofMethod(RuntimeClassInitialization.class, (String)"initializeAtRunTime", Void.TYPE, (Class[])new Class[]{String[].class});
    private static final MethodDescriptor RERUN_INITIALIZATION = MethodDescriptor.ofMethod((Object)"org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport", (String)"rerunInitialization", Void.TYPE, (Object[])new Object[]{Class.class, String.class});
    private static final MethodDescriptor RESOURCES_REGISTRY_ADD_RESOURCES = MethodDescriptor.ofMethod((Object)"com.oracle.svm.core.configure.ResourcesRegistry", (String)"addResources", Void.TYPE, (Object[])new Object[]{String.class});
    private static final MethodDescriptor RESOURCES_REGISTRY_IGNORE_RESOURCES = MethodDescriptor.ofMethod((Object)"com.oracle.svm.core.configure.ResourcesRegistry", (String)"ignoreResources", Void.TYPE, (Object[])new Object[]{String.class});
    static final String RUNTIME_REFLECTION = RuntimeReflection.class.getName();
    static final String JNI_RUNTIME_ACCESS = "com.oracle.svm.core.jni.JNIRuntimeAccess";
    static final String BEFORE_ANALYSIS_ACCESS = Feature.BeforeAnalysisAccess.class.getName();
    static final String DYNAMIC_PROXY_REGISTRY = "com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry";
    static final String LEGACY_LOCALIZATION_FEATURE = "com.oracle.svm.core.jdk.LocalizationFeature";
    static final String LOCALIZATION_FEATURE = "com.oracle.svm.core.jdk.localization.LocalizationFeature";

    @BuildStep
    void generateFeature(final BuildProducer<GeneratedNativeImageClassBuildItem> nativeImageClass, List<RuntimeInitializedClassBuildItem> runtimeInitializedClassBuildItems, List<RuntimeInitializedPackageBuildItem> runtimeInitializedPackageBuildItems, List<RuntimeReinitializedClassBuildItem> runtimeReinitializedClassBuildItems, List<NativeImageProxyDefinitionBuildItem> proxies, List<NativeImageResourceBuildItem> resources, List<NativeImageResourcePatternsBuildItem> resourcePatterns, List<NativeImageResourceBundleBuildItem> resourceBundles, List<ReflectiveMethodBuildItem> reflectiveMethods, List<ReflectiveFieldBuildItem> reflectiveFields, List<ReflectiveClassBuildItem> reflectiveClassBuildItems, List<ForceNonWeakReflectiveClassBuildItem> nonWeakReflectiveClassBuildItems, List<ServiceProviderBuildItem> serviceProviderBuildItems, List<UnsafeAccessedFieldBuildItem> unsafeAccessedFields, List<JniRuntimeAccessBuildItem> jniRuntimeAccessibleClasses) {
        TryBlock tc;
        ResultHandle thisClass;
        ClassCreator file = new ClassCreator(new ClassOutput(){

            public void write(String s, byte[] bytes) {
                nativeImageClass.produce(new GeneratedNativeImageClassBuildItem(s, bytes));
            }
        }, GRAAL_AUTOFEATURE, null, Object.class.getName(), new String[]{Feature.class.getName()});
        file.addAnnotation("com.oracle.svm.core.annotate.AutomaticFeature");
        MethodCreator beforeAn = file.getMethodCreator("beforeAnalysis", "V", new String[]{BEFORE_ANALYSIS_ACCESS});
        TryBlock overallCatch = beforeAn.tryBlock();
        ResultHandle beforeAnalysisParam = beforeAn.getMethodParam(0);
        for (UnsafeAccessedFieldBuildItem unsafeAccessedField : unsafeAccessedFields) {
            TryBlock tc2 = overallCatch.tryBlock();
            ResultHandle declaringClassHandle = tc2.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{tc2.load(unsafeAccessedField.getDeclaringClass())});
            ResultHandle resultHandle = tc2.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), declaringClassHandle, new ResultHandle[]{tc2.load(unsafeAccessedField.getFieldName())});
            tc2.invokeInterfaceMethod(MethodDescriptor.ofMethod(Feature.BeforeAnalysisAccess.class, (String)"registerAsUnsafeAccessed", Void.TYPE, (Class[])new Class[]{Field.class}), beforeAnalysisParam, new ResultHandle[]{resultHandle});
            CatchBlockCreator cc = tc2.addCatch(Throwable.class);
            cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
        }
        if (!runtimeInitializedClassBuildItems.isEmpty()) {
            thisClass = overallCatch.loadClass(GRAAL_AUTOFEATURE);
            ResultHandle cl = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            ResultHandle classes = overallCatch.newArray(Class.class, overallCatch.load(runtimeInitializedClassBuildItems.size()));
            for (int i = 0; i < runtimeInitializedClassBuildItems.size(); ++i) {
                TryBlock tryBlock = overallCatch.tryBlock();
                ResultHandle clazz = tryBlock.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tryBlock.load(runtimeInitializedClassBuildItems.get(i).getClassName()), tryBlock.load(false), cl});
                tryBlock.writeArrayValue(classes, i, clazz);
                CatchBlockCreator cc = tryBlock.addCatch(Throwable.class);
                cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
            }
            overallCatch.invokeStaticMethod(INITIALIZE_CLASSES_AT_RUN_TIME, new ResultHandle[]{classes});
        }
        if (!runtimeInitializedPackageBuildItems.isEmpty()) {
            ResultHandle packages = overallCatch.newArray(String.class, overallCatch.load(runtimeInitializedPackageBuildItems.size()));
            for (int i = 0; i < runtimeInitializedPackageBuildItems.size(); ++i) {
                TryBlock tc2 = overallCatch.tryBlock();
                ResultHandle pkg = tc2.load(runtimeInitializedPackageBuildItems.get(i).getPackageName());
                tc2.writeArrayValue(packages, i, pkg);
                CatchBlockCreator catchBlockCreator = tc2.addCatch(Throwable.class);
                catchBlockCreator.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), catchBlockCreator.getCaughtException(), new ResultHandle[0]);
            }
            overallCatch.invokeStaticMethod(INITIALIZE_PACKAGES_AT_RUN_TIME, new ResultHandle[]{packages});
        }
        if (!runtimeReinitializedClassBuildItems.isEmpty()) {
            thisClass = overallCatch.loadClass(GRAAL_AUTOFEATURE);
            ResultHandle cl = overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getClassLoader", ClassLoader.class, (Class[])new Class[0]), thisClass, new ResultHandle[0]);
            Iterator<Object> initSingleton = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{overallCatch.loadClass("org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport")});
            ResultHandle quarkus = overallCatch.load("Quarkus");
            for (RuntimeReinitializedClassBuildItem runtimeReinitializedClass : runtimeReinitializedClassBuildItems) {
                tc = overallCatch.tryBlock();
                ResultHandle clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load(runtimeReinitializedClass.getClassName()), tc.load(false), cl});
                tc.invokeInterfaceMethod(RERUN_INITIALIZATION, initSingleton, new ResultHandle[]{clazz, quarkus});
                CatchBlockCreator cc = tc.addCatch(Throwable.class);
                cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
            }
        }
        if (!proxies.isEmpty()) {
            ResultHandle proxySupportClass = overallCatch.loadClass(DYNAMIC_PROXY_REGISTRY);
            ResultHandle proxySupport = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{proxySupportClass});
            for (NativeImageProxyDefinitionBuildItem proxy : proxies) {
                ResultHandle resultHandle = overallCatch.newArray(Class.class, overallCatch.load(proxy.getClasses().size()));
                int i = 0;
                for (String p : proxy.getClasses()) {
                    ResultHandle clazz = overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(p)});
                    overallCatch.writeArrayValue(resultHandle, i++, clazz);
                }
                overallCatch.invokeInterfaceMethod(MethodDescriptor.ofMethod((Object)DYNAMIC_PROXY_REGISTRY, (String)"addProxyClass", Void.TYPE, (Object[])new Object[]{Class[].class}), proxySupport, new ResultHandle[]{resultHandle});
            }
        }
        for (NativeImageResourceBuildItem i : resources) {
            for (String j : i.getResources()) {
                overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(j)});
            }
        }
        if (!resourcePatterns.isEmpty()) {
            ResultHandle resourcesRegistrySingleton = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{overallCatch.loadClass("com.oracle.svm.core.configure.ResourcesRegistry")});
            TryBlock tc4 = overallCatch.tryBlock();
            for (NativeImageResourcePatternsBuildItem resourcePatternsItem : resourcePatterns) {
                for (String pattern : resourcePatternsItem.getExcludePatterns()) {
                    tc4.invokeInterfaceMethod(RESOURCES_REGISTRY_IGNORE_RESOURCES, resourcesRegistrySingleton, new ResultHandle[]{overallCatch.load(pattern)});
                }
                for (String pattern : resourcePatternsItem.getIncludePatterns()) {
                    tc4.invokeInterfaceMethod(RESOURCES_REGISTRY_ADD_RESOURCES, resourcesRegistrySingleton, new ResultHandle[]{tc4.load(pattern)});
                }
            }
            CatchBlockCreator cc = tc4.addCatch(Throwable.class);
            cc.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), cc.getCaughtException(), new ResultHandle[0]);
        }
        for (ServiceProviderBuildItem i : serviceProviderBuildItems) {
            overallCatch.invokeStaticMethod(MethodDescriptor.ofMethod(ResourceHelper.class, (String)"registerResources", Void.TYPE, (Class[])new Class[]{String.class}), new ResultHandle[]{overallCatch.load(i.serviceDescriptorFile())});
        }
        if (!resourceBundles.isEmpty()) {
            AssignableResultHandle registerMethod = overallCatch.createVariable(Method.class);
            AssignableResultHandle locClass = overallCatch.createVariable(Class.class);
            TryBlock locTryBlock = overallCatch.tryBlock();
            ResultHandle legacyLocClass = locTryBlock.loadClass(LEGACY_LOCALIZATION_FEATURE);
            locTryBlock.assign(locClass, legacyLocClass);
            ResultHandle resultHandle = locTryBlock.marshalAsArray(Class.class, new ResultHandle[]{locTryBlock.loadClass(String.class)});
            ResultHandle legacyRegisterMethod = locTryBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), legacyLocClass, new ResultHandle[]{locTryBlock.load("addBundleToCache"), resultHandle});
            locTryBlock.assign(registerMethod, legacyRegisterMethod);
            CatchBlockCreator locCatchBlock = locTryBlock.addCatch(NoClassDefFoundError.class);
            ResultHandle newLocClass = locCatchBlock.loadClass(LOCALIZATION_FEATURE);
            locCatchBlock.assign(locClass, newLocClass);
            ResultHandle newParams = locCatchBlock.marshalAsArray(Class.class, new ResultHandle[]{locCatchBlock.loadClass(String.class)});
            ResultHandle newRegisterMethod = locCatchBlock.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), newLocClass, new ResultHandle[]{locCatchBlock.load("prepareBundle"), newParams});
            locCatchBlock.assign(registerMethod, newRegisterMethod);
            overallCatch.invokeVirtualMethod(MethodDescriptor.ofMethod(AccessibleObject.class, (String)"setAccessible", Void.TYPE, (Class[])new Class[]{Boolean.TYPE}), (ResultHandle)registerMethod, new ResultHandle[]{overallCatch.load(true)});
            ResultHandle locSupport = overallCatch.invokeStaticMethod(IMAGE_SINGLETONS_LOOKUP, new ResultHandle[]{locClass});
            for (NativeImageResourceBundleBuildItem i : resourceBundles) {
                TryBlock et = overallCatch.tryBlock();
                et.invokeVirtualMethod(MethodDescriptor.ofMethod(Method.class, (String)"invoke", Object.class, (Class[])new Class[]{Object.class, Object[].class}), (ResultHandle)registerMethod, new ResultHandle[]{locSupport, et.marshalAsArray(Object.class, new ResultHandle[]{et.load(i.getBundleName())})});
                CatchBlockCreator catchBlockCreator = et.addCatch(Throwable.class);
            }
        }
        int count = 0;
        LinkedHashMap<String, ReflectionInfo> reflectiveClasses = new LinkedHashMap<String, ReflectionInfo>();
        HashSet<String> forcedNonWeakClasses = new HashSet<String>();
        for (ForceNonWeakReflectiveClassBuildItem forceNonWeakReflectiveClassBuildItem : nonWeakReflectiveClassBuildItems) {
            forcedNonWeakClasses.add(forceNonWeakReflectiveClassBuildItem.getClassName());
        }
        for (ReflectiveClassBuildItem reflectiveClassBuildItem : reflectiveClassBuildItems) {
            this.addReflectiveClass(reflectiveClasses, forcedNonWeakClasses, reflectiveClassBuildItem.isConstructors(), reflectiveClassBuildItem.isMethods(), reflectiveClassBuildItem.isFields(), reflectiveClassBuildItem.areFinalFieldsWritable(), reflectiveClassBuildItem.isWeak(), reflectiveClassBuildItem.getClassNames().toArray(new String[0]));
        }
        for (ReflectiveFieldBuildItem reflectiveFieldBuildItem : reflectiveFields) {
            this.addReflectiveField(reflectiveClasses, reflectiveFieldBuildItem);
        }
        for (ReflectiveMethodBuildItem reflectiveMethodBuildItem : reflectiveMethods) {
            this.addReflectiveMethod(reflectiveClasses, reflectiveMethodBuildItem);
        }
        for (ServiceProviderBuildItem serviceProviderBuildItem : serviceProviderBuildItems) {
            this.addReflectiveClass(reflectiveClasses, forcedNonWeakClasses, true, false, false, false, false, serviceProviderBuildItem.providers().toArray(new String[0]));
        }
        for (Map.Entry entry : reflectiveClasses.entrySet()) {
            ResultHandle fhandle;
            String type;
            ResultHandle paramArray;
            ResultHandle farray;
            MethodCreator mv = file.getMethodCreator("registerClass" + count++, "V", new String[0]);
            mv.setModifiers(10);
            overallCatch.invokeStaticMethod(mv.getMethodDescriptor(), new ResultHandle[0]);
            tc = mv.tryBlock();
            ResultHandle currentThread = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"currentThread", Thread.class, (Class[])new Class[0]), new ResultHandle[0]);
            ResultHandle tccl = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]), currentThread, new ResultHandle[0]);
            ResultHandle clazz = tc.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc.load((String)entry.getKey()), tc.load(false), tccl});
            ResultHandle constructors = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructors", Constructor[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
            ResultHandle methods = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethods", Method[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
            ResultHandle fields = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredFields", Field[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
            if (!((ReflectionInfo)entry.getValue()).weak) {
                ResultHandle carray = tc.newArray(Class.class, tc.load(1));
                tc.writeArrayValue(carray, 0, clazz);
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
            }
            if (((ReflectionInfo)entry.getValue()).constructors) {
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
            } else if (!((ReflectionInfo)entry.getValue()).ctorSet.isEmpty()) {
                farray = tc.newArray(Constructor.class, tc.load(1));
                for (ReflectiveMethodBuildItem ctor : ((ReflectionInfo)entry.getValue()).ctorSet) {
                    paramArray = tc.newArray(Class.class, tc.load(ctor.getParams().length));
                    for (int i = 0; i < ctor.getParams().length; ++i) {
                        type = ctor.getParams()[i];
                        tc.writeArrayValue(paramArray, i, tc.loadClass(type));
                    }
                    fhandle = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructor", Constructor.class, (Class[])new Class[]{Class[].class}), clazz, new ResultHandle[]{paramArray});
                    tc.writeArrayValue(farray, 0, fhandle);
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                }
            }
            if (((ReflectionInfo)entry.getValue()).methods) {
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
            } else if (!((ReflectionInfo)entry.getValue()).methodSet.isEmpty()) {
                farray = tc.newArray(Method.class, tc.load(1));
                for (ReflectiveMethodBuildItem method : ((ReflectionInfo)entry.getValue()).methodSet) {
                    paramArray = tc.newArray(Class.class, tc.load(method.getParams().length));
                    for (int i = 0; i < method.getParams().length; ++i) {
                        type = method.getParams()[i];
                        tc.writeArrayValue(paramArray, i, tc.loadClass(type));
                    }
                    fhandle = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethod", Method.class, (Class[])new Class[]{String.class, Class[].class}), clazz, new ResultHandle[]{tc.load(method.getName()), paramArray});
                    tc.writeArrayValue(farray, 0, fhandle);
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{farray});
                }
            }
            if (((ReflectionInfo)entry.getValue()).fields) {
                tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Boolean.TYPE, Field[].class}), new ResultHandle[]{tc.load(((ReflectionInfo)entry.getValue()).finalFieldsWritable), fields});
            } else if (!((ReflectionInfo)entry.getValue()).fieldSet.isEmpty()) {
                farray = tc.newArray(Field.class, tc.load(1));
                for (String field : ((ReflectionInfo)entry.getValue()).fieldSet) {
                    ResultHandle fhandle2 = tc.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredField", Field.class, (Class[])new Class[]{String.class}), clazz, new ResultHandle[]{tc.load(field)});
                    tc.writeArrayValue(farray, 0, fhandle2);
                    tc.invokeStaticMethod(MethodDescriptor.ofMethod((Object)RUNTIME_REFLECTION, (String)"register", Void.TYPE, (Object[])new Object[]{Field[].class}), new ResultHandle[]{farray});
                }
            }
            CatchBlockCreator cc = tc.addCatch(Throwable.class);
            mv.returnValue(null);
        }
        count = 0;
        for (JniRuntimeAccessBuildItem jniRuntimeAccessBuildItem : jniRuntimeAccessibleClasses) {
            for (String className : jniRuntimeAccessBuildItem.getClassNames()) {
                MethodCreator mv = file.getMethodCreator("registerJniAccessibleClass" + count++, "V", new String[0]);
                mv.setModifiers(10);
                overallCatch.invokeStaticMethod(mv.getMethodDescriptor(), new ResultHandle[0]);
                TryBlock tc5 = mv.tryBlock();
                ResultHandle currentThread = tc5.invokeStaticMethod(MethodDescriptor.ofMethod(Thread.class, (String)"currentThread", Thread.class, (Class[])new Class[0]), new ResultHandle[0]);
                ResultHandle tccl = tc5.invokeVirtualMethod(MethodDescriptor.ofMethod(Thread.class, (String)"getContextClassLoader", ClassLoader.class, (Class[])new Class[0]), currentThread, new ResultHandle[0]);
                ResultHandle clazz = tc5.invokeStaticMethod(MethodDescriptor.ofMethod(Class.class, (String)"forName", Class.class, (Class[])new Class[]{String.class, Boolean.TYPE, ClassLoader.class}), new ResultHandle[]{tc5.load(className), tc5.load(false), tccl});
                ResultHandle constructors = tc5.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredConstructors", Constructor[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
                ResultHandle methods = tc5.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredMethods", Method[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
                ResultHandle fields = tc5.invokeVirtualMethod(MethodDescriptor.ofMethod(Class.class, (String)"getDeclaredFields", Field[].class, (Class[])new Class[0]), clazz, new ResultHandle[0]);
                ResultHandle carray = tc5.newArray(Class.class, tc5.load(1));
                tc5.writeArrayValue(carray, 0, clazz);
                tc5.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Class[].class}), new ResultHandle[]{carray});
                if (jniRuntimeAccessBuildItem.isConstructors()) {
                    tc5.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{constructors});
                }
                if (jniRuntimeAccessBuildItem.isMethods()) {
                    tc5.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Executable[].class}), new ResultHandle[]{methods});
                }
                if (jniRuntimeAccessBuildItem.isFields()) {
                    tc5.invokeStaticMethod(MethodDescriptor.ofMethod((Object)JNI_RUNTIME_ACCESS, (String)"register", Void.TYPE, (Object[])new Object[]{Boolean.TYPE, Field[].class}), new ResultHandle[]{tc5.load(jniRuntimeAccessBuildItem.isFinalFieldsWriteable()), fields});
                }
                CatchBlockCreator cc = tc5.addCatch(Throwable.class);
                mv.returnValue(null);
            }
        }
        CatchBlockCreator print = overallCatch.addCatch(Throwable.class);
        print.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"printStackTrace", Void.TYPE, (Class[])new Class[0]), print.getCaughtException(), new ResultHandle[0]);
        beforeAn.loadClass("io.quarkus.runner.ApplicationImpl");
        beforeAn.returnValue(null);
        file.close();
    }

    public void addReflectiveMethod(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveMethodBuildItem methodInfo) {
        String cl = methodInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        if (methodInfo.getName().equals("<init>")) {
            existing.ctorSet.add(methodInfo);
        } else {
            existing.methodSet.add(methodInfo);
        }
    }

    public void addReflectiveClass(Map<String, ReflectionInfo> reflectiveClasses, Set<String> forcedNonWeakClasses, boolean constructors, boolean method, boolean fields, boolean finalFieldsWritable, boolean weak, String ... className) {
        for (String cl : className) {
            ReflectionInfo existing = reflectiveClasses.get(cl);
            if (existing == null) {
                reflectiveClasses.put(cl, new ReflectionInfo(constructors, method, fields, finalFieldsWritable, !forcedNonWeakClasses.contains(cl) && weak));
                continue;
            }
            if (constructors) {
                existing.constructors = true;
            }
            if (method) {
                existing.methods = true;
            }
            if (!fields) continue;
            existing.fields = true;
        }
    }

    public void addReflectiveField(Map<String, ReflectionInfo> reflectiveClasses, ReflectiveFieldBuildItem fieldInfo) {
        String cl = fieldInfo.getDeclaringClass();
        ReflectionInfo existing = reflectiveClasses.get(cl);
        if (existing == null) {
            existing = new ReflectionInfo(false, false, false, false, false);
            reflectiveClasses.put(cl, existing);
        }
        existing.fieldSet.add(fieldInfo.getName());
    }

    static final class ReflectionInfo {
        boolean constructors;
        boolean methods;
        boolean fields;
        boolean finalFieldsWritable;
        boolean weak;
        Set<String> fieldSet = new HashSet<String>();
        Set<ReflectiveMethodBuildItem> methodSet = new HashSet<ReflectiveMethodBuildItem>();
        Set<ReflectiveMethodBuildItem> ctorSet = new HashSet<ReflectiveMethodBuildItem>();

        private ReflectionInfo(boolean constructors, boolean methods, boolean fields, boolean finalFieldsWritable, boolean weak) {
            this.methods = methods;
            this.fields = fields;
            this.constructors = constructors;
            this.finalFieldsWritable = finalFieldsWritable;
            this.weak = weak;
        }
    }
}

