/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.docker.common.deployment;

import io.quarkus.container.image.docker.common.deployment.RedHatOpenJDKRuntimeBaseProvider;
import io.quarkus.container.image.docker.common.deployment.UbiMinimalBaseProvider;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public interface DockerFileBaseInformationProvider {
    public Optional<DockerFileBaseInformation> determine(Path var1);

    public static DockerFileBaseInformationProvider impl() {
        return new DockerFileBaseInformationProvider(){
            private final List<DockerFileBaseInformationProvider> delegates = List.of(new UbiMinimalBaseProvider(), new RedHatOpenJDKRuntimeBaseProvider());

            @Override
            public Optional<DockerFileBaseInformation> determine(Path dockerFile) {
                for (DockerFileBaseInformationProvider delegate : this.delegates) {
                    Optional<DockerFileBaseInformation> result = delegate.determine(dockerFile);
                    if (!result.isPresent()) continue;
                    return result;
                }
                return Optional.empty();
            }
        };
    }

    public record DockerFileBaseInformation(String baseImage, int javaVersion) {
    }
}

