/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.buildpack.deployment;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.PushResponseItem;
import dev.snowdrop.buildpack.BuildConfig;
import dev.snowdrop.buildpack.BuildConfigBuilder;
import dev.snowdrop.buildpack.BuildConfigFluent;
import dev.snowdrop.buildpack.Logger;
import dev.snowdrop.buildpack.config.EditableRegistryAuthConfig;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.config.RegistryAuthConfig;
import dev.snowdrop.buildpack.config.RegistryAuthConfigBuilder;
import dev.snowdrop.buildpack.docker.DockerClientUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.buildpack.deployment.BuildpackBuild;
import io.quarkus.container.image.buildpack.deployment.BuildpackConfig;
import io.quarkus.container.image.buildpack.deployment.BuildpackLogger;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.EnablementUtil;
import io.quarkus.container.image.deployment.util.NativeBinaryUtil;
import io.quarkus.container.spi.AvailableContainerImageExtensionBuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageBuilderBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.util.PathsUtil;
import io.quarkus.deployment.IsNormalNotRemoteDev;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.JvmStartupOptimizerArchiveResultBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class BuildpackProcessor {
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(BuildpackProcessor.class);
    private static final String QUARKUS_CONTAINER_IMAGE_BUILD = "QUARKUS_CONTAINER_IMAGE_BUILD";
    private static final String QUARKUS_CONTAINER_IMAGE_PUSH = "QUARKUS_CONTAINER_IMAGE_PUSH";
    public static final String BUILDPACK = "buildpack";

    @BuildStep
    public AvailableContainerImageExtensionBuildItem availability() {
        return new AvailableContainerImageExtensionBuildItem(BUILDPACK);
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, BuildpackBuild.class}, onlyIfNot={NativeBuild.class})
    public void buildFromJar(ContainerImageConfig containerImageConfig, BuildpackConfig buildpackConfig, ContainerImageInfoBuildItem containerImage, JarBuildItem sourceJar, MainClassBuildItem mainClass, OutputTargetBuildItem outputTarget, CurateOutcomeBuildItem curateOutcome, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, Optional<JvmStartupOptimizerArchiveResultBuildItem> jvmStartupOptimizerArchiveResult, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder) {
        boolean buildContainerImage = EnablementUtil.buildContainerImageNeeded((ContainerImageConfig)containerImageConfig, buildRequest);
        boolean pushContainerImage = EnablementUtil.pushContainerImageNeeded((ContainerImageConfig)containerImageConfig, pushRequest);
        if (!buildContainerImage && !pushContainerImage) {
            return;
        }
        if (containerImageConfig.isBuildExplicitlyDisabled()) {
            return;
        }
        log.info((Object)"Starting (local) container image build for jar using buildpack.");
        String targetImageName = this.runBuildpackBuild(buildpackConfig, containerImage, containerImageConfig, buildContainerImage, pushContainerImage, outputTarget, false);
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Collections.singletonMap("container-image", targetImageName)));
        containerImageBuilder.produce((BuildItem)new ContainerImageBuilderBuildItem(BUILDPACK));
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, BuildpackBuild.class, NativeBuild.class})
    public void buildFromNative(ContainerImageConfig containerImageConfig, BuildpackConfig buildpackConfig, ContainerImageInfoBuildItem containerImage, NativeImageBuildItem nativeImage, OutputTargetBuildItem outputTarget, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder) {
        boolean buildContainerImage = EnablementUtil.buildContainerImageNeeded((ContainerImageConfig)containerImageConfig, buildRequest);
        boolean pushContainerImage = EnablementUtil.pushContainerImageNeeded((ContainerImageConfig)containerImageConfig, pushRequest);
        if (!buildContainerImage && !pushContainerImage) {
            return;
        }
        if (containerImageConfig.isBuildExplicitlyDisabled()) {
            return;
        }
        if (!NativeBinaryUtil.nativeIsLinuxBinary((NativeImageBuildItem)nativeImage)) {
            throw new RuntimeException("The native binary produced by the build is not a Linux binary and therefore cannot be used in a Linux container image. Consider adding \"quarkus.native.container-build=true\" to your configuration");
        }
        log.info((Object)"Starting (local) container image build for native binary using buildpack.");
        String targetImageName = this.runBuildpackBuild(buildpackConfig, containerImage, containerImageConfig, buildContainerImage, pushContainerImage, outputTarget, true);
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Collections.singletonMap("container-image", targetImageName)));
        containerImageBuilder.produce((BuildItem)new ContainerImageBuilderBuildItem(BUILDPACK));
    }

    private Map<ProjectDirs, Path> getPaths(OutputTargetBuildItem outputTarget) {
        Path targetDirectory = outputTarget.getOutputDirectory();
        AbstractMap.SimpleEntry mainSourcesRoot = PathsUtil.findMainSourcesRoot((Path)targetDirectory);
        if (mainSourcesRoot == null) {
            throw new RuntimeException("Buildpack build unable to determine project dir");
        }
        Path sourceRoot = (Path)mainSourcesRoot.getKey();
        Path projectRoot = (Path)mainSourcesRoot.getValue();
        if (!projectRoot.toFile().exists() || !sourceRoot.toFile().exists()) {
            throw new RuntimeException("Buildpack build unable to verify project dir");
        }
        HashMap<ProjectDirs, Path> result = new HashMap<ProjectDirs, Path>();
        result.put(ProjectDirs.ROOT, projectRoot);
        result.put(ProjectDirs.SOURCE, sourceRoot);
        result.put(ProjectDirs.TARGET, targetDirectory);
        return result;
    }

    private String runBuildpackBuild(BuildpackConfig buildpackConfig, ContainerImageInfoBuildItem containerImage, ContainerImageConfig containerImageConfig, boolean buildContainerImage, boolean pushContainerImage, OutputTargetBuildItem outputTarget, boolean isNativeBuild) {
        Map<ProjectDirs, Path> dirs = this.getPaths(outputTarget);
        log.debug((Object)("Using target dir of " + String.valueOf(dirs.get((Object)ProjectDirs.TARGET))));
        log.debug((Object)("Using source root of " + String.valueOf(dirs.get((Object)ProjectDirs.SOURCE))));
        log.debug((Object)("Using project root of " + String.valueOf(dirs.get((Object)ProjectDirs.ROOT))));
        String targetImageName = containerImage.getImage();
        log.debug((Object)("Using Destination image of " + targetImageName));
        HashMap<String, String> envMap = new HashMap<String, String>(buildpackConfig.builderEnv());
        if (!envMap.isEmpty()) {
            log.info((Object)("Using builder environment with vars " + String.valueOf(envMap.keySet())));
        }
        ArrayList<EditableRegistryAuthConfig> authConfigs = new ArrayList<EditableRegistryAuthConfig>();
        HashMap<String, String> registryUserMap = new HashMap<String, String>(buildpackConfig.registryUser());
        HashMap<String, String> registryPasswordMap = new HashMap<String, String>(buildpackConfig.registryPassword());
        HashMap<String, String> registryTokenMap = new HashMap<String, String>(buildpackConfig.registryToken());
        HashSet registries = new HashSet();
        registries.addAll(registryUserMap.keySet());
        registries.addAll(registryPasswordMap.keySet());
        registries.addAll(registryTokenMap.keySet());
        for (String registry : registries) {
            authConfigs.add(((RegistryAuthConfigBuilder)RegistryAuthConfig.builder().accept(RegistryAuthConfigBuilder.class, a -> {
                a.withRegistryAddress(registry);
                if (registryUserMap.containsKey(registry)) {
                    log.debug((Object)("adding username to auth credential for " + registry));
                    a.withUsername((String)registryUserMap.get(registry));
                }
                if (registryPasswordMap.containsKey(registry)) {
                    log.debug((Object)("adding password to auth credential for " + registry));
                    a.withPassword((String)registryPasswordMap.get(registry));
                }
                if (registryTokenMap.containsKey(registry)) {
                    log.debug((Object)("adding token to auth credential for " + registry));
                    a.withRegistryToken((String)registryTokenMap.get(registry));
                }
            })).build());
        }
        if (containerImageConfig.username().isPresent() && containerImageConfig.password().isPresent()) {
            String registry = null;
            registry = !containerImageConfig.registry().isPresent() ? containerImage.getRegistry().orElseGet(() -> {
                log.info((Object)"No container image registry was set, so 'docker.io' will be used");
                return "docker.io";
            }) : (String)containerImageConfig.registry().get();
            if (registry != null && !registries.contains(registry)) {
                log.debug((Object)"Adding auth creds from container-image properties");
                authConfigs.add(((RegistryAuthConfigBuilder)((RegistryAuthConfigBuilder)((RegistryAuthConfigBuilder)RegistryAuthConfig.builder().withUsername((String)containerImageConfig.username().get())).withPassword((String)containerImageConfig.password().get())).withRegistryAddress(registry)).build());
            }
        }
        envMap.put(QUARKUS_CONTAINER_IMAGE_BUILD, "false");
        envMap.put(QUARKUS_CONTAINER_IMAGE_PUSH, "false");
        if (buildContainerImage) {
            log.info((Object)"Initiating Buildpack build");
            int exitCode = ((BuildConfigBuilder)((BuildConfigBuilder)((BuildConfigFluent.DockerConfigNested)((BuildConfigFluent.DockerConfigNested)((BuildConfigFluent.DockerConfigNested)((BuildConfigFluent.DockerConfigNested)((BuildConfigFluent.DockerConfigNested)((BuildConfigFluent.DockerConfigNested)((BuildConfigBuilder)((BuildConfigFluent.LogConfigNested)((BuildConfigFluent.LogConfigNested)((BuildConfigFluent.LogConfigNested)((BuildConfigBuilder)((BuildConfigFluent.PlatformConfigNested)((BuildConfigBuilder)((BuildConfigBuilder)BuildConfig.builder().addNewFileContentApplication(dirs.get((Object)ProjectDirs.ROOT).toFile())).withOutputImage(new ImageReference(targetImageName))).withNewPlatformConfig().withEnvironment(envMap)).endPlatformConfig()).withNewLogConfig().withLogger((Logger)new BuildpackLogger())).withLogLevel(buildpackConfig.logLevel())).withUseTimestamps(buildpackConfig.getUseTimestamps())).endLogConfig()).withNewDockerConfig().withPullRetryIncreaseSeconds(buildpackConfig.pullTimeoutIncreaseSeconds())).withPullTimeoutSeconds(buildpackConfig.pullTimeoutSeconds())).withPullRetryCount(buildpackConfig.pullRetryCount())).withDockerNetwork((String)buildpackConfig.dockerNetwork().orElse(null))).withUseDaemon(buildpackConfig.useDaemon())).withAuthConfigs(authConfigs)).endDockerConfig()).accept(BuildConfigBuilder.class, b -> {
                if (isNativeBuild) {
                    buildpackConfig.nativeBuilderImage().ifPresent(i -> b.withBuilderImage(new ImageReference(i)));
                } else {
                    b.withBuilderImage(new ImageReference(buildpackConfig.jvmBuilderImage()));
                }
                if (buildpackConfig.runImage().isPresent()) {
                    log.info((Object)("Using Run image of " + buildpackConfig.runImage().get()));
                    b.withRunImage(new ImageReference(buildpackConfig.runImage().get()));
                }
                if (buildpackConfig.trustBuilderImage().isPresent()) {
                    log.info((Object)("Setting trusted image to " + String.valueOf(buildpackConfig.trustBuilderImage().get())));
                    ((BuildConfigFluent.PlatformConfigNested)b.editPlatformConfig().withTrustBuilder(buildpackConfig.trustBuilderImage().get())).endPlatformConfig();
                }
                BuildConfigFluent.DockerConfigNested dc = b.editDockerConfig();
                buildpackConfig.dockerHost().ifPresent(dh -> dc.withDockerHost(dh));
                buildpackConfig.dockerSocket().ifPresent(ds -> dc.withDockerSocket(ds));
                dc.endDockerConfig();
                buildpackConfig.lifecycleImage().ifPresent(li -> ((BuildConfigFluent.PlatformConfigNested)b.editPlatformConfig().withLifecycleImage(new ImageReference(li))).endPlatformConfig());
                buildpackConfig.platformLevel().ifPresent(pl -> ((BuildConfigFluent.PlatformConfigNested)b.editPlatformConfig().withPlatformLevel(pl)).endPlatformConfig());
            })).build().getExitCode();
            if (exitCode != 0) {
                throw new IllegalStateException("Buildpack build failed");
            }
            log.info((Object)"Buildpack build complete");
        }
        if (pushContainerImage && Boolean.TRUE.equals(buildpackConfig.useDaemon())) {
            log.info((Object)"Pushing image to registry");
            Stream.concat(Stream.of(containerImage.getImage()), containerImage.getAdditionalImageTags().stream()).forEach(i -> {
                DockerClientUtils.HostAndSocket hns = DockerClientUtils.probeContainerRuntime((DockerClientUtils.HostAndSocket)new DockerClientUtils.HostAndSocket(buildpackConfig.dockerHost().orElse(""), buildpackConfig.dockerSocket().orElse("")));
                DockerClient dockerClient = DockerClientUtils.getDockerClient((DockerClientUtils.HostAndSocket)hns, (List)authConfigs);
                ResultCallback.Adapter<PushResponseItem> callback = new ResultCallback.Adapter<PushResponseItem>(){

                    public void onNext(PushResponseItem object) {
                        log.info((Object)object.toString());
                    }
                };
                dockerClient.pushImageCmd(i).exec((ResultCallback)callback);
                try {
                    callback.awaitCompletion();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            });
        }
        return targetImageName;
    }

    private static enum ProjectDirs {
        TARGET,
        SOURCE,
        ROOT;

    }
}

