/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.buildpack.deployment;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.model.AuthConfig;
import dev.snowdrop.buildpack.BuildConfig;
import dev.snowdrop.buildpack.BuildConfigBuilder;
import dev.snowdrop.buildpack.BuildConfigFluent;
import dev.snowdrop.buildpack.Logger;
import dev.snowdrop.buildpack.config.ImageReference;
import dev.snowdrop.buildpack.docker.DockerClientUtils;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.container.image.buildpack.deployment.BuildpackBuild;
import io.quarkus.container.image.buildpack.deployment.BuildpackConfig;
import io.quarkus.container.image.buildpack.deployment.BuildpackLogger;
import io.quarkus.container.image.deployment.ContainerImageConfig;
import io.quarkus.container.image.deployment.util.EnablementUtil;
import io.quarkus.container.image.deployment.util.NativeBinaryUtil;
import io.quarkus.container.spi.AvailableContainerImageExtensionBuildItem;
import io.quarkus.container.spi.ContainerImageBuildRequestBuildItem;
import io.quarkus.container.spi.ContainerImageBuilderBuildItem;
import io.quarkus.container.spi.ContainerImageInfoBuildItem;
import io.quarkus.container.spi.ContainerImageLabelBuildItem;
import io.quarkus.container.spi.ContainerImagePushRequestBuildItem;
import io.quarkus.container.util.PathsUtil;
import io.quarkus.deployment.IsNormalNotRemoteDev;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.pkg.builditem.AppCDSResultBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.NativeImageBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class BuildpackProcessor {
    private static final org.jboss.logging.Logger log = org.jboss.logging.Logger.getLogger(BuildpackProcessor.class);
    private static final String QUARKUS_CONTAINER_IMAGE_BUILD = "QUARKUS_CONTAINER_IMAGE_BUILD";
    private static final String QUARKUS_CONTAINER_IMAGE_PUSH = "QUARKUS_CONTAINER_IMAGE_PUSH";
    public static final String BUILDPACK = "buildpack";

    @BuildStep
    public AvailableContainerImageExtensionBuildItem availability() {
        return new AvailableContainerImageExtensionBuildItem(BUILDPACK);
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, BuildpackBuild.class}, onlyIfNot={NativeBuild.class})
    public void buildFromJar(ContainerImageConfig containerImageConfig, BuildpackConfig buildpackConfig, ContainerImageInfoBuildItem containerImage, JarBuildItem sourceJar, MainClassBuildItem mainClass, OutputTargetBuildItem outputTarget, CurateOutcomeBuildItem curateOutcome, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, Optional<AppCDSResultBuildItem> appCDSResult, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder) {
        boolean buildContainerImage = EnablementUtil.buildContainerImageNeeded((ContainerImageConfig)containerImageConfig, buildRequest);
        boolean pushContainerImage = EnablementUtil.pushContainerImageNeeded((ContainerImageConfig)containerImageConfig, pushRequest);
        if (!buildContainerImage && !pushContainerImage) {
            return;
        }
        if (containerImageConfig.isBuildExplicitlyDisabled()) {
            return;
        }
        log.info((Object)"Starting (local) container image build for jar using buildpack.");
        String targetImageName = this.runBuildpackBuild(buildpackConfig, containerImage, containerImageConfig, buildContainerImage, pushContainerImage, outputTarget, false);
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "jar-container", Collections.singletonMap("container-image", targetImageName)));
        containerImageBuilder.produce((BuildItem)new ContainerImageBuilderBuildItem(BUILDPACK));
    }

    @BuildStep(onlyIf={IsNormalNotRemoteDev.class, BuildpackBuild.class, NativeBuild.class})
    public void buildFromNative(ContainerImageConfig containerImageConfig, BuildpackConfig buildpackConfig, ContainerImageInfoBuildItem containerImage, NativeImageBuildItem nativeImage, OutputTargetBuildItem outputTarget, Optional<ContainerImageBuildRequestBuildItem> buildRequest, Optional<ContainerImagePushRequestBuildItem> pushRequest, List<ContainerImageLabelBuildItem> containerImageLabels, BuildProducer<ArtifactResultBuildItem> artifactResultProducer, BuildProducer<ContainerImageBuilderBuildItem> containerImageBuilder) {
        boolean buildContainerImage = EnablementUtil.buildContainerImageNeeded((ContainerImageConfig)containerImageConfig, buildRequest);
        boolean pushContainerImage = EnablementUtil.pushContainerImageNeeded((ContainerImageConfig)containerImageConfig, pushRequest);
        if (!buildContainerImage && !pushContainerImage) {
            return;
        }
        if (containerImageConfig.isBuildExplicitlyDisabled()) {
            return;
        }
        if (!NativeBinaryUtil.nativeIsLinuxBinary((NativeImageBuildItem)nativeImage)) {
            throw new RuntimeException("The native binary produced by the build is not a Linux binary and therefore cannot be used in a Linux container image. Consider adding \"quarkus.native.container-build=true\" to your configuration");
        }
        log.info((Object)"Starting (local) container image build for native binary using buildpack.");
        String targetImageName = this.runBuildpackBuild(buildpackConfig, containerImage, containerImageConfig, buildContainerImage, pushContainerImage, outputTarget, true);
        artifactResultProducer.produce((BuildItem)new ArtifactResultBuildItem(null, "native-container", Collections.singletonMap("container-image", targetImageName)));
        containerImageBuilder.produce((BuildItem)new ContainerImageBuilderBuildItem(BUILDPACK));
    }

    private Map<ProjectDirs, Path> getPaths(OutputTargetBuildItem outputTarget) {
        Path targetDirectory = outputTarget.getOutputDirectory();
        AbstractMap.SimpleEntry mainSourcesRoot = PathsUtil.findMainSourcesRoot((Path)targetDirectory);
        if (mainSourcesRoot == null) {
            throw new RuntimeException("Buildpack build unable to determine project dir");
        }
        Path sourceRoot = (Path)mainSourcesRoot.getKey();
        Path projectRoot = (Path)mainSourcesRoot.getValue();
        if (!projectRoot.toFile().exists() || !sourceRoot.toFile().exists()) {
            throw new RuntimeException("Buildpack build unable to verify project dir");
        }
        HashMap<ProjectDirs, Path> result = new HashMap<ProjectDirs, Path>();
        result.put(ProjectDirs.ROOT, projectRoot);
        result.put(ProjectDirs.SOURCE, sourceRoot);
        result.put(ProjectDirs.TARGET, targetDirectory);
        return result;
    }

    private final String getDockerHost(BuildpackConfig buildpackConfig) {
        String dockerHostVal = null;
        if (buildpackConfig.dockerHost().isPresent()) {
            dockerHostVal = buildpackConfig.dockerHost().get();
        } else {
            String dockerHostEnv = System.getenv("DOCKER_HOST");
            if (dockerHostEnv != null && !dockerHostEnv.isEmpty()) {
                dockerHostVal = dockerHostEnv;
            }
        }
        if (dockerHostVal != null) {
            log.info((Object)("Using dockerHost of " + dockerHostVal));
        }
        return dockerHostVal;
    }

    private String runBuildpackBuild(BuildpackConfig buildpackConfig, ContainerImageInfoBuildItem containerImage, ContainerImageConfig containerImageConfig, boolean buildContainerImage, boolean pushContainerImage, OutputTargetBuildItem outputTarget, boolean isNativeBuild) {
        Map<ProjectDirs, Path> dirs = this.getPaths(outputTarget);
        log.debug((Object)("Using target dir of " + String.valueOf(dirs.get((Object)ProjectDirs.TARGET))));
        log.debug((Object)("Using source root of " + String.valueOf(dirs.get((Object)ProjectDirs.SOURCE))));
        log.debug((Object)("Using project root of " + String.valueOf(dirs.get((Object)ProjectDirs.ROOT))));
        String targetImageName = containerImage.getImage();
        log.debug((Object)("Using Destination image of " + targetImageName));
        HashMap<String, String> envMap = new HashMap<String, String>(buildpackConfig.builderEnv());
        if (!envMap.isEmpty()) {
            log.info((Object)("Using builder environment of " + String.valueOf(envMap)));
        }
        envMap.put(QUARKUS_CONTAINER_IMAGE_BUILD, "false");
        envMap.put(QUARKUS_CONTAINER_IMAGE_PUSH, "false");
        if (buildContainerImage) {
            log.info((Object)"Initiating Buildpack build");
            int exitCode = ((BuildConfigBuilder)((BuildConfigBuilder)((BuildConfigFluent.DockerConfigNested)((BuildConfigFluent.DockerConfigNested)((BuildConfigFluent.DockerConfigNested)((BuildConfigFluent.DockerConfigNested)((BuildConfigFluent.DockerConfigNested)((BuildConfigFluent.DockerConfigNested)((BuildConfigBuilder)((BuildConfigFluent.LogConfigNested)((BuildConfigFluent.LogConfigNested)((BuildConfigBuilder)((BuildConfigFluent.PlatformConfigNested)((BuildConfigBuilder)((BuildConfigBuilder)BuildConfig.builder().addNewFileContentApplication(dirs.get((Object)ProjectDirs.ROOT).toFile())).withOutputImage(new ImageReference(targetImageName))).withNewPlatformConfig().withEnvironment(envMap)).endPlatformConfig()).withNewLogConfig().withLogger((Logger)new BuildpackLogger())).withLogLevel(buildpackConfig.logLevel())).endLogConfig()).withNewDockerConfig().withPullRetryIncreaseSeconds(buildpackConfig.pullTimeoutIncreaseSeconds())).withPullTimeoutSeconds(buildpackConfig.pullTimeoutSeconds())).withPullRetryCount(buildpackConfig.pullRetryCount())).withDockerHost(this.getDockerHost(buildpackConfig))).withDockerNetwork((String)buildpackConfig.dockerNetwork().orElse(null))).withUseDaemon(buildpackConfig.useDaemon())).endDockerConfig()).accept(BuildConfigBuilder.class, b -> {
                if (isNativeBuild) {
                    buildpackConfig.nativeBuilderImage().ifPresent(i -> b.withBuilderImage(new ImageReference(i)));
                } else {
                    b.withBuilderImage(new ImageReference(buildpackConfig.jvmBuilderImage()));
                }
                if (buildpackConfig.runImage().isPresent()) {
                    log.info((Object)("Using Run image of " + buildpackConfig.runImage().get()));
                    b.withRunImage(new ImageReference(buildpackConfig.runImage().get()));
                }
                if (buildpackConfig.trustBuilderImage().isPresent()) {
                    log.info((Object)("Setting trusted image to " + String.valueOf(buildpackConfig.trustBuilderImage().get())));
                    ((BuildConfigFluent.PlatformConfigNested)b.editPlatformConfig().withTrustBuilder(buildpackConfig.trustBuilderImage().get())).endPlatformConfig();
                }
            })).build().getExitCode();
            if (exitCode != 0) {
                throw new IllegalStateException("Buildpack build failed");
            }
            log.info((Object)"Buildpack build complete");
        }
        if (pushContainerImage) {
            String registry = containerImage.getRegistry().orElseGet(() -> {
                log.info((Object)"No container image registry was set, so 'docker.io' will be used");
                return "docker.io";
            });
            AuthConfig authConfig = new AuthConfig();
            authConfig.withRegistryAddress(registry);
            containerImageConfig.username().ifPresent(u -> authConfig.withUsername(u));
            containerImageConfig.password().ifPresent(p -> authConfig.withPassword(p));
            log.info((Object)("Pushing image to " + authConfig.getRegistryAddress()));
            Stream.concat(Stream.of(containerImage.getImage()), containerImage.getAdditionalImageTags().stream()).forEach(i -> {
                ResultCallback.Adapter callback = DockerClientUtils.getDockerClient((String)this.getDockerHost(buildpackConfig)).pushImageCmd(i).start();
                try {
                    callback.awaitCompletion();
                    log.info((Object)"Push complete");
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        return targetImageName;
    }

    private static enum ProjectDirs {
        TARGET,
        SOURCE,
        ROOT;

    }
}

