/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.build.ExecuteUtil;
import io.quarkus.cli.common.OutputOptionMixin;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;

public interface PluginCommand
extends Callable<Integer> {
    public List<String> getCommand();

    public List<String> getArguments();

    public OutputOptionMixin getOutput();

    public void useArguments(List<String> var1);

    default public Path getWorkingDirectory() {
        return Paths.get(System.getProperty("user.dir"), new String[0]);
    }

    @Override
    default public Integer call() throws Exception {
        try {
            ArrayList<String> commandWithArgs = new ArrayList<String>();
            commandWithArgs.addAll(this.getCommand());
            commandWithArgs.addAll(this.getArguments());
            ExecuteUtil.executeProcess(this.getOutput(), commandWithArgs.toArray(new String[commandWithArgs.size()]), this.getWorkingDirectory().toFile());
            return 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.getOutput().handleCommandException(e, "Unable to run plugin command: [" + String.join((CharSequence)" ", this.getCommand()) + "] with arguments: [" + String.join((CharSequence)" ", this.getArguments()) + "]");
        }
    }
}

