/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.config;

import io.quarkus.cli.config.BaseConfigCommand;
import io.quarkus.cli.config.Encrypt;
import io.quarkus.devtools.messagewriter.MessageIcons;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.concurrent.Callable;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import picocli.CommandLine;

@CommandLine.Command(name="decrypt", aliases={"dec"}, header={"Decrypt Secrets"}, description={"Decrypt a Secret value using the AES/GCM/NoPadding algorithm as a default."})
public class Decrypt
extends BaseConfigCommand
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", paramLabel="SECRET", description={"The secret value to decrypt"})
    String secret;
    @CommandLine.Parameters(index="1", paramLabel="DECRYPTION KEY", description={"The decryption key"})
    String decryptionKey;
    @CommandLine.Option(names={"-f", "--format"}, description={"The decryption key format (base64 / plain)"}, defaultValue="base64")
    Encrypt.KeyFormat decryptionKeyFormat;
    @CommandLine.Option(hidden=true, names={"-a", "--algorithm"}, description={"Algorithm"}, defaultValue="AES")
    String algorithm;
    @CommandLine.Option(hidden=true, names={"-m", "--mode"}, description={"Mode"}, defaultValue="GCM")
    String mode;
    @CommandLine.Option(hidden=true, names={"-p", "--padding"}, description={"Padding"}, defaultValue="NoPadding")
    String padding;
    @CommandLine.Option(hidden=true, names={"-q", "--quiet"}, defaultValue="false")
    boolean quiet;

    @Override
    public Integer call() throws Exception {
        if (this.decryptionKey.startsWith("\\\"") && this.decryptionKey.endsWith("\"\\")) {
            this.decryptionKey = this.decryptionKey.substring(2, this.decryptionKey.length() - 2);
        }
        byte[] decryptionKeyBytes = this.decryptionKeyFormat.equals((Object)Encrypt.KeyFormat.base64) ? Base64.getUrlDecoder().decode(this.decryptionKey) : this.decryptionKey.getBytes(StandardCharsets.UTF_8);
        Cipher cipher = Cipher.getInstance(this.algorithm + "/" + this.mode + "/" + this.padding);
        ByteBuffer byteBuffer = ByteBuffer.wrap(Base64.getUrlDecoder().decode(this.secret.getBytes(StandardCharsets.UTF_8)));
        byte ivLength = byteBuffer.get();
        byte[] iv = new byte[ivLength];
        byteBuffer.get(iv);
        byte[] encrypted = new byte[byteBuffer.remaining()];
        byteBuffer.get(encrypted);
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(decryptionKeyBytes);
        cipher.init(2, (Key)new SecretKeySpec(sha256.digest(), "AES"), new GCMParameterSpec(128, iv));
        String decrypted = new String(cipher.doFinal(encrypted), StandardCharsets.UTF_8);
        if (!this.quiet) {
            String success = String.valueOf(MessageIcons.SUCCESS_ICON) + " The secret @|bold " + this.secret + "|@ was decrypted to @|bold " + decrypted + "|@";
            this.output.info(success);
        }
        return 0;
    }
}

