/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.plugin.JBangSupport;
import io.quarkus.cli.plugin.PluginCommand;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.util.ArrayList;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command
public class JBangCommand
implements PluginCommand {
    private String location;
    private JBangSupport jbang;
    private OutputOptionMixin output;
    private final List<String> arguments = new ArrayList<String>();

    public JBangCommand() {
    }

    public JBangCommand(String location, OutputOptionMixin output) {
        this.location = location;
        this.jbang = new JBangSupport(!output.isCliTest(), (MessageWriter)output);
        this.output = output;
        this.arguments.add(location);
    }

    @Override
    public Integer call() throws Exception {
        if (this.jbang.ensureJBangIsInstalled()) {
            return PluginCommand.super.call();
        }
        this.output.error("Unable to find JBang! Command execution aborted!");
        return 1;
    }

    @Override
    public List<String> getCommand() {
        return this.jbang.getCommand();
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public OutputOptionMixin getOutput() {
        return this.output;
    }

    @Override
    public void useArguments(List<String> arguments) {
        this.arguments.clear();
        this.arguments.add(this.location);
        this.arguments.addAll(arguments);
    }
}

