/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli;

import io.quarkus.cli.build.BaseBuildCommand;
import io.quarkus.cli.build.BuildSystemRunner;
import io.quarkus.cli.common.CategoryListFormatOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.common.TargetQuarkusPlatformGroup;
import io.quarkus.devtools.commands.ListCategories;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.registry.RegistryResolutionException;
import java.nio.file.Path;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import picocli.CommandLine;

@CommandLine.Command(name="categories", aliases={"cat"}, header={"List extension categories."})
public class ProjectExtensionsCategories
extends BaseBuildCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    RunModeOption runMode;
    @CommandLine.ArgGroup(heading="%nOutput format:%n")
    CategoryListFormatOptions format = new CategoryListFormatOptions();
    @CommandLine.ArgGroup(order=2, heading="%nQuarkus version:%n")
    TargetQuarkusPlatformGroup targetQuarkusVersion = new TargetQuarkusPlatformGroup();

    @Override
    public Integer call() {
        try {
            this.output.debug("List extension categories with initial parameters: %s", new Object[]{this});
            this.output.throwIfUnmatchedArguments(this.spec.commandLine());
            BuildTool buildTool = QuarkusProjectHelper.detectExistingBuildTool((Path)this.projectRoot());
            if (buildTool == null || this.targetQuarkusVersion.isPlatformSpecified() || this.targetQuarkusVersion.isStreamSpecified()) {
                if (this.runMode.isDryRun()) {
                    return this.dryRunList(this.spec.commandLine().getHelp(), null);
                }
                Integer exitCode = this.listPlatformCategories();
                this.printHints(!this.format.isSpecified(), true);
                return exitCode;
            }
            BuildSystemRunner runner = this.getRunner();
            if (this.runMode.isDryRun()) {
                return this.dryRunList(this.spec.commandLine().getHelp(), runner.getBuildTool());
            }
            Integer exitCode = runner.listExtensionCategories(this.runMode, this.format);
            this.printHints(!this.format.isSpecified(), true);
            return exitCode;
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to list extension categories: " + e.getMessage());
        }
    }

    Integer dryRunList(CommandLine.Help help, BuildTool buildTool) {
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        if (buildTool == null) {
            this.output.printText("\nList extension categories for specified platform\n", "\t" + this.targetQuarkusVersion.dryRun());
        } else {
            this.output.printText("\nList extension categories for current project\n", "\t" + this.projectRoot().toString());
            dryRunOutput.put("Build tool", buildTool.name());
        }
        dryRunOutput.put("Batch (non-interactive mode)", Boolean.toString(this.runMode.isBatchMode()));
        dryRunOutput.put("List format", this.format.getFormatString());
        this.output.info(help.createTextTable(dryRunOutput).toString());
        return 0;
    }

    Integer listPlatformCategories() throws QuarkusCommandException, RegistryResolutionException {
        QuarkusProject qp = this.registryClient.createQuarkusProject(this.projectRoot(), this.targetQuarkusVersion, BuildTool.MAVEN, this.output);
        QuarkusCommandOutcome outcome = new ListCategories(qp, (MessageWriter)this.output).fromCli(true).format(this.format.getFormatString()).batchMode(this.runMode.isBatchMode()).execute();
        return outcome.isSuccess() ? 0 : 1;
    }

    private void printHints(boolean formatHint, boolean extensionListHint) {
        if (this.runMode.isBatchMode()) {
            return;
        }
        if (formatHint) {
            this.output.info("");
            this.output.info("To get more information, append `%s` to your command line.", new Object[]{"--full"});
        }
        if (extensionListHint) {
            this.output.info("");
            this.output.info("To list extensions in given category, use:\n%s", new Object[]{"`quarkus extension list --installable --category \"categoryId\"`"});
        }
    }

    public String toString() {
        return "ProjectExtensionsCategories [output=" + String.valueOf(this.output) + ", runMode=" + String.valueOf(this.runMode) + "]";
    }
}

