/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.build;

import io.quarkus.cli.build.BuildSystemRunner;
import io.quarkus.cli.common.HelpOption;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.registry.ToggleRegistryClientMixin;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import java.nio.file.Path;
import java.nio.file.Paths;
import picocli.CommandLine;

public class BaseBuildCommand {
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin(name="output")
    protected OutputOptionMixin output;
    @CommandLine.Mixin
    protected ToggleRegistryClientMixin registryClient;
    @CommandLine.Mixin
    protected HelpOption helpOption;
    @CommandLine.ArgGroup(exclusive=false, validate=false)
    protected PropertiesOptions propertiesOptions = new PropertiesOptions();
    Path projectRoot;

    public Path projectRoot() {
        if (this.projectRoot == null) {
            this.projectRoot = this.output.getTestDirectory();
            if (this.projectRoot == null) {
                this.projectRoot = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();
            }
        }
        return this.projectRoot;
    }

    public BuildSystemRunner getRunner() {
        BuildTool buildTool = QuarkusProjectHelper.detectExistingBuildTool((Path)this.projectRoot());
        return BuildSystemRunner.getRunner(this.output, this.propertiesOptions, this.registryClient, this.projectRoot(), buildTool);
    }

    public void setOutput(OutputOptionMixin output) {
        this.output = output;
    }
}

