/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.create;

import io.quarkus.cli.common.HelpOption;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.common.TargetQuarkusPlatformGroup;
import io.quarkus.cli.create.CodeGenerationGroup;
import io.quarkus.cli.create.TargetGAVGroup;
import io.quarkus.cli.registry.ToggleRegistryClientMixin;
import io.quarkus.devtools.commands.CreateProjectHelper;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.JavaVersion;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.SourceType;
import io.quarkus.registry.RegistryResolutionException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import picocli.CommandLine;

public class BaseCreateCommand
implements Callable<Integer> {
    @CommandLine.Mixin
    protected RunModeOption runMode;
    @CommandLine.Mixin(name="output")
    protected OutputOptionMixin output;
    @CommandLine.Mixin
    ToggleRegistryClientMixin registryClient;
    @CommandLine.Mixin
    protected HelpOption helpOption;
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(paramLabel="OUTPUT-DIR", names={"-o", "--output-directory"}, description={"The directory to create the new project in."})
    String targetDirectory;
    private Map<String, Object> values = new HashMap<String, Object>();
    private Path outputPath;
    private Path projectRootPath;
    private String projectDirName;

    public void setTestOutputDirectory(Path testOutputDirectory) {
        if (testOutputDirectory != null && this.targetDirectory == null) {
            this.outputPath = testOutputDirectory;
        }
    }

    public Path outputDirectory() {
        if (this.outputPath == null) {
            this.outputPath = CreateProjectHelper.createOutputDirectory((String)this.targetDirectory);
        }
        return this.outputPath;
    }

    public void setSingleProjectGAV(TargetGAVGroup targetGav) {
        this.projectDirName = targetGav.getArtifactId();
        this.setValue("project.group-id", targetGav.getGroupId());
        this.setValue("project.artifact-id", targetGav.getArtifactId());
        this.setValue("project.version", targetGav.getVersion());
    }

    public void setExtensionId(String extensionId) {
        this.projectDirName = extensionId;
    }

    public boolean checkProjectRootAlreadyExists(boolean dryRun) {
        if (this.projectRootPath == null) {
            try {
                this.projectRootPath = CreateProjectHelper.checkProjectRootPath((Path)this.outputDirectory(), (String)this.projectDirName);
            }
            catch (IllegalArgumentException iex) {
                if (dryRun) {
                    this.output.warn("A directory named '" + this.projectDirName + "' already exists.");
                    this.projectRootPath = this.outputDirectory().resolve(this.projectDirName);
                }
                this.output.error(iex.getMessage());
                this.output.out().printf("Specify a different artifactId / directory name.%n", new Object[0]);
                this.output.out().printf("See '%s --help' for more information.%n", this.spec.qualifiedName());
                return true;
            }
        }
        return false;
    }

    public Path projectRoot() {
        if (this.projectRootPath == null) {
            this.projectRootPath = CreateProjectHelper.checkProjectRootPath((Path)this.outputDirectory(), (String)this.projectDirName);
        }
        return this.projectRootPath;
    }

    public void setSourceTypeExtensions(Set<String> extensions, SourceType sourceType) {
        extensions = CreateProjectHelper.sanitizeExtensions(extensions);
        CreateProjectHelper.addSourceTypeExtensions((Set)extensions, (SourceType)sourceType);
        this.setValue("project.extensions", extensions);
    }

    public void setJavaVersion(SourceType sourceType, String javaVersion) {
        this.values.put("project.java-version", JavaVersion.computeJavaVersion((SourceType)sourceType, (String)javaVersion));
    }

    public void setCodegenOptions(CodeGenerationGroup codeGeneration) {
        this.setValue("project.package-name", codeGeneration.packageName);
        this.setValue("project.app-config", codeGeneration.getAppConfig());
        this.setValue("codegen.no-code", !codeGeneration.includeCode);
        this.setValue("codegen.no-buildtool-wrapper", !codeGeneration.includeWrapper);
        this.setValue("codegen.no-dockerfiles", !codeGeneration.includeDockerfiles);
    }

    protected void setValue(String name, Object value) {
        if (value != null) {
            this.values.put(name, value);
        }
    }

    public QuarkusCommandInvocation build(BuildTool buildTool, TargetQuarkusPlatformGroup targetVersion, Map<String, String> properties, Collection<String> extensions) throws RegistryResolutionException {
        CreateProjectHelper.handleSpringConfiguration(this.values);
        this.output.debug("Creating an app using the following settings: %s", new Object[]{this.values});
        properties.entrySet().forEach(x -> {
            if (((String)x.getValue()).length() > 0) {
                System.setProperty((String)x.getKey(), (String)x.getValue());
                this.output.info("property: %s=%s", new Object[]{x.getKey(), x.getValue()});
            } else {
                System.setProperty((String)x.getKey(), "");
                this.output.info("property: %s", new Object[]{x.getKey()});
            }
        });
        QuarkusProject qp = this.registryClient.createQuarkusProject(this.projectRoot(), targetVersion, buildTool, this.output, extensions);
        return new QuarkusCommandInvocation(qp, this.values);
    }

    public QuarkusProject getExtensionVersions(BuildTool buildTool, TargetQuarkusPlatformGroup targetVersion) throws RegistryResolutionException {
        return this.registryClient.createQuarkusProject(this.outputDirectory(), targetVersion, buildTool, this.output);
    }

    @Override
    public Integer call() throws Exception {
        this.spec.commandLine().usage(this.output.out());
        return 0;
    }

    public String toString() {
        return "BaseCreateCommand [outputPath=" + String.valueOf(this.outputPath) + ", registryClient=" + String.valueOf(this.registryClient) + ", projectDirName=" + this.projectDirName + ", projectRootPath=" + String.valueOf(this.projectRootPath) + ", targetDirectory=" + this.targetDirectory + ", values=" + String.valueOf(this.values) + "]";
    }

    public void dryRun(BuildTool buildTool, QuarkusCommandInvocation invocation, OutputOptionMixin output) {
        CommandLine.Help help = this.spec.commandLine().getHelp();
        output.printText("\nA new project would have been created in", "\t" + this.projectRoot().toString(), "\nThe project would have been created using the following settings:\n");
        TreeMap<String, String> dryRunOutput = new TreeMap<String, String>();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            dryRunOutput.put(this.prettyName(entry.getKey()), entry.getValue().toString());
        }
        dryRunOutput.put("Quarkus Core Version", invocation.getExtensionsCatalog().getQuarkusCoreVersion());
        dryRunOutput.put("Build tool", buildTool == null ? "JBang" : buildTool.name());
        output.info(help.createTextTable(dryRunOutput).toString());
    }

    public String prettyName(String key) {
        if ("codegen.no-buildtool-wrapper".equals(key)) {
            return "Omit build tool wrapper";
        }
        key = ((String)key).substring(0, 1).toUpperCase() + ((String)key).substring(1);
        StringBuilder builder = new StringBuilder((String)key);
        for (int i = 0; i < builder.length(); ++i) {
            char c = builder.charAt(i);
            if (c != '-' && c != '.') continue;
            builder.replace(i, i + 1, " ");
            builder.replace(i + 1, i + 2, String.valueOf(Character.toUpperCase(builder.charAt(i + 1))));
        }
        return builder.toString();
    }
}

