/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.common;

import io.quarkus.cli.QuarkusCli;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import picocli.CommandLine;

public class OutputOptionMixin
implements MessageWriter {
    static final boolean picocliDebugEnabled = "DEBUG".equalsIgnoreCase(System.getProperty("picocli.trace"));
    boolean verbose = false;
    @CommandLine.Option(names={"-e", "--errors"}, description={"Print more context on errors and exceptions."})
    boolean showErrors;
    @CommandLine.Option(names={"--cli-test"}, hidden=true, description={"Manually set output streams for unit test purposes."})
    boolean cliTestMode;
    Path testProjectRoot;
    @CommandLine.Spec(value=CommandLine.Spec.Target.MIXEE)
    CommandLine.Model.CommandSpec mixee;
    CommandLine.Help.ColorScheme scheme;
    PrintWriter out;
    PrintWriter err;

    @CommandLine.Option(names={"--cli-test-dir"}, hidden=true)
    void setTestProjectRoot(String path) {
        this.testProjectRoot = Paths.get(path, new String[0]).toAbsolutePath();
    }

    CommandLine.Help.ColorScheme colorScheme() {
        CommandLine.Help.ColorScheme colors = this.scheme;
        if (colors == null) {
            colors = this.scheme = this.mixee.commandLine().getColorScheme();
        }
        return colors;
    }

    public PrintWriter out() {
        PrintWriter o = this.out;
        if (o == null) {
            o = this.out = this.mixee.commandLine().getOut();
        }
        return o;
    }

    public PrintWriter err() {
        PrintWriter e = this.err;
        if (e == null) {
            e = this.err = this.mixee.commandLine().getErr();
        }
        return e;
    }

    public boolean isShowErrors() {
        return this.showErrors || picocliDebugEnabled;
    }

    private static OutputOptionMixin getOutput(CommandLine.Model.CommandSpec commandSpec) {
        return ((QuarkusCli)commandSpec.root().userObject()).getOutput();
    }

    @CommandLine.Option(names={"--verbose"}, description={"Verbose mode."})
    public void setVerbose(boolean verbose) {
        OutputOptionMixin.getOutput((CommandLine.Model.CommandSpec)this.mixee).verbose = verbose;
    }

    public boolean getVerbose() {
        return OutputOptionMixin.getOutput((CommandLine.Model.CommandSpec)this.mixee).verbose;
    }

    public boolean isVerbose() {
        return this.getVerbose() || picocliDebugEnabled;
    }

    public boolean isCliTest() {
        return this.cliTestMode;
    }

    public boolean isAnsiEnabled() {
        return CommandLine.Help.Ansi.AUTO.enabled();
    }

    public void printText(String ... text) {
        for (String line : text) {
            PrintWriter printWriter = this.out();
            CommandLine.Help.Ansi ansi = this.colorScheme().ansi();
            Objects.requireNonNull(ansi);
            printWriter.println(new CommandLine.Help.Ansi.Text(ansi, line, this.colorScheme()));
        }
    }

    public void printErrorText(String[] text) {
        for (String line : text) {
            this.err().println(this.colorScheme().errorText(line));
        }
    }

    public void printStackTrace(Exception ex) {
        if (this.isShowErrors()) {
            this.err().println(this.colorScheme().stackTraceText((Throwable)ex));
        }
    }

    public Path getTestDirectory() {
        if (this.isCliTest()) {
            return this.testProjectRoot;
        }
        return null;
    }

    public void info(String msg) {
        PrintWriter printWriter = this.out();
        CommandLine.Help.Ansi ansi = this.colorScheme().ansi();
        Objects.requireNonNull(ansi);
        printWriter.println(new CommandLine.Help.Ansi.Text(ansi, msg, this.colorScheme()));
    }

    public void error(String msg) {
        this.out().println(this.colorScheme().errorText(String.valueOf(MessageIcons.ERROR_ICON) + " " + msg));
    }

    public boolean isDebugEnabled() {
        return this.isVerbose();
    }

    public void debug(String msg) {
        if (this.isVerbose()) {
            PrintWriter printWriter = this.out();
            CommandLine.Help.Ansi ansi = this.colorScheme().ansi();
            Objects.requireNonNull(ansi);
            printWriter.println(new CommandLine.Help.Ansi.Text(ansi, "@|faint [DEBUG] " + msg + "|@", this.colorScheme()));
        }
    }

    public void warn(String msg) {
        PrintWriter printWriter = this.out();
        CommandLine.Help.Ansi ansi = this.colorScheme().ansi();
        Objects.requireNonNull(ansi);
        printWriter.println(new CommandLine.Help.Ansi.Text(ansi, "@|yellow " + String.valueOf(MessageIcons.WARN_ICON) + " " + msg + "|@", this.colorScheme()));
    }

    public void throwIfUnmatchedArguments(CommandLine cmd) {
        List unmatchedArguments = cmd.getUnmatchedArguments();
        if (!unmatchedArguments.isEmpty()) {
            throw new CommandLine.UnmatchedArgumentException(cmd, unmatchedArguments);
        }
    }

    public int handleCommandException(Exception ex, String message) {
        CommandLine cmd = this.mixee.commandLine();
        this.printStackTrace(ex);
        if (ex instanceof CommandLine.ParameterException) {
            CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)((CommandLine.ParameterException)ex), (PrintWriter)this.out());
        }
        this.error(message);
        if (!this.isShowErrors()) {
            this.info("\nAdd the -e/--errors option to get more information about the error. Add the --verbose option to get even more details.");
        }
        return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : this.mixee.exitCodeOnInvalidInput();
    }

    public String toString() {
        return "OutputOptions [testMode=" + this.cliTestMode + ", showErrors=" + this.showErrors + ", verbose=" + this.getVerbose() + "]";
    }
}

