/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.common;

import io.quarkus.runtime.util.ClassPathUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Properties;

public class VersionHelper {
    private static String version;

    public static String clientVersion() {
        if (version != null) {
            return version;
        }
        Properties props = new Properties();
        URL quarkusPropertiesUrl = Thread.currentThread().getContextClassLoader().getResource("quarkus.properties");
        if (quarkusPropertiesUrl == null) {
            throw new RuntimeException("Failed to locate quarkus.properties on the classpath");
        }
        if ("file".equals(quarkusPropertiesUrl.getProtocol()) || "jar".equals(quarkusPropertiesUrl.getProtocol())) {
            ClassPathUtils.consumeAsPath((URL)quarkusPropertiesUrl, p -> {
                try (BufferedReader reader = Files.newBufferedReader(p);){
                    props.load(reader);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to load quarkus.properties", e);
                }
            });
        } else {
            try {
                props.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("quarkus.properties"));
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to load quarkus.properties", e);
            }
        }
        version = props.getProperty("quarkus-core-version");
        if (version == null) {
            throw new RuntimeException("Failed to locate quarkus-core-version property in the bundled quarkus.properties");
        }
        return version;
    }
}

