/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.common.build;

import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.cli.common.BuildOptions;
import io.quarkus.cli.common.CategoryListFormatOptions;
import io.quarkus.cli.common.DebugOptions;
import io.quarkus.cli.common.DevOptions;
import io.quarkus.cli.common.ListFormatOptions;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.common.TargetQuarkusVersionGroup;
import io.quarkus.cli.common.VersionHelper;
import io.quarkus.cli.common.build.BuildSystemRunner;
import io.quarkus.cli.common.build.ExecuteUtil;
import io.quarkus.cli.common.registry.RegistryClientMixin;
import io.quarkus.cli.common.update.RewriteGroup;
import io.quarkus.devtools.commands.AddExtensions;
import io.quarkus.devtools.commands.ListCategories;
import io.quarkus.devtools.commands.ListExtensions;
import io.quarkus.devtools.commands.RemoveExtensions;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.QuarkusProjectHelper;
import io.quarkus.devtools.project.buildfile.MavenProjectBuildFile;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.config.RegistriesConfig;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;

public class MavenRunner
implements BuildSystemRunner {
    public static String MAVEN_SETTINGS = "maven.settings";
    static final String[] windowsWrapper = new String[]{"mvnw.cmd", "mvnw.bat"};
    static final String otherWrapper = "mvnw";
    final OutputOptionMixin output;
    final RegistryClientMixin registryClient;
    final PropertiesOptions propertiesOptions;
    final Path projectRoot;

    public MavenRunner(OutputOptionMixin output, PropertiesOptions propertiesOptions, RegistryClientMixin registryClient, Path projectRoot) {
        this.output = output;
        this.projectRoot = projectRoot;
        this.propertiesOptions = propertiesOptions;
        this.registryClient = registryClient;
        this.verifyBuildFile();
    }

    @Override
    public File getWrapper() {
        return ExecuteUtil.findWrapper(this.projectRoot, windowsWrapper, otherWrapper);
    }

    @Override
    public File getExecutable() {
        return ExecuteUtil.findExecutable("mvn", "Unable to find the maven executable, is it in your path?", this.output);
    }

    @Override
    public Path getProjectRoot() {
        return this.projectRoot;
    }

    @Override
    public OutputOptionMixin getOutput() {
        return this.output;
    }

    @Override
    public BuildTool getBuildTool() {
        return BuildTool.MAVEN;
    }

    QuarkusProject quarkusProject() throws Exception {
        QuarkusProjectHelper.setToolsConfig((RegistriesConfig)this.registryClient.resolveConfig());
        return MavenProjectBuildFile.getProject((Path)this.projectRoot, (MessageWriter)this.output, VersionHelper::clientVersion);
    }

    @Override
    public Integer listExtensionCategories(RunModeOption runMode, CategoryListFormatOptions format) throws Exception {
        QuarkusCommandOutcome outcome = new ListCategories(this.quarkusProject(), (MessageWriter)this.output).fromCli(true).format(format.getFormatString()).batchMode(runMode.isBatchMode()).execute();
        return outcome.isSuccess() ? 0 : 1;
    }

    @Override
    public Integer listExtensions(RunModeOption runMode, ListFormatOptions format, boolean installable, String searchPattern, String category) throws Exception {
        QuarkusCommandOutcome outcome = new ListExtensions(this.quarkusProject(), (MessageWriter)this.output).fromCli(true).all(false).installed(!installable).format(format.getFormatString()).search(searchPattern).category(category).batchMode(runMode.isBatchMode()).execute();
        return outcome.isSuccess() ? 0 : 1;
    }

    @Override
    public Integer addExtension(RunModeOption runMode, Set<String> extensions) throws Exception {
        AddExtensions invoker = new AddExtensions(this.quarkusProject());
        invoker.extensions(extensions);
        return invoker.execute().isSuccess() ? 0 : 1;
    }

    @Override
    public Integer removeExtension(RunModeOption runMode, Set<String> extensions) throws Exception {
        RemoveExtensions invoker = new RemoveExtensions(this.quarkusProject());
        invoker.extensions(extensions);
        return invoker.execute().isSuccess() ? 0 : 1;
    }

    @Override
    public Integer projectInfo(boolean perModule) throws Exception {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setMavenProperties(args, true);
        args.add("quarkus:info");
        if (perModule) {
            args.add("-DperModule");
        }
        args.add("-ntp");
        return this.run(this.prependExecutable(args));
    }

    @Override
    public Integer updateProject(TargetQuarkusVersionGroup targetQuarkusVersion, RewriteGroup rewrite) throws Exception {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setMavenProperties(args, true);
        ExtensionCatalog extensionCatalog = ToolsUtils.resolvePlatformDescriptorDirectly((String)"io.quarkus", null, (String)VersionHelper.clientVersion(), (MavenArtifactResolver)QuarkusProjectHelper.artifactResolver(), (MessageWriter)MessageWriter.info());
        Properties props = ToolsUtils.readQuarkusProperties((ExtensionCatalog)extensionCatalog);
        args.add(ToolsUtils.getPluginKey((Properties)props) + ":" + ToolsUtils.getMavenPluginVersion((Properties)props) + ":update");
        args.add("-e");
        args.add("-N");
        if (targetQuarkusVersion.platformVersion != null) {
            args.add("-DplatformVersion=" + targetQuarkusVersion.platformVersion);
        }
        if (targetQuarkusVersion.streamId != null) {
            args.add("-Dstream=" + targetQuarkusVersion.streamId);
        }
        if (rewrite.pluginVersion != null) {
            args.add("-DrewritePluginVersion=" + rewrite.pluginVersion);
        }
        if (rewrite.quarkusUpdateRecipes != null) {
            args.add("-DquarkusUpdateRecipes=" + rewrite.quarkusUpdateRecipes);
        }
        if (rewrite.additionalUpdateRecipes != null) {
            args.add("-DadditionalUpdateRecipes=" + rewrite.additionalUpdateRecipes);
        }
        if (rewrite.run != null) {
            if (rewrite.run.yes) {
                args.add("-Drewrite");
            }
            if (rewrite.run.no) {
                args.add("-Drewrite=false");
            }
            if (rewrite.run.dryRun) {
                args.add("-DrewriteDryRun");
            }
        }
        args.add("-ntp");
        return this.run(this.prependExecutable(args));
    }

    @Override
    public BuildSystemRunner.BuildCommandArgs prepareBuild(BuildOptions buildOptions, RunModeOption runMode, List<String> params) {
        return this.prepareAction("install", buildOptions, runMode, params);
    }

    @Override
    public BuildSystemRunner.BuildCommandArgs prepareAction(String action, BuildOptions buildOptions, RunModeOption runMode, List<String> params) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        this.setMavenProperties(args, runMode.isBatchMode());
        if (runMode.isBatchMode()) {
            args.add("-B");
            args.add("-ntp");
        }
        if (buildOptions.offline) {
            args.add("--offline");
        }
        if (buildOptions.clean) {
            args.add("clean");
        }
        args.add(action);
        if (buildOptions.buildNative) {
            args.add("-Dnative");
        }
        if (buildOptions.skipTests()) {
            this.setSkipTests(args);
        }
        args.addAll(params);
        return this.prependExecutable(args);
    }

    @Override
    public BuildSystemRunner.BuildCommandArgs prepareTest(BuildOptions buildOptions, RunModeOption runMode, List<String> params, String filter) {
        if (filter != null) {
            params.add("-Dtest=" + filter);
        }
        return this.prepareAction("test", buildOptions, runMode, params);
    }

    @Override
    public List<Supplier<BuildSystemRunner.BuildCommandArgs>> prepareDevTestMode(boolean devMode, DevOptions commonOptions, DebugOptions debugOptions, List<String> params) {
        ArrayDeque<String> args = new ArrayDeque<String>();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        this.setMavenProperties(args, commonOptions.isBatchMode());
        if (commonOptions.isBatchMode()) {
            args.add("-B");
            args.add("-ntp");
        }
        if (commonOptions.clean) {
            args.add("clean");
        }
        args.add(devMode ? "quarkus:dev" : "quarkus:test");
        if (commonOptions.offline) {
            args.add("--offline");
        }
        debugOptions.addDebugArguments(args, jvmArgs);
        this.propertiesOptions.flattenJvmArgs(jvmArgs, args);
        this.paramsToQuarkusArgs(params, args);
        BuildSystemRunner.BuildCommandArgs buildCommandArgs = this.prependExecutable(args);
        return Collections.singletonList(() -> buildCommandArgs);
    }

    void setSkipTests(ArrayDeque<String> args) {
        args.add("-DskipTests");
        args.add("-Dmaven.test.skip=true");
    }

    void setMavenProperties(ArrayDeque<String> args, boolean batchMode) {
        String configFile;
        String mavenSettings;
        if (this.output.isShowErrors()) {
            args.addFirst("-e");
        }
        if (this.output.isAnsiEnabled() && !batchMode) {
            args.addFirst("-Dstyle.color=always");
        }
        if ((mavenSettings = this.propertiesOptions.properties.remove(MAVEN_SETTINGS)) != null && !mavenSettings.isEmpty()) {
            args.add("-s");
            args.add(mavenSettings);
        } else {
            mavenSettings = System.getProperty(MAVEN_SETTINGS);
            if (mavenSettings != null && !mavenSettings.isEmpty() && Files.exists(Path.of(mavenSettings, new String[0]), new LinkOption[0])) {
                args.add("-s");
                args.add(mavenSettings);
            }
        }
        args.addAll(this.flattenMappedProperties(this.propertiesOptions.properties));
        args.add(this.registryClient.getRegistryClientProperty());
        String string = configFile = this.registryClient.getConfigArg() == null ? System.getProperty("quarkus.tools.config") : this.registryClient.getConfigArg();
        if (configFile != null) {
            args.add("-Dquarkus.tools.config=" + configFile);
        }
    }

    void verifyBuildFile() {
        File buildFile = this.projectRoot.resolve("pom.xml").toFile();
        if (!buildFile.isFile()) {
            throw new IllegalStateException("Is this a project directory? Unable to find a build file in: " + String.valueOf(this.projectRoot));
        }
    }
}

