/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.common;

import io.quarkus.cli.common.BuildOptions;
import io.quarkus.cli.common.BuildToolContext;
import io.quarkus.cli.common.HelpOption;
import io.quarkus.cli.common.OutputOptionMixin;
import io.quarkus.cli.common.PropertiesOptions;
import io.quarkus.cli.common.RunModeOption;
import io.quarkus.cli.common.build.BuildSystemRunner;
import io.quarkus.cli.common.gradle.GradleInitScript;
import io.quarkus.cli.common.registry.ToggleRegistryClientMixin;
import io.quarkus.devtools.project.BuildTool;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import picocli.CommandLine;

public class BuildToolDelegatingCommand
implements Callable<Integer> {
    private static final String GRADLE_NO_BUILD_CACHE = "--no-build-cache";
    private static final String GRADLE_NO_DAEMON = "--no-daemon";
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin(name="output")
    protected OutputOptionMixin output;
    @CommandLine.Mixin
    protected ToggleRegistryClientMixin registryClient;
    @CommandLine.Mixin
    protected HelpOption helpOption;
    @CommandLine.ArgGroup(exclusive=false, validate=false)
    protected PropertiesOptions propertiesOptions = new PropertiesOptions();
    @CommandLine.Mixin
    private RunModeOption runMode;
    @CommandLine.ArgGroup(order=1, exclusive=false, validate=false, heading="%nBuild options:%n")
    private BuildOptions buildOptions = new BuildOptions();
    @CommandLine.Parameters(description={"Additional parameters passed to the build system"})
    private List<String> params = new ArrayList<String>();
    private Path projectRoot;

    private Path projectRoot() {
        if (this.projectRoot == null) {
            this.projectRoot = this.output.getTestDirectory();
            if (this.projectRoot == null) {
                this.projectRoot = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();
            }
        }
        return this.projectRoot;
    }

    public BuildSystemRunner getRunner(BuildToolContext context) {
        return BuildSystemRunner.getRunner(this.output, context.getPropertiesOptions(), this.registryClient, context.getProjectRoot(), context.getBuildTool());
    }

    public void populateContext(BuildToolContext context) {
    }

    public Optional<BuildToolDelegatingCommand> getParentCommand() {
        return Optional.empty();
    }

    public final Integer call(BuildToolContext context) throws Exception {
        try {
            this.populateContext(context);
            this.prepare(context);
            BuildSystemRunner runner = this.getRunner(context);
            if (this.getParentCommand().isPresent()) {
                return this.getParentCommand().get().call(context);
            }
            if (context.getRunModeOption().isDryRun()) {
                this.output.info("Dry run option detected. Target command(s):");
            }
            String action = this.getAction(context).orElseThrow(() -> new IllegalStateException("Unknown action for " + runner.getBuildTool().name()));
            BuildSystemRunner.BuildCommandArgs commandArgs = runner.prepareAction(action, context.getBuildOptions(), context.getRunModeOption(), context.getParams());
            if (context.getRunModeOption().isDryRun()) {
                this.output.info(" " + commandArgs.showCommand());
                return 0;
            }
            return runner.run(commandArgs);
        }
        catch (Exception e) {
            return this.output.handleCommandException(e, "Unable to build: " + e.getMessage());
        }
    }

    @Override
    public final Integer call() throws Exception {
        return this.call(new BuildToolContext(this.projectRoot(), this.runMode, this.buildOptions, this.propertiesOptions, new ArrayList<String>(), new ArrayList<String>(this.params)));
    }

    public void prepare(BuildToolContext context) {
        BuildSystemRunner runner = this.getRunner(context);
        if (runner.getBuildTool() == BuildTool.GRADLE) {
            this.prepareGradle(context);
        }
        if (runner.getBuildTool() == BuildTool.MAVEN) {
            this.prepareMaven(context);
        }
    }

    public void prepareMaven(BuildToolContext context) {
        BuildSystemRunner runner = this.getRunner(context);
        BuildSystemRunner.BuildCommandArgs compileArgs = runner.prepareAction("resources:resources", context.getBuildOptions(), context.getRunModeOption(), context.getParams());
        if (this.getParentCommand().isPresent()) {
            return;
        }
        if (context.getRunModeOption().isDryRun()) {
            this.output.info(" " + compileArgs.showCommand());
        } else {
            int compileExitCode = runner.run(compileArgs);
            if (compileExitCode != 0) {
                throw new RuntimeException("Failed to compile. Compilation exited with exit code:" + compileExitCode);
            }
        }
    }

    public void prepareGradle(BuildToolContext context) {
        if (!context.getParams().contains(GRADLE_NO_BUILD_CACHE)) {
            context.getParams().add(GRADLE_NO_BUILD_CACHE);
        }
        if (!context.getParams().contains(GRADLE_NO_DAEMON)) {
            context.getParams().add(GRADLE_NO_DAEMON);
        }
        if (!context.getForcedExtensions().isEmpty()) {
            GradleInitScript.populateForExtensions(context.getForcedExtensions(), context.getParams());
        }
    }

    public Map<BuildTool, String> getActionMapping() {
        return Collections.emptyMap();
    }

    public Optional<String> getAction(BuildToolContext context) {
        return this.getParentCommand().map(cmd -> cmd.getAction(context)).orElse(Optional.ofNullable(this.getActionMapping().get(this.getRunner(context).getBuildTool())));
    }
}

