/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.common;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;

public class VersionHelper {
    private static String version;

    public static String clientVersion() {
        if (version != null) {
            return version;
        }
        Properties props = new Properties();
        URL quarkusPropertiesUrl = Thread.currentThread().getContextClassLoader().getResource("quarkus.properties");
        if (quarkusPropertiesUrl == null) {
            return "999-SNAPSHOT";
        }
        try {
            if (quarkusPropertiesUrl.getProtocol().equals("file")) {
                try (InputStream is = Files.newInputStream(Paths.get(quarkusPropertiesUrl.toURI()), new OpenOption[0]);){
                    props.load(is);
                }
            }
            try (InputStream is = quarkusPropertiesUrl.openStream();){
                props.load(is);
            }
            version = props.getProperty("quarkus.version", "999-SNAPSHOT");
        }
        catch (Exception e) {
            version = "999-SNAPSHOT";
        }
        return version;
    }
}

