/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.deployment;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.arc.deployment.GeneratedBeanGizmo2Adaptor;
import io.quarkus.arc.deployment.InjectionPointTransformerBuildItem;
import io.quarkus.arc.processor.Annotations;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.InjectionPointsTransformer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.cache.CacheResult;
import io.quarkus.cache.CachedResults;
import io.quarkus.cache.deployment.spi.AdditionalCacheNameBuildItem;
import io.quarkus.cache.runtime.CachedResultsDiff;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.gizmo2.ClassOutput;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.Gizmo;
import io.quarkus.gizmo2.ParamVar;
import io.quarkus.gizmo2.creator.AnnotatableCreator;
import io.quarkus.gizmo2.creator.AnnotationCreator;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.runtime.util.HashUtil;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.EquivalenceKey;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.gizmo2.Jandex2Gizmo;
import org.jboss.logging.Logger;

public class CachedResultsProcessor {
    private static final Logger LOG = Logger.getLogger(CachedResultsProcessor.class);
    private static final DotName CACHED_RESULTS = DotName.createSimple(CachedResults.class);
    private static final DotName INJECT = DotName.createSimple(Inject.class);

    @BuildStep
    AdditionalBeanBuildItem registerQualifier() {
        return new AdditionalBeanBuildItem(new Class[]{CachedResults.class, CachedResultsDiff.class});
    }

    @BuildStep
    void analyzeInjectionPoints(CombinedIndexBuildItem index, BuildProducer<CachedResultsInjectConfigBuildItem> cachedResultsInjectConfigs) {
        HashSet<CachedResultsInjectConfig> injectConfigs = new HashSet<CachedResultsInjectConfig>();
        for (AnnotationInstance annotation : index.getIndex().getAnnotations(CACHED_RESULTS)) {
            injectConfigs.add(CachedResultsProcessor.createConfig(index.getComputingIndex(), annotation));
        }
        injectConfigs.stream().map(CachedResultsInjectConfigBuildItem::new).forEach(arg_0 -> cachedResultsInjectConfigs.produce(arg_0));
    }

    @BuildStep
    void generateWrapperBeans(CombinedIndexBuildItem index, List<CachedResultsInjectConfigBuildItem> cachedResultsInjectConfigs, BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<AdditionalCacheNameBuildItem> cacheNames, BuildProducer<CachedResultsDifferentiator> diffs) {
        GeneratedBeanGizmo2Adaptor classOutput = new GeneratedBeanGizmo2Adaptor(generatedBeans);
        Gizmo gizmo = Gizmo.create((ClassOutput)classOutput);
        for (CachedResultsInjectConfigBuildItem injectConfig : cachedResultsInjectConfigs) {
            CachedResultsInjectConfig config = injectConfig.getConfig();
            Pattern exclude = config.exclude() != null ? Pattern.compile(config.exclude()) : null;
            DotName clazzName = config.injectedClazz().name();
            String name = clazzName.toString() + "_CachedResults_" + HashUtil.sha1((String)config.toString());
            gizmo.class_(name, cc -> {
                if (config.injectedClazz().isInterface()) {
                    cc.implements_(Jandex2Gizmo.classDescOf((DotName)clazzName));
                } else {
                    cc.extends_(Jandex2Gizmo.classDescOf((DotName)clazzName));
                }
                cc.addAnnotation(Dependent.class);
                cc.addAnnotation(CachedResults.class, ac -> {
                    ac.add("cacheName", config.cacheName());
                    if (!config.cacheName().equals("<<default>>")) {
                        cacheNames.produce((BuildItem)new AdditionalCacheNameBuildItem(config.cacheName()));
                    }
                    if (config.lockTimeout() != null) {
                        ac.add("lockTimeout", config.lockTimeout().longValue());
                    }
                    if (config.keyGenerator() != null) {
                        ac.add("keyGenerator", Jandex2Gizmo.classDescOf((DotName)config.keyGenerator()));
                    }
                    if (config.exclude() != null) {
                        ac.add("exclude", config.exclude());
                    }
                });
                String diff = config.annotations().stream().map(Object::toString).collect(Collectors.joining());
                cc.addAnnotation(CachedResultsDiff.class, ac -> ac.add("value", diff));
                diffs.produce((BuildItem)new CachedResultsDifferentiator(config, diff));
                cc.defaultConstructor();
                FieldDesc delegateField = cc.field("cachedResults_delegate", fc -> {
                    fc.packagePrivate();
                    fc.setType(Jandex2Gizmo.classDescOf((ClassInfo)config.injectedClazz()));
                    for (AnnotationInstance a : config.annotations()) {
                        Jandex2Gizmo.addAnnotation((AnnotatableCreator)fc, (AnnotationInstance)a, (IndexView)index.getIndex());
                    }
                    fc.addAnnotation(Inject.class);
                });
                HashMap<MethodKey, MethodInfo> forwarded = new HashMap<MethodKey, MethodInfo>();
                CachedResultsProcessor.addForwardedMethods(index.getComputingIndex(), config.injectedClazz(), forwarded);
                for (MethodInfo method : forwarded.values()) {
                    MethodDesc methodDesc = Jandex2Gizmo.methodDescOf((MethodInfo)method);
                    cc.method(methodDesc, mc -> {
                        mc.returning(methodDesc.returnType());
                        if (Modifier.isProtected(method.flags())) {
                            mc.protected_();
                        } else if (CachedResultsProcessor.isPackagePrivate(method.flags())) {
                            mc.packagePrivate();
                        }
                        for (Type exception : method.exceptions()) {
                            mc.throws_(Jandex2Gizmo.classDescOf((Type)exception));
                        }
                        ParamVar[] params = new ParamVar[methodDesc.parameterCount()];
                        for (int i = 0; i < methodDesc.parameterCount(); ++i) {
                            params[i] = mc.parameter("arg" + i, i);
                        }
                        if (!(method.returnType().kind() == Type.Kind.VOID || exclude != null && exclude.matcher(method.name()).matches())) {
                            Object cacheName;
                            if (config.cacheName().equals("<<default>>")) {
                                cacheName = method.declaringClass().name().toString() + "#" + method.name() + "(" + method.parameterTypes().stream().map(Type::name).map(Object::toString).collect(Collectors.joining(",")) + ")";
                                cacheNames.produce((BuildItem)new AdditionalCacheNameBuildItem((String)cacheName));
                            } else {
                                cacheName = config.cacheName();
                            }
                            mc.addAnnotation(CacheResult.class, arg_0 -> CachedResultsProcessor.lambda$generateWrapperBeans$3((String)cacheName, config, arg_0));
                        }
                        mc.body(bc -> {
                            Expr ret = methodDesc instanceof InterfaceMethodDesc ? bc.invokeInterface(methodDesc, (Expr)cc.this_().field(delegateField), (Expr[])params) : bc.invokeVirtual(methodDesc, (Expr)cc.this_().field(delegateField), (Expr[])params);
                            bc.return_(ret);
                        });
                    });
                }
            });
        }
    }

    @BuildStep
    void transformInjectionPoints(final CombinedIndexBuildItem index, List<CachedResultsDifferentiator> differentiators, BuildProducer<InjectionPointTransformerBuildItem> transformers) {
        for (final CachedResultsDifferentiator diff : differentiators) {
            transformers.produce((BuildItem)new InjectionPointTransformerBuildItem(new InjectionPointsTransformer(){

                public void transform(InjectionPointsTransformer.TransformationContext transformationContext) {
                    AnnotationInstance cachedResults = Annotations.find((Collection)transformationContext.getQualifiers(), (DotName)CACHED_RESULTS);
                    if (cachedResults != null && CachedResultsProcessor.createConfig(index.getComputingIndex(), cachedResults).equals(diff.getConfig())) {
                        ((InjectionPointsTransformer.Transformation)((InjectionPointsTransformer.Transformation)transformationContext.transform().remove(annotation -> !annotation.name().equals((Object)CACHED_RESULTS))).add(AnnotationInstance.builder(CachedResultsDiff.class).add("value", diff.getValue()).build())).done();
                    }
                }

                public boolean appliesTo(Type requiredType) {
                    return requiredType.name().equals((Object)diff.getConfig().injectedClazz().name());
                }
            }));
        }
    }

    static void addForwardedMethods(IndexView index, ClassInfo clazz, Map<MethodKey, MethodInfo> forwarded) {
        if (clazz != null) {
            ClassInfo superClazz;
            for (MethodInfo method : clazz.methods()) {
                if (method.isConstructor() || method.isStaticInitializer() || Modifier.isPrivate(method.flags()) || Modifier.isStatic(method.flags()) || method.declaringClass().name().equals((Object)DotNames.OBJECT) && !method.name().equals("toString")) continue;
                if (Modifier.isFinal(method.flags())) {
                    LOG.warn((Object)"Final method %s.%s() cannot be forwarded and should never be invoked upon the injected @CachedResults wrapper".formatted(method.declaringClass(), method.name()));
                    continue;
                }
                forwarded.putIfAbsent(MethodKey.of(method), method);
            }
            if (clazz.superClassType() != null && (superClazz = index.getClassByName(clazz.superName())) != null) {
                CachedResultsProcessor.addForwardedMethods(index, superClazz, forwarded);
            }
            for (DotName interfaceName : clazz.interfaceNames()) {
                ClassInfo interfaceClazz = index.getClassByName(interfaceName);
                if (interfaceClazz == null) continue;
                CachedResultsProcessor.addForwardedMethods(index, interfaceClazz, forwarded);
            }
        }
    }

    private static boolean isPackagePrivate(int mod) {
        return !Modifier.isPrivate(mod) && !Modifier.isProtected(mod) && !Modifier.isPublic(mod);
    }

    static CachedResultsInjectConfig createConfig(IndexView index, AnnotationInstance annotation) {
        Type type;
        AnnotationValue excludeValue;
        AnnotationValue keyGeneratorValue;
        AnnotationValue lockTimeoutValue;
        String cacheName = "<<default>>";
        DotName keyGenerator = null;
        Long lockTimeout = null;
        String exclude = null;
        AnnotationValue cacheNameValue = annotation.value("cacheName");
        if (cacheNameValue != null) {
            cacheName = cacheNameValue.asString();
        }
        if ((lockTimeoutValue = annotation.value("lockTimeout")) != null) {
            lockTimeout = lockTimeoutValue.asLong();
        }
        if ((keyGeneratorValue = annotation.value("keyGenerator")) != null) {
            keyGenerator = keyGeneratorValue.asClass().name();
        }
        if ((excludeValue = annotation.value("exclude")) != null) {
            exclude = excludeValue.asString();
        }
        if (annotation.target().kind() == AnnotationTarget.Kind.FIELD) {
            type = annotation.target().asField().type();
        } else if (annotation.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            type = annotation.target().asMethodParameter().type();
        } else {
            throw new IllegalStateException("Unsupported target:" + String.valueOf(annotation.target()));
        }
        if (type.kind() != Type.Kind.CLASS) {
            throw new IllegalStateException("Invalid type: " + String.valueOf(type));
        }
        ClassInfo injectedClazz = index.getClassByName(type.name());
        if (injectedClazz == null) {
            throw new IllegalStateException("Injected class not found in index: " + String.valueOf(type.name()));
        }
        if (!injectedClazz.isInterface() && !injectedClazz.hasNoArgsConstructor()) {
            throw new IllegalStateException("@CachedResults class must be an interface or declare a no-args constructor: " + String.valueOf(injectedClazz));
        }
        return new CachedResultsInjectConfig(cacheName, lockTimeout, keyGenerator, injectedClazz, annotation.target().declaredAnnotations().stream().filter(a -> !a.name().equals((Object)CACHED_RESULTS) && !a.name().equals((Object)INJECT)).toList(), exclude);
    }

    private static /* synthetic */ void lambda$generateWrapperBeans$3(String cacheName, CachedResultsInjectConfig config, AnnotationCreator ac) {
        ac.add("cacheName", cacheName);
        if (config.lockTimeout() != null) {
            ac.add("lockTimeout", config.lockTimeout().longValue());
        }
        if (config.keyGenerator() != null) {
            ac.add("keyGenerator", Jandex2Gizmo.classDescOf((DotName)config.keyGenerator()));
        }
    }

    record CachedResultsInjectConfig(String cacheName, Long lockTimeout, DotName keyGenerator, ClassInfo injectedClazz, Collection<AnnotationInstance> annotations, String exclude) {
    }

    static final class CachedResultsInjectConfigBuildItem
    extends MultiBuildItem {
        private final CachedResultsInjectConfig config;

        CachedResultsInjectConfigBuildItem(CachedResultsInjectConfig config) {
            this.config = config;
        }

        public CachedResultsInjectConfig getConfig() {
            return this.config;
        }
    }

    static final class CachedResultsDifferentiator
    extends MultiBuildItem {
        private final CachedResultsInjectConfig config;
        private final String value;

        CachedResultsDifferentiator(CachedResultsInjectConfig config, String value) {
            this.config = config;
            this.value = value;
        }

        CachedResultsInjectConfig getConfig() {
            return this.config;
        }

        String getValue() {
            return this.value;
        }
    }

    record MethodKey(String name, List<EquivalenceKey.TypeEquivalenceKey> params, EquivalenceKey.TypeEquivalenceKey returnType) {
        static MethodKey of(MethodInfo method) {
            if (method.parametersCount() == 0) {
                return new MethodKey(method.name(), List.of(), EquivalenceKey.of((Type)method.returnType()));
            }
            return new MethodKey(method.name(), method.parameterTypes().stream().map(EquivalenceKey::of).toList(), EquivalenceKey.of((Type)method.returnType()));
        }
    }
}

