/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.builder;

import io.quarkus.builder.diag.Diagnostic;
import io.smallrye.common.constraint.Assert;
import java.util.Collections;
import java.util.List;

public class BuildException
extends Exception {
    private static final long serialVersionUID = -2190774463525631311L;
    private final List<Diagnostic> diagnostics;

    public BuildException(List<Diagnostic> diagnostics) {
        super(BuildException.constructMessage(null, (List)Assert.checkNotNullParam((String)"diagnostics", diagnostics)));
        this.diagnostics = diagnostics;
    }

    public BuildException(String msg) {
        this(msg, Collections.emptyList());
    }

    public BuildException(String msg, List<Diagnostic> diagnostics) {
        super(BuildException.constructMessage(msg, (List)Assert.checkNotNullParam((String)"diagnostics", diagnostics)));
        Assert.checkNotNullParam((String)"diagnostics", diagnostics);
        this.diagnostics = diagnostics;
        for (Diagnostic d : diagnostics) {
            this.addSuppressed(d.getThrown());
        }
    }

    public BuildException(Throwable cause, List<Diagnostic> diagnostics) {
        super(BuildException.constructMessage(null, (List)Assert.checkNotNullParam((String)"diagnostics", diagnostics)), cause);
        Assert.checkNotNullParam((String)"diagnostics", diagnostics);
        this.diagnostics = diagnostics;
    }

    public BuildException(String msg, Throwable cause, List<Diagnostic> diagnostics) {
        super(BuildException.constructMessage(msg, (List)Assert.checkNotNullParam((String)"diagnostics", diagnostics)), cause);
        Assert.checkNotNullParam((String)"diagnostics", diagnostics);
        this.diagnostics = diagnostics;
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    private static String constructMessage(String msg, List<Diagnostic> diagnostics) {
        StringBuilder b = new StringBuilder();
        b.append("Build failure");
        if (msg != null) {
            b.append(": ").append(msg);
        }
        for (Diagnostic d : diagnostics) {
            b.append("\n\t");
            d.toString(b);
        }
        return b.toString();
    }
}

