/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import java.util.function.Consumer;

public class DependencyLoggingConfig {
    private boolean verbose;
    private boolean graph;
    private Consumer<String> msgConsumer;

    public static Builder builder() {
        return new DependencyLoggingConfig().new Builder();
    }

    public boolean isGraph() {
        return this.graph;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Consumer<String> getMessageConsumer() {
        return this.msgConsumer;
    }

    public class Builder {
        private boolean built;

        private Builder() {
        }

        public Builder setGraph(boolean graph) {
            if (!this.built) {
                DependencyLoggingConfig.this.graph = graph;
            }
            return this;
        }

        public Builder setVerbose(boolean verbose) {
            if (!this.built) {
                DependencyLoggingConfig.this.verbose = verbose;
            }
            return this;
        }

        public Builder setMessageConsumer(Consumer<String> msgConsumer) {
            if (!this.built) {
                DependencyLoggingConfig.this.msgConsumer = msgConsumer;
            }
            return this;
        }

        public DependencyLoggingConfig build() {
            if (!this.built) {
                this.built = true;
                if (DependencyLoggingConfig.this.msgConsumer == null) {
                    throw new IllegalArgumentException("msgConsumer has not been initialized");
                }
            }
            return DependencyLoggingConfig.this;
        }
    }
}

