/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.aether.graph.DependencyNode;

class OrderedDependencyVisitor {
    private final Deque<DependencyList> stack = new ArrayDeque<DependencyList>();
    private DependencyList currentList;
    private int currentIndex = -1;
    private int currentDistance;
    private int totalOnCurrentDistance = 1;
    private int totalOnNextDistance;

    OrderedDependencyVisitor(DependencyNode root) {
        this.currentList = new DependencyList(0, List.of(root));
    }

    DependencyNode getCurrent() {
        this.ensureNonNegativeIndex();
        return this.currentList.deps.get(this.currentIndex);
    }

    int getCurrentDistance() {
        this.ensureNonNegativeIndex();
        return this.currentDistance;
    }

    private void ensureNonNegativeIndex() {
        if (this.currentIndex < 0) {
            throw new RuntimeException("The visitor has not been positioned on the first dependency node yet");
        }
    }

    boolean hasNext() {
        return !this.stack.isEmpty() || this.currentIndex + 1 < this.currentList.deps.size() || !this.currentList.deps.get(this.currentIndex).getChildren().isEmpty();
    }

    DependencyNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.currentIndex >= 0) {
            List children = this.currentList.deps.get(this.currentIndex).getChildren();
            if (!children.isEmpty()) {
                this.stack.addLast(new DependencyList(this.getSubtreeIndexForChildren(), children));
                this.totalOnNextDistance += children.size();
            }
            if (--this.totalOnCurrentDistance == 0) {
                ++this.currentDistance;
                this.totalOnCurrentDistance = this.totalOnNextDistance;
                this.totalOnNextDistance = 0;
            }
        }
        if (++this.currentIndex == this.currentList.deps.size()) {
            this.currentList = this.stack.removeFirst();
            this.currentIndex = 0;
        }
        return this.currentList.deps.get(this.currentIndex);
    }

    private int getSubtreeIndexForChildren() {
        return this.currentDistance < 2 ? this.currentIndex + 1 : this.currentList.subtreeIndex;
    }

    int getSubtreeIndex() {
        return this.currentDistance == 0 ? 0 : (this.currentDistance < 2 ? this.currentIndex + 1 : this.currentList.subtreeIndex);
    }

    void replaceCurrent(DependencyNode newNode) {
        this.currentList.deps.set(this.currentIndex, newNode);
    }

    private static class DependencyList {
        private final int subtreeIndex;
        private final List<DependencyNode> deps;

        public DependencyList(int branchIndex, List<DependencyNode> deps) {
            this.subtreeIndex = branchIndex;
            this.deps = deps;
        }
    }
}

