/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.apache.maven.model.Model;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

public class BootstrapMavenContextConfig<T extends BootstrapMavenContextConfig<T>> {
    protected String localRepo;
    protected String[] localRepoTail;
    protected Boolean localRepoTailIgnoreAvailability;
    protected Boolean offline;
    protected LocalProject currentProject;
    protected boolean workspaceDiscovery = true;
    protected RepositorySystem repoSystem;
    protected RepositorySystemSession repoSession;
    protected List<RemoteRepository> remoteRepos;
    protected List<RemoteRepository> remotePluginRepos;
    protected RemoteRepositoryManager remoteRepoManager;
    protected SettingsDecrypter settingsDecrypter;
    protected String alternatePomName;
    protected File userSettings;
    protected boolean artifactTransferLogging = true;
    protected BootstrapMavenOptions cliOptions;
    protected Path rootProjectDir;
    protected boolean preferPomsFromWorkspace;
    protected Boolean effectiveModelBuilder;
    protected Boolean wsModuleParentHierarchy;
    protected Function<Path, Model> modelProvider;
    protected List<String> excludeSisuBeanPackages;
    protected List<String> includeSisuBeanPackages;
    protected Boolean warnOnFailedWorkspaceModules;

    public static boolean getEffectiveModelBuilderProperty(Properties props) {
        String value = System.getProperty("quarkus.bootstrap.effective-model-builder");
        return value == null ? Boolean.parseBoolean(props.getProperty("quarkus.bootstrap.effective-model-builder")) : Boolean.parseBoolean(value);
    }

    public T excludeSisuBeanPackage(String packageName) {
        if (this.excludeSisuBeanPackages == null) {
            this.excludeSisuBeanPackages = new ArrayList<String>();
        }
        this.excludeSisuBeanPackages.add(packageName);
        return (T)this;
    }

    protected List<String> getExcludeSisuBeanPackages() {
        if (this.excludeSisuBeanPackages == null) {
            return List.of("org.apache.maven.shared.release", "org.apache.maven.toolchain", "org.apache.maven.lifecycle", "org.apache.maven.execution", "org.apache.maven.plugin");
        }
        return this.excludeSisuBeanPackages;
    }

    public T includeSisuBeanPackage(String packageName) {
        if (this.includeSisuBeanPackages == null) {
            this.includeSisuBeanPackages = new ArrayList<String>();
        }
        this.includeSisuBeanPackages.add(packageName);
        return (T)this;
    }

    protected List<String> getIncludeSisuBeanPackages() {
        if (this.includeSisuBeanPackages == null) {
            return List.of("io.smallrye.beanbag", "org.eclipse.aether", "org.sonatype.plexus.components", "org.apache.maven");
        }
        return this.includeSisuBeanPackages;
    }

    public T setLocalRepository(String localRepo) {
        this.localRepo = localRepo;
        return (T)this;
    }

    public T setLocalRepositoryTail(String ... localRepoTail) {
        this.localRepoTail = localRepoTail;
        return (T)this;
    }

    public T setLocalRepositoryTailIgnoreAvailability(boolean localRepoTailIgnoreAvailability) {
        this.localRepoTailIgnoreAvailability = localRepoTailIgnoreAvailability;
        return (T)this;
    }

    public T setOffline(boolean offline) {
        this.offline = offline;
        return (T)this;
    }

    public T setCurrentProject(LocalProject currentProject) {
        this.currentProject = currentProject;
        return (T)this;
    }

    public T setWorkspaceDiscovery(boolean workspaceDiscovery) {
        this.workspaceDiscovery = workspaceDiscovery;
        return (T)this;
    }

    public T setRepositorySystem(RepositorySystem repoSystem) {
        this.repoSystem = repoSystem;
        return (T)this;
    }

    public T setRepositorySystemSession(RepositorySystemSession repoSession) {
        this.repoSession = repoSession;
        return (T)this;
    }

    public T setRemoteRepositories(List<RemoteRepository> remoteRepos) {
        this.remoteRepos = remoteRepos;
        return (T)this;
    }

    public T setRemotePluginRepositories(List<RemoteRepository> remotePluginRepos) {
        this.remotePluginRepos = remotePluginRepos;
        return (T)this;
    }

    public T setRemoteRepositoryManager(RemoteRepositoryManager remoteRepoManager) {
        this.remoteRepoManager = remoteRepoManager;
        return (T)this;
    }

    public T setSettingsDecrypter(SettingsDecrypter settingsDecrypter) {
        this.settingsDecrypter = settingsDecrypter;
        return (T)this;
    }

    public T setCurrentProject(String currentProject) {
        this.alternatePomName = currentProject;
        return (T)this;
    }

    public T setUserSettings(File userSettings) {
        this.userSettings = userSettings;
        return (T)this;
    }

    public T setArtifactTransferLogging(boolean artifactTransferLogging) {
        this.artifactTransferLogging = artifactTransferLogging;
        return (T)this;
    }

    public Path getPomForDirOrNull(Path basedir) {
        if (!Files.isDirectory(basedir, new LinkOption[0])) {
            return null;
        }
        String altPom = this.alternatePomName == null ? this.getInitializedCliOptions().getOptionValue("f") : this.alternatePomName;
        return BootstrapMavenContext.getPomForDirOrNull(basedir, altPom == null ? null : Paths.get(altPom, new String[0]));
    }

    public T setRootProjectDir(Path rootProjectDir) {
        this.rootProjectDir = rootProjectDir;
        return (T)this;
    }

    public T setPreferPomsFromWorkspace(boolean preferPomsFromWorkspace) {
        this.preferPomsFromWorkspace = preferPomsFromWorkspace;
        return (T)this;
    }

    public T setEffectiveModelBuilder(boolean effectiveModelBuilder) {
        this.effectiveModelBuilder = effectiveModelBuilder;
        return (T)this;
    }

    public T setWorkspaceModuleParentHierarchy(boolean wsModuleParentHierarchy) {
        this.wsModuleParentHierarchy = wsModuleParentHierarchy;
        return (T)this;
    }

    public T setProjectModelProvider(Function<Path, Model> modelProvider) {
        this.modelProvider = modelProvider;
        return (T)this;
    }

    public T setWarnOnFailedWorkspaceModules(boolean warnOnFailedWorkspaceModules) {
        this.warnOnFailedWorkspaceModules = warnOnFailedWorkspaceModules;
        return (T)this;
    }

    private BootstrapMavenOptions getInitializedCliOptions() {
        return this.cliOptions == null ? (this.cliOptions = BootstrapMavenOptions.newInstance()) : this.cliOptions;
    }
}

