/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import java.util.List;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.Problem;
import org.gradle.internal.deprecation.ConfigurationDeprecationType;
import org.gradle.internal.deprecation.DeprecatedFeatureUsage;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessage;
import org.gradle.internal.deprecation.DeprecationTimeline;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.javax.annotation.CheckReturnValue;
import org.gradle.util.GradleVersion;

@CheckReturnValue
public class DeprecationMessageBuilder<T extends DeprecationMessageBuilder<T>> {
    private static final GradleVersion GRADLE9 = GradleVersion.version("9.0");
    private static final GradleVersion GRADLE10 = GradleVersion.version("10.0");
    protected String summary;
    private DeprecationTimeline deprecationTimeline;
    private String context;
    private String advice;
    private DocLink documentation = null;
    private DeprecatedFeatureUsage.Type usageType = DeprecatedFeatureUsage.Type.USER_CODE_DIRECT;
    protected String problemIdDisplayName;
    protected String problemId;
    public static final char DASH = '-';

    DeprecationMessageBuilder() {
    }

    public static WithDocumentation withDocumentation(Problem warning, WithDeprecationTimeline withDeprecationTimeline) {
        DocLink docLink = warning.getDefinition().getDocumentationLink();
        if (docLink != null) {
            return withDeprecationTimeline.withDocumentation(warning.getDefinition().getDocumentationLink());
        }
        return (WithDocumentation)withDeprecationTimeline.undocumented();
    }

    protected String createDefaultDeprecationIdDisplayName() {
        return this.summary;
    }

    public T withContext(String context) {
        this.context = context;
        return (T)this;
    }

    public T withAdvice(String advice) {
        this.advice = advice;
        return (T)this;
    }

    public T withProblemIdDisplayName(String problemIdDisplayName) {
        this.problemIdDisplayName = problemIdDisplayName;
        return (T)this;
    }

    public T withProblemId(String problemId) {
        this.problemId = problemId;
        return (T)this;
    }

    public WithDeprecationTimeline willBeRemovedInGradle9() {
        this.deprecationTimeline = DeprecationTimeline.willBeRemovedInVersion(GRADLE9);
        return new WithDeprecationTimeline(this);
    }

    public WithDeprecationTimeline willBeRemovedInGradle10() {
        this.deprecationTimeline = DeprecationTimeline.willBeRemovedInVersion(GRADLE10);
        return new WithDeprecationTimeline(this);
    }

    public WithDeprecationTimeline willBecomeAnErrorInGradle9() {
        this.deprecationTimeline = DeprecationTimeline.willBecomeAnErrorInVersion(GRADLE9);
        return new WithDeprecationTimeline(this);
    }

    public WithDeprecationTimeline willBecomeAnErrorInGradle10() {
        this.deprecationTimeline = DeprecationTimeline.willBecomeAnErrorInVersion(GRADLE10);
        return new WithDeprecationTimeline(this);
    }

    public WithDeprecationTimeline startingWithGradle9(String message) {
        this.deprecationTimeline = DeprecationTimeline.startingWithVersion(GRADLE9, message);
        return new WithDeprecationTimeline(this);
    }

    void setIndirectUsage() {
        this.usageType = DeprecatedFeatureUsage.Type.USER_CODE_INDIRECT;
    }

    void setBuildInvocationUsage() {
        this.usageType = DeprecatedFeatureUsage.Type.BUILD_INVOCATION;
    }

    void setSummary(String summary) {
        this.summary = summary;
    }

    void setAdvice(String advice) {
        this.advice = advice;
    }

    void setDeprecationTimeline(DeprecationTimeline deprecationTimeline) {
        this.deprecationTimeline = deprecationTimeline;
    }

    void setDocumentation(DocLink documentation) {
        this.documentation = documentation;
    }

    void setProblemIdDisplayName(String problemIdDisplayName) {
        this.problemIdDisplayName = problemIdDisplayName;
    }

    DeprecationMessage build() {
        if (this.problemIdDisplayName == null) {
            this.setProblemIdDisplayName(this.createDefaultDeprecationIdDisplayName());
        }
        return new DeprecationMessage(this.summary, this.deprecationTimeline.toString(), this.advice, this.context, this.documentation, this.usageType, this.problemIdDisplayName, this.problemId);
    }

    public void setProblemId(String problemId) {
        this.problemId = problemId;
    }

    public static String createDefaultDeprecationId(String ... ids) {
        StringBuilder sb = new StringBuilder();
        for (String id : ids) {
            CharSequence cleanId;
            if (id == null || (cleanId = DeprecationMessageBuilder.createDashedId(id)).length() <= 0) continue;
            sb.append(cleanId);
            sb.append('-');
        }
        DeprecationMessageBuilder.removeTrailingDashes(sb);
        return sb.toString();
    }

    private static void removeTrailingDashes(StringBuilder sb) {
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == '-') {
            sb.setLength(sb.length() - 1);
        }
    }

    private static CharSequence createDashedId(String id) {
        StringBuilder cleanId = new StringBuilder();
        boolean previousWasDash = false;
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (Character.isLetter(c)) {
                previousWasDash = false;
                cleanId.append(Character.toLowerCase(c));
                continue;
            }
            if (previousWasDash) continue;
            cleanId.append('-');
            previousWasDash = true;
        }
        return cleanId;
    }

    public static class DeprecateBehaviour
    extends DeprecationMessageBuilder<DeprecateBehaviour> {
        private final String behaviour;

        public DeprecateBehaviour(String behaviour) {
            this.behaviour = behaviour;
        }

        @Override
        public WithDeprecationTimeline willBeRemovedInGradle9() {
            this.setDeprecationTimeline(DeprecationTimeline.behaviourWillBeRemovedInVersion(GRADLE9));
            return new WithDeprecationTimeline(this);
        }

        @Override
        DeprecationMessage build() {
            this.setSummary(String.format("%s This behavior has been deprecated.", this.behaviour));
            return super.build();
        }
    }

    public static class DeprecateInternalApi
    extends WithReplacement<String, DeprecateInternalApi> {
        DeprecateInternalApi(String api) {
            super(api);
        }

        @Override
        String formatSummary(String api) {
            return String.format("Internal API %s has been deprecated.", api);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use %s instead.", replacement);
        }
    }

    public static class DeprecatePlugin
    extends WithReplacement<String, DeprecatePlugin> {
        private boolean externalReplacement = false;

        DeprecatePlugin(String plugin) {
            super(plugin);
        }

        @Override
        String formatSummary(String plugin) {
            return String.format("The %s plugin has been deprecated.", plugin);
        }

        @Override
        String formatAdvice(String replacement) {
            return this.externalReplacement ? String.format("Consider using the %s plugin instead.", replacement) : String.format("Please use the %s plugin instead.", replacement);
        }

        public DeprecatePlugin replaceWithExternalPlugin(String replacement) {
            this.externalReplacement = true;
            return (DeprecatePlugin)this.replaceWith(replacement);
        }
    }

    public static class DeprecateTaskType
    extends WithReplacement<Class<?>, DeprecateTaskType> {
        private final String path;

        DeprecateTaskType(String task, String path) {
            super(task);
            this.path = path;
        }

        @Override
        String formatSummary(String type) {
            return String.format("The task type %s (used by the %s task) has been deprecated.", type, this.path);
        }

        @Override
        String formatAdvice(Class<?> replacement) {
            return String.format("Please use the %s type instead.", replacement.getCanonicalName());
        }
    }

    public static class DeprecateTask
    extends WithReplacement<String, DeprecateTask> {
        DeprecateTask(String task) {
            super(task);
        }

        @Override
        String formatSummary(String task) {
            return String.format("The %s task has been deprecated.", task);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s task instead.", replacement);
        }
    }

    public static class DeprecateType
    extends WithReplacement<String, DeprecateType> {
        DeprecateType(String type) {
            super(type);
        }

        @Override
        String formatSummary(String type) {
            return String.format("The %s type has been deprecated.", type);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s type instead.", replacement);
        }
    }

    public static class DeprecateInvocation
    extends WithReplacement<String, DeprecateInvocation> {
        DeprecateInvocation(String invocation) {
            super(invocation);
        }

        @Override
        String formatSummary(String invocation) {
            return String.format("Using method %s has been deprecated.", invocation);
        }

        @Override
        String formatAdvice(String replacement) {
            return DeprecateMethod.pleaseUseThisMethodInstead(replacement);
        }
    }

    public static class DeprecateMethod
    extends WithReplacement<String, DeprecateMethod> {
        private final Class<?> methodClass;
        private final String methodWithParams;

        DeprecateMethod(Class<?> methodClass, String methodWithParams) {
            super(methodWithParams);
            this.methodClass = methodClass;
            this.methodWithParams = methodWithParams;
        }

        @Override
        String formatSubject() {
            return String.format("%s.%s", this.methodClass.getSimpleName(), this.methodWithParams);
        }

        @Override
        String formatSummary(String method) {
            return String.format("The %s method has been deprecated.", method);
        }

        @Override
        String formatAdvice(String replacement) {
            return DeprecateMethod.pleaseUseThisMethodInstead(replacement);
        }

        private static String pleaseUseThisMethodInstead(String replacement) {
            return String.format("Please use the %s method instead.", replacement);
        }
    }

    public static class DeprecateConfiguration
    extends WithReplacement<List<String>, DeprecateConfiguration> {
        private final ConfigurationDeprecationType deprecationType;

        DeprecateConfiguration(String configuration, ConfigurationDeprecationType deprecationType) {
            super(configuration);
            this.deprecationType = deprecationType;
            if (!deprecationType.inUserCode) {
                this.setIndirectUsage();
            }
        }

        @Override
        String formatSummary(String configuration) {
            return String.format("The %s configuration has been deprecated for %s.", configuration, this.deprecationType.displayName());
        }

        @Override
        String formatAdvice(List<String> replacements) {
            if (replacements.isEmpty()) {
                return "Please " + this.deprecationType.usage + " another configuration instead.";
            }
            return String.format("Please %s the %s configuration instead.", this.deprecationType.usage, Joiner.on(" or ").join(replacements));
        }
    }

    @CheckReturnValue
    public static class ConfigurationDeprecationTypeSelector {
        private final String configuration;

        ConfigurationDeprecationTypeSelector(String configuration) {
            this.configuration = configuration;
        }

        public DeprecateConfiguration forArtifactDeclaration() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.ARTIFACT_DECLARATION);
        }

        public DeprecateConfiguration forConsumption() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.CONSUMPTION);
        }

        public DeprecateConfiguration forDependencyDeclaration() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.DEPENDENCY_DECLARATION);
        }

        public DeprecateConfiguration forResolution() {
            return new DeprecateConfiguration(this.configuration, ConfigurationDeprecationType.RESOLUTION);
        }
    }

    public static class DeprecateSystemProperty
    extends WithReplacement<String, DeprecateSystemProperty> {
        private final String systemProperty;

        DeprecateSystemProperty(String systemProperty) {
            super(systemProperty);
            this.systemProperty = systemProperty;
            this.setIndirectUsage();
        }

        @Override
        String formatSubject() {
            return this.systemProperty;
        }

        @Override
        String formatSummary(String property) {
            return String.format("The %s system property has been deprecated.", property);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s system property instead.", replacement);
        }
    }

    public static class DeprecateProperty
    extends WithReplacement<String, DeprecateProperty> {
        private final Class<?> propertyClass;
        private final String property;

        DeprecateProperty(Class<?> propertyClass, String property) {
            super(property);
            this.propertyClass = propertyClass;
            this.property = property;
        }

        @Override
        public WithDeprecationTimeline willBeRemovedInGradle9() {
            this.setDeprecationTimeline(DeprecationTimeline.willBeRemovedInVersion(GRADLE9));
            return new WithDeprecationTimeline(this);
        }

        @Override
        String formatSubject() {
            return String.format("%s.%s", this.propertyClass.getSimpleName(), this.property);
        }

        @Override
        String formatSummary(String property) {
            return String.format("The %s property has been deprecated.", property);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s property instead.", replacement);
        }

        public class WithDeprecationTimeline
        extends org.gradle.internal.deprecation.DeprecationMessageBuilder$WithDeprecationTimeline {
            private final DeprecateProperty builder;

            public WithDeprecationTimeline(DeprecateProperty builder) {
                super(builder);
                this.builder = builder;
            }

            @CheckReturnValue
            public WithDocumentation withDslReference() {
                DeprecateProperty.this.setDocumentation(Documentation.dslReference(DeprecateProperty.this.propertyClass, DeprecateProperty.this.property));
                return new WithDocumentation(this.builder);
            }
        }
    }

    public static class DeprecateNamedParameter
    extends WithReplacement<String, DeprecateNamedParameter> {
        DeprecateNamedParameter(String parameter) {
            super(parameter);
        }

        @Override
        String formatSummary(String parameter) {
            return String.format("The %s named parameter has been deprecated.", parameter);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use the %s named parameter instead.", replacement);
        }
    }

    public static class DeprecateAction
    extends WithReplacement<String, DeprecateAction> {
        DeprecateAction(String subject) {
            super(subject);
        }

        @Override
        protected String createDefaultDeprecationIdDisplayName() {
            return this.subject;
        }

        @Override
        String formatSummary(String subject) {
            return String.format("%s has been deprecated.", subject);
        }

        @Override
        String formatAdvice(String replacement) {
            return String.format("Please use %s instead.", replacement);
        }
    }

    public static abstract class WithReplacement<T, SELF extends WithReplacement<T, SELF>>
    extends DeprecationMessageBuilder<SELF> {
        protected final String subject;
        private T replacement;

        WithReplacement(String subject) {
            this.subject = subject;
        }

        public SELF replaceWith(T replacement) {
            this.replacement = replacement;
            return (SELF)this;
        }

        String formatSubject() {
            return this.subject;
        }

        abstract String formatSummary(String var1);

        abstract String formatAdvice(T var1);

        @Override
        DeprecationMessage build() {
            this.setSummary(this.formatSummary(this.formatSubject()));
            if (this.replacement != null) {
                this.setAdvice(this.formatAdvice(this.replacement));
            }
            if (this.problemIdDisplayName == null) {
                this.setProblemIdDisplayName(this.summary);
            }
            if (this.problemId == null) {
                this.setProblemId(DeprecationMessageBuilder.createDefaultDeprecationId(this.createDefaultDeprecationIdDisplayName()));
            }
            return super.build();
        }
    }

    public static class WithDocumentation {
        private final DeprecationMessageBuilder<?> builder;

        WithDocumentation(DeprecationMessageBuilder<?> builder) {
            this.builder = builder;
        }

        public void nagUser() {
            DeprecationLogger.nagUserWith(this.builder, WithDocumentation.class);
        }
    }

    public static class WithDeprecationTimeline
    extends Documentation.AbstractBuilder<WithDocumentation> {
        private final DeprecationMessageBuilder<?> builder;

        public WithDeprecationTimeline(DeprecationMessageBuilder<?> builder) {
            this.builder = builder;
        }

        @Override
        public WithDocumentation withDocumentation(DocLink documentation) {
            this.builder.setDocumentation(documentation);
            return new WithDocumentation(this.builder);
        }
    }
}

