/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.utils;

import io.quarkus.bootstrap.model.gradle.QuarkusModel;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.bootstrap.resolver.QuarkusGradleModelFactory;
import io.quarkus.bootstrap.util.QuarkusModelHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jboss.logging.Logger;

public class BuildToolHelper {
    private static final Logger log = Logger.getLogger(BuildToolHelper.class);

    private BuildToolHelper() {
    }

    public static Path getProjectDir(Path p) {
        for (Path currentPath = p; currentPath != null; currentPath = currentPath.getParent()) {
            if (!BuildTool.MAVEN.exists(currentPath) && !BuildTool.GRADLE.exists(currentPath)) continue;
            return currentPath;
        }
        log.warnv("Unable to find a project directory for {0}.", (Object)p.toString());
        return null;
    }

    public static BuildTool findBuildTool(Path project) {
        for (Path currentPath = project; currentPath != null; currentPath = currentPath.getParent()) {
            if (BuildTool.MAVEN.exists(currentPath)) {
                return BuildTool.MAVEN;
            }
            if (!BuildTool.GRADLE.exists(currentPath)) continue;
            return BuildTool.GRADLE;
        }
        log.warnv("Unable to find a build tool in {0} or in any parent.", (Object)project.toString());
        return null;
    }

    public static boolean isMavenProject(Path project) {
        return BuildToolHelper.findBuildTool(project) == BuildTool.MAVEN;
    }

    public static boolean isGradleProject(Path project) {
        return BuildToolHelper.findBuildTool(project) == BuildTool.GRADLE;
    }

    public static Path getBuildFile(Path project, BuildTool tool) {
        for (Path currentPath = project; currentPath != null; currentPath = currentPath.getParent()) {
            if (!tool.exists(currentPath)) continue;
            return currentPath;
        }
        return null;
    }

    public static QuarkusModel enableGradleAppModelForTest(Path projectRoot) throws IOException, AppModelResolverException {
        return BuildToolHelper.enableGradleAppModel(projectRoot, "TEST", QuarkusModelHelper.ENABLE_JAR_PACKAGING, QuarkusModelHelper.TEST_REQUIRED_TASKS);
    }

    public static QuarkusModel enableGradleAppModel(Path projectRoot, String mode, List<String> jvmArgs, String ... tasks) throws IOException, AppModelResolverException {
        if (BuildToolHelper.isGradleProject(projectRoot)) {
            QuarkusModel model = QuarkusGradleModelFactory.create((File)BuildToolHelper.getBuildFile(projectRoot, BuildTool.GRADLE).toFile(), (String)mode, jvmArgs, (String[])tasks);
            QuarkusModelHelper.exportModel((QuarkusModel)model, (boolean)"TEST".equalsIgnoreCase(mode));
            return model;
        }
        return null;
    }

    public static QuarkusModel enableGradleAppModelForDevMode(Path projectRoot) throws IOException, AppModelResolverException {
        if (BuildToolHelper.isGradleProject(projectRoot)) {
            QuarkusModel model = QuarkusGradleModelFactory.createForTasks((File)BuildToolHelper.getBuildFile(projectRoot, BuildTool.GRADLE).toFile(), (String[])QuarkusModelHelper.DEVMODE_REQUIRED_TASKS);
            QuarkusModelHelper.exportModel((QuarkusModel)model, (boolean)false);
            return model;
        }
        return null;
    }

    public static enum BuildTool {
        MAVEN("pom.xml"),
        GRADLE("build.gradle", "build.gradle.kts");

        private final String[] buildFiles;

        private BuildTool(String ... buildFile) {
            this.buildFiles = buildFile;
        }

        public String[] getBuildFiles() {
            return this.buildFiles;
        }

        public boolean exists(Path root) {
            for (String buildFile : this.buildFiles) {
                if (!Files.exists(root.resolve(buildFile), new LinkOption[0])) continue;
                return true;
            }
            return false;
        }
    }
}

