/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.deployment.devui;

import io.quarkus.arc.deployment.ArcConfig;
import io.quarkus.arc.deployment.ArcDevModeConfig;
import io.quarkus.arc.deployment.CompletedApplicationClassPredicateBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.deployment.devui.ArcBeanInfoBuildItem;
import io.quarkus.arc.deployment.devui.DependencyGraph;
import io.quarkus.arc.deployment.devui.DevBeanInfo;
import io.quarkus.arc.deployment.devui.DevBeanInfos;
import io.quarkus.arc.deployment.devui.DevDecoratorInfo;
import io.quarkus.arc.deployment.devui.DevInterceptorInfo;
import io.quarkus.arc.deployment.devui.DevObserverInfo;
import io.quarkus.arc.deployment.devui.Link;
import io.quarkus.arc.deployment.devui.Node;
import io.quarkus.arc.processor.BeanDeploymentValidator;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BeanResolver;
import io.quarkus.arc.processor.BuildExtension;
import io.quarkus.arc.processor.DecoratorInfo;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.ObserverInfo;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.dev.console.DevConsoleManager;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class ArcDevModeApiProcessor {
    private static final Logger LOG = Logger.getLogger(ArcDevModeApiProcessor.class);
    private static final int DEPENCENY_GRAPH_BEANS_LIMIT = 1000;
    private static final int DEPENCENY_GRAPH_NODES_LIMIT = 30;

    @BuildStep(onlyIf={IsDevelopment.class})
    public void collectBeanInfo(ArcConfig config, ValidationPhaseBuildItem validationPhaseBuildItem, CompletedApplicationClassPredicateBuildItem predicate, BuildProducer<ArcBeanInfoBuildItem> arcBeanInfoProducer) {
        BeanDeploymentValidator.ValidationContext validationContext = validationPhaseBuildItem.getContext();
        DevBeanInfos beanInfos = new DevBeanInfos();
        for (BeanInfo bean : validationContext.beans()) {
            beanInfos.addBean(DevBeanInfo.from(bean, predicate));
        }
        for (BeanInfo bean : validationContext.removedBeans()) {
            beanInfos.addRemovedBean(DevBeanInfo.from(bean, predicate));
        }
        for (ObserverInfo observer : (Collection)validationContext.get(BuildExtension.Key.OBSERVERS)) {
            beanInfos.addObserver(DevObserverInfo.from(observer, predicate));
        }
        for (Object interceptor : (Collection)validationContext.get(BuildExtension.Key.INTERCEPTORS)) {
            beanInfos.addInterceptor(DevInterceptorInfo.from((InterceptorInfo)interceptor, predicate));
        }
        Collection removedInterceptors = (Collection)validationContext.get(BuildExtension.Key.REMOVED_INTERCEPTORS);
        if (removedInterceptors != null) {
            for (InterceptorInfo interceptor : removedInterceptors) {
                beanInfos.addRemovedInterceptor(DevInterceptorInfo.from(interceptor, predicate));
            }
        }
        for (Object decorator : (Collection)validationContext.get(BuildExtension.Key.DECORATORS)) {
            beanInfos.addDecorator(DevDecoratorInfo.from((DecoratorInfo)decorator, predicate));
        }
        Collection removedDecorators = (Collection)validationContext.get(BuildExtension.Key.REMOVED_DECORATORS);
        if (removedDecorators != null) {
            for (DecoratorInfo decorator : removedDecorators) {
                beanInfos.addRemovedDecorator(DevDecoratorInfo.from(decorator, predicate));
            }
        }
        HashMap beanDependenciesMap = new HashMap();
        if (this.generateDependencyGraphs(config, beanInfos)) {
            BeanResolver resolver = validationPhaseBuildItem.getBeanResolver();
            Collection beans = (Collection)validationContext.get(BuildExtension.Key.BEANS);
            HashMap<BeanInfo, List<InjectionPointInfo>> directDependents = new HashMap<BeanInfo, List<InjectionPointInfo>>();
            ArrayList<InjectionPointInfo> allInjectionPoints = new ArrayList<InjectionPointInfo>();
            Map declaringToProducers = (Map)validationContext.beans().producers().collect(Collectors.groupingBy(BeanInfo::getDeclaringBean));
            for (BeanInfo b : beans) {
                if (!b.hasInjectionPoint()) continue;
                for (InjectionPointInfo ip : b.getAllInjectionPoints()) {
                    if (!ip.getTargetBean().isPresent()) continue;
                    allInjectionPoints.add(ip);
                }
            }
            for (BeanInfo bean : beans) {
                DependencyGraph dependencyGraph = this.buildDependencyGraph(bean, validationContext, resolver, beanInfos, allInjectionPoints, declaringToProducers, directDependents);
                if (dependencyGraph.links.isEmpty()) continue;
                if (dependencyGraph.nodes.size() > 30) {
                    DependencyGraph visibleGraph = dependencyGraph.forLevel(10);
                    if (visibleGraph.nodes.size() > 30) {
                        LOG.debugf("Skip dependency graph for %s - too many visible nodes: %s", (Object)bean, (Object)visibleGraph.nodes.size());
                        continue;
                    }
                    LOG.debugf("Dependency graph for %s was reduced to visible nodes: %s", (Object)bean, (Object)dependencyGraph.nodes.size());
                    dependencyGraph = visibleGraph;
                }
                beanInfos.addDependencyGraph(bean.getIdentifier(), dependencyGraph);
                beanDependenciesMap.put(bean.getIdentifier(), dependencyGraph.filterLinks((Predicate<Link>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$collectBeanInfo$0(io.quarkus.arc.deployment.devui.Link ), (Lio/quarkus/arc/deployment/devui/Link;)Z)()).nodes.stream().map(Node::getId).filter(id -> !id.equals(bean.getIdentifier())).collect(Collectors.toList()));
            }
        }
        DevConsoleManager.setGlobal((String)"io.quarkus.arc.beanDependencies", beanDependenciesMap);
        beanInfos.sort();
        arcBeanInfoProducer.produce((BuildItem)new ArcBeanInfoBuildItem(beanInfos));
    }

    DependencyGraph buildDependencyGraph(BeanInfo bean, BeanDeploymentValidator.ValidationContext validationContext, BeanResolver resolver, DevBeanInfos devBeanInfos, List<InjectionPointInfo> allInjectionPoints, Map<BeanInfo, List<BeanInfo>> declaringToProducers, Map<BeanInfo, List<InjectionPointInfo>> directDependents) {
        HashSet<DevBeanInfo> nodes = new HashSet<DevBeanInfo>();
        HashSet<Link> links = new HashSet<Link>();
        this.addNodesDependencies(0, bean, nodes, links, bean, devBeanInfos);
        this.addNodesDependents(0, bean, nodes, links, bean, allInjectionPoints, declaringToProducers, resolver, devBeanInfos, directDependents);
        return new DependencyGraph(nodes.stream().map(Node::from).collect(Collectors.toSet()), links);
    }

    private void addNodesDependencies(int level, BeanInfo root, Set<DevBeanInfo> nodes, Set<Link> links, BeanInfo bean, DevBeanInfos devBeanInfos) {
        if (nodes.add(devBeanInfos.getBean(bean.getIdentifier()))) {
            if (bean.isProducerField() || bean.isProducerMethod()) {
                links.add(Link.producer(bean.getIdentifier(), bean.getDeclaringBean().getIdentifier(), level));
                this.addNodesDependencies(level + 1, root, nodes, links, bean.getDeclaringBean(), devBeanInfos);
            }
            for (InjectionPointInfo injectionPoint : bean.getAllInjectionPoints()) {
                BeanInfo resolved = injectionPoint.getResolvedBean();
                if (resolved == null || resolved.equals((Object)bean)) continue;
                Link link = Link.dependency(bean.getIdentifier(), resolved.getIdentifier(), level);
                links.add(link);
                this.addNodesDependencies(level + 1, root, nodes, links, injectionPoint.getResolvedBean(), devBeanInfos);
            }
        }
    }

    private void addNodesDependents(int level, BeanInfo root, Set<DevBeanInfo> nodes, Set<Link> links, BeanInfo bean, List<InjectionPointInfo> injectionPoints, Map<BeanInfo, List<BeanInfo>> declaringToProducers, BeanResolver resolver, DevBeanInfos devBeanInfos, Map<BeanInfo, List<InjectionPointInfo>> directDependents) {
        BeanInfo dependent;
        List<InjectionPointInfo> direct = directDependents.get(bean);
        if (direct == null) {
            direct = new ArrayList<InjectionPointInfo>();
            for (InjectionPointInfo injectionPoint : injectionPoints) {
                dependent = (BeanInfo)injectionPoint.getTargetBean().get();
                if (dependent.equals((Object)bean)) continue;
                BeanInfo resolved = injectionPoint.getResolvedBean();
                if (resolved == null) {
                    if (!injectionPoint.isProgrammaticLookup() || !resolver.matches(bean, (Type)injectionPoint.getType().asParameterizedType().arguments().get(0), injectionPoint.getRequiredQualifiers())) continue;
                    direct.add(injectionPoint);
                    continue;
                }
                if (!bean.equals((Object)resolved)) continue;
                direct.add(injectionPoint);
            }
            directDependents.put(bean, direct);
        }
        for (InjectionPointInfo ip : direct) {
            dependent = (BeanInfo)ip.getTargetBean().get();
            Link link = ip.getResolvedBean() == null ? Link.lookup(dependent.getIdentifier(), bean.getIdentifier(), level) : Link.dependency(dependent.getIdentifier(), bean.getIdentifier(), level);
            links.add(link);
            if (!nodes.add(devBeanInfos.getBean(dependent.getIdentifier()))) continue;
            this.addNodesDependents(level + 1, root, nodes, links, dependent, injectionPoints, declaringToProducers, resolver, devBeanInfos, directDependents);
        }
        for (BeanInfo producer : declaringToProducers.getOrDefault(bean, Collections.emptyList())) {
            links.add(Link.producer(producer.getIdentifier(), bean.getIdentifier(), level));
            if (!nodes.add(devBeanInfos.getBean(producer.getIdentifier()))) continue;
            this.addNodesDependents(level + 1, root, nodes, links, producer, injectionPoints, declaringToProducers, resolver, devBeanInfos, directDependents);
        }
    }

    private boolean generateDependencyGraphs(ArcConfig config, DevBeanInfos beanInfos) {
        return switch (config.devMode().generateDependencyGraphs()) {
            case ArcDevModeConfig.GenerateDependencyGraphs.TRUE -> true;
            case ArcDevModeConfig.GenerateDependencyGraphs.FALSE -> false;
            case ArcDevModeConfig.GenerateDependencyGraphs.AUTO -> {
                if (beanInfos.getBeans().size() < 1000) {
                    yield true;
                }
                yield false;
            }
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)config.devMode().generateDependencyGraphs()));
        };
    }

    private static /* synthetic */ boolean lambda$collectBeanInfo$0(Link link) {
        return link.type.equals("directDependency");
    }
}

