/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.analytics;

import io.quarkus.analytics.config.FileLocations;
import io.quarkus.analytics.util.FileUtils;
import io.quarkus.devtools.messagewriter.MessageWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.UUID;
import java.util.stream.Stream;

public class AnonymousUserId {
    private static AnonymousUserId INSTANCE = null;
    private final String uuid;
    private boolean isNew;
    private final MessageWriter log;

    public static AnonymousUserId getInstance(FileLocations fileLocations, MessageWriter log) {
        if (INSTANCE == null) {
            INSTANCE = new AnonymousUserId(fileLocations, log);
        }
        return INSTANCE;
    }

    private AnonymousUserId(FileLocations fileLocations, MessageWriter log) {
        this.log = log;
        this.uuid = this.loadOrCreate(fileLocations.getUUIDFile());
    }

    public String getUuid() {
        return this.uuid;
    }

    public boolean isNew() {
        return this.isNew;
    }

    private String loadOrCreate(Path file) {
        try {
            if (Files.exists(file, new LinkOption[0])) {
                return this.load(file);
            }
            String uuid = UUID.randomUUID().toString();
            this.write(uuid, file);
            this.isNew = true;
            return uuid;
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("[Quarkus build analytics] Could not create UUID file at " + String.valueOf(file.toAbsolutePath()), new Object[]{e});
            }
            return "N/A";
        }
    }

    private String load(Path file) {
        String uuid;
        block8: {
            uuid = "N/A";
            try (Stream<String> lines = Files.lines(file);){
                uuid = lines.findAny().map(String::trim).orElse("empty");
            }
            catch (IOException e) {
                if (!this.log.isDebugEnabled()) break block8;
                this.log.debug("[Quarkus build analytics] Could not read redhat anonymous UUID file at " + String.valueOf(file.toAbsolutePath()), new Object[]{e});
            }
        }
        return uuid;
    }

    private void write(String uuid, Path uuidFile) {
        block2: {
            try {
                FileUtils.createFileAndParent(uuidFile);
                FileUtils.append(uuid, uuidFile);
            }
            catch (IOException e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("[Quarkus build analytics] Could not write redhat anonymous UUID to file at " + String.valueOf(uuidFile.toAbsolutePath()), new Object[]{e});
            }
        }
    }
}

