/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.quarkus.amazon.lambda.http.model.AwsProxyRequest;
import io.quarkus.amazon.lambda.http.model.AwsProxyRequestContext;
import io.quarkus.amazon.lambda.http.model.AwsProxyResponse;
import io.quarkus.amazon.lambda.http.model.Headers;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualClientConnection;
import io.quarkus.netty.runtime.virtual.VirtualResponseHandler;
import io.quarkus.vertx.http.runtime.QuarkusHttpHeaders;
import io.quarkus.vertx.http.runtime.VertxHttpRecorder;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import java.io.ByteArrayOutputStream;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jboss.logging.Logger;

public class LambdaHttpHandler
implements RequestHandler<AwsProxyRequest, AwsProxyResponse> {
    private static final Logger log = Logger.getLogger((String)"quarkus.amazon.lambda.http");
    private static final int BUFFER_SIZE = 8096;
    private static final Headers errorHeaders = new Headers();

    public AwsProxyResponse handleRequest(AwsProxyRequest request, Context context) {
        InetSocketAddress clientAddress = null;
        if (request.getRequestContext() != null && request.getRequestContext().getIdentity() != null && request.getRequestContext().getIdentity().getSourceIp() != null) {
            clientAddress = new InetSocketAddress(request.getRequestContext().getIdentity().getSourceIp(), 443);
        }
        try {
            return this.nettyDispatch(clientAddress, request, context);
        }
        catch (Exception e) {
            log.error((Object)"Request Failure", (Throwable)e);
            return new AwsProxyResponse(500, errorHeaders, "{ \"message\": \"Internal Server Error\" }");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AwsProxyResponse nettyDispatch(InetSocketAddress clientAddress, AwsProxyRequest request, Context context) throws Exception {
        String path = request.getPath();
        if (request.getMultiValueQueryStringParameters() != null && !request.getMultiValueQueryStringParameters().isEmpty()) {
            StringBuilder sb = new StringBuilder(path);
            sb.append("?");
            boolean first = true;
            for (Map.Entry<String, List<String>> entry : request.getMultiValueQueryStringParameters().entrySet()) {
                for (String v : entry.getValue()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append("&");
                    }
                    if (request.getRequestSource() == AwsProxyRequest.RequestSource.ALB) {
                        sb.append(entry.getKey());
                        sb.append("=");
                        sb.append(v);
                        continue;
                    }
                    sb.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.name()));
                    sb.append("=");
                    sb.append(URLEncoder.encode(v, StandardCharsets.UTF_8.name()));
                }
            }
            path = sb.toString();
        }
        QuarkusHttpHeaders quarkusHeaders = new QuarkusHttpHeaders();
        quarkusHeaders.setContextObject(Context.class, (Object)context);
        quarkusHeaders.setContextObject(AwsProxyRequestContext.class, (Object)request.getRequestContext());
        quarkusHeaders.setContextObject(AwsProxyRequest.class, (Object)request);
        DefaultHttpRequest nettyRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.valueOf((String)request.getHttpMethod()), path, (HttpHeaders)quarkusHeaders);
        if (request.getMultiValueHeaders() != null) {
            for (Map.Entry<String, List<String>> entry : request.getMultiValueHeaders().entrySet()) {
                nettyRequest.headers().add(entry.getKey(), (Iterable)entry.getValue());
            }
        }
        if (!nettyRequest.headers().contains((CharSequence)HttpHeaderNames.HOST)) {
            nettyRequest.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)"localhost");
        }
        LastHttpContent requestContent = LastHttpContent.EMPTY_LAST_CONTENT;
        if (request.getBody() != null) {
            nettyRequest.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
            if (request.isBase64Encoded()) {
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])Base64.getDecoder().decode(request.getBody()));
                requestContent = new DefaultLastHttpContent(byteBuf);
            } else {
                ByteBuf byteBuf = Unpooled.copiedBuffer((CharSequence)request.getBody(), (Charset)StandardCharsets.UTF_8);
                requestContent = new DefaultLastHttpContent(byteBuf);
            }
        }
        NettyResponseHandler nettyResponseHandler = new NettyResponseHandler(request);
        VirtualClientConnection connection = VirtualClientConnection.connect((VirtualResponseHandler)nettyResponseHandler, (VirtualAddress)VertxHttpRecorder.VIRTUAL_HTTP, (java.net.SocketAddress)clientAddress);
        if (request.getRequestContext() != null && request.getRequestContext().getIdentity() != null && request.getRequestContext().getIdentity().getSourceIp() != null && request.getRequestContext().getIdentity().getSourceIp().length() > 0) {
            int port = 443;
            if (request.getMultiValueHeaders() != null && request.getMultiValueHeaders().getFirst("X-Forwarded-Port") != null) {
                port = Integer.parseInt((String)request.getMultiValueHeaders().getFirst("X-Forwarded-Port"));
            }
            connection.peer().attr(ConnectionBase.REMOTE_ADDRESS_OVERRIDE).set((Object)SocketAddress.inetSocketAddress((int)port, (String)request.getRequestContext().getIdentity().getSourceIp()));
        }
        connection.sendMessage((Object)nettyRequest);
        connection.sendMessage((Object)requestContent);
        try {
            AwsProxyResponse awsProxyResponse = nettyResponseHandler.getFuture().get();
            return awsProxyResponse;
        }
        finally {
            connection.close();
        }
    }

    private ByteArrayOutputStream createByteStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(8096);
        return baos;
    }

    private boolean isText(String contentType) {
        if (contentType != null) {
            String ct = contentType.toLowerCase(Locale.ROOT);
            return ct.startsWith("text") || ct.contains("json") || ct.contains("xml") && !ct.contains("openxmlformats") || ct.contains("yaml");
        }
        return false;
    }

    static {
        errorHeaders.putSingle("Content-Type", "application/json");
    }

    private class NettyResponseHandler
    implements VirtualResponseHandler {
        AwsProxyResponse responseBuilder = new AwsProxyResponse();
        ByteArrayOutputStream baos;
        WritableByteChannel byteChannel;
        final AwsProxyRequest request;
        CompletableFuture<AwsProxyResponse> future = new CompletableFuture();

        public NettyResponseHandler(AwsProxyRequest request) {
            this.request = request;
        }

        public CompletableFuture<AwsProxyResponse> getFuture() {
            return this.future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Object msg) {
            try {
                FileRegion file;
                if (msg instanceof HttpResponse) {
                    HttpResponse res = (HttpResponse)msg;
                    this.responseBuilder.setStatusCode(res.status().code());
                    if (this.request.getRequestSource() == AwsProxyRequest.RequestSource.ALB) {
                        this.responseBuilder.setStatusDescription(res.status().reasonPhrase());
                    }
                    this.responseBuilder.setMultiValueHeaders(new Headers());
                    for (String name : res.headers().names()) {
                        if (name.equalsIgnoreCase("Transfer-Encoding")) continue;
                        for (String v : res.headers().getAll(name)) {
                            if (name.equalsIgnoreCase("Transfer-Encoding") && v.contains("chunked")) continue;
                            this.responseBuilder.getMultiValueHeaders().add(name, v);
                        }
                    }
                }
                if (msg instanceof HttpContent) {
                    HttpContent content = (HttpContent)msg;
                    int readable = content.content().readableBytes();
                    if (this.baos == null && readable > 0) {
                        this.baos = LambdaHttpHandler.this.createByteStream();
                    }
                    for (int i = 0; i < readable; ++i) {
                        this.baos.write(content.content().readByte());
                    }
                }
                if (msg instanceof FileRegion && (file = (FileRegion)msg).count() > 0L && file.transferred() < file.count()) {
                    if (this.baos == null) {
                        this.baos = LambdaHttpHandler.this.createByteStream();
                    }
                    if (this.byteChannel == null) {
                        this.byteChannel = Channels.newChannel(this.baos);
                    }
                    file.transferTo(this.byteChannel, file.transferred());
                }
                if (msg instanceof LastHttpContent) {
                    if (this.baos != null) {
                        if (LambdaHttpHandler.this.isText((String)this.responseBuilder.getMultiValueHeaders().getFirst("Content-Type"))) {
                            this.responseBuilder.setBody(this.baos.toString(StandardCharsets.UTF_8));
                        } else {
                            this.responseBuilder.setBase64Encoded(true);
                            this.responseBuilder.setBody(Base64.getEncoder().encodeToString(this.baos.toByteArray()));
                        }
                    }
                    this.future.complete(this.responseBuilder);
                }
            }
            catch (Throwable ex) {
                this.future.completeExceptionally(ex);
            }
            finally {
                if (msg != null) {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        }

        public void close() {
            if (!this.future.isDone()) {
                this.future.completeExceptionally(new RuntimeException("Connection closed"));
            }
        }
    }
}

