/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.http;

import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import io.quarkus.amazon.lambda.http.CognitoPrincipal;
import io.quarkus.amazon.lambda.http.CustomPrincipal;
import io.quarkus.amazon.lambda.http.DefaultLambdaAuthenticationRequest;
import io.quarkus.amazon.lambda.http.IAMPrincipal;
import io.quarkus.amazon.lambda.http.LambdaHttpRecorder;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.IdentityProvider;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.runtime.QuarkusPrincipal;
import io.quarkus.security.runtime.QuarkusSecurityIdentity;
import io.smallrye.mutiny.Uni;
import jakarta.enterprise.context.ApplicationScoped;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;

@ApplicationScoped
public final class DefaultLambdaIdentityProvider
implements IdentityProvider<DefaultLambdaAuthenticationRequest> {
    public Class<DefaultLambdaAuthenticationRequest> getRequestType() {
        return DefaultLambdaAuthenticationRequest.class;
    }

    public Uni<SecurityIdentity> authenticate(DefaultLambdaAuthenticationRequest request, AuthenticationRequestContext context) {
        APIGatewayV2HTTPEvent event = request.getEvent();
        SecurityIdentity identity = DefaultLambdaIdentityProvider.authenticate(event, LambdaHttpRecorder.config.mapCognitoToRoles());
        if (identity == null) {
            return Uni.createFrom().optional(Optional.empty());
        }
        return Uni.createFrom().item((Object)identity);
    }

    public static SecurityIdentity authenticate(APIGatewayV2HTTPEvent event, boolean groups) {
        Principal principal = DefaultLambdaIdentityProvider.getPrincipal(event);
        if (principal == null) {
            return null;
        }
        QuarkusSecurityIdentity.Builder builder = QuarkusSecurityIdentity.builder();
        builder.setPrincipal(principal);
        if (groups && principal instanceof CognitoPrincipal) {
            CognitoPrincipal cognito = (CognitoPrincipal)((Object)principal);
            for (String group : cognito.getGroups()) {
                builder.addRole(group);
            }
        }
        return builder.build();
    }

    protected static Principal getPrincipal(APIGatewayV2HTTPEvent request) {
        APIGatewayV2HTTPEvent.RequestContext.Authorizer authorizer;
        Map<String, String> systemEnvironment = System.getenv();
        boolean isSamLocal = Boolean.parseBoolean(systemEnvironment.get("AWS_SAM_LOCAL"));
        APIGatewayV2HTTPEvent.RequestContext requestContext = request.getRequestContext();
        if (isSamLocal && (requestContext == null || requestContext.getAuthorizer() == null)) {
            String forcedUserName = systemEnvironment.get("QUARKUS_AWS_LAMBDA_FORCE_USER_NAME");
            if (forcedUserName != null && !forcedUserName.isEmpty()) {
                return new QuarkusPrincipal(forcedUserName);
            }
        } else if (requestContext != null && (authorizer = requestContext.getAuthorizer()) != null) {
            Object tmp;
            if (authorizer.getJwt() != null) {
                APIGatewayV2HTTPEvent.RequestContext.Authorizer.JWT jwt = authorizer.getJwt();
                Map claims = jwt.getClaims();
                if (claims != null && claims.containsKey("cognito:username")) {
                    return new CognitoPrincipal(jwt);
                }
            } else if (authorizer.getIam() != null) {
                if (authorizer.getIam().getUserId() != null) {
                    return new IAMPrincipal(authorizer.getIam());
                }
            } else if (authorizer.getLambda() != null && (tmp = authorizer.getLambda().get("principalId")) != null && tmp instanceof String) {
                String username = (String)tmp;
                return new CustomPrincipal(username, authorizer.getLambda());
            }
        }
        return null;
    }
}

