/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.lambda.deployment;

import io.quarkus.amazon.lambda.deployment.EventServerOverrideBuildItem;
import io.quarkus.amazon.lambda.deployment.LambdaBuildConfig;
import io.quarkus.amazon.lambda.deployment.LambdaObjectMapperInitializedBuildItem;
import io.quarkus.amazon.lambda.runtime.LambdaHotReplacementRecorder;
import io.quarkus.amazon.lambda.runtime.MockEventServer;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsLiveReloadSupportedByLaunchMode;
import io.quarkus.deployment.IsProduction;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Produce;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.builditem.Startable;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class DevServicesLambdaProcessor {
    private static final Logger log = Logger.getLogger(DevServicesLambdaProcessor.class);

    @BuildStep(onlyIf={IsLiveReloadSupportedByLaunchMode.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    public void enableHotReplacementChecker(LaunchModeBuildItem launchMode, LambdaHotReplacementRecorder recorder, LambdaObjectMapperInitializedBuildItem dependency) {
        if (launchMode.getLaunchMode().isDevOrTest() && !this.legacyTestingEnabled()) {
            recorder.enable();
        }
    }

    private boolean legacyTestingEnabled() {
        try {
            Class.forName("io.quarkus.amazon.lambda.test.LambdaClient");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Produce(value=ServiceStartBuildItem.class)
    @BuildStep(onlyIfNot={IsProduction.class})
    public void startEventServer(LaunchModeBuildItem launchModeBuildItem, LambdaBuildConfig config, Optional<EventServerOverrideBuildItem> override, BuildProducer<DevServicesResultBuildItem> devServicePropertiesProducer) {
        LaunchMode launchMode = launchModeBuildItem.getLaunchMode();
        if (!launchMode.isDevOrTest()) {
            return;
        }
        if (this.legacyTestingEnabled()) {
            return;
        }
        if (!config.mockEventServer().enabled()) {
            return;
        }
        MockEventServer server = override.isPresent() ? override.get().getServer().get() : new MockEventServer();
        boolean isTest = launchMode == LaunchMode.TEST;
        String portPropertySuffix = isTest ? "test-port" : "dev-port";
        String propName = "quarkus.lambda.mock-event-server." + portPropertySuffix;
        DevServicesResultBuildItem buildItem = DevServicesResultBuildItem.owned().feature(Feature.AMAZON_LAMBDA).serviceName(Feature.AMAZON_LAMBDA.getName()).serviceConfig((Object)config).startable(() -> new StartableEventServer(server, propName, isTest)).highPriorityConfig(Set.of(propName)).configProvider(Map.of(propName, s -> String.valueOf(s.getExposedPort()), "quarkus-internal.aws-lambda.test-api", StartableEventServer::getConnectionInfo)).build();
        devServicePropertiesProducer.produce((BuildItem)buildItem);
    }

    private static class StartableEventServer
    implements Startable {
        private final MockEventServer server;
        private final String propName;
        private final boolean isTest;

        public StartableEventServer(MockEventServer server, String propName, boolean isTest) {
            this.server = server;
            this.propName = propName;
            this.isTest = isTest;
        }

        public void start() {
            int port = this.isTest ? Integer.parseInt("8081") : Integer.parseInt("8080");
            int configuredPort = (Integer)ConfigProvider.getConfig().getOptionalValue(this.propName, Integer.class).or(() -> Optional.of(port)).get();
            this.server.start(configuredPort);
            log.debugf("Starting event server on port %d", configuredPort);
        }

        public int getExposedPort() {
            return this.server.getPort();
        }

        public String getConnectionInfo() {
            return "localhost:" + this.getExposedPort() + "/_lambda_";
        }

        public String getContainerId() {
            return null;
        }

        public void close() throws IOException {
            this.server.close();
        }
    }
}

