/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.deployment.util.DeploymentUtil;
import io.quarkus.maven.dependency.ArtifactDependency;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public enum Deployer {
    kubernetes("quarkus-kubernetes", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
    minikube("quarkus-minikube", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
    kind("quarkus-kind", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
    knative("quarkus-kubernetes", "quarkus-container-image-docker", "quarkus-container-image-jib", "quarkus-container-image-buildpack"),
    openshift("quarkus-openshift", new String[0]);

    private final String extension;
    private final String[] requiresOneOf;
    static final String QUARKUS_GROUP_ID = "io.quarkus";
    static final String QUARKUS_PREFIX = "quarkus-";

    private Deployer(String extension, String ... requiresOneOf) {
        this.extension = extension;
        this.requiresOneOf = requiresOneOf;
    }

    public String getExtension() {
        return this.extension;
    }

    public String[] getRequiresOneOf() {
        return this.requiresOneOf;
    }

    public Optional<ArtifactDependency> getExtensionArtifact(MavenProject project) {
        String artifactId = QUARKUS_PREFIX + this.name();
        return project.getDependencyManagement().getDependencies().stream().filter(d -> QUARKUS_GROUP_ID.equals(d.getGroupId()) && artifactId.equals(d.getArtifactId())).map(d -> new ArtifactDependency(d.getGroupId(), d.getArtifactId(), null, "jar", d.getVersion())).findFirst();
    }

    public static Optional<Deployer> getDeployer(MavenProject project) {
        return DeploymentUtil.getEnabledDeployer().or(() -> Deployer.getProjecDeployer(project).stream().findFirst()).map(Deployer::valueOf);
    }

    public static Set<String> getProjecDeployer(MavenProject project) {
        return Deployer.getProjecDeployers(project.getDependencies());
    }

    public static Set<String> getProjecDeployers(List<Dependency> dependencies) {
        if (dependencies == null) {
            return Collections.emptySet();
        }
        return dependencies.stream().filter(d -> QUARKUS_GROUP_ID.equals(d.getGroupId())).map(d -> Deployer.strip(d.getArtifactId())).filter(n -> Arrays.stream(Deployer.values()).anyMatch(e -> e.name().equals(n))).collect(Collectors.toSet());
    }

    private static final String strip(String s) {
        return s.replaceAll("^" + Pattern.quote(QUARKUS_PREFIX), "");
    }
}

