/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import jakarta.websocket.RemoteEndpoint;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class BinaryOutputStream
extends OutputStream {
    final RemoteEndpoint.Basic basic;
    boolean closed;

    public BinaryOutputStream(RemoteEndpoint.Basic basic) {
        this.basic = basic;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        this.basic.sendBinary(ByteBuffer.wrap(b, off, len), false);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.basic.sendBinary(ByteBuffer.allocate(0), true);
        }
    }
}

