/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.handshake;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.undertow.websockets.ConfiguredServerEndpoint;
import io.undertow.websockets.ExtensionImpl;
import io.undertow.websockets.handshake.Base64;
import io.undertow.websockets.handshake.HandshakeUtil;
import io.undertow.websockets.handshake.WebSocketHttpExchange;
import jakarta.websocket.Extension;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class Handshake {
    private static final String EXTENSION_SEPARATOR = ",";
    private static final String PARAMETER_SEPARATOR = ";";
    private static final char PARAMETER_EQUAL = '=';
    public static final String MAGIC_NUMBER = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    public static final String SHA1 = "SHA1";
    private static final String WEB_SOCKET_VERSION = "13";
    protected final Set<String> subprotocols;
    private static final byte[] EMPTY = new byte[0];
    private static final Pattern PATTERN = Pattern.compile("\\s*,\\s*");
    protected Set<WebSocketServerExtensionHandshaker> availableExtensions = new HashSet<WebSocketServerExtensionHandshaker>(Arrays.asList(new DeflateFrameServerExtensionHandshaker(), new PerMessageDeflateServerExtensionHandshaker()));
    protected boolean allowExtensions;
    private final ConfiguredServerEndpoint config;
    private final int maxFrameSize;

    public Handshake(ConfiguredServerEndpoint config, Set<String> subprotocols, int maxFrameSize) {
        this.subprotocols = subprotocols;
        this.config = config;
        this.maxFrameSize = maxFrameSize;
    }

    public ConfiguredServerEndpoint getConfig() {
        return this.config;
    }

    protected static String getWebSocketLocation(WebSocketHttpExchange exchange) {
        String scheme = "https".equals(exchange.getRequestScheme()) ? "wss" : "ws";
        return scheme + "://" + exchange.getRequestHeader((CharSequence)HttpHeaderNames.HOST) + exchange.getRequestURI();
    }

    public final void handshake(WebSocketHttpExchange exchange, final Consumer<ChannelHandlerContext> completeListener) {
        String origin = exchange.getRequestHeader((CharSequence)HttpHeaderNames.ORIGIN);
        if (origin != null) {
            exchange.setResponseHeader((CharSequence)HttpHeaderNames.ORIGIN, origin);
        }
        this.selectSubprotocol(exchange);
        final List<WebSocketServerExtension> extensions = this.selectExtensions(exchange);
        exchange.setResponseHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_LOCATION, Handshake.getWebSocketLocation(exchange));
        String key = exchange.getRequestHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY);
        try {
            String solution = this.solve(key);
            exchange.setResponseHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ACCEPT, solution);
            this.performUpgrade(exchange);
        }
        catch (NoSuchAlgorithmException e) {
            exchange.endExchange();
            return;
        }
        this.handshakeInternal(exchange);
        exchange.upgradeChannel(new Consumer<Object>(){

            @Override
            public void accept(Object c) {
                ChannelHandlerContext context = (ChannelHandlerContext)c;
                WebSocket13FrameDecoder decoder = new WebSocket13FrameDecoder(true, !extensions.isEmpty(), Handshake.this.maxFrameSize, false);
                WebSocket13FrameEncoder encoder = new WebSocket13FrameEncoder(false);
                ChannelPipeline p = context.pipeline();
                if (p.get(HttpObjectAggregator.class) != null) {
                    p.remove(HttpObjectAggregator.class);
                }
                if (p.get(HttpContentCompressor.class) != null) {
                    p.remove(HttpContentCompressor.class);
                }
                p.addLast("ws-encoder", (ChannelHandler)encoder);
                p.addLast("ws-decoder", (ChannelHandler)decoder);
                for (WebSocketServerExtension extension : extensions) {
                    WebSocketExtensionDecoder exdecoder = extension.newExtensionDecoder();
                    WebSocketExtensionEncoder exencoder = extension.newExtensionEncoder();
                    p.addAfter("ws-decoder", exdecoder.getClass().getName(), (ChannelHandler)exdecoder);
                    p.addAfter("ws-encoder", exencoder.getClass().getName(), (ChannelHandler)exencoder);
                }
                completeListener.accept(context);
            }
        });
    }

    protected void handshakeInternal(WebSocketHttpExchange exchange) {
    }

    protected final void performUpgrade(WebSocketHttpExchange exchange) {
        exchange.setResponseHeader((CharSequence)HttpHeaderNames.UPGRADE, "WebSocket");
        exchange.setResponseHeader((CharSequence)HttpHeaderNames.CONNECTION, "Upgrade");
        HandshakeUtil.prepareUpgrade(this.config.getEndpointConfiguration(), exchange);
    }

    protected final void selectSubprotocol(WebSocketHttpExchange exchange) {
        String requestedSubprotocols = exchange.getRequestHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        if (requestedSubprotocols == null) {
            return;
        }
        if (requestedSubprotocols.trim().isEmpty()) {
            throw new RuntimeException(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL + " header was provided but was empty");
        }
        String[] requestedSubprotocolArray = PATTERN.split(requestedSubprotocols);
        String subProtocol = this.supportedSubprotols(requestedSubprotocolArray);
        if (subProtocol != null && !subProtocol.isEmpty()) {
            exchange.setResponseHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, subProtocol);
        }
    }

    final List<WebSocketServerExtension> selectExtensions(WebSocketHttpExchange exchange) {
        String extensionHeader = exchange.getRequestHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
        if (extensionHeader == null) {
            return Collections.emptyList();
        }
        if (extensionHeader.trim().isEmpty()) {
            throw new RuntimeException(HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS + " header was provided but was empty");
        }
        List requestedExtensions = WebSocketExtensionUtil.extractExtensions((String)extensionHeader);
        List<WebSocketServerExtension> extensions = this.selectedExtension(requestedExtensions);
        if (extensions != null && !extensions.isEmpty()) {
            String headerValue = "";
            for (WebSocketServerExtension extension : extensions) {
                WebSocketExtensionData extensionData = extension.newReponseData();
                headerValue = Handshake.appendExtension(headerValue, extensionData.name(), extensionData.parameters());
            }
            exchange.setResponseHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, headerValue);
        }
        return extensions;
    }

    public final void addExtension(WebSocketServerExtensionHandshaker extension) {
        this.availableExtensions.add(extension);
        this.allowExtensions = true;
    }

    protected final List<WebSocketServerExtension> initExtensions(WebSocketHttpExchange exchange) {
        List extensions;
        String extHeader = exchange.getResponseHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
        ArrayList<WebSocketServerExtension> ret = new ArrayList<WebSocketServerExtension>();
        if (extHeader != null && (extensions = WebSocketExtensionUtil.extractExtensions((String)extHeader)) != null && !extensions.isEmpty()) {
            for (WebSocketExtensionData ext : extensions) {
                for (WebSocketServerExtensionHandshaker extHandshake : this.availableExtensions) {
                    WebSocketServerExtension negotiated = extHandshake.handshakeExtension(ext);
                    if (negotiated == null) continue;
                    ret.add(negotiated);
                }
            }
        }
        return ret;
    }

    protected String supportedSubprotols(String[] requestedSubprotocolArray) {
        return HandshakeUtil.selectSubProtocol(this.config, requestedSubprotocolArray);
    }

    protected List<WebSocketServerExtension> selectedExtension(List<WebSocketExtensionData> extensionList) {
        ArrayList<Extension> ext = new ArrayList<Extension>();
        for (WebSocketExtensionData i : extensionList) {
            ext.add(new ExtensionImpl(i));
        }
        List<Extension> selected = HandshakeUtil.selectExtensions(this.config, ext);
        if (selected == null) {
            return Collections.emptyList();
        }
        ArrayList<WebSocketServerExtension> ret = new ArrayList<WebSocketServerExtension>();
        for (Extension i : selected) {
            for (WebSocketServerExtensionHandshaker handshaker : this.availableExtensions) {
                WebSocketServerExtension negotiated = handshaker.handshakeExtension(((ExtensionImpl)i).getData());
                if (negotiated == null) continue;
                ret.add(negotiated);
                break;
            }
            if (ret.isEmpty()) continue;
            break;
        }
        return ret;
    }

    static String appendExtension(String currentHeaderValue, String extensionName, Map<String, String> extensionParameters) {
        StringBuilder newHeaderValue = new StringBuilder(currentHeaderValue != null ? currentHeaderValue.length() : extensionName.length() + 1);
        if (currentHeaderValue != null && !currentHeaderValue.trim().isEmpty()) {
            newHeaderValue.append(currentHeaderValue);
            newHeaderValue.append(EXTENSION_SEPARATOR);
        }
        newHeaderValue.append(extensionName);
        for (Map.Entry<String, String> extensionParameter : extensionParameters.entrySet()) {
            newHeaderValue.append(PARAMETER_SEPARATOR);
            newHeaderValue.append(extensionParameter.getKey());
            if (extensionParameter.getValue() == null) continue;
            newHeaderValue.append('=');
            newHeaderValue.append(extensionParameter.getValue());
        }
        return newHeaderValue.toString();
    }

    public boolean matches(WebSocketHttpExchange exchange) {
        if (exchange.getRequestHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY) != null && exchange.getRequestHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION) != null && exchange.getRequestHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION).equals(WEB_SOCKET_VERSION)) {
            return HandshakeUtil.checkOrigin(this.config.getEndpointConfiguration(), exchange);
        }
        return false;
    }

    protected final String solve(String nonceBase64) throws NoSuchAlgorithmException {
        String concat = nonceBase64.trim() + MAGIC_NUMBER;
        MessageDigest digest = MessageDigest.getInstance(SHA1);
        digest.update(concat.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBytes(digest.digest()).trim();
    }
}

