/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.handshake;

import io.undertow.websockets.handshake.WebSocketHttpExchange;
import jakarta.websocket.HandshakeResponse;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ExchangeHandshakeResponse
implements HandshakeResponse {
    private final WebSocketHttpExchange exchange;
    private Map<String, List<String>> headers;

    public ExchangeHandshakeResponse(WebSocketHttpExchange exchange) {
        this.exchange = exchange;
    }

    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            this.headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            this.headers.putAll(this.exchange.getResponseHeaders());
        }
        return this.headers;
    }

    void update() {
        if (this.headers != null) {
            this.exchange.setResponseHeaders(this.headers);
        }
    }
}

