/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.undertow.websockets.FrameHandler;
import io.undertow.websockets.JsrWebSocketMessages;
import io.undertow.websockets.util.PathTemplate;
import jakarta.websocket.Decoder;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Encoder;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class JsrWebSocketMessages_$bundle
implements JsrWebSocketMessages,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final JsrWebSocketMessages_$bundle INSTANCE = new JsrWebSocketMessages_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected JsrWebSocketMessages_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String pongMessageNotSupported$str() {
        return "UT003001: PongMessage not supported with MessageHandler.Async";
    }

    @Override
    public final IllegalStateException pongMessageNotSupported() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.pongMessageNotSupported$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String sendStreamClosed$str() {
        return "UT003002: SendStream is closed";
    }

    @Override
    public final IOException sendStreamClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.sendStreamClosed$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String sendWriterClosed$str() {
        return "UT003003: SendWriter is closed";
    }

    @Override
    public final IOException sendWriterClosed() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.sendWriterClosed$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String clientNotSupported$str() {
        return "UT003004: Client not supported";
    }

    @Override
    public final DeploymentException clientNotSupported() {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.clientNotSupported$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String handlerAlreadyRegistered$str() {
        return "UT003005: MessageHandler for type %s already registered";
    }

    @Override
    public final IllegalStateException handlerAlreadyRegistered(FrameHandler.FrameType frameType) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.handlerAlreadyRegistered$str(), new Object[]{frameType}));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unsupportedFrameType$str() {
        return "UT003006: Unable to detect FrameType for clazz %s";
    }

    @Override
    public final IllegalStateException unsupportedFrameType(Class<?> clazz) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unsupportedFrameType$str(), clazz));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownHandlerType$str() {
        return "UT003007: Unable to detect MessageHandler type for %s";
    }

    @Override
    public final IllegalStateException unknownHandlerType(Class<?> clazz) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownHandlerType$str(), clazz));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownEncoderType$str() {
        return "UT003008: Unable to detect Encoder type for %s";
    }

    @Override
    public final IllegalStateException unknownEncoderType(Class<?> clazz) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.unknownEncoderType$str(), clazz));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String moreThanOneParameterOfType$str() {
        return "UT003009: More than one %s parameter for %s";
    }

    @Override
    public final IllegalArgumentException moreThanOneParameterOfType(Class<?> type, Method method) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.moreThanOneParameterOfType$str(), type, method));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String parameterNotFound$str() {
        return "UT003010: No parameter of type %s found in method %s";
    }

    @Override
    public final IllegalArgumentException parameterNotFound(Class<?> type, Method method) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.parameterNotFound$str(), type, method));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String moreThanOneAnnotation$str() {
        return "UT003011: More than one method is annotated with %s";
    }

    @Override
    public final DeploymentException moreThanOneAnnotation(Class<?> clazz) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.moreThanOneAnnotation$str(), clazz));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidParameters$str() {
        return "UT003012: Method %s has invalid parameters at locations %s";
    }

    @Override
    public final DeploymentException invalidParameters(Method method, Set<Integer> allParams) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.invalidParameters$str(), method, allParams));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotDetermineDecoderTypeFor$str() {
        return "UT003014: Could not determine decoder type for %s";
    }

    @Override
    public final IllegalArgumentException couldNotDetermineDecoderTypeFor(Class<?> decoderClass) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.couldNotDetermineDecoderTypeFor$str(), decoderClass));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String noDecoderAcceptedMessage$str() {
        return "UT003015: No decoder accepted message %s";
    }

    @Override
    public final String noDecoderAcceptedMessage(List<? extends Decoder> decoders) {
        return String.format(this.getLoggingLocale(), this.noDecoderAcceptedMessage$str(), decoders);
    }

    protected String cannotSendInMiddleOfFragmentedMessage$str() {
        return "UT003016: Cannot send in middle of fragmeneted message";
    }

    @Override
    public final IllegalStateException cannotSendInMiddleOfFragmentedMessage() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotSendInMiddleOfFragmentedMessage$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotAddEndpointAfterDeployment$str() {
        return "UT003017: Cannot add endpoint after deployment";
    }

    @Override
    public final IllegalStateException cannotAddEndpointAfterDeployment() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotAddEndpointAfterDeployment$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotDetermineTypeOfDecodeMethodForClass$str() {
        return "UT003018: Could not determine type of decode method for class %s";
    }

    @Override
    public final DeploymentException couldNotDetermineTypeOfDecodeMethodForClass(Class<? extends Decoder> decoder, Exception e) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.couldNotDetermineTypeOfDecodeMethodForClass$str(), decoder), (Throwable)e);
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotDetermineTypeOfEncodeMethodForClass$str() {
        return "UT003019: Could not determine type of encode method for class %s";
    }

    @Override
    public final DeploymentException couldNotDetermineTypeOfEncodeMethodForClass(Class<? extends Encoder> encoder) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.couldNotDetermineTypeOfEncodeMethodForClass$str(), encoder));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String didNotImplementKnownDecoderSubclass$str() {
        return "UT003020: %s did not implement known decoder interface";
    }

    @Override
    public final DeploymentException didNotImplementKnownDecoderSubclass(Class<? extends Decoder> decoder) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.didNotImplementKnownDecoderSubclass$str(), decoder));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String classDoesNotHaveDefaultConstructor$str() {
        return "UT003021: %s does not have default constructor";
    }

    @Override
    public final DeploymentException classDoesNotHaveDefaultConstructor(Class<?> c, NoSuchMethodException e) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.classDoesNotHaveDefaultConstructor$str(), c), (Throwable)e);
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String multipleEndpointsWithOverlappingPaths$str() {
        return "UT003023: Multiple endpoints with the same logical mapping %s and %s";
    }

    @Override
    public final DeploymentException multipleEndpointsWithOverlappingPaths(PathTemplate template, PathTemplate existing) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.multipleEndpointsWithOverlappingPaths$str(), template, existing));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotDeploy$str() {
        return "UT003024: Web socket deployment failed";
    }

    @Override
    public final DeploymentException couldNotDeploy(Exception e) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.couldNotDeploy$str(), new Object[0]), (Throwable)e);
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String cannotConnectUntilDeploymentComplete$str() {
        return "UT003025: Cannot connect until deployment is complete";
    }

    @Override
    public final IllegalStateException cannotConnectUntilDeploymentComplete() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.cannotConnectUntilDeploymentComplete$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notAValidClientEndpointType$str() {
        return "UT003026: %s is not a valid client endpoint type";
    }

    @Override
    public final DeploymentException notAValidClientEndpointType(Class<?> type) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.notAValidClientEndpointType$str(), type));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String classWasNotAnnotated$str() {
        return "UT003027: Class %s was not annotated with @ClientEndpoint or @ServerEndpoint";
    }

    @Override
    public final DeploymentException classWasNotAnnotated(Class<?> endpoint) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.classWasNotAnnotated$str(), endpoint));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotFindDecoderForType$str() {
        return "UT003028: Could not find decoder for type %s on method %s";
    }

    @Override
    public final DeploymentException couldNotFindDecoderForType(Class<?> param, Method method) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.couldNotFindDecoderForType$str(), param, method));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String couldNotFindMessageParameter$str() {
        return "UT003029: Could not find message parameter on method %s";
    }

    @Override
    public final DeploymentException couldNotFindMessageParameter(Method method) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.couldNotFindMessageParameter$str(), method));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String receivedTextFrameButNoMethod$str() {
        return "UT003030: Received a text frame however endpoint does not have a method capable of handling it";
    }

    @Override
    public final RuntimeException receivedTextFrameButNoMethod() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.receivedTextFrameButNoMethod$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String receivedBinaryFrameButNoMethod$str() {
        return "UT003031: Received a binary frame however endpoint does not have a method capable of handling it";
    }

    @Override
    public final RuntimeException receivedBinaryFrameButNoMethod() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.receivedBinaryFrameButNoMethod$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidParametersWithWrongAnnotation$str() {
        return "UT003033: Method %s has invalid parameters at locations %s. It looks like you may have accidentally used jakarta.ws.rs.PathParam instead of jakarta.websocket.server.PathParam";
    }

    @Override
    public final DeploymentException invalidParametersWithWrongAnnotation(Method method, Set<Integer> allParams) {
        DeploymentException result = new DeploymentException(String.format(this.getLoggingLocale(), this.invalidParametersWithWrongAnnotation$str(), method, allParams));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String extensionWasNotPresentInClientHandshake$str() {
        return "UT003034: Server provided extension %s which was not in client supported extensions %s";
    }

    @Override
    public final IOException extensionWasNotPresentInClientHandshake(String e, List supportedExtensions) {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.extensionWasNotPresentInClientHandshake$str(), e, supportedExtensions));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String connectionTimedOut$str() {
        return "UT003035: Connection timed out";
    }

    @Override
    public final IOException connectionTimedOut() {
        IOException result = new IOException(String.format(this.getLoggingLocale(), this.connectionTimedOut$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String handlerIsNull$str() {
        return "UT003036: SendHandler is null";
    }

    @Override
    public final IllegalArgumentException handlerIsNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.handlerIsNull$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String messageInNull$str() {
        return "UT003037: Message is null";
    }

    @Override
    public final IllegalArgumentException messageInNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.messageInNull$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String messageTooLarge$str() {
        return "UT003038: Message of size %s was larger than the maximum of %s";
    }

    @Override
    public final IllegalArgumentException messageTooLarge(int size, int max) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.messageTooLarge$str(), size, max));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotInstantiateEndpoint$str() {
        return "UT003039: The container cannot find a suitable constructor to instantiate endpoint of type %s";
    }

    @Override
    public final InstantiationException cannotInstantiateEndpoint(Class<?> c) {
        InstantiationException result = new InstantiationException(String.format(this.getLoggingLocale(), this.cannotInstantiateEndpoint$str(), c));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String endpointNotOfCorrectType$str() {
        return "UT003040: Annotated endpoint instance %s was not of correct type %s";
    }

    @Override
    public final IllegalArgumentException endpointNotOfCorrectType(Object instance, Class expected) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.endpointNotOfCorrectType$str(), instance, expected));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String endpointDoesNotHaveAppropriateConstructor$str() {
        return "UT003041: Annotated endpoint %s does not have a no arg constructor, but is using a custom configurator. The custom configurator must create the instance.";
    }

    @Override
    public final RuntimeException endpointDoesNotHaveAppropriateConstructor(Class<?> endpoint) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.endpointDoesNotHaveAppropriateConstructor$str(), endpoint));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String deploymentFailedDueToProgramaticErrors$str() {
        return "UT003042: Deployment failed due to invalid programmatically added endpoints";
    }

    @Override
    public final RuntimeException deploymentFailedDueToProgramaticErrors() {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.deploymentFailedDueToProgramaticErrors$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String pathMustBeSpecified$str() {
        return "UT003043: Path must be specified";
    }

    @Override
    public final IllegalArgumentException pathMustBeSpecified() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.pathMustBeSpecified$str(), new Object[0]));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String couldNotParseUriTemplate$str() {
        return "UT003044: Could not path URI template %s at position %s";
    }

    @Override
    public final RuntimeException couldNotParseUriTemplate(String path, int length) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.couldNotParseUriTemplate$str(), path, length));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String matcherAlreadyContainsTemplate$str() {
        return "UT003045: Cannot add path template %s, matcher already contains an equivalent pattern %s";
    }

    @Override
    public final IllegalStateException matcherAlreadyContainsTemplate(String templateString, String templateString1) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.matcherAlreadyContainsTemplate$str(), templateString, templateString1));
        JsrWebSocketMessages_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

