/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import io.undertow.websockets.DefaultPongMessage;
import io.undertow.websockets.Encoding;
import io.undertow.websockets.JsrWebSocketMessages;
import io.undertow.websockets.OrderedExecutor;
import io.undertow.websockets.UndertowSession;
import io.undertow.websockets.util.ClassUtils;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.PongMessage;
import jakarta.websocket.Session;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;

class FrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    private final Endpoint endpoint;
    private final UndertowSession session;
    protected static final byte[] EMPTY = new byte[0];
    private final ConcurrentMap<FrameType, HandlerWrapper> handlers = new ConcurrentHashMap<FrameType, HandlerWrapper>();
    private final LinkedBlockingDeque<WebSocketFrame> pending = new LinkedBlockingDeque();
    private volatile boolean started;
    private final Executor executor;
    private StringBuilder stringBuffer;
    private ByteArrayOutputStream binaryBuffer;
    private FrameType expectedContinuation;

    protected FrameHandler(UndertowSession session, Endpoint endpoint) {
        this.session = session;
        this.endpoint = endpoint;
        Object executor = session.getContainer().isDispatchToWorker() ? new OrderedExecutor(session.getExecutor()) : session.getChannel().eventLoop();
        this.executor = executor;
    }

    synchronized void start() {
        while (!this.pending.isEmpty()) {
            WebSocketFrame webSocketFrame = this.pending.poll();
            try {
                this.processFrame(webSocketFrame);
            }
            catch (IOException e) {
                try {
                    this.session.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new RuntimeException(e);
            }
            finally {
                webSocketFrame.release();
            }
        }
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame msg) throws Exception {
        if (!this.started) {
            FrameHandler frameHandler = this;
            synchronized (frameHandler) {
                if (!this.started) {
                    this.pending.add(msg);
                    msg.retain();
                    return;
                }
            }
        }
        this.processFrame(msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        try {
            this.invokeOnError(cause);
        }
        finally {
            ReferenceCountUtil.release((Object)cause);
        }
    }

    private void processFrame(WebSocketFrame msg) throws IOException {
        if (msg instanceof CloseWebSocketFrame) {
            this.onCloseFrame((CloseWebSocketFrame)msg);
        } else if (msg instanceof PongWebSocketFrame) {
            this.onPongMessage((PongWebSocketFrame)msg);
        } else if (msg instanceof PingWebSocketFrame) {
            this.onPingFrame(msg);
        } else if (msg instanceof TextWebSocketFrame) {
            this.onText(msg, ((TextWebSocketFrame)msg).text());
        } else if (msg instanceof BinaryWebSocketFrame) {
            this.onBinary(msg);
        } else if (msg instanceof ContinuationWebSocketFrame) {
            if (this.expectedContinuation == FrameType.BYTE) {
                this.onBinary(msg);
            } else if (this.expectedContinuation == FrameType.TEXT) {
                this.onText(msg, ((ContinuationWebSocketFrame)msg).text());
            }
        }
    }

    void onPingFrame(WebSocketFrame message) throws IOException {
        if (this.session.isSessionClosed()) {
            return;
        }
        byte[] data = new byte[message.content().readableBytes()];
        message.content().readBytes(data);
        this.session.getAsyncRemote().sendPong(ByteBuffer.wrap(data));
    }

    void onCloseFrame(CloseWebSocketFrame message) {
        if (this.session.isSessionClosed()) {
            return;
        }
        final String reason = message.reasonText();
        final int code = message.statusCode() == -1 ? CloseReason.CloseCodes.NORMAL_CLOSURE.getCode() : message.statusCode();
        this.session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

            @Override
            public void run() {
                try {
                    FrameHandler.this.session.closeInternal(new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), reason));
                }
                catch (IOException e) {
                    FrameHandler.this.invokeOnError(e);
                }
            }
        }, this.session);
    }

    private void invokeOnError(final Throwable e) {
        this.session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

            @Override
            public void run() {
                FrameHandler.this.getEndpoint().onError((Session)FrameHandler.this.session, e);
            }
        }, this.session);
    }

    private void onPongMessage(PongWebSocketFrame frame) {
        if (this.session.isSessionClosed()) {
            return;
        }
        final HandlerWrapper handler = this.getHandler(FrameType.PONG);
        if (handler != null) {
            final PongMessage message = DefaultPongMessage.create(Unpooled.copiedBuffer((ByteBuf)frame.content()).nioBuffer());
            this.session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

                @Override
                public void run() {
                    try {
                        ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)message);
                    }
                    catch (Exception e) {
                        FrameHandler.this.invokeOnError(e);
                    }
                }
            }, this.session);
        }
    }

    private void onText(WebSocketFrame frame, String text) throws IOException {
        if (this.session.isSessionClosed()) {
            this.session.close();
            return;
        }
        this.expectedContinuation = !frame.isFinalFragment() ? FrameType.TEXT : null;
        HandlerWrapper handler = this.getHandler(FrameType.TEXT);
        if (handler != null && (handler.isPartialHandler() || this.stringBuffer == null && frame.isFinalFragment())) {
            this.invokeTextHandler(text, handler, frame.isFinalFragment());
        } else if (handler != null) {
            if (this.stringBuffer == null) {
                this.stringBuffer = new StringBuilder();
            }
            this.stringBuffer.append(text);
            if (frame.isFinalFragment()) {
                this.invokeTextHandler(this.stringBuffer.toString(), handler, frame.isFinalFragment());
                this.stringBuffer = null;
            }
        }
    }

    private void onBinary(WebSocketFrame frame) throws IOException {
        if (this.session.isSessionClosed()) {
            this.session.close();
            return;
        }
        this.expectedContinuation = !frame.isFinalFragment() ? FrameType.BYTE : null;
        HandlerWrapper handler = this.getHandler(FrameType.BYTE);
        if (handler != null && (handler.isPartialHandler() || this.binaryBuffer == null && frame.isFinalFragment())) {
            byte[] data = new byte[frame.content().readableBytes()];
            frame.content().readBytes(data);
            this.invokeBinaryHandler(data, handler, frame.isFinalFragment());
        } else if (handler != null) {
            if (this.binaryBuffer == null) {
                this.binaryBuffer = new ByteArrayOutputStream();
            }
            byte[] data = new byte[frame.content().readableBytes()];
            frame.content().readBytes(data);
            this.binaryBuffer.write(data);
            if (frame.isFinalFragment()) {
                this.invokeBinaryHandler(this.binaryBuffer.toByteArray(), handler, frame.isFinalFragment());
                this.binaryBuffer = null;
            }
        }
    }

    private void invokeBinaryHandler(final byte[] data, final HandlerWrapper handler, final boolean finalFragment) {
        this.session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

            @Override
            public void run() {
                try {
                    if (handler.isPartialHandler()) {
                        MessageHandler.Partial mHandler = (MessageHandler.Partial)handler.getHandler();
                        if (handler.decodingNeeded) {
                            Object object = FrameHandler.this.getSession().getEncoding().decodeBinary(handler.getMessageType(), data);
                            mHandler.onMessage(object, finalFragment);
                        } else if (handler.getMessageType() == ByteBuffer.class) {
                            mHandler.onMessage((Object)ByteBuffer.wrap(data), finalFragment);
                        } else if (handler.getMessageType() == byte[].class) {
                            mHandler.onMessage((Object)data, finalFragment);
                        } else if (handler.getMessageType() == InputStream.class) {
                            mHandler.onMessage((Object)new ByteArrayInputStream(data), finalFragment);
                        }
                    } else {
                        MessageHandler.Whole mHandler = (MessageHandler.Whole)handler.getHandler();
                        if (handler.decodingNeeded) {
                            Object object = FrameHandler.this.getSession().getEncoding().decodeBinary(handler.getMessageType(), data);
                            mHandler.onMessage(object);
                        } else if (handler.getMessageType() == ByteBuffer.class) {
                            mHandler.onMessage((Object)ByteBuffer.wrap(data));
                        } else if (handler.getMessageType() == byte[].class) {
                            mHandler.onMessage((Object)data);
                        } else if (handler.getMessageType() == InputStream.class) {
                            mHandler.onMessage((Object)new ByteArrayInputStream(data));
                        }
                    }
                }
                catch (Exception e) {
                    FrameHandler.this.invokeOnError(e);
                }
            }
        }, this.session);
    }

    private void invokeTextHandler(final String message, final HandlerWrapper handler, final boolean finalFragment) {
        this.session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

            @Override
            public void run() {
                MessageHandler mHandler = handler.getHandler();
                try {
                    if (mHandler instanceof MessageHandler.Partial) {
                        if (handler.decodingNeeded) {
                            Object object = FrameHandler.this.getSession().getEncoding().decodeText(handler.getMessageType(), message);
                            ((MessageHandler.Partial)handler.getHandler()).onMessage(object, finalFragment);
                        } else if (handler.getMessageType() == String.class) {
                            ((MessageHandler.Partial)handler.getHandler()).onMessage((Object)message, finalFragment);
                        } else if (handler.getMessageType() == Reader.class) {
                            ((MessageHandler.Partial)handler.getHandler()).onMessage((Object)new StringReader(message), finalFragment);
                        }
                    } else if (handler.decodingNeeded) {
                        Object object = FrameHandler.this.getSession().getEncoding().decodeText(handler.getMessageType(), message);
                        ((MessageHandler.Whole)handler.getHandler()).onMessage(object);
                    } else if (handler.getMessageType() == String.class) {
                        ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)message);
                    } else if (handler.getMessageType() == Reader.class) {
                        ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)new StringReader(message));
                    }
                }
                catch (Exception e) {
                    FrameHandler.this.invokeOnError(e);
                }
            }
        }, this.session);
    }

    public final void addHandler(Class<?> messageType, MessageHandler handler) {
        this.addHandlerInternal(handler, messageType, handler instanceof MessageHandler.Partial);
    }

    public final void addHandler(MessageHandler handler) {
        Map<Class<?>, Boolean> types = ClassUtils.getHandlerTypes(handler.getClass());
        for (Map.Entry<Class<?>, Boolean> e : types.entrySet()) {
            Class<?> type = e.getKey();
            boolean partial = e.getValue();
            this.addHandlerInternal(handler, type, partial);
        }
    }

    private void addHandlerInternal(MessageHandler handler, Class<?> type, boolean partial) {
        this.verify(type, handler);
        List<HandlerWrapper> handlerWrappers = this.createHandlerWrappers(type, handler, partial);
        for (HandlerWrapper handlerWrapper : handlerWrappers) {
            if (this.handlers.containsKey((Object)handlerWrapper.getFrameType())) {
                throw JsrWebSocketMessages.MESSAGES.handlerAlreadyRegistered(handlerWrapper.getFrameType());
            }
            if (this.handlers.putIfAbsent(handlerWrapper.getFrameType(), handlerWrapper) == null) continue;
            throw JsrWebSocketMessages.MESSAGES.handlerAlreadyRegistered(handlerWrapper.getFrameType());
        }
    }

    protected List<HandlerWrapper> createHandlerWrappers(Class<?> type, MessageHandler handler, boolean partialHandler) {
        Encoding encoding = this.session.getEncoding();
        ArrayList<HandlerWrapper> ret = new ArrayList<HandlerWrapper>(2);
        if (encoding.canDecodeText(type)) {
            ret.add(new HandlerWrapper(FrameType.TEXT, handler, type, true, false));
        }
        if (encoding.canDecodeBinary(type)) {
            ret.add(new HandlerWrapper(FrameType.BYTE, handler, type, true, false));
        }
        if (!ret.isEmpty()) {
            return ret;
        }
        if (partialHandler) {
            if (type == String.class) {
                return Collections.singletonList(new HandlerWrapper(FrameType.TEXT, handler, type, false, true));
            }
            if (type == byte[].class || type == ByteBuffer.class) {
                return Collections.singletonList(new HandlerWrapper(FrameType.BYTE, handler, type, false, true));
            }
            throw JsrWebSocketMessages.MESSAGES.unsupportedFrameType(type);
        }
        if (type == byte[].class || type == ByteBuffer.class || type == InputStream.class) {
            return Collections.singletonList(new HandlerWrapper(FrameType.BYTE, handler, type, false, false));
        }
        if (type == String.class || type == Reader.class) {
            return Collections.singletonList(new HandlerWrapper(FrameType.TEXT, handler, type, false, false));
        }
        if (type == PongMessage.class) {
            return Collections.singletonList(new HandlerWrapper(FrameType.PONG, handler, type, false, false));
        }
        throw JsrWebSocketMessages.MESSAGES.unsupportedFrameType(type);
    }

    protected void verify(Class<?> type, MessageHandler handler) {
    }

    public final void removeHandler(MessageHandler handler) {
        Map<Class<?>, Boolean> types = ClassUtils.getHandlerTypes(handler.getClass());
        for (Map.Entry<Class<?>, Boolean> e : types.entrySet()) {
            Class<?> type = e.getKey();
            List<HandlerWrapper> handlerWrappers = this.createHandlerWrappers(type, handler, e.getValue());
            for (HandlerWrapper handlerWrapper : handlerWrappers) {
                FrameType frameType = handlerWrapper.getFrameType();
                HandlerWrapper wrapper = (HandlerWrapper)this.handlers.get((Object)frameType);
                if (wrapper == null || wrapper.getMessageType() != type) continue;
                this.handlers.remove((Object)frameType, wrapper);
            }
        }
    }

    public final Set<MessageHandler> getHandlers() {
        HashSet<MessageHandler> msgHandlers = new HashSet<MessageHandler>();
        for (HandlerWrapper handler : this.handlers.values()) {
            msgHandlers.add(handler.getHandler());
        }
        return msgHandlers;
    }

    protected final HandlerWrapper getHandler(FrameType type) {
        return (HandlerWrapper)this.handlers.get((Object)type);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    UndertowSession getSession() {
        return this.session;
    }

    Endpoint getEndpoint() {
        return this.endpoint;
    }

    static enum FrameType {
        PONG,
        BYTE,
        TEXT;

    }

    static final class HandlerWrapper {
        private final FrameType frameType;
        private final MessageHandler handler;
        private final Class<?> msgType;
        private final boolean decodingNeeded;
        private final boolean partialHandler;

        private HandlerWrapper(FrameType frameType, MessageHandler handler, Class<?> msgType, boolean decodingNeeded, boolean partialHandler) {
            this.frameType = frameType;
            this.handler = handler;
            this.msgType = msgType;
            this.decodingNeeded = decodingNeeded;
            this.partialHandler = partialHandler;
        }

        public MessageHandler getHandler() {
            return this.handler;
        }

        public Class<?> getMessageType() {
            return this.msgType;
        }

        FrameType getFrameType() {
            return this.frameType;
        }

        boolean isDecodingNeeded() {
            return this.decodingNeeded;
        }

        boolean isPartialHandler() {
            return this.partialHandler;
        }
    }
}

