/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.undertow.websockets.ConfiguredClientEndpoint;
import io.undertow.websockets.ConfiguredServerEndpoint;
import io.undertow.websockets.DefaultContainerConfigurator;
import io.undertow.websockets.EncodingFactory;
import io.undertow.websockets.EndpointSessionHandler;
import io.undertow.websockets.ExtensionImpl;
import io.undertow.websockets.JsrWebSocketLogger;
import io.undertow.websockets.JsrWebSocketMessages;
import io.undertow.websockets.UndertowSession;
import io.undertow.websockets.WebSocketClientNegotiation;
import io.undertow.websockets.WebSocketReconnectHandler;
import io.undertow.websockets.WebsocketClientSslProvider;
import io.undertow.websockets.WebsocketConnectionBuilder;
import io.undertow.websockets.annotated.AnnotatedEndpoint;
import io.undertow.websockets.annotated.AnnotatedEndpointFactory;
import io.undertow.websockets.handshake.Handshake;
import io.undertow.websockets.util.ConstructorObjectFactory;
import io.undertow.websockets.util.ContextSetupHandler;
import io.undertow.websockets.util.ImmediateObjectHandle;
import io.undertow.websockets.util.ObjectFactory;
import io.undertow.websockets.util.ObjectHandle;
import io.undertow.websockets.util.ObjectIntrospecter;
import io.undertow.websockets.util.PathTemplate;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;

public class ServerWebSocketContainer
implements ServerContainer,
Closeable {
    public static final String TIMEOUT = "io.undertow.websocket.CONNECT_TIMEOUT";
    public static final int DEFAULT_WEB_SOCKET_TIMEOUT_SECONDS = 10;
    public static final int DEFAULT_MAX_FRAME_SIZE = 65536;
    protected final ObjectIntrospecter objectIntrospecter;
    private final Map<Class<?>, ConfiguredClientEndpoint> clientEndpoints = new ConcurrentHashMap();
    private final List<ConfiguredServerEndpoint> configuredServerEndpoints = new ArrayList<ConfiguredServerEndpoint>();
    private final Set<Class<?>> annotatedEndpointClasses = new HashSet();
    private final TreeSet<PathTemplate> seenPaths = new TreeSet();
    private final boolean dispatchToWorker;
    private final InetSocketAddress clientBindAddress;
    private final WebSocketReconnectHandler webSocketReconnectHandler;
    private final Supplier<EventLoopGroup> eventLoopSupplier;
    private final Supplier<Executor> executorSupplier;
    private volatile long defaultAsyncSendTimeout;
    private volatile long defaultMaxSessionIdleTimeout;
    private volatile int defaultMaxBinaryMessageBufferSize;
    private volatile int defaultMaxTextMessageBufferSize;
    private volatile boolean deploymentComplete = false;
    private final List<DeploymentException> deploymentExceptions = new ArrayList<DeploymentException>();
    private final List<PauseListener> pauseListeners = new ArrayList<PauseListener>();
    protected final List<Extension> installedExtensions;
    private final List<WebsocketClientSslProvider> clientSslProviders;
    private final int maxFrameSize;
    private final ContextSetupHandler.Action<Void, Runnable> invokeEndpointTask;
    private volatile boolean closed = false;

    public ServerWebSocketContainer(ObjectIntrospecter objectIntrospecter, Supplier<EventLoopGroup> eventLoopSupplier, List<ContextSetupHandler> contextSetupHandlers, boolean dispatchToWorker, boolean clientMode) {
        this(objectIntrospecter, ServerWebSocketContainer.class.getClassLoader(), eventLoopSupplier, contextSetupHandlers, dispatchToWorker, null, null);
    }

    public ServerWebSocketContainer(ObjectIntrospecter objectIntrospecter, ClassLoader classLoader, Supplier<EventLoopGroup> eventLoopSupplier, List<ContextSetupHandler> contextSetupHandlers, boolean dispatchToWorker, Supplier<Executor> executorSupplier) {
        this(objectIntrospecter, classLoader, eventLoopSupplier, contextSetupHandlers, dispatchToWorker, null, null, executorSupplier, Collections.emptyList());
    }

    public ServerWebSocketContainer(ObjectIntrospecter objectIntrospecter, ClassLoader classLoader, Supplier<EventLoopGroup> eventLoopSupplier, List<ContextSetupHandler> contextSetupHandlers, boolean dispatchToWorker, InetSocketAddress clientBindAddress, WebSocketReconnectHandler reconnectHandler) {
        this(objectIntrospecter, classLoader, eventLoopSupplier, contextSetupHandlers, dispatchToWorker, clientBindAddress, reconnectHandler, null, Collections.emptyList());
    }

    public ServerWebSocketContainer(ObjectIntrospecter objectIntrospecter, ClassLoader classLoader, Supplier<EventLoopGroup> eventLoopSupplier, List<ContextSetupHandler> contextSetupHandlers, boolean dispatchToWorker, InetSocketAddress clientBindAddress, WebSocketReconnectHandler reconnectHandler, Supplier<Executor> executorSupplier, List<Extension> installedExtensions) {
        this(objectIntrospecter, classLoader, eventLoopSupplier, contextSetupHandlers, dispatchToWorker, clientBindAddress, reconnectHandler, executorSupplier, installedExtensions, 65536);
    }

    public ServerWebSocketContainer(ObjectIntrospecter objectIntrospecter, ClassLoader classLoader, Supplier<EventLoopGroup> eventLoopSupplier, List<ContextSetupHandler> contextSetupHandlers, boolean dispatchToWorker, InetSocketAddress clientBindAddress, WebSocketReconnectHandler reconnectHandler, Supplier<Executor> executorSupplier, List<Extension> installedExtensions, int maxFrameSize) {
        this.objectIntrospecter = objectIntrospecter;
        this.eventLoopSupplier = eventLoopSupplier;
        this.dispatchToWorker = dispatchToWorker;
        this.clientBindAddress = clientBindAddress;
        this.executorSupplier = executorSupplier;
        this.installedExtensions = new ArrayList<Extension>(installedExtensions);
        this.webSocketReconnectHandler = reconnectHandler;
        this.maxFrameSize = maxFrameSize;
        ContextSetupHandler.Action<Void, Runnable> task = new ContextSetupHandler.Action<Void, Runnable>(){

            @Override
            public Void call(Runnable context) throws Exception {
                context.run();
                return null;
            }
        };
        ArrayList<WebsocketClientSslProvider> clientSslProviders = new ArrayList<WebsocketClientSslProvider>();
        for (WebsocketClientSslProvider provider : ServiceLoader.load(WebsocketClientSslProvider.class, classLoader)) {
            clientSslProviders.add(provider);
        }
        this.clientSslProviders = Collections.unmodifiableList(clientSslProviders);
        for (ContextSetupHandler handler : contextSetupHandlers) {
            task = handler.create(task);
        }
        this.invokeEndpointTask = task;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long defaultAsyncSendTimeout) {
        this.defaultAsyncSendTimeout = defaultAsyncSendTimeout;
    }

    protected Supplier<Executor> getExecutorSupplier() {
        return this.executorSupplier;
    }

    public Session connectToServer(Object annotatedEndpointInstance, WebsocketConnectionBuilder connectionBuilder) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ConfiguredClientEndpoint config = this.getClientEndpoint(annotatedEndpointInstance.getClass(), false);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(annotatedEndpointInstance.getClass());
        }
        AnnotatedEndpoint instance = config.getFactory().createInstance(new ImmediateObjectHandle<Object>(annotatedEndpointInstance));
        return this.connectToServerInternal(instance, config, connectionBuilder);
    }

    public Session connectToServer(Object annotatedEndpointInstance, URI path) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ConfiguredClientEndpoint config = this.getClientEndpoint(annotatedEndpointInstance.getClass(), false);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(annotatedEndpointInstance.getClass());
        }
        AnnotatedEndpoint instance = config.getFactory().createInstance(new ImmediateObjectHandle<Object>(annotatedEndpointInstance));
        SSLContext ssl = null;
        if (path.getScheme().equals("wss")) {
            WebsocketClientSslProvider provider;
            Iterator<WebsocketClientSslProvider> iterator = this.clientSslProviders.iterator();
            while (iterator.hasNext() && (ssl = (provider = iterator.next()).getSsl(this.eventLoopSupplier.get(), annotatedEndpointInstance, path)) == null) {
            }
            if (ssl == null) {
                try {
                    ssl = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
        }
        return this.connectToServerInternal(instance, ssl, config, path);
    }

    public Session connectToServer(Class<?> aClass, WebsocketConnectionBuilder connectionBuilder) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ConfiguredClientEndpoint config = this.getClientEndpoint(aClass, true);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(aClass);
        }
        AnnotatedEndpointFactory factory = config.getFactory();
        ObjectHandle<?> instance = config.getInstanceFactory().createInstance();
        return this.connectToServerInternal(factory.createInstance(instance), config, connectionBuilder);
    }

    public Session connectToServer(Class<?> aClass, URI uri) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ConfiguredClientEndpoint config = this.getClientEndpoint(aClass, true);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(aClass);
        }
        AnnotatedEndpointFactory factory = config.getFactory();
        ObjectHandle<?> instance = config.getInstanceFactory().createInstance();
        SSLContext ssl = null;
        if (uri.getScheme().equals("wss")) {
            WebsocketClientSslProvider provider;
            Iterator<WebsocketClientSslProvider> iterator = this.clientSslProviders.iterator();
            while (iterator.hasNext() && (ssl = (provider = iterator.next()).getSsl(this.eventLoopSupplier.get(), aClass, uri)) == null) {
            }
            if (ssl == null) {
                try {
                    ssl = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
        }
        return this.connectToServerInternal(factory.createInstance(instance), ssl, config, uri);
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ClientEndpointConfig cec = config != null ? config : ClientEndpointConfig.Builder.create().build();
        SSLContext ssl = null;
        if (path.getScheme().equals("wss")) {
            WebsocketClientSslProvider provider;
            Iterator<WebsocketClientSslProvider> iterator = this.clientSslProviders.iterator();
            while (iterator.hasNext() && (ssl = (provider = iterator.next()).getSsl(this.eventLoopSupplier.get(), endpointInstance, cec, path)) == null) {
            }
            if (ssl == null) {
                try {
                    ssl = SSLContext.getDefault();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
        }
        ClientNegotiation clientNegotiation = new ClientNegotiation(cec.getPreferredSubprotocols(), ServerWebSocketContainer.toExtensionList(cec.getExtensions()), cec);
        WebsocketConnectionBuilder connectionBuilder = new WebsocketConnectionBuilder(path, this.eventLoopSupplier.get()).setSsl(ssl).setBindAddress(this.clientBindAddress).setClientNegotiation(clientNegotiation);
        return this.connectToServer(endpointInstance, config, connectionBuilder);
    }

    private static List<WebSocketExtensionData> toExtensionList(List<Extension> extensions) {
        ArrayList<WebSocketExtensionData> ret = new ArrayList<WebSocketExtensionData>();
        for (Extension e : extensions) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (Extension.Parameter p : e.getParameters()) {
                parameters.put(p.getName(), p.getValue());
            }
            ret.add(new WebSocketExtensionData(e.getName(), parameters));
        }
        return ret;
    }

    public Session connectToServer(final Endpoint endpointInstance, ClientEndpointConfig config, final WebsocketConnectionBuilder connectionBuilder) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        final ClientEndpointConfig cec = config != null ? config : ClientEndpointConfig.Builder.create().build();
        final WebSocketClientNegotiation clientNegotiation = connectionBuilder.getClientNegotiation();
        final CompletableFuture sessionCompletableFuture = new CompletableFuture();
        final EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        final ArrayList<ExtensionImpl> extensions = new ArrayList<ExtensionImpl>();
        HashMap<String, Extension> extMap = new HashMap<String, Extension>();
        for (Extension ext : cec.getExtensions()) {
            extMap.put(ext.getName(), ext);
        }
        for (WebSocketExtensionData e : clientNegotiation.getSelectedExtensions()) {
            Extension ext = (Extension)extMap.get(e.name());
            if (ext == null) {
                throw JsrWebSocketMessages.MESSAGES.extensionWasNotPresentInClientHandshake(e.name(), clientNegotiation.getSupportedExtensions());
            }
            extensions.add(new ExtensionImpl(e));
        }
        CompletionStage session = connectionBuilder.connect(new Function<Channel, UndertowSession>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public UndertowSession apply(final Channel channel) {
                channel.config().setAutoRead(false);
                ConfiguredClientEndpoint configured = (ConfiguredClientEndpoint)ServerWebSocketContainer.this.clientEndpoints.get(endpointInstance.getClass());
                if (configured == null) {
                    Map map = ServerWebSocketContainer.this.clientEndpoints;
                    synchronized (map) {
                        configured = (ConfiguredClientEndpoint)ServerWebSocketContainer.this.clientEndpoints.get(endpointInstance.getClass());
                        if (configured == null) {
                            configured = new ConfiguredClientEndpoint();
                            ServerWebSocketContainer.this.clientEndpoints.put(endpointInstance.getClass(), configured);
                        }
                    }
                }
                EncodingFactory encodingFactory = null;
                try {
                    encodingFactory = EncodingFactory.createFactory(ServerWebSocketContainer.this.objectIntrospecter, cec.getDecoders(), cec.getEncoders());
                }
                catch (DeploymentException e) {
                    throw new RuntimeException(e);
                }
                final UndertowSession undertowSession = new UndertowSession(channel, connectionBuilder.getUri(), Collections.emptyMap(), Collections.emptyMap(), sessionHandler, null, new ImmediateObjectHandle<Endpoint>(endpointInstance), (EndpointConfig)cec, connectionBuilder.getUri().getQuery(), encodingFactory.createEncoding((EndpointConfig)cec), configured, clientNegotiation.getSelectedSubProtocol(), extensions, connectionBuilder, (Executor)ServerWebSocketContainer.this.executorSupplier.get());
                ServerWebSocketContainer.this.invokeEndpointMethod((Executor)ServerWebSocketContainer.this.executorSupplier.get(), new Runnable(){

                    @Override
                    public void run() {
                        try {
                            endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec);
                        }
                        finally {
                            undertowSession.getFrameHandler().start();
                            channel.config().setAutoRead(true);
                            channel.read();
                            sessionCompletableFuture.complete(undertowSession);
                        }
                    }
                });
                return undertowSession;
            }
        }).exceptionally((Function)new Function<Throwable, UndertowSession>(){

            @Override
            public UndertowSession apply(Throwable throwable) {
                sessionCompletableFuture.completeExceptionally(throwable);
                return null;
            }
        });
        Number timeout = (Number)cec.getUserProperties().get(TIMEOUT);
        try {
            return (Session)sessionCompletableFuture.get(timeout == null ? 10L : (long)timeout.intValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            ((CompletableFuture)session).cancel(true);
            throw new IOException(e);
        }
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        Endpoint endpoint = this.objectIntrospecter.createInstanceFactory(endpointClass).createInstance().getInstance();
        return this.connectToServer(endpoint, cec, path);
    }

    private Session connectToServerInternal(Endpoint endpointInstance, SSLContext ssl, ConfiguredClientEndpoint cec, URI path) throws DeploymentException, IOException {
        ClientNegotiation clientNegotiation = new ClientNegotiation(cec.getConfig().getPreferredSubprotocols(), ServerWebSocketContainer.toExtensionList(cec.getConfig().getExtensions()), cec.getConfig());
        WebsocketConnectionBuilder connectionBuilder = new WebsocketConnectionBuilder(path, this.eventLoopSupplier.get()).setSsl(ssl).setBindAddress(this.clientBindAddress).setClientNegotiation(clientNegotiation);
        return this.connectToServerInternal(endpointInstance, cec, connectionBuilder);
    }

    private Session connectToServerInternal(final Endpoint endpointInstance, final ConfiguredClientEndpoint cec, final WebsocketConnectionBuilder connectionBuilder) throws DeploymentException, IOException {
        final ArrayList<ExtensionImpl> extensions = new ArrayList<ExtensionImpl>();
        HashMap<String, Extension> extMap = new HashMap<String, Extension>();
        for (Object ext : cec.getConfig().getExtensions()) {
            extMap.put(ext.getName(), (Extension)ext);
        }
        String subProtocol = null;
        if (connectionBuilder.getClientNegotiation() != null) {
            for (WebSocketExtensionData e : connectionBuilder.getClientNegotiation().getSelectedExtensions()) {
                Extension ext = (Extension)extMap.get(e.name());
                if (ext == null) {
                    throw JsrWebSocketMessages.MESSAGES.extensionWasNotPresentInClientHandshake(e.name(), connectionBuilder.getClientNegotiation().getSupportedExtensions());
                }
                extensions.add(new ExtensionImpl(e));
            }
            subProtocol = connectionBuilder.getClientNegotiation().getSelectedSubProtocol();
        }
        final String finalSubProtocol = subProtocol;
        final EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        CompletableFuture<UndertowSession> session = connectionBuilder.connect(new Function<Channel, UndertowSession>(){

            @Override
            public UndertowSession apply(Channel channel) {
                return new UndertowSession(channel, connectionBuilder.getUri(), Collections.emptyMap(), Collections.emptyMap(), sessionHandler, null, new ImmediateObjectHandle<Endpoint>(endpointInstance), (EndpointConfig)cec.getConfig(), connectionBuilder.getUri().getQuery(), cec.getEncodingFactory().createEncoding((EndpointConfig)cec.getConfig()), cec, finalSubProtocol, extensions, connectionBuilder, (Executor)ServerWebSocketContainer.this.executorSupplier.get());
            }
        });
        Number timeout = (Number)cec.getConfig().getUserProperties().get(TIMEOUT);
        try {
            final UndertowSession result = session.get(timeout == null ? 10L : (long)timeout.intValue(), TimeUnit.SECONDS);
            this.invokeEndpointMethod(this.executorSupplier.get(), new Runnable(){

                @Override
                public void run() {
                    try {
                        endpointInstance.onOpen((Session)result, (EndpointConfig)cec.getConfig());
                    }
                    finally {
                        result.getFrameHandler().start();
                        result.getChannel().config().setAutoRead(true);
                        result.getChannel().read();
                    }
                }
            });
            return result;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            InterruptedIOException interruptedIOException = new InterruptedIOException();
            interruptedIOException.addSuppressed(e);
            throw interruptedIOException;
        }
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.defaultMaxSessionIdleTimeout = timeout;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.defaultMaxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int defaultMaxBinaryMessageBufferSize) {
        this.defaultMaxBinaryMessageBufferSize = defaultMaxBinaryMessageBufferSize;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.defaultMaxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int defaultMaxTextMessageBufferSize) {
        this.defaultMaxTextMessageBufferSize = defaultMaxTextMessageBufferSize;
    }

    public Set<Extension> getInstalledExtensions() {
        return new HashSet<Extension>(this.installedExtensions);
    }

    public void invokeEndpointMethod(Executor executor, final Runnable invocation) {
        if (this.dispatchToWorker) {
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ServerWebSocketContainer.this.invokeEndpointMethod(invocation);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                this.invokeEndpointMethod(invocation);
            }
        } else {
            this.invokeEndpointMethod(invocation);
        }
    }

    public void invokeEndpointMethod(Runnable invocation) {
        try {
            this.invokeEndpointTask.call(invocation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addEndpoint(Class<?> endpoint) throws DeploymentException {
        if (this.deploymentComplete) {
            throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
        }
        if (this.annotatedEndpointClasses.contains(endpoint)) {
            return;
        }
        this.annotatedEndpointClasses.add(endpoint);
        try {
            this.addEndpointInternal(endpoint, true);
        }
        catch (DeploymentException e) {
            this.deploymentExceptions.add(e);
            throw e;
        }
    }

    private synchronized void addEndpointInternal(final Class<?> endpoint, boolean requiresCreation) throws DeploymentException {
        ServerEndpoint serverEndpoint = endpoint.getAnnotation(ServerEndpoint.class);
        ClientEndpoint clientEndpoint = endpoint.getAnnotation(ClientEndpoint.class);
        if (serverEndpoint != null) {
            JsrWebSocketLogger.ROOT_LOGGER.addingAnnotatedServerEndpoint(endpoint, serverEndpoint.value());
            PathTemplate template = PathTemplate.create(serverEndpoint.value());
            if (this.seenPaths.contains(template)) {
                PathTemplate existing = null;
                for (PathTemplate p : this.seenPaths) {
                    if (p.compareTo(template) != 0) continue;
                    existing = p;
                    break;
                }
                throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
            }
            this.seenPaths.add(template);
            Class configuratorClass = serverEndpoint.configurator();
            EncodingFactory encodingFactory = EncodingFactory.createFactory(this.objectIntrospecter, serverEndpoint.decoders(), serverEndpoint.encoders());
            AnnotatedEndpointFactory annotatedEndpointFactory = AnnotatedEndpointFactory.create(endpoint, encodingFactory, template.getParameterNames());
            ObjectFactory<Object> ObjectFactory2 = null;
            try {
                ObjectFactory2 = this.objectIntrospecter.createInstanceFactory(endpoint);
            }
            catch (Exception e) {
                if (configuratorClass == ServerEndpointConfig.Configurator.class) {
                    throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
                }
                ObjectFactory2 = new ObjectFactory<Object>(){

                    @Override
                    public ObjectHandle<Object> createInstance() {
                        throw JsrWebSocketMessages.MESSAGES.endpointDoesNotHaveAppropriateConstructor(endpoint);
                    }
                };
            }
            DefaultContainerConfigurator configurator = configuratorClass != ServerEndpointConfig.Configurator.class ? (ServerEndpointConfig.Configurator)this.objectIntrospecter.createInstanceFactory(configuratorClass).createInstance().getInstance() : DefaultContainerConfigurator.INSTANCE;
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(endpoint, (String)serverEndpoint.value()).decoders(Arrays.asList(serverEndpoint.decoders())).encoders(Arrays.asList(serverEndpoint.encoders())).subprotocols(Arrays.asList(serverEndpoint.subprotocols())).extensions(Collections.emptyList()).configurator((ServerEndpointConfig.Configurator)configurator).build();
            ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(config, ObjectFactory2, template, encodingFactory, annotatedEndpointFactory, this.installedExtensions);
            this.configuredServerEndpoints.add(confguredServerEndpoint);
            this.handleAddingFilterMapping();
        } else if (clientEndpoint != null) {
            ObjectFactory<Object> ObjectFactory3;
            JsrWebSocketLogger.ROOT_LOGGER.addingAnnotatedClientEndpoint(endpoint);
            EncodingFactory encodingFactory = EncodingFactory.createFactory(this.objectIntrospecter, clientEndpoint.decoders(), clientEndpoint.encoders());
            try {
                ObjectFactory3 = this.objectIntrospecter.createInstanceFactory(endpoint);
            }
            catch (Exception e) {
                try {
                    ObjectFactory3 = new ConstructorObjectFactory(endpoint.getConstructor(new Class[0]));
                }
                catch (NoSuchMethodException e1) {
                    if (requiresCreation) {
                        throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
                    }
                    ObjectFactory3 = new ObjectFactory<Object>(){

                        @Override
                        public ObjectHandle<Object> createInstance() {
                            throw new RuntimeException();
                        }
                    };
                }
            }
            AnnotatedEndpointFactory factory = AnnotatedEndpointFactory.create(endpoint, encodingFactory, Collections.emptySet());
            ClientEndpointConfig.Configurator configurator = null;
            configurator = (ClientEndpointConfig.Configurator)this.objectIntrospecter.createInstanceFactory(clientEndpoint.configurator()).createInstance().getInstance();
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().decoders(Arrays.asList(clientEndpoint.decoders())).encoders(Arrays.asList(clientEndpoint.encoders())).preferredSubprotocols(Arrays.asList(clientEndpoint.subprotocols())).configurator(configurator).build();
            ConfiguredClientEndpoint configuredClientEndpoint = new ConfiguredClientEndpoint(config, factory, encodingFactory, ObjectFactory3);
            this.clientEndpoints.put(endpoint, configuredClientEndpoint);
        } else {
            throw JsrWebSocketMessages.MESSAGES.classWasNotAnnotated(endpoint);
        }
    }

    protected void handleAddingFilterMapping() {
    }

    public void addEndpoint(ServerEndpointConfig endpoint) throws DeploymentException {
        if (this.deploymentComplete) {
            throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
        }
        JsrWebSocketLogger.ROOT_LOGGER.addingProgramaticEndpoint(endpoint.getEndpointClass(), endpoint.getPath());
        PathTemplate template = PathTemplate.create(endpoint.getPath());
        if (this.seenPaths.contains(template)) {
            PathTemplate existing = null;
            for (PathTemplate p : this.seenPaths) {
                if (p.compareTo(template) != 0) continue;
                existing = p;
                break;
            }
            throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
        }
        this.seenPaths.add(template);
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.objectIntrospecter, endpoint.getDecoders(), endpoint.getEncoders());
        AnnotatedEndpointFactory annotatedEndpointFactory = null;
        if (!Endpoint.class.isAssignableFrom(endpoint.getEndpointClass())) {
            annotatedEndpointFactory = AnnotatedEndpointFactory.create(endpoint.getEndpointClass(), encodingFactory, template.getParameterNames());
        }
        ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(endpoint, null, template, encodingFactory, annotatedEndpointFactory, endpoint.getExtensions());
        this.configuredServerEndpoints.add(confguredServerEndpoint);
        this.handleAddingFilterMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfiguredClientEndpoint getClientEndpoint(Class<?> endpointType, boolean requiresCreation) {
        Class<?> type;
        for (type = endpointType; type != Object.class && type != null && !type.isAnnotationPresent(ClientEndpoint.class); type = type.getSuperclass()) {
        }
        if (type == Object.class || type == null) {
            return null;
        }
        ConfiguredClientEndpoint existing = this.clientEndpoints.get(type);
        if (existing != null) {
            return existing;
        }
        ServerWebSocketContainer serverWebSocketContainer = this;
        synchronized (serverWebSocketContainer) {
            existing = this.clientEndpoints.get(type);
            if (existing != null) {
                return existing;
            }
            if (type.isAnnotationPresent(ClientEndpoint.class)) {
                try {
                    this.addEndpointInternal(type, requiresCreation);
                    return this.clientEndpoints.get(type);
                }
                catch (DeploymentException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    public void validateDeployment() {
        if (!this.deploymentExceptions.isEmpty()) {
            RuntimeException e = JsrWebSocketMessages.MESSAGES.deploymentFailedDueToProgramaticErrors();
            for (DeploymentException ex : this.deploymentExceptions) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    public void deploymentComplete() {
        this.deploymentComplete = true;
        this.validateDeployment();
    }

    public List<ConfiguredServerEndpoint> getConfiguredServerEndpoints() {
        return this.configuredServerEndpoints;
    }

    public synchronized void close(int waitTime) {
        this.doClose();
        long end = System.currentTimeMillis() + (long)waitTime;
        for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
            endpoint.awaitClose(end - System.currentTimeMillis());
        }
    }

    @Override
    public synchronized void close() {
        this.close(10000);
    }

    public synchronized void pause(PauseListener listener) {
        this.closed = true;
        if (this.configuredServerEndpoints.isEmpty()) {
            listener.paused();
            return;
        }
        if (listener != null) {
            this.pauseListeners.add(listener);
        }
        for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
            for (final Session session : endpoint.getOpenSessions()) {
                ((UndertowSession)session).getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, ""));
                        }
                        catch (Exception e) {
                            JsrWebSocketLogger.ROOT_LOGGER.couldNotCloseOnUndeploy(e);
                        }
                    }
                });
            }
        }
        Runnable done = new Runnable(){
            int count;
            {
                this.count = ServerWebSocketContainer.this.configuredServerEndpoints.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                ArrayList copy = null;
                ServerWebSocketContainer serverWebSocketContainer = ServerWebSocketContainer.this;
                synchronized (serverWebSocketContainer) {
                    --this.count;
                    if (this.count == 0) {
                        copy = new ArrayList(ServerWebSocketContainer.this.pauseListeners);
                        ServerWebSocketContainer.this.pauseListeners.clear();
                    }
                }
                if (copy != null) {
                    for (PauseListener p : copy) {
                        p.paused();
                    }
                }
            }
        };
        for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
            endpoint.notifyClosed(done);
        }
    }

    private void doClose() {
        this.closed = true;
        for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
            for (Session session : endpoint.getOpenSessions()) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, ""));
                }
                catch (Exception e) {
                    JsrWebSocketLogger.ROOT_LOGGER.couldNotCloseOnUndeploy(e);
                }
            }
        }
    }

    public WebSocketHandshakeHolder handshakes(ConfiguredServerEndpoint config) {
        return new WebSocketHandshakeHolder(Collections.singletonList(new Handshake(config, Collections.emptySet(), this.maxFrameSize)), config);
    }

    public WebSocketHandshakeHolder handshakes(ConfiguredServerEndpoint config, List<WebSocketServerExtensionHandshaker> extensions) {
        Handshake hand = new Handshake(config, Collections.emptySet(), this.maxFrameSize);
        for (WebSocketServerExtensionHandshaker i : extensions) {
            hand.addExtension(i);
        }
        return new WebSocketHandshakeHolder(Collections.singletonList(hand), config);
    }

    public synchronized void resume() {
        this.closed = false;
        for (PauseListener p : this.pauseListeners) {
            p.resumed();
        }
        this.pauseListeners.clear();
    }

    public WebSocketReconnectHandler getWebSocketReconnectHandler() {
        return this.webSocketReconnectHandler;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDispatchToWorker() {
        return this.dispatchToWorker;
    }

    public static interface PauseListener {
        public void paused();

        public void resumed();
    }

    public static final class WebSocketHandshakeHolder {
        public final List<Handshake> handshakes;
        public final ConfiguredServerEndpoint endpoint;

        private WebSocketHandshakeHolder(List<Handshake> handshakes, ConfiguredServerEndpoint endpoint) {
            this.handshakes = handshakes;
            this.endpoint = endpoint;
        }
    }

    private static class ClientNegotiation
    extends WebSocketClientNegotiation {
        private final ClientEndpointConfig config;

        ClientNegotiation(List<String> supportedSubProtocols, List<WebSocketExtensionData> supportedExtensions, ClientEndpointConfig config) {
            super(supportedSubProtocols, supportedExtensions);
            this.config = config;
        }

        @Override
        public void afterRequest(HttpHeaders headers) {
            ClientEndpointConfig.Configurator configurator = this.config.getConfigurator();
            if (configurator != null) {
                final TreeMap newHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                for (Map.Entry entry : headers) {
                    ArrayList arrayList = new ArrayList(headers.getAll((String)entry.getKey()));
                    newHeaders.put(entry.getKey(), arrayList);
                }
                configurator.afterResponse(new HandshakeResponse(){

                    public Map<String, List<String>> getHeaders() {
                        return newHeaders;
                    }
                });
            }
            headers.remove((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
            super.afterRequest(headers);
        }

        @Override
        public void beforeRequest(HttpHeaders headers) {
            ClientEndpointConfig.Configurator configurator = this.config.getConfigurator();
            if (configurator != null) {
                TreeMap newHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                for (Map.Entry entry : headers) {
                    ArrayList arrayList = new ArrayList(headers.getAll((String)entry.getKey()));
                    newHeaders.put(entry.getKey(), arrayList);
                }
                configurator.beforeRequest(newHeaders);
                headers.clear();
                for (Map.Entry entry : newHeaders.entrySet()) {
                    if (((List)entry.getValue()).isEmpty()) continue;
                    headers.add((String)entry.getKey(), (Iterable)entry.getValue());
                }
            }
        }
    }
}

