/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.undertow.websockets.ConfiguredServerEndpoint;
import io.undertow.websockets.DefaultContainerConfigurator;
import io.undertow.websockets.JsrWebSocketLogger;
import io.undertow.websockets.ServerWebSocketContainer;
import io.undertow.websockets.UndertowSession;
import io.undertow.websockets.annotated.AnnotatedEndpoint;
import io.undertow.websockets.handshake.HandshakeUtil;
import io.undertow.websockets.handshake.WebSocketHttpExchange;
import io.undertow.websockets.util.ImmediateObjectHandle;
import io.undertow.websockets.util.ObjectFactory;
import io.undertow.websockets.util.ObjectHandle;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpointConfig;

public final class EndpointSessionHandler {
    private final ServerWebSocketContainer container;

    public EndpointSessionHandler(ServerWebSocketContainer container) {
        this.container = container;
    }

    ServerWebSocketContainer getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndertowSession connected(ChannelHandlerContext context, ConfiguredServerEndpoint config, WebSocketHttpExchange exchange, String subprotocol) {
        try {
            ObjectHandle<Object> endpointInstance;
            if (this.container.isClosed()) {
                context.write((Object)new CloseWebSocketFrame());
                return null;
            }
            ObjectFactory<?> endpointFactory = config.getEndpointFactory();
            ServerEndpointConfig.Configurator configurator = config.getEndpointConfiguration().getConfigurator();
            DefaultContainerConfigurator.setCurrentInstanceFactory(endpointFactory);
            final Object instanceFromConfigurator = configurator.getEndpointInstance(config.getEndpointConfiguration().getEndpointClass());
            final ObjectHandle<?> factoryInstance = DefaultContainerConfigurator.clearCurrentInstanceFactory();
            final ObjectHandle<Object> instance = factoryInstance == null ? new ImmediateObjectHandle<Object>(instanceFromConfigurator) : (factoryInstance.getInstance() == instanceFromConfigurator ? factoryInstance : new ObjectHandle<Object>(){

                @Override
                public Object getInstance() {
                    return instanceFromConfigurator;
                }

                @Override
                public void release() {
                    factoryInstance.release();
                }
            });
            Principal principal = exchange.getUserPrincipal();
            if (config.getAnnotatedEndpointFactory() != null) {
                final AnnotatedEndpoint annotated = config.getAnnotatedEndpointFactory().createInstance(instance);
                endpointInstance = new ObjectHandle<Endpoint>(){

                    @Override
                    public Endpoint getInstance() {
                        return annotated;
                    }

                    @Override
                    public void release() {
                        instance.release();
                    }
                };
            } else {
                endpointInstance = instance;
            }
            UndertowSession session = new UndertowSession(context.channel(), URI.create(exchange.getRequestURI()), (Map)exchange.getAttachment(HandshakeUtil.PATH_PARAMS), exchange.getRequestParameters(), this, principal, endpointInstance, (EndpointConfig)config.getEndpointConfiguration(), exchange.getQueryString(), config.getEncodingFactory().createEncoding((EndpointConfig)config.getEndpointConfiguration()), config, subprotocol, Collections.emptyList(), null, exchange.getExecutor());
            config.addOpenSession(session);
            session.setMaxBinaryMessageBufferSize(this.getContainer().getDefaultMaxBinaryMessageBufferSize());
            session.setMaxTextMessageBufferSize(this.getContainer().getDefaultMaxTextMessageBufferSize());
            session.setMaxIdleTimeout(this.getContainer().getDefaultMaxSessionIdleTimeout());
            session.getAsyncRemote().setSendTimeout(this.getContainer().getDefaultAsyncSendTimeout());
            try {
                ((Endpoint)endpointInstance.getInstance()).onOpen((Session)session, (EndpointConfig)config.getEndpointConfiguration());
                session.getFrameHandler().start();
            }
            catch (Exception e) {
                ((Endpoint)endpointInstance.getInstance()).onError((Session)session, (Throwable)e);
                session.close();
            }
            finally {
                session.getChannel().config().setAutoRead(true);
                session.getChannel().read();
            }
            return session;
        }
        catch (Exception e) {
            JsrWebSocketLogger.REQUEST_LOGGER.endpointCreationFailed(e);
            context.close();
            return null;
        }
    }
}

