/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets;

import io.undertow.websockets.EncodingFactory;
import io.undertow.websockets.util.ObjectHandle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;

public class Encoding
implements Closeable {
    private final Map<Class<?>, List<ObjectHandle<? extends Encoder>>> binaryEncoders;
    private final Map<Class<?>, List<ObjectHandle<? extends Decoder>>> binaryDecoders;
    private final Map<Class<?>, List<ObjectHandle<? extends Encoder>>> textEncoders;
    private final Map<Class<?>, List<ObjectHandle<? extends Decoder>>> textDecoders;

    public Encoding(Map<Class<?>, List<ObjectHandle<? extends Encoder>>> binaryEncoders, Map<Class<?>, List<ObjectHandle<? extends Decoder>>> binaryDecoders, Map<Class<?>, List<ObjectHandle<? extends Encoder>>> textEncoders, Map<Class<?>, List<ObjectHandle<? extends Decoder>>> textDecoders) {
        this.binaryEncoders = binaryEncoders;
        this.binaryDecoders = binaryDecoders;
        this.textEncoders = textEncoders;
        this.textDecoders = textDecoders;
    }

    public boolean canEncodeText(Class<?> type) {
        if (this.textEncoders.containsKey(type)) {
            return true;
        }
        for (Class<?> key : this.textEncoders.keySet()) {
            if (!key.isAssignableFrom(type)) continue;
            return true;
        }
        if (EncodingFactory.isPrimitiveOrBoxed(type)) {
            Class<?> primType = Encoding.boxedType(type);
            return !this.binaryEncoders.containsKey(primType) && !this.binaryEncoders.containsKey(Object.class);
        }
        return false;
    }

    public boolean canDecodeText(Class<?> type) {
        if (this.textDecoders.containsKey(type)) {
            return true;
        }
        if (EncodingFactory.isPrimitiveOrBoxed(type)) {
            Class<?> primType = Encoding.boxedType(type);
            return !this.binaryDecoders.containsKey(primType) && !this.binaryEncoders.containsKey(Object.class);
        }
        return false;
    }

    public boolean canEncodeBinary(Class<?> type) {
        if (this.binaryEncoders.containsKey(type)) {
            return true;
        }
        for (Class<?> key : this.binaryEncoders.keySet()) {
            if (!key.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public boolean canDecodeBinary(Class<?> type) {
        return this.binaryDecoders.containsKey(type);
    }

    public Object decodeText(Class<?> targetType, String message) throws DecodeException {
        if (EncodingFactory.isPrimitiveOrBoxed(targetType)) {
            return this.decodePrimitive(targetType, message);
        }
        List<ObjectHandle<? extends Decoder>> decoders = this.textDecoders.get(targetType);
        if (decoders != null) {
            for (ObjectHandle<? extends Decoder> decoderHandle : decoders) {
                Decoder decoder = decoderHandle.getInstance();
                if (decoder instanceof Decoder.Text) {
                    if (!((Decoder.Text)decoder).willDecode(message)) continue;
                    return ((Decoder.Text)decoder).decode(message);
                }
                try {
                    return ((Decoder.TextStream)decoder).decode((Reader)new StringReader(message));
                }
                catch (IOException e) {
                    throw new DecodeException(message, "Could not decode string", (Throwable)e);
                }
            }
        }
        throw new DecodeException(message, "Could not decode string");
    }

    private Object decodePrimitive(Class<?> targetType, String message) throws DecodeException {
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return Boolean.valueOf(message);
        }
        if (targetType == Character.class || targetType == Character.TYPE) {
            return Character.valueOf(message.charAt(0));
        }
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return Byte.valueOf(message);
        }
        if (targetType == Short.class || targetType == Short.TYPE) {
            return Short.valueOf(message);
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.valueOf(message);
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return Long.valueOf(message);
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.valueOf(message);
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return Double.valueOf(message);
        }
        return null;
    }

    public Object decodeBinary(Class<?> targetType, byte[] bytes) throws DecodeException {
        List<ObjectHandle<? extends Decoder>> decoders = this.binaryDecoders.get(targetType);
        if (decoders != null) {
            for (ObjectHandle<? extends Decoder> decoderHandle : decoders) {
                Decoder decoder = decoderHandle.getInstance();
                if (decoder instanceof Decoder.Binary) {
                    if (!((Decoder.Binary)decoder).willDecode(ByteBuffer.wrap(bytes))) continue;
                    return ((Decoder.Binary)decoder).decode(ByteBuffer.wrap(bytes));
                }
                try {
                    return ((Decoder.BinaryStream)decoder).decode((InputStream)new ByteArrayInputStream(bytes));
                }
                catch (IOException e) {
                    throw new DecodeException(ByteBuffer.wrap(bytes), "Could not decode binary", (Throwable)e);
                }
            }
        }
        throw new DecodeException(ByteBuffer.wrap(bytes), "Could not decode binary");
    }

    public String encodeText(Object o) throws EncodeException {
        Iterator<Object> iterator;
        List encoders = this.textEncoders.get(o.getClass());
        if (encoders == null) {
            iterator = this.textEncoders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!((Class)entry.getKey()).isAssignableFrom(o.getClass())) continue;
                encoders = (List)entry.getValue();
                break;
            }
        }
        if (encoders != null && (iterator = encoders.iterator()).hasNext()) {
            ObjectHandle decoderHandle = (ObjectHandle)iterator.next();
            Encoder decoder = (Encoder)decoderHandle.getInstance();
            if (decoder instanceof Encoder.Text) {
                return ((Encoder.Text)decoder).encode(o);
            }
            try {
                StringWriter out = new StringWriter();
                ((Encoder.TextStream)decoder).encode(o, (Writer)out);
                return out.toString();
            }
            catch (IOException e) {
                throw new EncodeException(o, "Could not encode text", (Throwable)e);
            }
        }
        if (EncodingFactory.isPrimitiveOrBoxed(o.getClass())) {
            return o.toString();
        }
        throw new EncodeException(o, "Could not encode text");
    }

    public ByteBuffer encodeBinary(Object o) throws EncodeException {
        Iterator<Object> iterator;
        List encoders = this.binaryEncoders.get(o.getClass());
        if (encoders == null) {
            iterator = this.binaryEncoders.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!((Class)entry.getKey()).isAssignableFrom(o.getClass())) continue;
                encoders = (List)entry.getValue();
                break;
            }
        }
        if (encoders != null && (iterator = encoders.iterator()).hasNext()) {
            ObjectHandle decoderHandle = (ObjectHandle)iterator.next();
            Encoder decoder = (Encoder)decoderHandle.getInstance();
            if (decoder instanceof Encoder.Binary) {
                return ((Encoder.Binary)decoder).encode(o);
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ((Encoder.BinaryStream)decoder).encode(o, (OutputStream)out);
                return ByteBuffer.wrap(out.toByteArray());
            }
            catch (IOException e) {
                throw new EncodeException(o, "Could not encode binary", (Throwable)e);
            }
        }
        throw new EncodeException(o, "Could not encode binary");
    }

    @Override
    public void close() {
        for (Map.Entry<Class<?>, List<ObjectHandle<Decoder>>> entry : this.binaryDecoders.entrySet()) {
            for (ObjectHandle<? extends Decoder> val : entry.getValue()) {
                val.getInstance().destroy();
                val.release();
            }
        }
        for (Map.Entry<Class<?>, List<ObjectHandle<Decoder>>> entry : this.textDecoders.entrySet()) {
            for (ObjectHandle<? extends Decoder> val : entry.getValue()) {
                val.getInstance().destroy();
                val.release();
            }
        }
        for (Map.Entry<Class<?>, List<ObjectHandle<Decoder>>> entry : this.binaryEncoders.entrySet()) {
            for (ObjectHandle<? extends Decoder> val : entry.getValue()) {
                ((Encoder)val.getInstance()).destroy();
                val.release();
            }
        }
        for (Map.Entry<Class<?>, List<ObjectHandle<Decoder>>> entry : this.textEncoders.entrySet()) {
            for (ObjectHandle<? extends Decoder> val : entry.getValue()) {
                ((Encoder)val.getInstance()).destroy();
                val.release();
            }
        }
    }

    private static Class<?> boxedType(Class<?> targetType) {
        if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (targetType == Character.class || targetType == Character.TYPE) {
            return Character.class;
        }
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            return Byte.class;
        }
        if (targetType == Short.class || targetType == Short.TYPE) {
            return Short.class;
        }
        if (targetType == Integer.class || targetType == Integer.TYPE) {
            return Integer.class;
        }
        if (targetType == Long.class || targetType == Long.TYPE) {
            return Long.class;
        }
        if (targetType == Float.class || targetType == Float.TYPE) {
            return Float.class;
        }
        if (targetType == Double.class || targetType == Double.TYPE) {
            return Double.class;
        }
        return targetType;
    }
}

