/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.gradle.tasks.ImageTask;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.tasks.TaskAction;

public abstract class ImagePush
extends ImageTask {
    @Inject
    public ImagePush() {
        super("Perform an image push");
        MapProperty<String, String> forcedProperties = this.extension().forcedPropertiesProperty();
        forcedProperties.put((Object)"quarkus.container-image.build", (Object)"true");
        forcedProperties.put((Object)"quarkus.container-image.push", (Object)"true");
    }

    @Override
    @TaskAction
    public void checkRequiredExtensions() {
        List containerImageExtensions = this.getProject().getConfigurations().stream().flatMap(c -> c.getDependencies().stream()).map(d -> d.getName()).filter(n -> n.startsWith("quarkus-container-image-")).map(n -> n.replaceAll("-deployment$", "")).collect(Collectors.toList());
        List<String> extensions = Arrays.stream(ImageTask.Builder.values()).map(b -> "quarkus-container-image-" + b.name()).collect(Collectors.toList());
        if (containerImageExtensions.isEmpty()) {
            this.getLogger().warn("Task: {} requires a container image extension.", (Object)this.getName());
            this.getLogger().warn("Available container image exntesions: [{}]", (Object)extensions.stream().collect(Collectors.joining(", ")));
            this.getLogger().warn("To add an extension to the project, you can run one of the commands below:");
            extensions.forEach(e -> this.getLogger().warn("\tgradle addExtension --extensions={}", e));
        }
    }
}

