/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle;

import io.quarkus.gradle.NamedImpl;
import io.quarkus.gradle.actions.BeforeTestAction;
import io.quarkus.gradle.dependency.ApplicationDeploymentClasspathBuilder;
import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.gradle.extension.SourceSetExtension;
import io.quarkus.gradle.tasks.Deploy;
import io.quarkus.gradle.tasks.ImageBuild;
import io.quarkus.gradle.tasks.ImageCheckRequirementsTask;
import io.quarkus.gradle.tasks.ImagePush;
import io.quarkus.gradle.tasks.QuarkusAddExtension;
import io.quarkus.gradle.tasks.QuarkusApplicationModelTask;
import io.quarkus.gradle.tasks.QuarkusBuild;
import io.quarkus.gradle.tasks.QuarkusBuildCacheableAppParts;
import io.quarkus.gradle.tasks.QuarkusBuildDependencies;
import io.quarkus.gradle.tasks.QuarkusBuildTask;
import io.quarkus.gradle.tasks.QuarkusDev;
import io.quarkus.gradle.tasks.QuarkusGenerateCode;
import io.quarkus.gradle.tasks.QuarkusGoOffline;
import io.quarkus.gradle.tasks.QuarkusGradleUtils;
import io.quarkus.gradle.tasks.QuarkusInfo;
import io.quarkus.gradle.tasks.QuarkusListCategories;
import io.quarkus.gradle.tasks.QuarkusListExtensions;
import io.quarkus.gradle.tasks.QuarkusListPlatforms;
import io.quarkus.gradle.tasks.QuarkusPluginExtensionView;
import io.quarkus.gradle.tasks.QuarkusRemoteDev;
import io.quarkus.gradle.tasks.QuarkusRemoveExtension;
import io.quarkus.gradle.tasks.QuarkusRun;
import io.quarkus.gradle.tasks.QuarkusShowEffectiveConfig;
import io.quarkus.gradle.tasks.QuarkusTest;
import io.quarkus.gradle.tasks.QuarkusTestConfig;
import io.quarkus.gradle.tasks.QuarkusUpdate;
import io.quarkus.gradle.tasks.services.ForcedPropertieBuildService;
import io.quarkus.gradle.tooling.DefaultProjectDescriptor;
import io.quarkus.gradle.tooling.GradleApplicationModelBuilder;
import io.quarkus.gradle.tooling.ProjectDescriptorBuilder;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.gradle.tooling.dependency.DependencyUtils;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.gradle.tooling.dependency.ProjectExtensionDependency;
import io.quarkus.runtime.LaunchMode;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.testing.Test;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.gradle.util.GradleVersion;

public class QuarkusPlugin
implements Plugin<Project> {
    public static final String ID = "io.quarkus";
    public static final String DEFAULT_OUTPUT_DIRECTORY = "quarkus-app";
    public static final String EXTENSION_NAME = "quarkus";
    public static final String LIST_EXTENSIONS_TASK_NAME = "listExtensions";
    public static final String LIST_CATEGORIES_TASK_NAME = "listCategories";
    public static final String LIST_PLATFORMS_TASK_NAME = "listPlatforms";
    public static final String ADD_EXTENSION_TASK_NAME = "addExtension";
    public static final String REMOVE_EXTENSION_TASK_NAME = "removeExtension";
    public static final String QUARKUS_GENERATE_CODE_TASK_NAME = "quarkusGenerateCode";
    public static final String QUARKUS_GENERATE_CODE_DEV_TASK_NAME = "quarkusGenerateCodeDev";
    public static final String QUARKUS_GENERATE_CODE_TESTS_TASK_NAME = "quarkusGenerateCodeTests";
    public static final String QUARKUS_BUILD_DEP_TASK_NAME = "quarkusDependenciesBuild";
    public static final String QUARKUS_BUILD_APP_PARTS_TASK_NAME = "quarkusAppPartsBuild";
    public static final String QUARKUS_SHOW_EFFECTIVE_CONFIG_TASK_NAME = "quarkusShowEffectiveConfig";
    public static final String QUARKUS_BUILD_TASK_NAME = "quarkusBuild";
    public static final String QUARKUS_DEV_TASK_NAME = "quarkusDev";
    public static final String QUARKUS_RUN_TASK_NAME = "quarkusRun";
    public static final String QUARKUS_REMOTE_DEV_TASK_NAME = "quarkusRemoteDev";
    public static final String QUARKUS_TEST_TASK_NAME = "quarkusTest";
    public static final String QUARKUS_GO_OFFLINE_TASK_NAME = "quarkusGoOffline";
    public static final String QUARKUS_INFO_TASK_NAME = "quarkusInfo";
    public static final String QUARKUS_UPDATE_TASK_NAME = "quarkusUpdate";
    public static final String IMAGE_BUILD_TASK_NAME = "imageBuild";
    public static final String IMAGE_PUSH_TASK_NAME = "imagePush";
    public static final String DEPLOY_TASK_NAME = "deploy";
    @Deprecated
    public static final String BUILD_NATIVE_TASK_NAME = "buildNative";
    @Deprecated
    public static final String TEST_NATIVE_TASK_NAME = "testNative";
    @Deprecated
    public static final String QUARKUS_TEST_CONFIG_TASK_NAME = "quarkusTestConfig";
    public static final String NATIVE_TEST_SOURCE_SET_NAME = "native-test";
    public static final String NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME = "nativeTestImplementation";
    public static final String NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "nativeTestRuntimeOnly";
    public static final String INTEGRATION_TEST_TASK_NAME = "quarkusIntTest";
    public static final String INTEGRATION_TEST_SOURCE_SET_NAME = "integrationTest";
    public static final String INTEGRATION_TEST_IMPLEMENTATION_CONFIGURATION_NAME = "integrationTestImplementation";
    public static final String INTEGRATION_TEST_RUNTIME_ONLY_CONFIGURATION_NAME = "integrationTestRuntimeOnly";
    public static final String IMAGE_CHECK_REQUIREMENTS_NAME = "quarkusImageExtensionChecks";
    private final ToolingModelBuilderRegistry registry;
    private final TaskDependencyFactory taskDependencyFactory;

    @Inject
    public QuarkusPlugin(ToolingModelBuilderRegistry registry, TaskDependencyFactory taskDepFactory) {
        this.registry = registry;
        this.taskDependencyFactory = taskDepFactory;
    }

    public void apply(Project project) {
        this.verifyGradleVersion();
        project.getPluginManager().apply(JavaPlugin.class);
        this.registerModel();
        QuarkusPluginExtension quarkusExt = (QuarkusPluginExtension)project.getExtensions().create(EXTENSION_NAME, QuarkusPluginExtension.class, new Object[]{project});
        this.createSourceSets(project);
        this.createConfigurations(project);
        this.registerTasks(project, quarkusExt);
    }

    private void registerTasks(Project project, QuarkusPluginExtension quarkusExt) {
        TaskContainer tasks = project.getTasks();
        String forcedPropertiesService = String.format("forcedPropertiesService-%s", project.getName());
        Provider serviceProvider = project.getGradle().getSharedServices().registerIfAbsent(forcedPropertiesService, ForcedPropertieBuildService.class, spec -> {});
        String devRuntimeConfigName = ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT);
        Configuration devRuntimeDependencies = (Configuration)project.getConfigurations().maybeCreate(devRuntimeConfigName);
        tasks.register(LIST_EXTENSIONS_TASK_NAME, QuarkusListExtensions.class);
        tasks.register(LIST_CATEGORIES_TASK_NAME, QuarkusListCategories.class);
        tasks.register(LIST_PLATFORMS_TASK_NAME, QuarkusListPlatforms.class);
        tasks.register(ADD_EXTENSION_TASK_NAME, QuarkusAddExtension.class);
        tasks.register(REMOVE_EXTENSION_TASK_NAME, QuarkusRemoveExtension.class);
        tasks.register(QUARKUS_INFO_TASK_NAME, QuarkusInfo.class);
        tasks.register(QUARKUS_UPDATE_TASK_NAME, QuarkusUpdate.class);
        tasks.register(QUARKUS_GO_OFFLINE_TASK_NAME, QuarkusGoOffline.class, task -> {
            task.setCompileClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.NORMAL)));
            task.setTestCompileClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.TEST)));
            task.setQuarkusDevClasspath(project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT)));
        });
        ApplicationDeploymentClasspathBuilder normalClasspath = new ApplicationDeploymentClasspathBuilder(project, LaunchMode.NORMAL, this.taskDependencyFactory);
        ApplicationDeploymentClasspathBuilder testClasspath = new ApplicationDeploymentClasspathBuilder(project, LaunchMode.TEST, this.taskDependencyFactory);
        ApplicationDeploymentClasspathBuilder devClasspath = new ApplicationDeploymentClasspathBuilder(project, LaunchMode.DEVELOPMENT, this.taskDependencyFactory);
        Provider projectDescriptor = ProjectDescriptorBuilder.buildForApp((Project)project);
        TaskProvider quarkusGenerateTestAppModelTask = tasks.register("quarkusGenerateTestAppModel", QuarkusApplicationModelTask.class, task -> QuarkusPlugin.configureApplicationModelTask(project, task, (Provider<DefaultProjectDescriptor>)projectDescriptor, testClasspath, LaunchMode.TEST, "quarkus/application-model/quarkus-app-test-model.dat"));
        TaskProvider quarkusGenerateDevAppModelTask = tasks.register("quarkusGenerateDevAppModel", QuarkusApplicationModelTask.class, task -> QuarkusPlugin.configureApplicationModelTask(project, task, (Provider<DefaultProjectDescriptor>)projectDescriptor, devClasspath, LaunchMode.DEVELOPMENT, "quarkus/application-model/quarkus-app-dev-model.dat"));
        TaskProvider quarkusGenerateAppModelTask = tasks.register("quarkusGenerateAppModel", QuarkusApplicationModelTask.class, task -> QuarkusPlugin.configureApplicationModelTask(project, task, (Provider<DefaultProjectDescriptor>)projectDescriptor, normalClasspath, LaunchMode.NORMAL, "quarkus/application-model/quarkus-app-model.dat"));
        TaskProvider quarkusGenerateCode = tasks.register(QUARKUS_GENERATE_CODE_TASK_NAME, QuarkusGenerateCode.class, new Object[]{LaunchMode.NORMAL, "main", quarkusExt.getCodeGenerationInputs().get()});
        quarkusGenerateCode.configure(task -> QuarkusPlugin.configureGenerateCodeTask(task, (TaskProvider<QuarkusApplicationModelTask>)quarkusGenerateAppModelTask, "quarkus-generated-sources", quarkusExt));
        TaskProvider quarkusGenerateCodeDev = tasks.register(QUARKUS_GENERATE_CODE_DEV_TASK_NAME, QuarkusGenerateCode.class, new Object[]{LaunchMode.DEVELOPMENT, "main", quarkusExt.getCodeGenerationInputs().get()});
        quarkusGenerateCodeDev.configure(task -> {
            task.dependsOn(new Object[]{quarkusGenerateCode});
            QuarkusPlugin.configureGenerateCodeTask(task, (TaskProvider<QuarkusApplicationModelTask>)quarkusGenerateDevAppModelTask, "quarkus-generated-sources", quarkusExt);
        });
        TaskProvider quarkusGenerateCodeTests = tasks.register(QUARKUS_GENERATE_CODE_TESTS_TASK_NAME, QuarkusGenerateCode.class, new Object[]{LaunchMode.TEST, "test", quarkusExt.getCodeGenerationInputs().get()});
        quarkusGenerateCodeTests.configure(task -> {
            task.dependsOn(new Object[]{"compileQuarkusTestGeneratedSourcesJava"});
            QuarkusPlugin.configureGenerateCodeTask(task, (TaskProvider<QuarkusApplicationModelTask>)quarkusGenerateTestAppModelTask, "quarkus-test-generated-sources", quarkusExt);
        });
        TaskProvider quarkusBuildAppModelTask = tasks.register("quarkusBuildAppModel", QuarkusApplicationModelTask.class, task -> {
            task.dependsOn(new Object[]{tasks.named("classes")});
            QuarkusPlugin.configureApplicationModelTask(project, task, (Provider<DefaultProjectDescriptor>)projectDescriptor, normalClasspath, LaunchMode.NORMAL, "quarkus/application-model/quarkus-app-model-build.dat");
        });
        tasks.register(QUARKUS_SHOW_EFFECTIVE_CONFIG_TASK_NAME, QuarkusShowEffectiveConfig.class, task -> {
            QuarkusPlugin.configureQuarkusBuildTask(project, task, (TaskProvider<QuarkusApplicationModelTask>)quarkusBuildAppModelTask, (Provider<ForcedPropertieBuildService>)serviceProvider, quarkusExt);
            task.setDescription("Show effective Quarkus build configuration.");
        });
        TaskProvider quarkusBuildDependencies = tasks.register(QUARKUS_BUILD_DEP_TASK_NAME, QuarkusBuildDependencies.class, task -> {
            QuarkusPlugin.configureQuarkusBuildTask(project, task, (TaskProvider<QuarkusApplicationModelTask>)quarkusBuildAppModelTask, (Provider<ForcedPropertieBuildService>)serviceProvider, quarkusExt);
            task.getOutputs().doNotCacheIf("Dependencies are never cached", t -> true);
        });
        project.afterEvaluate(evaluated -> this.addDependencyOnJandexIfConfigured((Project)evaluated, (TaskProvider<? extends Task>)quarkusBuildDependencies));
        final Property<Boolean> cacheLargeArtifacts = quarkusExt.getCacheLargeArtifacts();
        TaskProvider quarkusBuildCacheableAppParts = tasks.register(QUARKUS_BUILD_APP_PARTS_TASK_NAME, QuarkusBuildCacheableAppParts.class, task -> {
            QuarkusPlugin.configureQuarkusBuildTask(project, task, (TaskProvider<QuarkusApplicationModelTask>)quarkusBuildAppModelTask, (Provider<ForcedPropertieBuildService>)serviceProvider, quarkusExt);
            task.dependsOn(new Object[]{quarkusGenerateCode});
            task.getOutputs().doNotCacheIf("Not adding uber-jars, native binaries and mutable-jar package type to Gradle build cache by default. To allow caching of uber-jars, native binaries and mutable-jar package type, set 'cacheUberAndNativeRunners' in the 'quarkus' Gradle extension to 'true'.", (Spec)new Spec<Task>(){

                public boolean isSatisfiedBy(Task t) {
                    QuarkusBuildCacheableAppParts q = (QuarkusBuildCacheableAppParts)t;
                    return !q.isCachedByDefault() && (Boolean)cacheLargeArtifacts.get() == false;
                }
            });
        });
        TaskProvider quarkusBuild = tasks.register(QUARKUS_BUILD_TASK_NAME, QuarkusBuild.class, build -> {
            QuarkusPlugin.configureQuarkusBuildTask(project, build, (TaskProvider<QuarkusApplicationModelTask>)quarkusBuildAppModelTask, (Provider<ForcedPropertieBuildService>)serviceProvider, quarkusExt);
            build.dependsOn(new Object[]{quarkusBuildDependencies, quarkusBuildCacheableAppParts});
            build.getOutputs().doNotCacheIf("Only collects and combines the outputs of quarkusAppPartsBuild and quarkusDependenciesBuild, see 'cacheLargeArtifacts' in the 'quarkus' Gradle extension for details.", (Spec)new Spec<Task>(){

                public boolean isSatisfiedBy(Task t) {
                    return (Boolean)cacheLargeArtifacts.get() == false;
                }
            });
        });
        TaskProvider quarkusRequiredExtension = tasks.register(IMAGE_CHECK_REQUIREMENTS_NAME, ImageCheckRequirementsTask.class, task -> {
            task.getOutputFile().set(project.getLayout().getBuildDirectory().file("quarkus/image-name"));
            task.getApplicationModel().set(quarkusGenerateAppModelTask.flatMap(QuarkusApplicationModelTask::getApplicationModel));
        });
        tasks.register(IMAGE_BUILD_TASK_NAME, ImageBuild.class, task -> {
            task.dependsOn(new Object[]{quarkusRequiredExtension});
            QuarkusPlugin.configureQuarkusBuildTask(project, task, (TaskProvider<QuarkusApplicationModelTask>)quarkusBuildAppModelTask, (Provider<ForcedPropertieBuildService>)serviceProvider, quarkusExt);
            task.getBuilderName().set(quarkusRequiredExtension.flatMap(ImageCheckRequirementsTask::getOutputFile));
            task.finalizedBy(new Object[]{quarkusBuild});
        });
        tasks.register(IMAGE_PUSH_TASK_NAME, ImagePush.class, task -> {
            task.dependsOn(new Object[]{quarkusRequiredExtension});
            QuarkusPlugin.configureQuarkusBuildTask(project, task, (TaskProvider<QuarkusApplicationModelTask>)quarkusBuildAppModelTask, (Provider<ForcedPropertieBuildService>)serviceProvider, quarkusExt);
            task.getBuilderName().set(quarkusRequiredExtension.flatMap(ImageCheckRequirementsTask::getOutputFile));
            task.finalizedBy(new Object[]{quarkusBuild});
        });
        tasks.register(DEPLOY_TASK_NAME, Deploy.class, task -> {
            QuarkusPlugin.configureQuarkusBuildTask(project, task, (TaskProvider<QuarkusApplicationModelTask>)quarkusBuildAppModelTask, (Provider<ForcedPropertieBuildService>)serviceProvider, quarkusExt);
            task.finalizedBy(new Object[]{quarkusBuild});
        });
        TaskProvider quarkusDev = tasks.register(QUARKUS_DEV_TASK_NAME, QuarkusDev.class, new Object[]{devRuntimeDependencies, quarkusExt});
        TaskProvider quarkusRun = tasks.register(QUARKUS_RUN_TASK_NAME, QuarkusRun.class, build -> {
            QuarkusPlugin.configureQuarkusBuildTask(project, build, (TaskProvider<QuarkusApplicationModelTask>)quarkusBuildAppModelTask, (Provider<ForcedPropertieBuildService>)serviceProvider, quarkusExt);
            build.dependsOn(new Object[]{quarkusBuild});
        });
        TaskProvider quarkusRemoteDev = tasks.register(QUARKUS_REMOTE_DEV_TASK_NAME, QuarkusRemoteDev.class, new Object[]{devRuntimeDependencies, quarkusExt});
        TaskProvider quarkusTest = tasks.register(QUARKUS_TEST_TASK_NAME, QuarkusTest.class, new Object[]{devRuntimeDependencies, quarkusExt});
        tasks.register(QUARKUS_TEST_CONFIG_TASK_NAME, QuarkusTestConfig.class);
        tasks.register(BUILD_NATIVE_TASK_NAME, DefaultTask.class, task -> {
            task.finalizedBy(new Object[]{quarkusBuild});
            task.doFirst(t -> t.getLogger().warn("The 'buildNative' task has been deprecated in favor of 'build -Dquarkus.native.enabled=true'"));
        });
        this.configureBuildNativeTask(project);
        project.getPlugins().withType(BasePlugin.class, basePlugin -> tasks.named("assemble", task -> task.dependsOn(new Object[]{quarkusBuild})));
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            project.afterEvaluate(this::afterEvaluate);
            TaskProvider classesTask = tasks.named("classes");
            TaskProvider resourcesTask = tasks.named("processResources");
            TaskProvider testClassesTask = tasks.named("testClasses");
            TaskProvider testResourcesTask = tasks.named("processTestResources");
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet mainSourceSet = (SourceSet)sourceSets.getByName("main");
            SourceSet testSourceSet = (SourceSet)sourceSets.getByName("test");
            quarkusGenerateCode.configure(task -> {
                Configuration config = project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.NORMAL));
                task.dependsOn(new Object[]{resourcesTask, config});
                task.setCompileClasspath(config);
                task.setSourcesDirectories(this.getSourcesParents(mainSourceSet));
            });
            quarkusGenerateCodeDev.configure(task -> {
                Configuration config = project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.DEVELOPMENT));
                task.dependsOn(new Object[]{resourcesTask, config});
                task.setCompileClasspath(config);
                task.setSourcesDirectories(this.getSourcesParents(mainSourceSet));
            });
            quarkusGenerateCodeTests.configure(task -> {
                Configuration config = project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName((LaunchMode)LaunchMode.TEST));
                task.dependsOn(new Object[]{resourcesTask, config});
                task.setCompileClasspath(config);
                task.setSourcesDirectories(this.getSourcesParents(testSourceSet));
            });
            quarkusDev.configure(task -> task.dependsOn(new Object[]{classesTask, resourcesTask, testClassesTask, testResourcesTask, quarkusGenerateCodeDev, quarkusGenerateCodeTests}));
            quarkusRemoteDev.configure(task -> task.dependsOn(new Object[]{classesTask, resourcesTask}));
            quarkusTest.configure(task -> task.dependsOn(new Object[]{classesTask, resourcesTask, testClassesTask, testResourcesTask, quarkusGenerateCode, quarkusGenerateCodeTests}));
            quarkusBuildCacheableAppParts.configure(task -> task.dependsOn(new Object[]{classesTask, resourcesTask, tasks.named("jar")}));
            SourceSet intTestSourceSet = (SourceSet)sourceSets.getByName(INTEGRATION_TEST_SOURCE_SET_NAME);
            intTestSourceSet.setCompileClasspath(intTestSourceSet.getCompileClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            intTestSourceSet.setRuntimeClasspath(intTestSourceSet.getRuntimeClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            TaskProvider testTask = tasks.named("test", Test.class);
            FileCollection intTestSourceOutputClasses = intTestSourceSet.getOutput().getClassesDirs();
            FileCollection intTestClasspath = intTestSourceSet.getRuntimeClasspath();
            tasks.register(INTEGRATION_TEST_TASK_NAME, Test.class, intTestTask -> {
                intTestTask.setGroup("verification");
                intTestTask.setDescription("Runs Quarkus integration tests");
                intTestTask.dependsOn(new Object[]{quarkusBuild});
                intTestTask.shouldRunAfter(new Object[]{testTask});
                intTestTask.setClasspath(intTestClasspath);
                intTestTask.setTestClassesDirs(intTestSourceOutputClasses);
            });
            SourceSet nativeTestSourceSet = (SourceSet)sourceSets.getByName(NATIVE_TEST_SOURCE_SET_NAME);
            nativeTestSourceSet.setCompileClasspath(nativeTestSourceSet.getCompileClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)intTestSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            nativeTestSourceSet.setRuntimeClasspath(nativeTestSourceSet.getRuntimeClasspath().plus((FileCollection)mainSourceSet.getOutput()).plus((FileCollection)intTestSourceSet.getOutput()).plus((FileCollection)testSourceSet.getOutput()));
            ConfigurableFileCollection nativeTestClassesDirs = project.files(new Object[]{nativeTestSourceSet.getOutput().getClassesDirs(), intTestSourceOutputClasses});
            FileCollection nativeTestClasspath = nativeTestSourceSet.getRuntimeClasspath();
            tasks.register(TEST_NATIVE_TASK_NAME, Test.class, arg_0 -> QuarkusPlugin.lambda$registerTasks$32(quarkusBuild, testTask, nativeTestClasspath, (FileCollection)nativeTestClassesDirs, arg_0));
            tasks.withType(Test.class).configureEach(t -> {
                t.setSystemProperties(QuarkusPlugin.extractQuarkusTestSystemProperties(project));
                t.getInputs().files(new Object[]{quarkusGenerateTestAppModelTask});
                t.doFirst((Action)new BeforeTestAction(project.getProjectDir(), QuarkusPluginExtension.combinedOutputSourceDirs(project), (Provider<RegularFile>)quarkusGenerateTestAppModelTask.flatMap(QuarkusApplicationModelTask::getApplicationModel), (Provider<File>)quarkusBuild.map(QuarkusBuild::getNativeRunner), mainSourceSet.getOutput().getClassesDirs(), (QuarkusPluginExtensionView)project.getObjects().newInstance(QuarkusPluginExtensionView.class, new Object[]{quarkusExt}), (MapProperty<String, Object>)project.getObjects().mapProperty(String.class, Object.class).convention((Map)quarkusExt.manifest().getAttributes()), (MapProperty<String, Attributes>)project.getObjects().mapProperty(String.class, Attributes.class).convention(quarkusExt.getAttributes())));
                t.useJUnitPlatform();
            });
            quarkusBuildCacheableAppParts.configure(task -> task.shouldRunAfter(new Object[]{tasks.withType(Test.class)}));
            tasks.named("compileJava", JavaCompile.class, compileJava -> {
                SourceSet generatedSourceSet = (SourceSet)sourceSets.getByName("quarkus-generated-sources");
                QuarkusPlugin.addCodeGenSourceDirs(compileJava, generatedSourceSet, quarkusExt);
                compileJava.dependsOn(new Object[]{quarkusGenerateCode});
                compileJava.mustRunAfter(new Object[]{quarkusGenerateCodeDev});
                if (tasks.contains((Object)new NamedImpl(generatedSourceSet.getCompileJavaTaskName()))) {
                    compileJava.mustRunAfter(new Object[]{tasks.named(generatedSourceSet.getCompileJavaTaskName())});
                }
            });
            tasks.named("compileTestJava", JavaCompile.class, compileTestJava -> {
                SourceSet generatedSourceSet = (SourceSet)sourceSets.getByName("quarkus-test-generated-sources");
                QuarkusPlugin.addCodeGenSourceDirs(compileTestJava, generatedSourceSet, quarkusExt);
                compileTestJava.dependsOn(new Object[]{quarkusGenerateCode, quarkusGenerateCodeTests});
                if (tasks.contains((Object)new NamedImpl(generatedSourceSet.getCompileJavaTaskName()))) {
                    compileTestJava.mustRunAfter(new Object[]{tasks.named(generatedSourceSet.getCompileJavaTaskName())});
                }
                if (project.getGradle().getStartParameter().getTaskNames().contains(QUARKUS_DEV_TASK_NAME)) {
                    compileTestJava.getOptions().setFailOnError(false);
                }
            });
        });
        project.getPlugins().withId("org.jetbrains.kotlin.jvm", plugin -> {
            quarkusDev.configure(task -> task.shouldPropagateJavaCompilerArgs(false));
            tasks.named("compileKotlin", task -> {
                String generatedSourcesCompileTaskName;
                SourceSet generatedSourceSet = (SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("quarkus-generated-sources");
                QuarkusPlugin.addCodeGenSourceDirs(task, generatedSourceSet, quarkusExt);
                task.dependsOn(new Object[]{quarkusGenerateCode});
                task.mustRunAfter(new Object[]{quarkusGenerateCodeDev});
                if (tasks.contains((Object)new NamedImpl(generatedSourceSet.getCompileJavaTaskName()))) {
                    task.mustRunAfter(new Object[]{tasks.named(generatedSourceSet.getCompileJavaTaskName())});
                }
                if (tasks.contains((Object)new NamedImpl(generatedSourcesCompileTaskName = generatedSourceSet.getCompileTaskName("kotlin")))) {
                    task.mustRunAfter(new Object[]{tasks.named(generatedSourcesCompileTaskName)});
                }
            });
            tasks.named("compileTestKotlin", task -> {
                String generatedSourcesCompileTaskName;
                SourceSet generatedSourceSet = (SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("quarkus-test-generated-sources");
                QuarkusPlugin.addCodeGenSourceDirs(task, generatedSourceSet, quarkusExt);
                task.dependsOn(new Object[]{quarkusGenerateCodeTests});
                if (tasks.contains((Object)new NamedImpl(generatedSourceSet.getCompileJavaTaskName()))) {
                    task.mustRunAfter(new Object[]{tasks.named(generatedSourceSet.getCompileJavaTaskName())});
                }
                if (tasks.contains((Object)new NamedImpl(generatedSourcesCompileTaskName = generatedSourceSet.getCompileTaskName("kotlin")))) {
                    task.mustRunAfter(new Object[]{tasks.named(generatedSourcesCompileTaskName)});
                }
            });
        });
    }

    private static void addCodeGenSourceDirs(JavaCompile compileJava, SourceSet generatedSourceSet, QuarkusPluginExtension quarkusExt) {
        File baseDir = ((Directory)generatedSourceSet.getJava().getClassesDirectory().get()).getAsFile();
        for (String provider : (List)quarkusExt.getCodeGenerationProviders().get()) {
            compileJava.source(new Object[]{new File(baseDir, provider)});
        }
    }

    private static void addCodeGenSourceDirs(Task compileKotlin, SourceSet generatedSourceSet, QuarkusPluginExtension quarkusExt) {
        File baseDir = ((Directory)generatedSourceSet.getJava().getClassesDirectory().get()).getAsFile();
        List codeGenProviders = (List)quarkusExt.getCodeGenerationProviders().get();
        Object[] codeGenDirs = new Object[codeGenProviders.size()];
        for (int i = 0; i < codeGenDirs.length; ++i) {
            codeGenDirs[i] = new File(baseDir, (String)codeGenProviders.get(i));
        }
        try {
            Method sourcesMethod = compileKotlin.getClass().getMethod("source", Object[].class);
            sourcesMethod.invoke((Object)compileKotlin, new Object[]{codeGenDirs});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ApplicationDeploymentClasspathBuilder getDeploymentClasspathBuilder(Project project, LaunchMode mode) {
        return new ApplicationDeploymentClasspathBuilder(project, mode, this.taskDependencyFactory);
    }

    private static void configureApplicationModelTask(Project project, QuarkusApplicationModelTask task, Provider<DefaultProjectDescriptor> projectDescriptor, ApplicationDeploymentClasspathBuilder classpath, LaunchMode launchMode, String quarkusModelFile) {
        task.getProjectDescriptor().set(projectDescriptor);
        task.getLaunchMode().set((Object)launchMode);
        task.getTypeModel().set((Object)task.getPath());
        task.getOriginalClasspath().setFrom((Iterable)classpath.getOriginalRuntimeClasspathAsInput());
        task.getAppClasspath().configureFrom(classpath.getRuntimeConfigurationWithoutResolvingDeployment());
        task.getPlatformConfiguration().configureFrom(classpath.getPlatformConfiguration());
        task.getPlatformInfo().configureFrom(classpath.getPlatformPropertiesConfiguration());
        task.getDeploymentClasspath().configureFrom(classpath.getDeploymentConfiguration());
        task.getDeploymentResolvedWorkaround().from(new Object[]{classpath.getDeploymentConfiguration().getIncoming().getFiles()});
        task.getApplicationModel().set(project.getLayout().getBuildDirectory().file(quarkusModelFile));
    }

    private static void configureQuarkusBuildTask(Project project, QuarkusBuildTask task, TaskProvider<QuarkusApplicationModelTask> quarkusGenerateAppModelTask, Provider<ForcedPropertieBuildService> serviceProvider, QuarkusPluginExtension quarkusExt) {
        task.getApplicationModel().set(quarkusGenerateAppModelTask.flatMap(QuarkusApplicationModelTask::getApplicationModel));
        SourceSet mainSourceSet = QuarkusGradleUtils.getSourceSet(project, "main");
        task.getAdditionalForcedProperties().set(serviceProvider);
        task.usesService(serviceProvider);
        task.setCompileClasspath(mainSourceSet.getCompileClasspath().plus(mainSourceSet.getRuntimeClasspath()).plus(mainSourceSet.getAnnotationProcessorPath()).plus((FileCollection)mainSourceSet.getResources()));
        task.getCachingRelevantInput().set(quarkusExt.cachingRelevantProperties((List)quarkusExt.getCachingRelevantProperties().get()));
        task.getJarEnabled().set((Object)quarkusExt.packageConfig().jar().enabled());
        task.getNativeEnabled().set((Object)quarkusExt.nativeConfig().enabled());
        task.getNativeSourcesOnly().set((Object)quarkusExt.nativeConfig().sourcesOnly());
        task.getRunnerSuffix().set((Object)quarkusExt.packageConfig().computedRunnerSuffix());
        task.getRunnerName().set((Object)quarkusExt.packageConfig().outputName().orElseGet(quarkusExt::finalName));
        task.getOutputDirectory().set((Object)Path.of(quarkusExt.packageConfig().outputDirectory().map(Path::toString).orElse(DEFAULT_OUTPUT_DIRECTORY), new String[0]));
        task.getJarType().set((Object)quarkusExt.packageConfig().jar().type());
        task.getManifestAttributes().set((Map)quarkusExt.manifest().getAttributes());
        task.getManifestSections().set(quarkusExt.manifest().getSections());
    }

    private static void configureGenerateCodeTask(QuarkusGenerateCode task, TaskProvider<QuarkusApplicationModelTask> applicationModelTaskTaskProvider, String generateSourcesDir, QuarkusPluginExtension quarkusExt) {
        SourceSet generatedSources = QuarkusGradleUtils.getSourceSet(task.getProject(), generateSourcesDir);
        Set sourceSetOutput = generatedSources.getOutput().filter(f -> f.getName().equals(generateSourcesDir)).getFiles();
        if (sourceSetOutput.isEmpty()) {
            throw new GradleException("Failed to configure " + task.getPath() + ": sourceSet " + generateSourcesDir + " has no output");
        }
        task.getApplicationModel().set(applicationModelTaskTaskProvider.flatMap(QuarkusApplicationModelTask::getApplicationModel));
        task.getGeneratedOutputDirectory().set(generatedSources.getJava().getClassesDirectory());
        task.getCachingRelevantInput().set(quarkusExt.cachingRelevantProperties((List)quarkusExt.getCachingRelevantProperties().get()));
        task.getManifestAttributes().set((Map)quarkusExt.manifest().getAttributes());
        task.getManifestSections().set(quarkusExt.manifest().getSections());
    }

    private void createSourceSets(Project project) {
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        sourceSets.create(INTEGRATION_TEST_SOURCE_SET_NAME);
        sourceSets.create(NATIVE_TEST_SOURCE_SET_NAME);
        sourceSets.create("quarkus-generated-sources");
        sourceSets.create("quarkus-test-generated-sources");
    }

    private void createConfigurations(Project project) {
        ConfigurationContainer configContainer = project.getConfigurations();
        configContainer.getByName(NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testImplementation")});
        configContainer.getByName(NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testRuntimeOnly")});
        ((Configuration)configContainer.maybeCreate(INTEGRATION_TEST_IMPLEMENTATION_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testImplementation")});
        ((Configuration)configContainer.maybeCreate(INTEGRATION_TEST_RUNTIME_ONLY_CONFIGURATION_NAME)).extendsFrom(new Configuration[]{(Configuration)configContainer.findByName("testRuntimeOnly")});
        ApplicationDeploymentClasspathBuilder.initConfigurations((Project)project);
    }

    private Set<Path> getSourcesParents(SourceSet mainSourceSet) {
        Set srcDirs = mainSourceSet.getJava().getSrcDirs();
        return srcDirs.stream().map(File::toPath).map(Path::getParent).collect(Collectors.toSet());
    }

    private void registerModel() {
        this.registry.register((ToolingModelBuilder)new GradleApplicationModelBuilder());
    }

    private void verifyGradleVersion() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.1")) < 0) {
            throw new GradleException("Quarkus plugin requires Gradle 6.1 or later. Current version is: " + String.valueOf(GradleVersion.current()));
        }
    }

    private void configureBuildNativeTask(Project project) {
        project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(project.getPath() + BUILD_NATIVE_TASK_NAME) || taskGraph.hasTask(project.getPath() + TEST_NATIVE_TASK_NAME)) {
                project.getExtensions().getExtraProperties().set("quarkus.native.enabled", (Object)"true");
            }
        });
    }

    private void afterEvaluate(Project project) {
        this.visitProjectDependencies(project, new HashSet<String>());
        ConfigurationContainer configurations = project.getConfigurations();
        SourceSetExtension sourceSetExtension = ((QuarkusPluginExtension)project.getExtensions().getByType(QuarkusPluginExtension.class)).sourceSetExtension();
        if (sourceSetExtension.extraNativeTest() != null) {
            SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
            SourceSet nativeTestSourceSets = (SourceSet)sourceSets.getByName(NATIVE_TEST_SOURCE_SET_NAME);
            nativeTestSourceSets.setCompileClasspath(nativeTestSourceSets.getCompileClasspath().plus((FileCollection)((SourceSet)sourceSets.getByName(INTEGRATION_TEST_SOURCE_SET_NAME)).getOutput()).plus((FileCollection)sourceSetExtension.extraNativeTest().getOutput()));
            nativeTestSourceSets.setRuntimeClasspath(nativeTestSourceSets.getRuntimeClasspath().plus((FileCollection)((SourceSet)sourceSets.getByName(INTEGRATION_TEST_SOURCE_SET_NAME)).getOutput()).plus((FileCollection)sourceSetExtension.extraNativeTest().getOutput()));
            configurations.getByName(NATIVE_TEST_IMPLEMENTATION_CONFIGURATION_NAME).extendsFrom(new Configuration[]{(Configuration)configurations.findByName(sourceSetExtension.extraNativeTest().getImplementationConfigurationName())});
            configurations.getByName(NATIVE_TEST_RUNTIME_ONLY_CONFIGURATION_NAME).extendsFrom(new Configuration[]{(Configuration)configurations.findByName(sourceSetExtension.extraNativeTest().getRuntimeOnlyConfigurationName())});
        }
    }

    private void visitProjectDep(Project project, Project dep, Set<String> visited) {
        if (dep.getState().getExecuted()) {
            this.setupQuarkusBuildTaskDeps(project, dep, visited);
        } else {
            dep.afterEvaluate(p -> this.setupQuarkusBuildTaskDeps(project, (Project)p, visited));
        }
    }

    private void setupQuarkusBuildTaskDeps(Project project, Project dep, Set<String> visited) {
        if (!visited.add(dep.getPath())) {
            return;
        }
        project.getLogger().debug("Configuring {} task dependencies on {} tasks", (Object)project, (Object)dep);
        this.getLazyTask(project, QUARKUS_BUILD_TASK_NAME).flatMap(quarkusBuild -> this.getLazyTask(dep, "jar")).ifPresent(jarTask -> {
            for (String taskName : new String[]{QUARKUS_GENERATE_CODE_TASK_NAME, QUARKUS_GENERATE_CODE_DEV_TASK_NAME, QUARKUS_GENERATE_CODE_TESTS_TASK_NAME}) {
                this.getLazyTask(project, taskName).ifPresent(quarkusTask -> quarkusTask.configure(t -> t.dependsOn(new Object[]{jarTask})));
            }
        });
        this.getLazyTask(project, QUARKUS_DEV_TASK_NAME).ifPresent(quarkusDev -> {
            this.getLazyTask(project, "processResources").ifPresent(t -> quarkusDev.configure(qd -> qd.dependsOn(new Object[]{t})));
            if (project.getRootProject().equals((Object)dep.getRootProject())) {
                this.addDependencyOnJandexIfConfigured(dep, (TaskProvider<? extends Task>)quarkusDev);
            }
        });
        this.visitProjectDependencies(dep, visited);
    }

    private void addDependencyOnJandexIfConfigured(Project project, TaskProvider<? extends Task> quarkusTask) {
        for (String taskName : new String[]{"jandex", "processJandexIndex"}) {
            this.getLazyTask(project, taskName).ifPresent(t -> quarkusTask.configure(qd -> qd.mustRunAfter(new Object[]{t})));
        }
    }

    protected void visitProjectDependencies(Project dep, Set<String> visited) {
        Configuration runtimeOnlyConfig;
        Configuration compileConfig = (Configuration)dep.getConfigurations().findByName("compileClasspath");
        if (compileConfig != null) {
            this.processDependencyProjectClasspath(dep, compileConfig, visited);
        }
        if ((runtimeOnlyConfig = (Configuration)dep.getConfigurations().findByName("runtimeOnly")) != null) {
            this.processDependencyProjectClasspath(dep, runtimeOnlyConfig, visited);
        }
    }

    private void processDependencyProjectClasspath(Project dependencyProject, Configuration config, Set<String> visited) {
        config.getIncoming().getDependencies().forEach(d -> {
            Project depProject = null;
            if (d instanceof ProjectDependency) {
                ProjectDependency projectDep = (ProjectDependency)d;
                depProject = dependencyProject.project(projectDep.getPath());
            } else if (d instanceof ExternalModuleDependency) {
                ExternalModuleDependency externalModuleDep = (ExternalModuleDependency)d;
                depProject = ToolingUtils.findIncludedProject((Project)dependencyProject, (ExternalModuleDependency)externalModuleDep);
            }
            if (depProject == null) {
                return;
            }
            if (depProject.getState().getExecuted()) {
                this.visitLocalProject(dependencyProject, depProject, visited);
            } else {
                depProject.afterEvaluate(p -> this.visitLocalProject(dependencyProject, (Project)p, visited));
            }
        });
    }

    private void visitLocalProject(Project project, Project localProject, Set<String> visited) {
        this.visitProjectDep(project, localProject, visited);
        ExtensionDependency extensionDependency = DependencyUtils.getExtensionInfoOrNull((Project)project, (Project)localProject);
        if (extensionDependency instanceof ProjectExtensionDependency) {
            ProjectExtensionDependency projectExtDep = (ProjectExtensionDependency)extensionDependency;
            this.visitProjectDep(project, (Project)projectExtDep.getDeploymentModule(), visited);
        }
    }

    private Optional<TaskProvider<Task>> getLazyTask(Project project, String name) {
        try {
            return Optional.of(project.getTasks().named(name));
        }
        catch (UnknownTaskException e) {
            return Optional.empty();
        }
    }

    private static Map<String, Object> extractQuarkusTestSystemProperties(Project project) {
        return new HashMap<String, Object>((Map)project.getProviders().systemPropertiesPrefixedBy("quarkus.test.").get());
    }

    private static /* synthetic */ void lambda$registerTasks$32(TaskProvider quarkusBuild, TaskProvider testTask, FileCollection nativeTestClasspath, FileCollection nativeTestClassesDirs, Test testNative) {
        testNative.setDescription("Runs native image tests");
        testNative.setGroup("verification");
        testNative.dependsOn(new Object[]{quarkusBuild});
        testNative.shouldRunAfter(new Object[]{testTask});
        testNative.setClasspath(nativeTestClasspath);
        testNative.setTestClassesDirs(nativeTestClassesDirs);
    }
}

