/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.gradle.extension.QuarkusPluginExtension;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.GradleVersion;

public abstract class QuarkusPluginExtensionView {
    @Inject
    public QuarkusPluginExtensionView(Project project, QuarkusPluginExtension extension) {
        project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(project.getPath() + "buildNative") || taskGraph.hasTask(project.getPath() + "testNative")) {
                this.getNativeBuild().set((Object)true);
            } else {
                this.getNativeBuild().set((Object)false);
            }
        });
        this.getCacheLargeArtifacts().set(extension.getCacheLargeArtifacts());
        this.getCleanupBuildOutput().set(extension.getCleanupBuildOutput());
        this.getFinalName().set(extension.getFinalName());
        this.getCodeGenForkOptions().set(this.getProviderFactory().provider(() -> extension.codeGenForkOptions));
        this.getBuildForkOptions().set(this.getProviderFactory().provider(() -> extension.buildForkOptions));
        this.getIgnoredEntries().set(extension.ignoredEntriesProperty());
        this.getMainResources().setFrom((Iterable)((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getResources().getSourceDirectories());
        this.getQuarkusBuildProperties().set(extension.getQuarkusBuildProperties());
        this.getQuarkusRelevantProjectProperties().set(this.getQuarkusRelevantProjectProperties(project));
        this.getQuarkusProfileSystemVariable().set(this.getProviderFactory().systemProperty("quarkus.profile"));
        this.getQuarkusProfileEnvVariable().set(this.getProviderFactory().environmentVariable("QUARKUS_PROFILE"));
        this.getCachingRelevantProperties().set(extension.getCachingRelevantProperties());
        this.getForcedProperties().set(extension.forcedPropertiesProperty());
        HashMap projectProperties = new HashMap();
        for (Map.Entry entry : project.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.")) continue;
            projectProperties.put((String)entry.getKey(), entry.getValue());
        }
        this.getProjectProperties().set(projectProperties);
    }

    private Provider<Map<String, String>> getQuarkusRelevantProjectProperties(Project project) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.0")) >= 0) {
            return this.getProviderFactory().gradlePropertiesPrefixedBy("quarkus.");
        }
        return this.getProviderFactory().provider(() -> project.getProperties().entrySet().stream().filter(e -> e.getValue() != null).map(e -> Map.entry((String)e.getKey(), e.getValue().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @Inject
    public abstract ProviderFactory getProviderFactory();

    @Input
    @Optional
    public abstract Property<Boolean> getNativeBuild();

    @Input
    public abstract Property<Boolean> getCacheLargeArtifacts();

    @Input
    public abstract ListProperty<String> getCachingRelevantProperties();

    @Input
    public abstract Property<Boolean> getCleanupBuildOutput();

    @Input
    public abstract Property<String> getFinalName();

    @Input
    public abstract MapProperty<String, Object> getProjectProperties();

    @Nested
    public abstract ListProperty<Action<? super JavaForkOptions>> getCodeGenForkOptions();

    @Nested
    public abstract ListProperty<Action<? super JavaForkOptions>> getBuildForkOptions();

    @Input
    public abstract ListProperty<String> getIgnoredEntries();

    @Input
    public abstract MapProperty<String, String> getQuarkusBuildProperties();

    @Input
    public abstract MapProperty<String, String> getQuarkusRelevantProjectProperties();

    @Internal
    public abstract ConfigurableFileCollection getMainResources();

    @Input
    @Optional
    public abstract Property<String> getQuarkusProfileSystemVariable();

    @Input
    @Optional
    public abstract Property<String> getQuarkusProfileEnvVariable();

    @Input
    @Optional
    public abstract MapProperty<String, String> getForcedProperties();
}

