/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gradle.tasks.QuarkusBuild;
import io.quarkus.gradle.tasks.QuarkusTaskWithExtensionView;
import io.quarkus.gradle.tasks.services.ForcedPropertieBuildService;
import io.quarkus.gradle.tasks.worker.BuildWorker;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.smallrye.common.expression.Expression;
import io.smallrye.config.Expressions;
import io.smallrye.config.SmallRyeConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.util.GradleVersion;
import org.gradle.workers.WorkQueue;

public abstract class QuarkusBuildTask
extends QuarkusTaskWithExtensionView {
    private static final String QUARKUS_BUILD_DIR = "quarkus-build";
    private static final String QUARKUS_BUILD_GEN_DIR = "quarkus-build/gen";
    private static final String QUARKUS_BUILD_APP_DIR = "quarkus-build/app";
    private static final String QUARKUS_BUILD_DEP_DIR = "quarkus-build/dep";
    static final String QUARKUS_ARTIFACT_PROPERTIES = "quarkus-artifact.properties";
    static final String NATIVE_SOURCES = "native-sources";
    private FileCollection classpath = this.getProject().getObjects().fileCollection();

    @Internal
    public abstract Property<ForcedPropertieBuildService> getAdditionalForcedProperties();

    QuarkusBuildTask(String description, boolean compatible) {
        super(description, compatible);
    }

    @Inject
    protected abstract FileSystemOperations getFileSystemOperations();

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setCompileClasspath(FileCollection compileClasspath) {
        this.classpath = compileClasspath;
    }

    @Override
    @Input
    public abstract MapProperty<String, String> getCachingRelevantInput();

    @Input
    public abstract Property<Boolean> getJarEnabled();

    @Input
    public abstract Property<Boolean> getNativeEnabled();

    @Input
    public abstract Property<Boolean> getNativeSourcesOnly();

    @Internal
    public abstract Property<String> getRunnerSuffix();

    @Internal
    public abstract Property<String> getRunnerName();

    @Internal
    public abstract Property<Path> getOutputDirectory();

    @Input
    public abstract Property<PackageConfig.JarConfig.JarType> getJarType();

    PackageConfig.JarConfig.JarType jarType() {
        return (PackageConfig.JarConfig.JarType)this.getJarType().get();
    }

    boolean jarEnabled() {
        return (Boolean)this.getJarEnabled().get();
    }

    boolean nativeEnabled() {
        return (Boolean)this.getNativeEnabled().get();
    }

    boolean nativeSourcesOnly() {
        return (Boolean)this.getNativeSourcesOnly().get();
    }

    Path gradleBuildDir() {
        return this.buildDir.toPath();
    }

    Path genBuildDir() {
        return this.gradleBuildDir().resolve(QUARKUS_BUILD_GEN_DIR);
    }

    Path appBuildDir() {
        return this.gradleBuildDir().resolve(QUARKUS_BUILD_APP_DIR);
    }

    Path depBuildDir() {
        return this.gradleBuildDir().resolve(QUARKUS_BUILD_DEP_DIR);
    }

    File artifactProperties() {
        return new File(this.buildDir, QUARKUS_ARTIFACT_PROPERTIES);
    }

    File nativeSources() {
        return new File(this.buildDir, NATIVE_SOURCES);
    }

    File fastJar() {
        return new File(this.buildDir, this.outputDirectory());
    }

    File runnerJar() {
        return new File(this.buildDir, this.runnerJarFileName());
    }

    File nativeRunner() {
        return new File(this.buildDir, this.nativeRunnerFileName());
    }

    String runnerJarFileName() {
        return this.runnerName() + ".jar";
    }

    String nativeRunnerFileName() {
        return this.runnerName();
    }

    String runnerName() {
        return this.runnerBaseName() + this.runnerSuffix();
    }

    String nativeImageSourceJarDirName() {
        return this.runnerBaseName() + "-native-image-source-jar";
    }

    String runnerBaseName() {
        return (String)this.getRunnerName().get();
    }

    String outputDirectory() {
        return ((Path)this.getOutputDirectory().get()).toString();
    }

    private String runnerSuffix() {
        return (String)this.getRunnerSuffix().get();
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getApplicationModel();

    ApplicationModel resolveAppModelForBuild() {
        try {
            return ToolingUtils.deserializeAppModel((Path)((RegularFile)this.getApplicationModel().get()).getAsFile().toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void generateBuild() {
        Path buildDir = this.gradleBuildDir();
        Path genDir = this.genBuildDir();
        if (this.nativeEnabled()) {
            if (this.nativeSourcesOnly()) {
                this.getLogger().info("Building Quarkus app for native (sources only) packaging in {}", (Object)genDir);
            } else {
                this.getLogger().info("Building Quarkus app for native packaging in {}", (Object)genDir);
            }
        } else {
            this.getLogger().info("Building Quarkus app for JAR type {} in {}", (Object)this.jarType(), (Object)genDir);
        }
        QuarkusBuildTask.deleteFileIfExists(genDir.resolve(this.outputDirectory()).resolve("app-cds.jsa"));
        this.getFileSystemOperations().delete(delete -> {
            delete.delete(new Object[]{genDir});
            if (this.nativeEnabled()) {
                if (this.jarEnabled()) {
                    throw QuarkusBuild.nativeAndJar();
                }
                delete.delete(new Object[]{this.fastJar()});
            } else if (this.jarEnabled()) {
                switch (this.jarType()) {
                    case FAST_JAR: {
                        delete.delete(new Object[]{buildDir.resolve(this.nativeImageSourceJarDirName())});
                        delete.delete(new Object[]{this.fastJar()});
                        break;
                    }
                    case LEGACY_JAR: {
                        delete.delete(new Object[]{buildDir.resolve("lib")});
                        break;
                    }
                }
            }
        });
        ApplicationModel appModel = this.resolveAppModelForBuild();
        SmallRyeConfig config = this.effectiveProvider().buildEffectiveConfiguration(appModel, ((ForcedPropertieBuildService)this.getAdditionalForcedProperties().get()).getProperties()).getConfig();
        Map quarkusProperties = (Map)Expressions.withoutExpansion(() -> {
            HashMap<String, String> values = new HashMap<String, String>();
            for (String key : config.getMapKeys("quarkus").values()) {
                values.put(key, config.getConfigValue(key).getValue());
            }
            for (String key : config.getMapKeys("platform.quarkus").values()) {
                values.put(key, config.getConfigValue(key).getValue());
            }
            return values;
        });
        if (this.nativeEnabled()) {
            if (this.nativeSourcesOnly()) {
                this.getLogger().info("Starting Quarkus application build for native (sources only) packaging");
            } else {
                this.getLogger().info("Starting Quarkus application build for native packaging");
            }
        } else {
            this.getLogger().info("Starting Quarkus application build for JAR type {}", (Object)this.jarType());
        }
        if (this.getLogger().isEnabled(LogLevel.INFO)) {
            this.getLogger().info("Effective properties: {}", (Object)quarkusProperties.entrySet().stream().map(Object::toString).sorted().collect(Collectors.joining("\n    ", "\n    ", "")));
        }
        WorkQueue workQueue = this.workQueue(quarkusProperties, (List)this.getExtensionView().getBuildForkOptions().get());
        workQueue.submit(BuildWorker.class, params -> {
            params.getBuildSystemProperties().putAll(this.buildSystemProperties(appModel.getAppArtifact(), quarkusProperties));
            params.getBaseName().set(this.getExtensionView().getFinalName());
            params.getTargetDirectory().set(buildDir.toFile());
            params.getAppModel().set((Object)appModel);
            params.getGradleVersion().set((Object)GradleVersion.current().getVersion());
        });
        workQueue.await();
        this.getFileSystemOperations().copy(copy -> {
            copy.from(new Object[]{buildDir});
            copy.into((Object)genDir);
            copy.eachFile((Action)new CopyActionDeleteNonWriteableTarget(genDir));
            if (this.nativeEnabled()) {
                if (this.jarEnabled()) {
                    throw QuarkusBuild.nativeAndJar();
                }
                if (this.nativeSourcesOnly()) {
                    copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                    copy.include(new String[]{this.nativeImageSourceJarDirName() + "/**"});
                } else {
                    copy.include(new String[]{this.nativeRunnerFileName()});
                    copy.include(new String[]{this.nativeImageSourceJarDirName() + "/**"});
                    copy.include(new String[]{this.outputDirectory() + "/**"});
                    copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                }
            } else if (this.jarEnabled()) {
                switch (this.jarType()) {
                    case FAST_JAR: {
                        copy.include(new String[]{this.outputDirectory() + "/**"});
                        copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                        break;
                    }
                    case LEGACY_JAR: {
                        copy.include(new String[]{"lib/**"});
                        copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                        copy.include(new String[]{this.runnerJarFileName()});
                        break;
                    }
                    case MUTABLE_JAR: 
                    case UBER_JAR: {
                        copy.include(new String[]{QUARKUS_ARTIFACT_PROPERTIES});
                        copy.include(new String[]{this.runnerJarFileName()});
                    }
                }
            }
        });
    }

    void abort(String message, Object ... args) {
        this.getLogger().warn(message, args);
        this.getProject().getTasks().stream().filter(t -> t != this).filter(t -> !t.getState().getExecuted()).forEach(t -> t.setEnabled(false));
        throw new StopExecutionException();
    }

    protected static void deleteFileIfExists(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> buildSystemProperties(ResolvedDependency appArtifact, Map<String, String> quarkusProperties) {
        HashMap<String, String> buildSystemProperties = new HashMap<String, String>();
        buildSystemProperties.putIfAbsent("quarkus.application.name", appArtifact.getArtifactId());
        buildSystemProperties.putIfAbsent("quarkus.application.version", appArtifact.getVersion());
        for (Map.Entry entry : ((Map)this.getExtensionView().getForcedProperties().get()).entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.")) continue;
            buildSystemProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : ((Map)this.getExtensionView().getQuarkusBuildProperties().get()).entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.")) continue;
            buildSystemProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : ((Map)this.getExtensionView().getProjectProperties().get()).entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.") || entry.getValue() == null) continue;
            buildSystemProperties.put((String)entry.getKey(), entry.getValue().toString());
        }
        HashSet<String> quarkusValues = new HashSet<String>();
        quarkusValues.addAll(quarkusProperties.values());
        quarkusValues.addAll(buildSystemProperties.values());
        for (String value : quarkusValues) {
            Expression expression = Expression.compile((String)value, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX, Expression.Flag.NO_TRIM, Expression.Flag.NO_SMART_BRACES, Expression.Flag.DOUBLE_COLON});
            for (String reference : expression.getReferencedStrings()) {
                String expanded = (String)((Map)this.getExtensionView().getForcedProperties().get()).get(reference);
                if (expanded != null) {
                    buildSystemProperties.put(reference, expanded);
                    continue;
                }
                expanded = (String)((Map)this.getExtensionView().getQuarkusBuildProperties().get()).get(reference);
                if (expanded != null) {
                    buildSystemProperties.put(reference, expanded);
                    continue;
                }
                expanded = (String)((Map)this.getExtensionView().getProjectProperties().get()).get(reference);
                if (expanded == null) continue;
                buildSystemProperties.put(reference, expanded);
            }
        }
        return buildSystemProperties;
    }

    public static final class CopyActionDeleteNonWriteableTarget
    implements Action<FileCopyDetails> {
        private final Path destDir;

        public CopyActionDeleteNonWriteableTarget(Path destDir) {
            this.destDir = destDir;
        }

        public void execute(FileCopyDetails details) {
            Path destFile = this.destDir.resolve(details.getPath());
            if (Files.exists(destFile, new LinkOption[0]) && !Files.isWritable(destFile)) {
                QuarkusBuildTask.deleteFileIfExists(destFile);
            }
        }
    }
}

