/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks.worker;

import io.quarkus.bootstrap.BootstrapException;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.gradle.tasks.worker.QuarkusParams;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.gradle.workers.WorkAction;

public abstract class QuarkusWorker<P extends QuarkusParams>
implements WorkAction<P> {
    Properties buildSystemProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)((Map)((QuarkusParams)this.getParameters()).getBuildSystemProperties().get()));
        return props;
    }

    CuratedApplication createAppCreationContext() throws BootstrapException {
        QuarkusParams params = (QuarkusParams)this.getParameters();
        Path buildDir = ((File)params.getTargetDirectory().getAsFile().get()).toPath();
        String baseName = (String)params.getBaseName().get();
        ApplicationModel appModel = (ApplicationModel)params.getAppModel().get();
        return QuarkusBootstrap.builder().setBaseClassLoader(this.getClass().getClassLoader()).setExistingModel(appModel).setTargetDirectory(buildDir).setBaseName(baseName).setBuildSystemProperties(this.buildSystemProperties()).setAppArtifact(appModel.getAppArtifact()).setLocalProjectDiscovery(Boolean.valueOf(false)).setIsolateDeployment(true).setDependencyInfoProvider(() -> null).build().bootstrap();
    }
}

