/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gradle.dsl.Manifest;
import io.quarkus.gradle.tasks.EffectiveConfig;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class BaseConfig {
    private final Manifest manifest = new Manifest();
    private final PackageConfig packageConfig;
    private final NativeConfig nativeConfig;
    private final Map<String, String> values;

    BaseConfig(EffectiveConfig config) {
        this.packageConfig = (PackageConfig)config.getConfig().getConfigMapping(PackageConfig.class);
        this.nativeConfig = (NativeConfig)config.getConfig().getConfigMapping(NativeConfig.class);
        PackageConfig.JarConfig.ManifestConfig manifestConfig = this.packageConfig.jar().manifest();
        this.manifest.attributes(manifestConfig.attributes());
        manifestConfig.sections().forEach((section, attribs) -> this.manifest.attributes((Map<String, String>)attribs, (String)section));
        this.values = config.getValues();
    }

    PackageConfig packageConfig() {
        return this.packageConfig;
    }

    NativeConfig nativeConfig() {
        return this.nativeConfig;
    }

    PackageConfig.JarConfig.JarType jarType() {
        return this.packageConfig().jar().type();
    }

    Manifest manifest() {
        return this.manifest;
    }

    Map<String, String> cachingRelevantProperties(List<String> propertyPatterns) {
        List patterns = propertyPatterns.stream().map(s -> "^(" + s + ")$").map(Pattern::compile).collect(Collectors.toList());
        Predicate<Map.Entry> keyPredicate = e -> patterns.stream().anyMatch(p -> p.matcher((CharSequence)e.getKey()).matches());
        return this.values.entrySet().stream().filter(keyPredicate).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (s, s2) -> {
            throw new IllegalArgumentException("Duplicate key");
        }, TreeMap::new));
    }
}

