/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tasks;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.gradle.dsl.Manifest;
import io.quarkus.gradle.extension.QuarkusPluginExtension;
import io.quarkus.gradle.tasks.AbstractQuarkusExtension;
import io.quarkus.gradle.tasks.EffectiveConfig;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.smallrye.common.expression.Expression;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.GradleVersion;

public abstract class QuarkusPluginExtensionView {
    @Inject
    public QuarkusPluginExtensionView(Project project, QuarkusPluginExtension extension) {
        project.getGradle().getTaskGraph().whenReady(taskGraph -> {
            if (taskGraph.hasTask(project.getPath() + "buildNative") || taskGraph.hasTask(project.getPath() + "testNative")) {
                this.getNativeBuild().set((Object)true);
            } else {
                this.getNativeBuild().set((Object)false);
            }
        });
        this.getCacheLargeArtifacts().set(extension.getCacheLargeArtifacts());
        this.getCleanupBuildOutput().set(extension.getCleanupBuildOutput());
        this.getFinalName().set(extension.getFinalName());
        this.getCodeGenForkOptions().set(this.getProviderFactory().provider(() -> extension.codeGenForkOptions));
        this.getBuildForkOptions().set(this.getProviderFactory().provider(() -> extension.buildForkOptions));
        this.getIgnoredEntries().set(extension.ignoredEntriesProperty());
        this.getMainResources().setFrom((Iterable)((SourceSet)((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main")).getResources().getSourceDirectories());
        this.getQuarkusBuildProperties().set(extension.getQuarkusBuildProperties());
        this.getQuarkusRelevantProjectProperties().set(this.getQuarkusRelevantProjectProperties(project));
        this.getQuarkusProfileSystemVariable().set(this.getProviderFactory().systemProperty("quarkus.profile"));
        this.getQuarkusProfileEnvVariable().set(this.getProviderFactory().environmentVariable("QUARKUS_PROFILE"));
        this.getCachingRelevantInput().set(extension.baseConfig().cachingRelevantProperties((List)extension.getCachingRelevantProperties().get()));
        this.getForcedProperties().set(extension.forcedPropertiesProperty());
        HashMap projectProperties = new HashMap();
        for (Map.Entry entry : project.getProperties().entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.")) continue;
            projectProperties.put((String)entry.getKey(), entry.getValue());
        }
        this.getProjectProperties().set(projectProperties);
        this.getJarEnabled().set((Object)extension.baseConfig().packageConfig().jar().enabled());
        this.getManifestAttributes().set((Map)extension.manifest().getAttributes());
        this.getManifestSections().set(extension.manifest().getSections());
        this.getNativeEnabled().set((Object)extension.baseConfig().nativeConfig().enabled());
        this.getNativeSourcesOnly().set((Object)extension.baseConfig().nativeConfig().sourcesOnly());
        this.getRunnerSuffix().set((Object)extension.baseConfig().packageConfig().computedRunnerSuffix());
        this.getRunnerName().set((Object)extension.baseConfig().packageConfig().outputName().orElseGet(extension::finalName));
        this.getOutputDirectory().set((Object)Path.of(extension.baseConfig().packageConfig().outputDirectory().map(Path::toString).orElse("quarkus-app"), new String[0]));
        this.getJarType().set((Object)extension.baseConfig().jarType());
    }

    private Provider<Map<String, String>> getQuarkusRelevantProjectProperties(Project project) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.0")) >= 0) {
            return this.getProviderFactory().gradlePropertiesPrefixedBy("quarkus.");
        }
        return this.getProviderFactory().provider(() -> project.getProperties().entrySet().stream().filter(e -> e.getValue() != null).map(e -> Map.entry((String)e.getKey(), e.getValue().toString())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    @Inject
    public abstract ProviderFactory getProviderFactory();

    @Input
    @Optional
    public abstract Property<Boolean> getNativeBuild();

    @Input
    public abstract Property<Boolean> getCacheLargeArtifacts();

    @Input
    public abstract Property<Boolean> getCleanupBuildOutput();

    @Input
    public abstract Property<String> getFinalName();

    @Input
    public abstract MapProperty<String, Object> getProjectProperties();

    @Nested
    public abstract ListProperty<Action<? super JavaForkOptions>> getCodeGenForkOptions();

    @Nested
    public abstract ListProperty<Action<? super JavaForkOptions>> getBuildForkOptions();

    @Input
    @Optional
    public abstract Property<Boolean> getJarEnabled();

    @Input
    @Optional
    public abstract Property<Boolean> getNativeEnabled();

    @Input
    @Optional
    public abstract Property<Manifest> getManifest();

    @Input
    @Optional
    public abstract Property<Boolean> getNativeSourcesOnly();

    @Input
    public abstract ListProperty<String> getIgnoredEntries();

    @Input
    public abstract MapProperty<String, String> getQuarkusBuildProperties();

    @Input
    public abstract MapProperty<String, String> getQuarkusRelevantProjectProperties();

    @Internal
    public abstract ConfigurableFileCollection getMainResources();

    @Internal
    public abstract Property<String> getRunnerSuffix();

    @Internal
    public abstract Property<String> getRunnerName();

    @Internal
    public abstract Property<Path> getOutputDirectory();

    @Input
    public abstract Property<PackageConfig.JarConfig.JarType> getJarType();

    @Input
    @Optional
    public abstract Property<String> getQuarkusProfileSystemVariable();

    @Input
    @Optional
    public abstract Property<String> getQuarkusProfileEnvVariable();

    @Input
    @Optional
    public abstract MapProperty<String, String> getCachingRelevantInput();

    @Input
    @Optional
    public abstract MapProperty<String, String> getForcedProperties();

    @Input
    @Optional
    public abstract MapProperty<String, Object> getManifestAttributes();

    @Input
    @Optional
    public abstract MapProperty<String, Attributes> getManifestSections();

    private void exportCustomManifestProperties(Map<String, Object> properties) {
        for (Map.Entry attribute : ((Map)this.getManifestAttributes().get()).entrySet()) {
            properties.put(AbstractQuarkusExtension.toManifestAttributeKey((String)attribute.getKey()), attribute.getValue());
        }
        for (Map.Entry section : ((Map)this.getManifestSections().get()).entrySet()) {
            for (Map.Entry attribute : ((Attributes)section.getValue()).entrySet()) {
                properties.put(AbstractQuarkusExtension.toManifestSectionAttributeKey((String)section.getKey(), (String)attribute.getKey()), attribute.getValue());
            }
        }
    }

    protected EffectiveConfig buildEffectiveConfiguration(ApplicationModel appModel, Map<String, ?> additionalForcedProperties) {
        ResolvedDependency appArtifact = appModel.getAppArtifact();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        this.exportCustomManifestProperties(properties);
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        String userIgnoredEntries = String.join((CharSequence)",", (Iterable)this.getIgnoredEntries().get());
        if (!userIgnoredEntries.isEmpty()) {
            defaultProperties.put("quarkus.package.jar.user-configured-ignored-entries", userIgnoredEntries);
        }
        Set resourcesDirs = this.getMainResources().getFiles();
        defaultProperties.putIfAbsent("quarkus.application.name", appArtifact.getArtifactId());
        defaultProperties.putIfAbsent("quarkus.application.version", appArtifact.getVersion());
        HashMap<String, String> forced = new HashMap<String, String>((Map)this.getForcedProperties().get());
        ((Map)this.getProjectProperties().get()).forEach((k, v) -> forced.put((String)k, v.toString()));
        additionalForcedProperties.forEach((k, v) -> forced.put((String)k, v.toString()));
        if (((Boolean)this.getNativeBuild().get()).booleanValue()) {
            forced.put("quarkus.native.enabled", "true");
        }
        return EffectiveConfig.builder().withPlatformProperties(appModel.getPlatformProperties()).withForcedProperties(forced).withTaskProperties(properties).withBuildProperties((Map)this.getQuarkusBuildProperties().get()).withProjectProperties((Map)this.getQuarkusRelevantProjectProperties().get()).withDefaultProperties(defaultProperties).withSourceDirectories(resourcesDirs).withProfile(this.getQuarkusProfile()).build();
    }

    protected Map<String, String> buildSystemProperties(ResolvedDependency appArtifact, Map<String, String> quarkusProperties) {
        HashMap<String, String> buildSystemProperties = new HashMap<String, String>();
        buildSystemProperties.putIfAbsent("quarkus.application.name", appArtifact.getArtifactId());
        buildSystemProperties.putIfAbsent("quarkus.application.version", appArtifact.getVersion());
        for (Map.Entry entry : ((Map)this.getForcedProperties().get()).entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.")) continue;
            buildSystemProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : ((Map)this.getQuarkusBuildProperties().get()).entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.")) continue;
            buildSystemProperties.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : ((Map)this.getProjectProperties().get()).entrySet()) {
            if (!((String)entry.getKey()).startsWith("quarkus.") && !((String)entry.getKey()).startsWith("platform.quarkus.") || entry.getValue() == null) continue;
            buildSystemProperties.put((String)entry.getKey(), entry.getValue().toString());
        }
        HashSet<String> quarkusValues = new HashSet<String>();
        quarkusValues.addAll(quarkusProperties.values());
        quarkusValues.addAll(buildSystemProperties.values());
        for (String value : quarkusValues) {
            Expression expression = Expression.compile((String)value, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX, Expression.Flag.NO_TRIM, Expression.Flag.NO_SMART_BRACES, Expression.Flag.DOUBLE_COLON});
            for (String reference : expression.getReferencedStrings()) {
                String expanded = (String)((Map)this.getForcedProperties().get()).get(reference);
                if (expanded != null) {
                    buildSystemProperties.put(reference, expanded);
                    continue;
                }
                expanded = (String)((Map)this.getQuarkusBuildProperties().get()).get(reference);
                if (expanded != null) {
                    buildSystemProperties.put(reference, expanded);
                    continue;
                }
                expanded = (String)((Map)this.getProjectProperties().get()).get(reference);
                if (expanded == null) continue;
                buildSystemProperties.put(reference, expanded);
            }
        }
        return buildSystemProperties;
    }

    private String getQuarkusProfile() {
        Object p;
        String profile = (String)this.getQuarkusProfileSystemVariable().getOrNull();
        if (profile == null) {
            profile = (String)this.getQuarkusProfileEnvVariable().getOrNull();
        }
        if (profile == null) {
            profile = (String)((Map)this.getQuarkusBuildProperties().get()).get("quarkus.profile");
        }
        if (profile == null && (p = ((Map)this.getQuarkusRelevantProjectProperties().get()).get("quarkus.profile")) != null) {
            profile = p.toString();
        }
        if (profile == null) {
            profile = "prod";
        }
        return profile;
    }
}

